/*	mem.c	6.1	83/07/29	*/

/*
 * Memory special file
 */

#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/conf.h"
#include "../h/buf.h"
#include "../h/systm.h"
#include "../h/vm.h"
#include "../h/cmap.h"
#include "../h/uio.h"

#include "../machine/board.h"

#ifdef	GWS
extern char vidbuf[];		/* virtual address for display memory */
extern short *gpaddr;		/* address of gip */
#endif	GWS

mmread(dev, uio)
	dev_t dev;
	struct uio *uio;
{
	return (mmrw(dev, uio, UIO_READ));
}

mmwrite(dev, uio)
	dev_t dev;
	struct uio *uio;
{
	return (mmrw(dev, uio, UIO_WRITE));
}

mmrw(dev, uio, rw)
	dev_t dev;
	struct uio *uio;
	enum uio_rw rw;
{
	register int o;
	register u_int c, v;
	register struct iovec *iov;
	int error = 0;

	while (uio->uio_resid > 0 && error == 0) {
		iov = uio->uio_iov;
		if (iov->iov_len == 0) {
			uio->uio_iov++;
			uio->uio_iovcnt--;
			if (uio->uio_iovcnt < 0)
				panic("mmrw");
			continue;
		}
		switch (minor(dev)) {

		    case 0:		/* minor device 0 is physical memory */
			v = btop(uio->uio_offset);
			if (v >= physmem)
				goto fault;
			*(int *)mmap = v | PG_V |
/* KLUDGE */				(/* rw == UIO_READ ? PG_KR : */ PG_KW);
			newptes(mmap, btop(vmmap), 1);
			o = (int)uio->uio_offset & PGOFSET;
			c = min((u_int)(NBPG - o), (u_int)iov->iov_len);
			c = min(c,(u_int)(NBPG - ((int)iov->iov_base&PGOFSET)));
			error = uiomove((caddr_t)&vmmap[o], (int)c, rw, uio);
			continue;

		    case 1:		/* minor device 1 is kernel memory */
			c = iov->iov_len;
			if (!kernacc((caddr_t)uio->uio_offset, c, 
				rw == UIO_READ ? B_READ : B_WRITE))
					goto fault;
			error = uiomove((caddr_t)uio->uio_offset, (int)c, rw, 
				uio);
			continue;

		    case 2:		/* minor device 2 is EOF/RATHOLE */
			if (rw == UIO_READ)
				return (0);
			c = iov->iov_len;
			break;

#ifdef	GWS
		    case 4:		/* minor device 4 is video memory */
			if (gpaddr == 0)
				goto fault;
			c = iov->iov_len;
#ifdef	COLOR
			if ((uio->uio_offset + c) > ctob(8*32))
#else	COLOR
			if ((uio->uio_offset + c) > ctob(4*32))
#endif	COLOR
				goto fault;
			CPUgetdisp();	/* get access to display memory */
			error = uiomove(&vidbuf[uio->uio_offset], (int)c, 
				rw, uio);
			continue;
#endif	GWS
		}
		if (error)
			break;
		iov->iov_base += c;
		iov->iov_len -= c;
		uio->uio_offset += c;
		uio->uio_resid -= c;
	}
	return (error);
fault:
	return (EFAULT);
}

#ifndef NOMMAP
/*
 * Return physical page frame # corresponding to byte offset.
 * Return -1 if illegal.
 */
	int
mmmap(dev, offset, prot)
	dev_t	dev;
	off_t	offset;			/* byte offset within device */
	int	prot;			/* mmap protection */
{
	register int	page;		/* physical page frame # */

	switch(minor(dev)) {
	    case 0:			/* physical memory */
		page = btop(offset);
		if (page & ~PG_PFNUM)	/* offset is too big (or negative) */
			break;
		return(page);

	    case 1:			/* kmem */
/*		if (!kernacc(SYSVBASE + offset, 1, B_WRITE))
			return(-1);		/**/
		page = btop(svtop(offset));
		if (page & ~PG_PFNUM)	/* offset is too big (or negative) */
			break;
		return(-1);

#ifdef	GWS
	    case 4:			/* video memory */
		if (gpaddr == 0)	/* exit if no gip */
			break;
		page = btop(svtop(&vidbuf[offset]));
		if (page & ~PG_PFNUM)	/* offset is too big (or negative) */
			break;
		return(page);
#endif	GWS
	}
	return(-1);
}
#endif	NOMMAP
