#define STACKTRACE /* */
#define SLEEPTRACE /* */
/*#define RAWIOTRACE /* */
/*#define BUFERTRACE /* */
/*	machdep.c	6.2	83/10/02	*/

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/kernel.h"
#include "../h/map.h"
#include "../h/vm.h"
#include "../h/proc.h"
#include "../h/buf.h"
#include "../h/reboot.h"
#include "../h/nami.h"
#include "../h/conf.h"
#include "../h/inode.h"
#include "../h/file.h"
#include "../h/text.h"
#include "../h/clist.h"
#include "../h/callout.h"
#include "../h/cmap.h"
#include "../h/mbuf.h"
#include "../h/msgbuf.h"
#include "../h/quota.h"
#include "../machine/reg.h"
#include "../machine/pte.h"
#include "../machine/psl.h"
#include "../machine/trap.h"
#include "../machine/frame.h"
#include "../machine/board.h"

#ifdef	VBUS
extern short	vb[];
#ifndef	M68020
int		shortmem;		/* page number where short io begins */
extern u_char 	shortio[];		/* virtual address of short io memory */
#endif	M68020
#ifdef	ENP
extern short	enp[];
#endif	ENP
int		vbnum;
#endif	VBUS

int		bufpages;		/* now initialized in param.o */
int		detachedmem;
unsigned short	mymid, servermid;
char 		*strarg();

/*
 * Declare these as initialized data so we can patch them.
 */
int	nbuf 	= 0;
int	nswbuf 	= 0;
int	howto;			/* d7 == how to boot */
int	devtype;		/* d6 == major of root dev */
char	*initflg;		/* pointer to icode single/multi user flag */

/*
 * Machine-dependent startup code
 */
startup(firstaddr)
	int firstaddr;
{
	register int unixsize;
	register unsigned i;
	register struct pte *pte;
	int mapaddr, j;
	register caddr_t v;
	int maxbufs, base, residual;
	extern char etext;
	int fa = firstaddr;
#ifdef	MEMDISKLEN
#define	MEMDISKLEN	(1024 * 1024)
	extern unsigned long mdaddr, mdend;

	if (ctob(maxmem) - MEMDISKLEN >= 2 * 1024 * 1024) {
		mdend = ctob(maxmem);
		maxmem -= btoc(MEMDISKLEN);
		mdaddr = ctob(maxmem);
		freemem = physmem = maxmem;
	}
#endif	MEMDISKLEN

	newptes(Usrptmap, btop(usrpt), 1);

	/* Set icode init flag for single/multi user mode */
	if (howto & RB_SINGLE)
		*initflg = 's';
	else
		*initflg = 'm';

	/* Initialize error message buffer (at end of core). */
	maxmem -= btoc(sizeof (struct msgbuf));
	pte = msgbufmap;
	for (i = 0; i < btoc(sizeof (struct msgbuf)); i++)
		*(int *)pte++ = PG_V | PG_KW | (maxmem + i);
	newptes(msgbufmap, btop(&msgbuf), btoc(sizeof (struct msgbuf)));

#ifdef	VBUS
	vbnum = atoi(strarg("VBNUM"));
	skyinit();

#ifdef	M68010
	/* Map in short io space.  See locore for shortmem.  */
	mapin(shortiomap, btop(shortio), shortmem, 16, PG_V|PG_FOD|PG_KW);
#endif	M68010

	/* Map in graphics memory */
	fa = (firstaddr += GP_initialize(ctob(maxmem+1), fa));

#ifdef	ENP
	/* Map in CMC ethernet node processor memory */
	mapin(enpmap, btop( enp ), btop( 0xF81000 ), 31, PG_V|PG_KW);
#endif	ENP

	/* Map in cluster communications memory */
#ifdef	VB
	mapin(vbmap, btop(vb), btop(0xE00000), 32*12, PG_V|PG_KW);
#endif	VB
#endif	VBUS

	strcpy(hostname, strarg("HOST"));
	mymid = atoi(strarg("MID")) << 8;
	servermid = atoi(strarg("SID")) << 8;
	hostnamelen = strlen(hostname);
	hostid = mymid << 16;
	if (servermid) {
		swdevt[0].sw_dev = makedev(6, (servermid >> 8));
		swdevt[0].sw_nblks = 33440 /*66880*/;
	}

	/*
	 * Good {morning,afternoon,evening,night}.
	 */
	printf(version);
	printf("real      memory = %mM\n",ctob(detachedmem+maxmem+1));
	if (detachedmem)
		printf("detached  memory = %mM at 0x%x\n",
			ctob(detachedmem), ctob(maxmem+1));

	/*
	 * Allocate space for system data structures. The first available real 
	 * memory address is in "firstaddr". The first available kernel virtual
	 * address is in "v". As pages of kernel virtual memory are allocated,
	 * "v" is incremented. As pages of memory are allocated and cleared,
	 * "firstaddr" is incremented.  An index into the kernel page table 
	 * corresponding to the virtual memory address maintained in "v" is 
	 * kept in "mapaddr".
	 */
	v = (caddr_t)(SYSV_BASE | (firstaddr * NBPG));
#define	valloc(name, type, num) 		\
	    (name) = (type *)(v); (v) = (caddr_t)((name)+(num))
#define	valloclim(name, type, num, lim) 	\
	    (name) = (type *)(v); (v) = (caddr_t)((lim) = ((name)+(num)))
#define	tvalloc(name, type, num) 		\
	    printf("name:	%x	len %x bytes\n", v, sizeof(type)*num); \
	    valloc(name, type, num);
#define	tvalloclim(name, type, num, lim) 	\
	    printf("name:	%x	len %x bytes\n", v, sizeof(type)*num); \
	    valloclim(name, type, num, lim)

	valloclim(inode, struct inode, ninode, inodeNINODE);
	valloclim(file, struct file, nfile, fileNFILE);
	valloclim(proc, struct proc, nproc, procNPROC);
	valloclim(text, struct text, ntext, textNTEXT);
	valloc(cfree, struct cblock, nclist);
	valloc(callout, struct callout, ncallout);
	nswapmap = nproc * 2;
	valloc(swapmap, struct map, nswapmap);
	valloc(argmap, struct map, ARGMAPSIZE);
	valloc(kernelmap, struct map, USRPTSIZE);
	valloc(mbmap, struct map, nmbclusters/4);
	valloc(buffermap, struct map, BUFMAPSIZE);
#ifdef	QBUS
	valloc(buffermap18, struct map, BUFMAP18SIZE);
	valloc(buf18, struct buf, NBUF18);
#endif	QBUS
	valloc(nch, struct nch, nchsize);
#ifdef	QUOTA
	valloclim(quota, struct quota, nquota, quotaNQUOTA);
	valloclim(dquot, struct dquot, ndquot, dquotNDQUOT);
#endif	QUOTA
#ifdef	LOCKF
	valloclim(locklist, struct locklist, NRLOCKS, locklistNRLOCKS);
#endif	LOCKF
	
	/*
	 * Determine how many buffers to allocate.
	 * Use 10% of memory for the first 2 Meg, 5% of the remaining memory. 
	 * Insure a minimum of 16 buffers.  We allocate half as many swap 
	 * buffer headers as file i/o buffers.
	 */
	if (bufpages == 0) {
		if (physmem < (2 * 1024 * 1024))
			bufpages = physmem / 10 / CLSIZE;
		else
			bufpages =
			    ((2 * 1024 * 1024) / 5 + physmem / 5) / CLSIZE;
#ifdef	QBUS
		bufpages -= btoc(NBUF18 * MAXBSIZE);
#endif	QBUS
	}
	if (nbuf == 0) {
		nbuf = (bufpages * CLBYTES) / AVGBSIZE;
/*		nbuf = bufpages / 2;	/**/
		if (nbuf < 20)
			nbuf = 20;
	}
	if (nswbuf == 0) {
		nswbuf = (nbuf / 2) &~ 1;	/* force even */
		if (nswbuf > 256)
			nswbuf = 256;		/* sanity */
	}
	if (nswbuf > 32)
		nswbuf = 32;		/* temporary kludge -- see swap() */

	valloc(swbuf, struct buf, nswbuf);

	/*
	 * Now the amount of virtual memory remaining for buffers can be 
	 * calculated, estimating needs for the cmap.
	 */
	ncmap = (maxmem*NBPG - ((int)v &~ SYSV_BASE)) /
		(CLBYTES + sizeof(struct cmap)) + 2;
	maxbufs = ((SYSPTSIZE * NBPG) -
	    ((int)(v + ncmap * sizeof(struct cmap)) - SYSV_BASE)) /
		(MAXBSIZE + sizeof(struct buf));
	if (maxbufs < 16)
		panic("sys pt too small");
	if (nbuf > maxbufs) {
	    printf("***  WARNING: SYSPTSIZE limits buffers from %d to %d ***\n",
		nbuf, maxbufs);
	    nbuf = maxbufs;
	}
	if (bufpages > nbuf * (MAXBSIZE / CLBYTES)) {
	    printf("***  WARNING: SYSPTSIZE limits bufpages from %d to %d ***\n",
		bufpages, nbuf * (MAXBSIZE / CLBYTES)); /**/
	    bufpages = nbuf * (MAXBSIZE / CLBYTES);
	}
	valloc(buf, struct buf, nbuf);
	valloc(buffers, char, bufpages * CLBYTES);

	/*
	 * Allocate space for core map.
	 * Allow space for all of phsical memory minus the amount 
	 * dedicated to the system. The amount of physical memory
	 * dedicated to the system is the total virtual memory of
	 * the system thus far, plus core map, buffer pages,
	 * and buffer headers not yet allocated.
	 * Add 2: 1 because the 0th entry is unused, 1 for rounding.
	 */
	ncmap = (maxmem*NBPG - ((int)v &~ SYSV_BASE)) /
		(CLBYTES + sizeof(struct cmap)) + 2;
	valloclim(cmap, struct cmap, ncmap, ecmap);
	if (((int)v & ~SYSV_BASE) > SYSPTSIZE*NBPG) {
		printf("v = %x, max %x\n", (int)v & ~SYSV_BASE, SYSPTSIZE*NBPG);
		panic("SYSPTSIZE too small");
	}

	/*
	 * Clear space allocated thus far, and make r/w entries for the space 
	 * in the kernel map.
	 */
	unixsize = btoc((int)v &~ SYSV_BASE);
	while (firstaddr < unixsize) {
		*(int *)(&Sysmap[firstaddr]) = PG_V | PG_KW | firstaddr;
		clearseg((unsigned)firstaddr);
		firstaddr++;
	}

	if (firstaddr >= physmem - 8*UPAGES)
		panic("no memory");
	newptes(&Sysmap[fa], fa, firstaddr - fa);

	/* Initialize callouts */
	callfree = callout;
	for (i = 1; i < ncallout; i++)
		callout[i-1].c_next = &callout[i];

	/* Initialize memory allocator and swap and user page table maps.  */
	meminit(firstaddr, maxmem);
	maxmem = freemem;
	printf("available memory = %mM\n", ctob(maxmem));
#ifdef	REALTIME
	/*
	 * Allow upto 75 % of memory to be locked. This number should be tuned;
	 * it is user settable in param.c.
	 */
	if (lockablemem == 0)
		lockablemem = (maxmem * 75) / 100;
	else {
		printf("user configured lockable mem = %mM\n", 
				ctob(lockablemem));
	}
#endif	REALTIME
	if (maxmem < 128)
		printf("***  WARNING:  Insufficient memory for this configuration  ***\n\n");
#ifdef	QBUS
	printf("using %d buffers containing %mM of memory\n", nbuf + NBUF18,
		(bufpages * CLBYTES) + (NBUF18 * MAXBSIZE));
#else	QBUS
	printf("using %d buffers containing %mM of memory\n", nbuf,
		(bufpages * CLBYTES));
#endif	QBUS
	rminit(buffermap, bufpages * CLBYTES, (long)buffers,
	    "buffers", BUFMAPSIZE);
#ifdef	QBUS
	rminit(buffermap18, NBUF18 * MAXBSIZE, (long)buffers18,
	    "18bitbuffers", BUFMAP18SIZE);
#endif	QBUS
	rminit(kernelmap, (long)USRPTSIZE-1, (long)1,
	    "usrpt", USRPTSIZE);
	rminit(mbmap, (long)((nmbclusters - 1) * CLSIZE), (long)CLSIZE,
	    "mbclusters", nmbclusters/4);

	/* Configure the system.  */
	configure();
}

#ifdef	PGINPROF
/*
 * Return the difference (in microseconds)
 * between the  current time and a previous
 * time as represented  by the arguments.
 */
vmtime(otime, olbolt, oicr)
	int otime, olbolt, oicr;
{
	return(((time.tv_sec-otime)*60 + lbolt-olbolt)*16667 + (0-oicr));
}
#endif	PGINPROF

#define	mask(s)		(1 << ((s)-1))
/*
 * Simulate vax sigcontext in <signal.h>, but with 680[12]0 stack frame format. 
 * Note that pc and psl are exchanged (they are in vax order).
 */
struct sigctx {
	int		sc_onstack;		/* sigstack state to restore */
	int		sc_mask;		/* signal mask to restore */
	int		sc_sp;			/* user sp to restore */
	union xsf	sc_xsf;			/* extended exception frame */
};						/* with pc and psl exchanged */
#define	sc_pc	sc_xsf.xf0.xsf_psl		/* vax pc position */
#define	sc_psl	sc_xsf.xf0.xsf_pc		/* vax psl position */

/*
 * Args to sigcode, plus eventual arg to sigcleanup, pushed on interrupt stack.
 * sigcode copies the first 3 items to make args to user's handler.
 */
struct sigframe {
	int		sf_sig;			/* signal # */
	int		sf_code;		/* extra hdware code */
	struct sigctx	*sf_sctxp;		/* ptr to sigcontext */
	int		(*sf_handler)();	/* user's handler */
	struct sigctx	*sf_copy_sctxp;		/* arg for sigcleanup */
};

/*
 * Sendsig - Send an interrupt to a process: First sigcode (see locore.s) gets 
 * pushed on the current user stack, for lack of any better place to put it.  
 * Then a max size sigctx structure (an extended sigcontext structure from 
 * <signal.h>) gets pushed on the user stack, to be used by sigcleanup (below)
 * to return to the user state before the interrupt occurred.  After pushing
 * the sigctx structure, we potentially switch to the user's interrupt stack.  
 * We push a sigframe structure, providing the arguments to the signal handler.
 * When we return from here to the user, we will return to the stacked sigcode.
 * After the user's signal handler returns to the sigcode, it will trap to 
 * sigcleanup (below) to finish the job. There is a unique trap #code for each 
 * 680[12]0 stack format to clean up.
 */
sendsig(handler, sig, sigmask)
int		(*handler)();			/* user's signal handler */
register int	sig;				/* signal number */
int		sigmask;			/* mask restore */
{
	register caddr_t	sigp;		/* where sigcode goes */
	struct sigctx		sctx;		/* sigctx is built here */
	register struct sigctx	*sctxp;		/* where sigctx goes */
	struct sigframe		sframe;		/* sigframe is built here */
	register struct sigframe *sframep;	/* where sigframe goes */
	register int		*regs;		/* ptr to user's regs */
	u_short			*vec;		/* stack format vector ptr */
	register int		xsfsize;	/* size of xsf stack frame */
	register int		oonstack;	/* old onstack status */
	extern caddr_t		sigcode;	/* sigcode, in locore.s */
	extern int		szsigcode;	/* sizeof sigcode */

	regs = u.u_ar0;
	oonstack = u.u_onstack;
	if (regs[SP] >= USRSTACK)	/* out of range */
		goto bad;
	sigp = (char *)(regs[SP] - szsigcode); /* claim space for sigcode */
	sctxp = (struct sigctx *)sigp - 1; /* claim space for sigctx */

	if (!u.u_onstack && (u.u_sigonstack & mask(sig))) {
		sframep = (struct sigframe *)u.u_sigsp - 1;
		u.u_onstack = 1;
	} else
		sframep = (struct sigframe *)sctxp - 1;

	/*
	 * Must build signal handler context on stack to be returned to so that
	 * sigcleanup (trapped to from sigcode) will pop ps and pc off correct 
	 * stack.  The remainder of the signal state used in calling the handler
	 * must be placed on the stack on which the handler is to operate so 
	 * that the procedure entry code in sigcode will save the registers and
	 * such correctly.
	 */
	if (!oonstack && (u_int)sframep <= USRSTACK - ctob(u.u_ssize)) 
		(void) grow((u_int)sframep);
	if (!useracc((caddr_t)sframep, sizeof (struct sigframe), B_WRITE))
		goto bad;
	if (!u.u_onstack && (u_int)sctxp <= USRSTACK - ctob(u.u_ssize))
		(void) grow((u_int)sctxp);
	if (!useracc((caddr_t)sctxp, sizeof (struct sigctx), B_WRITE))
		goto bad;
	if (copyout(sigcode, sigp, (u_int)szsigcode))
		goto bad;
	sframe.sf_sig = sig;
	if (sig == SIGILL || sig == SIGFPE) {
		sframe.sf_code = u.u_code;
		u.u_code = 0;
	} else
		sframe.sf_code = 0;
	sframe.sf_sctxp = sctxp;
	sframe.sf_handler = handler;

	/*
	 * Duplicate the pointer to the sigctx structure. This one doesn't get 
	 * popped by the rtd, and is used by sigcleanup to reset the signal 
	 * state on inward return.
	 */
	sframe.sf_copy_sctxp = sctxp;

	/* put sigframe structure on user's interrupt stack */
	if (copyout((caddr_t)&sframe, (char *)sframep, (u_int)sizeof(sframe)))
		goto bad;

	/* 
	 * Compute extended exception stack frame size and its sigcode entry
	 */
	sctx.sc_onstack = oonstack;	/* sigctx goes on previous stack */
	sctx.sc_mask = sigmask;
	sctx.sc_sp = regs[SP];
	vec = (u_short *)&regs[PC + 1];	/* xsf format/vector */
	switch (*vec & (ESF_FMTMSK & ~ESF_SOFT)) {
	  case ESF_FMT0:		/* sigcode returns via trap #8 */
		xsfsize = XSF_ISIZE0; sigp += 0; break;
	  case ESF_FMT2:		/* sigcode returns via trap #6 */
		xsfsize = XSF_ISIZE2; sigp += 2; break;
	  case ESF_FMT8:		/* sigcode returns via trap #5 */
		xsfsize = XSF_ISIZE8; sigp += 4; break;
	  case ESF_FMT9:		/* sigcode returns via trap #4 */
		xsfsize = XSF_ISIZE9; sigp += 6; break;
	  case ESF_FMTA:		/* sigcode returns via trap #3 */
		xsfsize = XSF_ISIZEA; sigp += 8; break;
	  case ESF_FMTB:		/* sigcode returns via trap #2 */
		xsfsize = XSF_ISIZEB; sigp += 10; break;
	  default:
		panic("Sendsig: bad stack format");
	}

	/* copy appropriate amount of kernel exception stack to local buffer */
	bcopy((caddr_t)&regs[PS], (caddr_t)&sctx.sc_pc, xsfsize);
	sctx.sc_psl = regs[PS];		/* make VAX order pc/psl */
	sctx.sc_pc = regs[PC];		/* make VAX order pc/psl */

	/* copy local sigctx to previous user stack */
	if (copyout((char *)&sctx, (char *)sctxp, (u_int)sizeof(sctx)))
		goto bad;

	/* 
	 * If we have a long frame, mark it so locore will collapse it to a 
	 * short 4-word frame to enter user sigcode.
	 */
	if (xsfsize != XSF_ISIZE0)	/* tell locore to collapse stack */
		*vec |= ESF_SOFT;	/* use illegal stack format bit */
	regs[SP] = (int)sframep;
	regs[PC] = (int)sigp;
	return;

bad:	sendill();
}

/*
 * Routine to cleanup state after a longjmp or signal has been taken. This is 
 * entered via trap #{8,7,6,5,4,3,2} which generates a negative syscall 
 * {-2,-1,-3,-4,-5,-6,-7}, one code per 680[12]0 exception stack format. User 
 * stack top is ptr to sigctx placed by Sendsig. Reset signal mask and stack 
 * state from sigctx, then fake a vax rei.
 */
sigcleanup(code)
int	code;		/* negative syscall code */
{
	struct sigctx		sctx;		/* local sigcontext buffer */
	register struct sigctx	*sctxp;		/* addr of user sigcontext */
	register struct proc	*p = u.u_procp;	/* current process */
	register u_int		sp;
	register u_int		ulen;		/* sizeof sigcontext struct */
	register u_short	fmt;		/* xsf stack format */
	register int		xsfsize;	/* size of xsf stack frame */

	if (code == -1)			/* longjmp cleanup */
		ulen = 5*4;		/* sizeof vax sigcontext cleanup */
	else
		ulen = sizeof(sctx);	/* sizeof 680[12]0 max sigcontext */

	sctxp = (struct sigctx *)fuword((caddr_t)u.u_ar0[SP]);
	if ((int)sctxp == -1)
		goto bad;
	if (!useracc((caddr_t)sctxp, ulen, B_WRITE))
		goto bad;
	/* get user's sigctx structure */
	if (copyin((caddr_t)sctxp, (caddr_t)&sctx, ulen))
		goto bad;
	u.u_onstack = sctx.sc_onstack & 01;
	p->p_sigmask = 
		sctx.sc_mask &~ (mask(SIGKILL)|mask(SIGCONT)|mask(SIGSTOP));
	sp = sctx.sc_sp;

	/* compute size of xsf stack frame */
	fmt = sctx.sc_xsf.xf0.xsf_vec & (ESF_FMTMSK & ~ESF_SOFT);
	xsfsize = -1;
	switch(code) {
	  case -1:		/* trap #7 longjmp cleanup */
		sp += 8;	/* pop pc and psl in fake sigcontext */
		xsfsize = 0;	/* don't copy user sigcontext */
		break;
	  case -2:		/* trap #8 xsf format 0 signal cleanup */
		if (fmt == ESF_FMT0)
			xsfsize = XSF_ISIZE0;
		break;
	  case -3:		/* trap #6 xsf format 2 signal cleanup */
		if (fmt == ESF_FMT2)
			xsfsize = XSF_ISIZE2;
		break;
	  case -4:		/* trap #5 xsf format 8 signal cleanup */
		if (fmt == ESF_FMT8)
			xsfsize = XSF_ISIZE8;
		break;
	  case -5:		/* trap #4 xsf format 9 signal cleanup */
		if (fmt == ESF_FMT9)
			xsfsize = XSF_ISIZE9;
		break;
	  case -6:		/* trap #3 xsf format A signal cleanup */
		if (fmt == ESF_FMTA)
			xsfsize = XSF_ISIZEA;
		break;
	  case -7:		/* trap #2 xsf format B signal cleanup */
		if (fmt == ESF_FMTB)
			xsfsize = XSF_ISIZEB;
		break;
	  default:
		goto bad;
	}
	if (xsfsize == -1)	/* user changed the stack format */
		goto bad;
	if (xsfsize > 0)	/* user's sigcontext is in vax order */
		bcopy((char *)&sctx.sc_pc, (char *)&u.u_ar0[PS], xsfsize);

	/* 
	 * now fake a vax rei, then pop the sigcode off user stack.
	 */
	u.u_ar0[PC] = sctx.sc_pc;	/* get pc from VAX order sigcontext */
	u.u_ar0[PS] = sctx.sc_psl;	/* get psl from VAX order sigcontext */
	u.u_ar0[PS] |= PSL_USERSET;	/* ensure return to user mode */
	u.u_ar0[PS] &= ~PSL_USERCLR;
	u.u_ar0[SP] = sp;
	return;

bad:	sendill();
}

/* proc trashed its stack, zap it */
sendill()
{
	register int sig;

	u.u_signal[SIGILL] = SIG_DFL;
	sig = mask(SIGILL);
	u.u_procp->p_sigignore &= ~sig;
	u.u_procp->p_sigcatch &= ~sig;
	u.u_procp->p_sigmask &= ~sig;
	psignal(u.u_procp, SIGILL);
}
#undef	mask

#ifdef	M68020
static int tout_cpu = 1;
static int cpu_tout()
{
	tout_cpu = 0;
}
#endif	M68020

prcpuspeed()
{
#ifdef	M68020
	register unsigned int i, j, k;
#define	DIVIDER	65200

	timeout(cpu_tout, (caddr_t)0, hz);
	spl0();
	for(i = 0; tout_cpu ; i++)
		;
	spl7();
	j = i/DIVIDER;
	k = ((i - (j*DIVIDER)) * 100) / DIVIDER;
/*	printf("%d.%dMHz CPU %d\n", j, k/10, i); /**/
	if (j < 16)
		printf("<16");
	else if (j == 16 && k/10 < 3)
		printf("16");
	else if (j < 17)
		printf("16.67");
	else
		printf(">17");
	printf("MHz MC68020 CPU");

	if (have68881())
		printf(" with MC68881 Floating-Point Coprocessor");
	printf("\n");
#else	M68020
	switch (*BSR & BSR_CPUSPEED) {
#ifdef	BSR_CPUSPEED8
	  case BSR_CPUSPEED8:	printf("8"); break;
#endif	BSR_CPUSPEED8
#ifdef	BSR_CPUSPEED10
	  case BSR_CPUSPEED10:	printf("10"); break;
#endif	BSR_CPUSPEED10
#ifdef	BSR_CPUSPEED11
	  case BSR_CPUSPEED11:	printf("11.1"); break;
#endif	BSR_CPUSPEED11
#ifdef	BSR_CPUSPEED12
	  case BSR_CPUSPEED12:	printf("12"); break;
#endif	BSR_CPUSPEED12
	}
	printf("MHz MC68010 CPU\n");
#endif	M68020
}

int want_parity = 1;
memenable()
{
#ifdef	QBUS
	/* older QBUS CPU cards do not correctly support parity */
#else	QBUS
	if (want_parity) {
		printf("Parity Enabled\n");
		parityon();
	} else {
		printf("Parity NOT Enabled\n");
		parityoff();
	}
#endif	QBUS
}

int	waittime = -1;

boot(paniced, arghowto)
int paniced, arghowto;
{
	register struct buf *bp;
	int iter, nbusy0, nbusy1;

/*	bufertrace();	/* */
/*	sleeptrace();	/* */
/*	stacktrace();	/* */
	(void) spl0();
	howto = arghowto;
	devtype = rootdev;
	if ((howto&RB_NOSYNC)==0 && waittime < 0 && bfreelist[0].b_forw) {
		waittime = 0;
		update();
		printf("syncing disks... ");
		nbusy0 = 100000;
		for (iter = 0; iter < 20; iter++) {
			nbusy1 = 0;
			for (bp = &buf[nbuf]; --bp >= buf; )
				if ((bp->b_flags & (B_BUSY|B_INVAL)) == B_BUSY)
					nbusy1++;
			if (nbusy1 == 0)
				break;
			if (nbusy1 < nbusy0) {
				printf("%d ", nbusy1);
				nbusy0 = nbusy1;
				iter = 0;
			}
			DELAY(80000);
		}
		DELAY(400000);
		printf("...done\n");
		DELAY(400000);
	}
	spl7();
#ifdef	VB
	vbreboot();
#endif	VB
	if (howto&RB_HALT) {
		printf("halting (in tight loop); hit RESET\n\n");
		for (;;)
			;
	} else if (paniced == RB_PANIC) {
			/*NOTREACHED*/
	}
	DELAY(800000);
	_reboot();
	/*NOTREACHED*/
}

#ifdef	notdef
int	dumpmag = 0x8fca0101;	/* magic number for savecore */
int	dumpsize = 0;		/* also for savecore */
/*
 * Doadump comes here after turning off memory management and
 * getting on the dump stack, either when called above, or by
 * the auto-restart code.
 */
dumpsys()
{

/*	rpb.rp_flag = 1;
/* */
#ifdef notdef
	if ((minor(dumpdev)&07) != 1)
		return;
#endif
	dumpsize = physmem;
	printf("\ndumping to dev %x, offset %d\n", dumpdev, dumplo);
	printf("dump ");
	switch ((*bdevsw[major(dumpdev)].d_dump)(dumpdev)) {

	case ENXIO:
		printf("device bad\n");
		break;

	case EFAULT:
		printf("device not ready\n");
		break;

	case EINVAL:
		printf("area improper\n");
		break;

	case EIO:
		printf("i/o error");
		break;

	default:
		printf("succeeded");
		break;
	}
}
#endif	notdef

physstrat(bp, strat, prio, lock)
	register struct buf *bp;
	int (*strat)(), prio, lock;
{
	register int ioaddr;
	register struct buf *bbp;
	char *a;
	int c, rw;

	/* pageout daemon doesn't wait for pushed pages */
	if (bp->b_flags & B_DIRTY)
		(*strat)(bp);
	else {
	    if (u.u_Rclient  ||
		((ioaddr = qbaddrmap(bp)),
		 (btop(ioaddr) != btop(ioaddr+bp->b_bcount-1)))
#ifdef	QBUS
		|| ((BQUALIFY(bp->b_dev)&B_18BIT) && 
		   (ioaddr+bp->b_bcount > 0x40000)) ) {
#else	QBUS
		) {
#endif	QBUS
		bbp = (struct buf *)getqeblk(bp->b_bcount, BQUALIFY(bp->b_dev));
		bbp->b_dev = bp->b_dev;
		bbp->b_blkno = bp->b_blkno;
		bbp->b_flags |= (bp->b_flags & (B_READ|B_WRITE));
#ifdef	RAWIOTRACE
		printf("b_blkno=%x b_bcount=%x b_bufsiz=%x b_flags=%b ",
			bbp->b_blkno,bbp->b_bcount,bbp->b_bufsize,
			bbp->b_flags,B_FLAGS_BITS);
#endif	RAWIOTRACE
		if ((bp->b_flags & B_READ) == 0) {
#ifdef	RAWIOTRACE
			printf("copyin from b_addru=%x to b_addrk=%x\n",
				bp->b_un.b_addr,bbp->b_un.b_addr);
#endif	RAWIOTRACE
			copyin(bp->b_un.b_addr, bbp->b_un.b_addr, bp->b_bcount);
		}
		(*strat)(bbp);
		biowait(bbp);
#ifdef	RAWIOTRACE
		printf("IODONE b_flags=%b ", bbp->b_flags,B_FLAGS_BITS);
#endif	RAWIOTRACE
		if (bp->b_flags & B_READ) {
#ifdef	RAWIOTRACE
			printf("copyout to b_addru=%x from b_addrk=%x\n",
				bp->b_un.b_addr,bbp->b_un.b_addr);
#endif	RAWIOTRACE
			copyout(bbp->b_un.b_addr, bp->b_un.b_addr, bp->b_bcount);
		}
		bp->b_flags |= (bbp->b_flags & B_ERROR);
		bp->b_resid = bbp->b_resid;
		bbp->b_dev = NODEV;
		bfree(bbp);
		brelse(bbp);
	    } else {
		if (lock) {
			rw = bp->b_flags & B_READ;
			vslock(a = bp->b_un.b_addr, c = bp->b_bcount);
		}
		(*strat)(bp);
		biowait(bp);
		if (lock)
			vsunlock(a, c, rw);
	    }
	}
}

stacktrace (arg0, arg1)
int arg0, arg1;
{
#ifdef STACKTRACE
	register struct frame *fp = ((struct frame *)&arg1) - 1;
	register struct frame *nextfp;
	register i = 0;
	int s;

	s = spl6();
	if ((caddr_t)fp < (caddr_t)&u  ||  
	    ((caddr_t)fp + sizeof(struct frame)) > (caddr_t)&u + 4096) {
		printf("stacktrace: initial fp=0x%x\n", fp);
		splx(s);
		return;
	}
	for (nextfp = (struct frame *)fp->fr_savfp;  ((int)nextfp & 1) == 0  &&
	     nextfp > fp  &&  (caddr_t)nextfp > (caddr_t)&u && 
	     ((caddr_t)nextfp + sizeof(struct frame)) < (caddr_t)&u + 4096;
	     nextfp = (struct frame *)fp->fr_savfp) {
		fp = nextfp;
		printf("savfp=0x%x savpc=0x%x	(0x%x,0x%x,0x%x)",
			fp->fr_savfp, fp->fr_savpc, fp->fr_arg[0], 
			fp->fr_arg[1], fp->fr_arg[2]);
		if (++i > 16) {
			printf("...\n");
			break;
		}
		printf("\n");
	}
	splx(s);
#endif STACKTRACE
}

/*
 * Print wait address of all sleeping procs
 */
sleeptrace(n)
register n;
{
#ifdef SLEEPTRACE
	register struct proc *p, **q;
	extern struct proc *slpque[];
	register i = 0;
	int s;
	static oldn = 0;

	s = spl6();
	n -= oldn;
	printf("sleep queue: %d\n",n);
	for (q = &slpque[0]; q < &slpque[0100]; q++)
		for (p = *q; p ; p = p->p_link ) {
			if (i++ == 20) {
				i = 0;
				n -= 1;
			}
			if (n == 0  ||  (n == -1  &&  i == 0))
			printf("PROC %x PID %d stat %x wait on %x at pri %d\n",
				p, p->p_pid, p->p_stat, p->p_wchan, p->p_pri);
		}
	if (n >= 0)
		oldn = n + 1;
	splx(s);
#endif SLEEPTRACE
}

bufertrace()
{
#ifdef BUFERTRACE
	register struct buf *dp, *bp;
	int i, j;
	int s;

	s = spl6();
	for (i=0,j=0 ; i < BQUEUES ; i++) {
		dp = &bfreelist[i];
		printf("FREE QUEUE %d %x :\n        ",i,dp);
		for (bp = dp->av_forw ; bp != dp ; bp = bp->av_forw) {
#ifdef	QBUS
			if (bp->b_flags & B_18BIT)
				printf("*");
#endif	QBUS
			printf("(%x %b %x) ",bp, bp->b_flags, B_FLAGS_BITS, bp->b_bufsize);
			if ((++j)%4 == 0)
				printf("\n        ");
		}
		printf("\n");
	}
	for (i=0 ; i < BUFHSZ ; i++) {
		dp = &bufhash[i];
		if (dp->b_forw == dp || dp->b_forw == 0)
			continue;
		j = 0;
		printf("CACHE QUEUE %d %x : ",i,dp);
		for (bp = dp->b_forw ; bp != dp ; bp = bp->b_forw) {
#ifdef	QBUS
			if (bp->b_flags & B_18BIT)
				printf("*");
#endif	QBUS
			printf("(%x %b %x) ",bp, bp->b_flags, B_FLAGS_BITS, bp->b_bufsize);
			if ((++j)%4 == 0)
				printf("\n        ");
		}
		printf("\n");
	}
	splx(s);
#endif BUFERTRACE
}


#define	ARGBUF		((char *)0x700)
#define	ARGBUFSIZE	(0x100 - 0x10)

char *
strarg(p)
register char *p;
{
	register char *q = ARGBUF;
	register int len = strlen(p);
	register int nleft = ARGBUFSIZE - len - 2;

	while (--nleft >= 0) {
		switch (q[-1]) {
		  case '\0': case ' ': case '\t': case '\n': case '\r':
			break;
		  default:
			q += 1;
			continue;
		}
		if (strncmp(p, q, len) == 0  &&  q[len] == '=') {
			q = p = &q[len + 1];
			while (--nleft >= 0)
				switch (*p++) {
				  case '\0': case ' ': case '\t': case '\n':
				  case '\r':
					*--p = '\0';
					return q;
				}
			*--p = '\0';
			return q;
		}
		q += 1;
	}
	return (char *)0;
}

atoi(p)
register char *p;
{
	register n = 0, base = 10, minus = 0;

	if (p == (char *)0)
		return 0;
	while (*p == ' '  ||  *p == '\t')
		p++;
	if (*p == '-') {
		minus = 1;
		p++;
	} else if (*p == '+')
		p++;
	if (*p == '0') {
		base = 8;
		p++;
		if (*p == 'x'  ||  *p == 'X') {
			base = 16;
			p += 1;
		}
	}
	for(;;) {
		switch (*p) {
		  case '0': case '1': case '2': case '3': case '4':
		  case '5': case '6': case '7': case '8': case '9':
			n = n * base + *p++ - '0';
			continue;
		  case 'a': case 'b': case 'c': case 'd': case 'e': case 'f':
			n = n * base + *p++ + 10 - 'a';
			continue;
		  case 'A': case 'B': case 'C': case 'D': case 'E': case 'F':
			n = n * base + *p++ + 10 - 'A';
			continue;
		}
		break;
	}
	switch (*p) {
	  case 'b': case 'B':
		n *= 512;
		break;
	  case 'k': case 'K':
		n *= 1024;
		break;
	  case 'm': case 'M':
		n *= 1024 * 1024;
		break;
	}
	return minus ? -n : n;
}
