/*	IS-68020 locore.s	09/23/85	CTH */

/*#define NEWAS		/* uncomment if assembler with 020+68881 instructions */
#define FP_68881	/* comment to disable 68881 save/restore on switch */
#define FP_SKY  	/* comment to disable sky save/restore on switch */
/*#define KPROF	0x10000	/* enable kernel profiling */

#include "../h/errno.h"
#include "../h/param.h"
#include "../machine/psl.h"
#include "../machine/pte.h"
#include "../machine/pcb.h"
#include "../machine/trap.h"
#include "../machine/scb.h"
#include "../machine/board.h"
#include "../is68kdev/sioreg.h"
#ifdef	FP_SKY
#include "../is68kdev/skyreg.h"
#endif	FP_SKY
#include "../net/netisr.h"

/*
 *	Debug trace skeleton and flags:
 *		TRACE(<ea>)
 *		Printn(reg, scratch_D_reg, scratch_D_reg, scratch_A_reg)
 */
#define	TXW		9: btst #2,S2681_R_SR_A; jeq 9b; /* wait for transmit */
#define	TRACE(x)	TXW; movb x,S2681_W_THR_A
#define	PN(X,Y,Z)	roll #4,X; movb X,Y; andw #0xF,Y; TRACE(Z@(0,Y:w))
#define	Printn(W,X,Y,Z) movl #N2C,X;andl #0xFFFFFFF,X;movl X,Z;movl W,X; \
			TRACE(#0x7b);PN(X,Y,Z);PN(X,Y,Z);PN(X,Y,Z);PN(X,Y,Z); \
			PN(X,Y,Z);PN(X,Y,Z);PN(X,Y,Z);PN(X,Y,Z);TRACE(#0x7d)

/*
 * System page table, must begin on a page boundary
 */
#define	vaddr(x)	(((((x) - _Sysmap) / 4 ) * NBPG ) + SYSV_BASE)
.set	pteindx,	SYSV_BASE + 0x1000

#define	SYSMAP(mname, vname, npte)					\
	.globl	_/**/mname;						\
	.globl	_/**/vname;						\
	.globl	_TBUF_S_/**/vname;					\
	.set	_/**/mname,	pteindx;				\
	.set	_/**/vname,	vaddr(_/**/mname);			\
	.set	_TBUF_S_/**/vname,TBUF_BASE_SYS|(_/**/vname&0x1FF000);	\
	.set	pteindx,	pteindx + (npte * 4);

	SYSMAP(Sysmap		,Sysbase	,SYSPTSIZE )
	SYSMAP(Usrptmap		,usrpt		,USRPTSIZE )
	SYSMAP(Umap		,u		,UPAGES )
	SYSMAP(Forkmap		,forkutl	,UPAGES )
	SYSMAP(Xswapmap		,xswaputl	,UPAGES )
	SYSMAP(Xswap2map	,xswap2utl	,UPAGES )
	SYSMAP(Swapmap		,swaputl	,UPAGES )
	SYSMAP(Pushmap		,pushutl	,UPAGES )
	SYSMAP(Vfmap		,vfutl		,UPAGES )
	SYSMAP(mcrmap		,mcr		,1 )
	SYSMAP(mmap		,vmmap		,1 )
	SYSMAP(msgbufmap	,msgbuf		,MSGBUFPTECNT )
	SYSMAP(camap		,cabase		,16*CLSIZE )
	SYSMAP(ecamap		,calimit	,0 )
	SYSMAP(Mbmap		,mbutl		,NMBCLUSTERS*CLSIZE )
#ifdef	GWS
	SYSMAP(vidbufmap	,vidbuf		,8*32 )
#endif	GWS
#ifdef	ENP
	SYSMAP(enpmap		,enp		,32)
#endif	ENP
#ifdef	VB
	SYSMAP(vbmap		,vb		,12*32)
#endif	VB
	SYSMAP(eSysmap		,esysmap	,0 )

	.globl	_Syssize
	.set	_Syssize,(_eSysmap - _Sysmap) / 4

#define	FC_UD		0x1		/* function code for user data */
#define	FC_UC		0x2		/* function code for user code */
#define	PSL_IPLN	PSL_IPL1	/* must be higher than PSL_IPLC */
#define	PSL_IPLC	PSL_IPL0

	.text
	.globl	start
/*
 * Initialization
 */
start:	movw	#PSL_IPL7,sr		/* make sure interrupts are disabled */
	lea	0x1000,sp		/* temporary stack */

	/* 
	 * Set up scb so if we trap out we end up in the PROM, for DEBUG.
	 */
	lea	0,a0
	movl	a0,vb			/* set vector base register to 0 */
	clrl	a0@+
	clrl	a0@+
	movw	#NSCBVEC-1-2,d0
	lea	PROM_REBOOT,a1
    1:	movl	a1,a0@+
	dbra	d0,1b

	/* 
	 * Determine processor type, panic if not 020
	 */

	/*
	 * Set context register and source/destination function codes for "movs"
	 */
	movl	#FC_UD,d0
	movl	d0,sfc			/* set source/destination function */
	movl	d0,dfc			/* code registers to user data */

	/*
	 * Initialize portion of Sysmap used for Sysmap itself: kernel code, 
	 * data, and bss.
 	 */
	movl	#_Sysmap,d0
	andl	#PTP_ADRMASK,d0		/* address of Sysmap nontranslated */
	movl	d0,a0
	movl	d0,a1
	movl	#_Sysbase,d0		/* Base of maped region */
	movl	#_end+NBPG-1,d1
	subl	d0,d1
	andl	#0x0FFFF000,d0
	movl	#PGSHIFT,d2
	lsrl	d2,d0
	orl	#PG_V|PG_KW,d0
	lsrl	d2,d1
	subl	#1,d1
    1:	movl	d0,a0@+
	addl	#1,d0
	dbra	d1,1b

	movl	#PG_KR,d0		/* invalidate to PTP pointer boundary */
    1:	movl	a0,d1
	andl	#PTP_LSBMASK-1,d1
	jeq	1f
	movl	d0,a0@+
	jra	1b

	/*
	 * Write protect as much kernel code as possibler. NOTE: kernel is a
	 * 407 image so there is no padding between text and data, leaving a
	 * small portion of kernel code which could be overwritten.
	 */
    1:	movl	#start,d0
	movl	d0,d1
	andl	#0x0FFFF000,d1
	lsrl	d2,d1
	lsll	#2,d1
	addl	a1,d1
	movl	d1,a1			/* Sysmap entry for start */
	movl	#_etext,d1
	subl	d0,d1
	lsrl	d2,d1
	subl	#1,d1
    1:	movl	a1@,d0
	andl	#~PG_PROT,d0		/* remove old protection */
	orl	#PG_KR,d0		/* add new protection */
	movl	d0,a1@+
	dbra	d1,1b

	/*
	 * Invalidate PTP's of all contexts
	 */
	movl	#PTP_INVALID,d1
	movl	#NCTX-1,d2
	movl	#PTP_INCR,d3
    1:	movb	d2,CTX
	movl	#NPTPS-1,d0
	lea	PTP_BASE,a0
    2:	movl	d1,a0@
	addl	d3,a0
	dbra	d0,2b
	dbra	d2,1b

	/*
	 * Invalidate system and user TBUF
	 */
	movl	#TBUF_INVALID,d1
	movl	#TBUF_INCR,d2
	lea	TBUF_BASE_SYS,a0
	lea	TBUF_BASE_USR,a1
	movl	#NTBUFS-1,d0
    1:	movl	d1,a0@;		addl	d2,a0
	movl	d1,a1@;		addl	d2,a1
	dbra	d0,1b

	/*
	 * Initialize system (context 0) PTP to point to Sysmap; context 0
	 * PTP is never touched again!
	 */
	lea	PTP_BASE,a0
	movl	#_Sysmap,d0
	andl	#PTP_ADRMASK,d0
	movl	#PTP_ADRSHIFT,d1
	lsrl	d1,d0
	movl	#_Syssize,d1
	movl	#9,d2
	lsrl	d2,d1
    1:	movl	d0,d2
	lsrl	#1,d2
	jcc	2f
	orl	#PTP_LSB,d2
    2:	movl	d2,a0@
	addl	#PTP_INCR,a0
	addl	#1,d0
	dbra	d1,1b

	/*******************************************************************
	 * Now able to reference kernel link space (system virtual) memory *
	 *******************************************************************/
	/*
	 * Size and zero non translated memory, starting at _edata.
	 * This will clear kernel BSS.
	 */
	movl	#_edata,d0
	andl	#NONT_MASK,d0
	movl	d0,a0
	movl	#0xCACAFECE,d0
	lea	0+SCB_BUSERR,a1		/* reprogram bus error vector */
	movl	a1@,d1
	movl	#2f,a1@
    1:	movl	d0,a0@
	cmpl	a0@,d0
	jne	2f
	clrl	a0@+
	jra	1b			/* clear until bus error */

	/*******************************************************************
	 * Now able to reference kernel BSS space                          *
	 *******************************************************************/
    2:	movl	d1,a1@
	movl	a0,d0
	movl	#PGSHIFT,d1
	lsrl	d1,d0
	subl	_detachedmem,d0		/* KLUDGE for detached mem */
	movl	d0,_maxmem
	movl	d0,_physmem
	movl	d0,_freemem
	movl	d7,_howto		/* PROM arguments: how to boot */
	movl	d6,_devtype		/* major number of boot device */

	/*
	 * Allocate and setup page table and _u area for proc[0]. 
	 * KLUDGE: UPAGES == 1
	 */
	movl	#_end+NBPG-1,d0		/* first page for proc 0 page table */
	andl	#0x0FFFF000,d0
	movl	#PGSHIFT,d1
	lsrl	d1,d0
	movl	d0,d2
	orl	#PG_V+PG_KW,d0
	movl	d0,_Usrptmap		/* map it into _usrpt */
	addl	#1,d0			/* next page is for proc 0 _u area */
	movl	d0,_usrpt+NBPG-4	/* last pte is for mapping _u area */
	movl	d0,_Umap		/* map it into _u */
	lea	_u+(UPAGES*NBPG),sp	/* set stack pointer to top of _u */

	/* 
	 * Initialize (slightly) the pcb
	 */
	lea	_u,a0
	movl	sp,a0@(PCB_SP)
	movw	sr,a0@(PCB_PSL+2)
	movl	#_usrpt,a0@(PCB_P0BR)
	movl	#AST_NONE+0,a0@(PCB_P0LR)
	movl	#(MAXU_ADDR>>PGSHIFT)-UPAGES,a0@(PCB_P1LR)
	movl	#_usrpt+(MAXU_ADDR>>PGSHIFT)-4,a0@(PCB_P1BR)
	movl	#1,a0@(PCB_SZPT)

	/*
	 * copy the template scb to vector base region (location 0).
	 */
	lea	_scb,a0
	lea	0,a1
	movw	#NSCBVEC-1,d0
    1:	movl	a0@+,a1@+
	dbra	d0,1b

	TRACE(#0xA); TRACE(#0xD);	/* Output "\n" */
	addl	#UPAGES+1,d2
	movl	d2,sp@-
	jsr	_main
	addl	#4,sp

	lea	NBPG,a0
	movl	a0,usp
	movw	#0,sp@-
	pea	0			/* user pc */
	movw	#PSL_USERSET,sp@-
	rte				/* go run icode */

/*
 * Interrupt vector routines. Following globals are for convienience in namelist
 */
	.globl	_waittime
	.globl	traps
	.globl	iret
	.globl	dorte

#define	SCBVEC(name)	.align 1;  .globl _X/**/name;  _X/**/name
#define	TRAP(x)		PEEXT(x); jra traps
#define	PEEXT(x)	clrw sp@-; pea x	/* push exception extention */
#ifdef	CAPTURE
#define	PUSHR		movml #0xC0C0,sp@-; jsr	_capture
#else	CAPTURE
#define	PUSHR		movml #0xC0C0,sp@-	/* save temp regs ([da][01]) */
#endif	CAPTURE
#define	POPR		movml sp@+,#0x0303	/* restore temp regs */
#define	PUSHED		16			/* offset around saved regs */
#define	TCODE		PUSHED			/* offset to trap code */
#define	TTYPE		(PUSHED+2)		/* offset to trap type */
#define	EEXT		6			/* size exception extension */
#define	ESF		(EEXT+PUSHED)		/* offset to exception frame */
#define	INC(counter)	addl #1,_cnt+counter
#define	IBEG		subl #EEXT,sp; PUSHR	/* null execption extention */
#define	RTE(n)		INC(n); jra iret

/*
 * collapse various stack formats to 4-word format 0 if ESF_SOFT bit is on in 
 * the stack format/vector offset word. Used to send signals to process, and 
 * for nofault recovery.
 */
#define	COLLAPSE(x)	\
    3:	cmpw	#ESF_FMT/**/x,sp@(ESF_VEC); jne 3f; /* stack format x to */    \
	movw	#ESF_FMT0,sp@(ESF_VEC+ESF_ISIZE/**/x-ESF_ISIZE0); /* fmt0 */   \
	movl	sp@(ESF_PC),sp@(ESF_PC+ESF_ISIZE/**/x-ESF_ISIZE0);/* copy pc */\
	movw	sp@(ESF_SW),sp@(ESF_SW+ESF_ISIZE/**/x-ESF_ISIZE0);/* copy sr */\
	lea	sp@(ESF_ISIZE/**/x-ESF_ISIZE0),sp; rte /* collapse stack size */

SCBVEC(stray):		TRAP(T_STRAY)
SCBVEC(adderr):		TRAP(T_ADDERR)
SCBVEC(illins):		TRAP(T_RESOPFLT)
SCBVEC(zerodiv):	TRAP(T_ZERODIV)
SCBVEC(chk):		TRAP(T_CHK)
SCBVEC(trapv):		TRAP(T_TRAPV)
SCBVEC(privvio):	TRAP(T_PRIVINFLT)
SCBVEC(l1010em):	TRAP(T_L1010EM)
SCBVEC(l1111em):	TRAP(T_L1111EM)
SCBVEC(trace):		TRAP(T_TRCTRAP)
SCBVEC(fmterr):		TRAP(T_FMTERR)
SCBVEC(coproc):		TRAP(T_COPROC)
SCBVEC(trap0):		TRAP(T_TRAP+(0<<16))
SCBVEC(trap9):		TRAP(T_TRAP+(9<<16))
SCBVEC(trap10):		TRAP(T_TRAP+(10<<16))
SCBVEC(trap11):		TRAP(T_TRAP+(11<<16))
SCBVEC(trap12):		TRAP(T_TRAP+(12<<16))
SCBVEC(trap13):		TRAP(T_TRAP+(13<<16))
SCBVEC(trap14):		TRAP(T_TRAP+(14<<16))
SCBVEC(trap15):		TRAP(T_BPTFLT)
SCBVEC(fpe):		TRAP(T_FPE)

traps:	PUSHR				/* save [da][01] temporary registers */
traps0:	movl	usp,a0			/* save user sp */
	pea	a0@
	jsr	_trap			/* call generic trap handler */
	movl	sp@+,a0
	movl	a0,usp			/* restore user sp */
	INC	(V_TRAP)		/* keep count */

iret:	movw	#PSL_IPL7,sr		/* raise priority to protect ast */
	tstb	_ast
	jne	4f			/* branch if pending async soft trap */
    1:	POPR				/* restore [da][01] */
	addl	#EEXT,sp		/* pop exception extention */

dorte:	bclr	#ESF_SOFT_BIT,sp@(ESF_VEC)
	jne	3f			/* branch if frame must be collapsed */
    2:	rte				/* return from trap/interrupt */

    3:	andw	#ESF_FMTMSK,sp@(ESF_VEC)/* isolate stack format */
	cmpw	#ESF_FMT0,sp@(ESF_VEC)	/* format 0 does not collapse */
	jeq	2b
#ifdef	M68020
	COLLAPSE(A)
	COLLAPSE(B)
	COLLAPSE(9)
	COLLAPSE(2)
#else	M68020
	COLLAPSE(8)
#endif	M68020
    3:	pea	panic_iret		/* bad stack format */
	jsr	_panic

    4:	movw	sp@(ESF+ESF_SW),d0	/* Handle asynchronious soft trap */
	andw	#PSL_HIGH,d0		/* are we returning to low priority? */
	jne	1b			/* no, leave ast pending */
	bclr	#AST_NET,_ast		/* check/clear net ast */
	jne	_Xnetintr
	bclr	#AST_TIC,_ast		/* check/clear softclock ast */
	jne	_Xsoftclock
	btst	#AST_USR,_ast		/* check/clear user resched ast */
	jeq	1b
	movw	sp@(ESF+ESF_SW),d0	/* must be user ast */
	andw	#PSL_CURMOD,d0		/* leave pending */
	jne	1b			/* if not return to user mode */
	bclr	#AST_USR,_ast		/* clear ast and go service in trap */
	movw	#T_ASTFLT,sp@(TTYPE)
	jra	traps0

SCBVEC(nmi):
#ifndef	KPROF
	TRAP(T_NMI)
#else	KPROF
	/*
	 * To prepare VMEBUS 68020 CPU board for kprof profiling at level 7:
	 *	-  Bend up U58 (LS32) pin 5, and ground that chip pin. This 
	 *	   disables latching of BSR on NMI interrupts, so that status 
	 *	   for bus errors is not lost.
	 *	-  Remove R5, which connects to AC fail on the bus. 
	 *	-  Inject profile clock into U82(LS113) pin 13.
	 */
	.data
	.globl	_kprof_magic
_kprof_magic:	.long	0x12345678
	.comm	_kprof_enable,4
	.comm	_kprof_su,2*4
	.comm	_kprof_spsl,8*4
	.comm	_kprof_upsl,8*4
	.comm	_kprof,KPROF*4
	.comm	_kprof_swtch,4
	.comm	_kprof_buse,4
	.comm	_kprof_sysc,4
	.comm	_kprof_pid,(20+32)*4	/* first 20 plus last 32 pid's */
	.comm	_kprof_pid_cnt,(20+32)*4
	.comm	_kprof_pid_nam,(20+32)*8
	.text

	IBEG
	tstb	_kprof_enable+3		/* skip if not enabled */
	jeq	3f
	cmpl	#0x800,sp		/* dont look at pid if swtching */
	jle	2f
	clrl	d0
	movl	_u+U_PROCP,a0		
	movw	a0@(P_PID),d0
	movl	d0,d1
	cmpw	#20,d0
	jle	1f
	andw	#0x1F,d0
	addl	#20,d0
    1:	lsll	#2,d0
	lea	_kprof_pid,a0
	addl	d0,a0
	movl	d1,a0@
	lea	_kprof_pid_cnt,a0
	addl	d0,a0
	addql	#1,a0@
	lea	_kprof_pid_nam,a0
	lsll	#1,d0
	addl	d0,a0
	lea	_u+U_COMM,a1		
	movl	a1@+,a0@+
	movl	a1@,a0@
    2:	clrl	d0
	movw	sp@(ESF+ESF_SW),d0	/* get psl */
	movw	d0,d1
	andl	#PSL_HIGH,d0
	lsrw	#PSL_IPL_SHIFT-2,d0	/* define kprof_[su]psl index */
	andl	#PSL_CURMOD,d1		/* test system mode */
	jeq	1f			/* jump if user mode */
	addql	#1,_kprof_su+4		/* accumulate system mode stats */
	jmi	4f;			/* jump if auto-shutoff */
	movl	sp@(ESF+ESF_PC),d1	/* get pc */
	andl	#NONT_MASK,d1
	lsrl	#2,d1			/* >>4, &(KPROF-1), <<2 */
	andl	#((KPROF-1)<<2),d1
	lea	_kprof,a0
	addl	d1,a0
	addql	#1,a0@
	lea	_kprof_spsl,a0
	jra	2f
    1:	addql	#1,_kprof_su		/* user mode */
	jmi	4f;			/* jump if auto-shutoff */
	lea	_kprof_upsl,a0
    2:	addl	d0,a0
	addql	#1,a0@
    3:	jra	iret
    4:	clrl	_kprof_enable		/* disable */
	jra	iret
#endif	KPROF

	/* 
	 * AST HANDLERS: exception extension stuff and regs are already pushed
	 */
SCBVEC(softclock):
	movw	#PSL_IPLC,sr
	movw	sp@(ESF+ESF_SW),sp@-
	clrw	sp@-
	movl	sp@(4+ESF+ESF_PC),sp@-
	jsr	_softclock		/* softclock(pc,psl) */
	addl	#8,sp
	jra	iret

	.globl	_netisr
SCBVEC(netintr):
	movw	#PSL_IPLN,sr
#ifdef	VB
	jsr	_vbintr
#endif	VB
	bclr	#NETISR_RAW,_netisr+3
	jeq	1f
	jsr	_rawintr
    1:
#ifdef	INET
#include "../netinet/in_systm.h"
	bclr	#NETISR_IP,_netisr+3
	jeq	1f
	jsr	_ipintr
    1:
#endif	INET
#ifdef	NS
	bclr	#NETISR_NS,_netisr+3
	jeq	1f
	jsr	_nsintr
    1:
#endif	NS
	jra	iret

/*
 * T_CNTXFLT: attempt to access unallocated context
 * T_PAGEFLT: attempt to access valid logical location in paged out page
 * T_PROTFLT: attempt to write into a read-only page
 * T_SEGVIO:  attempt to access location outside of user address space
 * T_BUSERR:  bummer
 */
SCBVEC(buserr):
#ifdef	KPROF
	tstb	_kprof_enable+3
	jeq	1f
	addql	#1,_kprof_buse		/* kprof: count bus errors */
    1:
#endif	KPROF
	PEEXT(T_PAGEFLT)		/* hopeful trap type */
	PUSHR
	movb	_ctx,d1			/* in context 7, context fault */
	cmpb	#CTX_INVALID,d1
	jeq	4f
	/*
	 * NOTE: all higher priority interrupts which could come in must 
	 * not cause any bus errors (via a badaddr, useracc, fuword, copyin, 
	 * ...etc) during service or they will trash the ESR register. This is 
	 * a result of the 68000's not leaving the processor at level 7 after a
	 * bus error.						CTH 12/85
	 */
    	movb	ESR,d0
/*	movw	d0,sp@(TCODE)		/* pass error status as code */
	btst	#ESR_ADDR_OK_BIT,d0
	jeq	3f
	btst	#ESR_PROT_OK_BIT,d0
	jne	3f
	btst	#ESR_PTP_OK_BIT,d0
	jeq	2f
	btst	#ESR_PG_V_BIT,d0
	jne	1f
	jeq	traps0			/* trap with pagefault */
    1:	movw	#T_PROTFLT,sp@(TTYPE)
	jra	traps0
    2:	movw	#T_SEGVIO,sp@(TTYPE)
	jra	traps0
    3:	movw	#T_BUSERR,sp@(TTYPE)
	jra	traps0
    4:	movw	#T_CNTXFLT,sp@(TTYPE)
	jra	traps0

SCBVEC(clock):
	IBEG
#ifdef	VB
	jsr	_vbcheck
	subqw	#1,tictoc
	jgt	1f
	movw	_fastclock,tictoc
#endif	VB
	movw	sp@(ESF+ESF_SW),sp@-
	clrw	sp@-
	movl	sp@(4+ESF+ESF_PC),sp@-
	jsr	_hardclock		/* hardclock(pc,psl) */
	addl	#8,sp
    1:	RTE	(V_INTR)		/* temp so not to break vmstat -= HZ */

SCBVEC(procint):
	IBEG
#ifdef	VB
	jsr	_vbcheck
#endif	VB
	RTE	(V_INTR)

/*
 * System call service: Trap #1 is typical user system call. Signal and 
 * longjmp cleanup use traps #2 - #8, and go to Sigcleanup() via a 
 * negative-number syscall.  The traps are 4-word stack format 0, but may need 
 * to return with a larger stack format obtained from the user. Here we allocate
 * larger exception stack frame, slide the 4-word format up to the top of the 
 * allocated area, and change its format so that if it is actually used, it will
 * collapse back to 4 words.
 */
#define	SIG_CLEAN_SYSCALL(x,n)	\
	subl	#(ESF_ISIZE/**/x-ESF_ISIZE0),sp;/* allocate for format x */ \
	movw	sp@(ESF_SW+ESF_ISIZE/**/x-ESF_ISIZE0),sp@(ESF_SW);	\
	movl	sp@(ESF_PC+ESF_ISIZE/**/x-ESF_ISIZE0),sp@(ESF_PC);	\
	movw	#(ESF_SOFT|ESF_FMT/**/x),sp@(ESF_VEC);			\
	PEEXT(T_SYSCALL + (-n << 16)); jra 2b	/* syscall -n */

SCBVEC(trap1):
#ifdef	KPROF
	tstb	_kprof_enable+3
	jeq	1f
	addql	#1,_kprof_sysc		/* kprof: count system calls */
    1:
#endif	KPROF
	clrw	sp@-			/* align psl, part of EEXT */
	movw	#T_SYSCALL,sp@-		/* push type, part of EEXT */
	movw	d0,sp@-			/* push code, part of EEXT */
	jne	1f
	movw	d1,sp@
	movml	#0x7F00,_u+U_ARG
	jra	2f
    1:	movml	#0x7F02,_u+U_ARG
    2:	PUSHR				/* save temp regs */
	movl	usp,a0			/* save user sp */
	pea	a0@
	jsr	_syscall		/* call system call handler */
	movl	sp@+,a0
	movl	a0,usp			/* restore user sp */
	RTE	(V_SYSCALL)		/* return */

SCBVEC(trap2):	SIG_CLEAN_SYSCALL(B,7)	/* trampoline format B, syscall -7 */
SCBVEC(trap3):	SIG_CLEAN_SYSCALL(A,6)	/* trampoline format A, syscall -6 */
SCBVEC(trap4):	SIG_CLEAN_SYSCALL(9,5)	/* trampoline format 9, syscall -5 */
SCBVEC(trap5):	SIG_CLEAN_SYSCALL(8,4)	/* trampoline format 8, syscall -4 */
SCBVEC(trap6):	SIG_CLEAN_SYSCALL(2,3)	/* trampoline format 2, syscall -3 */
SCBVEC(trap8):				/* trampoline format 0, syscall -2 */
	PEEXT(T_SYSCALL + (-2 << 16)); jra	2b
SCBVEC(trap7):				/* longjmp cleanup, syscall -1 */
	PEEXT(T_SYSCALL + (-1 << 16)); jra	2b

	.globl	_badaddr
/*
 * badaddr(addr, len)
 *	See if access addr with a len type instruction causes a bus or address 
 *	error. Len is length of access (1=byte, 2=short, 4=long).
 */
_badaddr:
	movl	sp@(4),a0		/* address to be tested */
	movl	sp@(8),d1		/* size of operand (1, 2, or 4) */
	movw	sr,d0
	movl	d0,a1			/* save old sr in a1 */
	movq	#0,d0			/* hopeful return value: 0 */
	orw	#PSL_HIGH,sr		/* disable interrupts */
	movl	0+SCB_BUSERR,sp@-	/* save old bus error vector */
	movl	0+SCB_ADRERR,sp@-	/* save old address error vector */
	movl	#8f,0+SCB_BUSERR	/* set new bus error vector */
	movl	#9f,0+SCB_ADRERR	/* set new address error vector */
	lsrw	#1,d1			/* byte operation? */
	jcc	1f			/*   no */
	tstb	a0@			/*   yes -- try to access byte */
    1:	lsrw	#1,d1			/* short operation? */
	jcc	2f			/*   no */
	tstw	a0@			/*   yes -- try to access short */
    2:	lsrw	#1,d1			/* long operation? */
	jcc	3f			/*   no */
	tstl	a0@			/*   yes -- try to access long */
    3:	movl	sp@+,0+SCB_ADRERR	/* restore old address error vector */
	movl	sp@+,0+SCB_BUSERR	/* restore old bus error vector */
	movl	a1,d1
	movw	d1,sr			/* restore old interrupt priority */
	rts				/* return value in d0 */

    8:	addw	#1,d0			/* BUS ERROR modify return value */
	andw	#ESF_SSW_SOFTMSK,sp@(ESF_SSW)
	jra	dorte			/* return from bus error exception */

    9:	addw	#8,d0			/* ADDRESS ERROR modify return value */
	andw	#ESF_SSW_SOFTMSK,sp@(ESF_SSW)
	jra	dorte			/* return from address error exceptn */

/* addupc(pc, &u.u_prof, nticks)
/*	struct uprof {			/* profile arguments */
/*		short	*pr_base;	/* buffer base */
/*		unsigned pr_size;	/* buffer size */
/*		unsigned pr_off;	/* pc offset */
/*		unsigned pr_scale;	/* pc scaling */
/*	} u_prof;
/* */
	.globl	_addupc
_addupc:movl	sp@(8),a1		/* &u.u_prof */
	movl	sp@(4),d0
	subl	a1@(8),d0		/* corrected pc */
	jlt	9f
	lsrl	#1,d0			/* logical right shift */
	movl	a1@(12),d1
	lsrl	#1,d1			/* ditto for scale */
#ifdef	NEWAS
	mulul	d1, d1:d0		/* [d1:d0]=(pc-pr_off)/2*pr_scale/2 */
#else	NEWAS
 	.long	0x4C010401
#endif	NEWAS
	lsll	#1,d0			/* quad right shift 14 */
	roxll	#1,d1
	jcs	9f
	lsll	#1,d0
	roxll	#1,d1
	jcs	9f
	movw	d1,d0
	clrw	d1
	swap	d0
	swap	d1
	jne	9f
	andw	#0xFFFE,d0
	cmpl	a1@(4),d0		/* length */
	jhs	9f
	addl	a1@,d0			/* base */
	movl	d0,a0
	movl	_nofault,sp@-
	movl	#8f,_nofault
	movsw	a0@,d1
	addl	sp@(16),d1
	movsw	d1,a0@
    7:	movl	sp@+,_nofault
    9:	rts
    8:	clrl	a1@(12)
	jra	7b

	.globl	_useracc
	.globl	_kernacc
_useracc:
#ifdef	BARF
	tstl	_u+U_RCLIENT
	jne	_Wuseracc
#endif	BARF
	movl	sp@(4),d0		/* user virtual address */
	andl	#NONT_MASK,d0
	orl	#USRV_BASE,d0		/* user source */
	movl	d0,a0
	jra	1f

_kernacc:
	movl	sp@(4),a0		/* system virtual address */
    1:	movl	#NBPG,d1
	movl	a0,a1
	addl	sp@(8),a1
	subql	#1,a1			/* address of last byte */
	movl	_nofault,sp@-
	movl	#4f,_nofault
	tstl	sp@(16)
	jeq	2f

    1:	movb	a0@,d0			/* read user space */
	addl	d1,a0
	cmpl	a0,a1
	jgt	1b
	movb	a1@,d0
	jra	3f
    2:	movb	a0@,d0			/* write user space */
	movb	d0,a0@
	addl	d1,a0
	cmpl	a0,a1
	jgt	1b

	movb	a1@,d0
	movb	d0,a1@
    3:	movq	#1,d0
    1:	movl	sp@+,_nofault
	rts
    4:	movq	#0,d0
	jra	1b

	.globl	_whichqs
	.globl	_qs
	.globl	_noproc
	.comm	_noproc,4
	.globl	_runrun
	.comm	_runrun,4

	.globl	_setrq
	.globl	_remrq
	.globl	__insque
	.globl	__remque
/*
 * setrq(p): 	Called at spl6().  p->p_stat should be SRUN.
 */
_setrq:	movl	sp@(4),a0
	tstl	a0@(P_RLINK)
	jeq	1f
	pea	panic_setrq
	jsr	_panic

    1:	movq	#0,d1
	movb	a0@(P_PRI),d1
	lsrw	#2,d1			/* put on queue which is p->p_pri / 4 */
	movl	d1,d0
	lslw	#3,d0
	lea	_qs,a1
	lea	a1@(0,d0:w),a1
	movl	a1,a0@			/* insert at end of queue */
	movl	a1@(4),d0
	movl	d0,a0@(4)
	movl	a0,a1@(4)
	movl	d0,a1
	movl	a0,a1@
	lea	_whichqs,a1		/* mark queue non-empty */
	movl	a1@,d0
	bset	d1,d0
	movl	d0,a1@
	rts

/*
 * remrq(p): 	Called at spl6().
 */
_remrq:	movl	sp@(4),a0
	movq	#0,d1
	movb	a0@(P_PRI),d1
	lsrw	#2,d1
	movl	_whichqs,d0
	bclr	d1,d0
	jne	1f
	movl	d0,_whichqs
	pea	panic_remrq
	jsr	_panic

    1:	movl	a0@,a1
	movl	a0@(4),d1
	cmpl	d1,a1
	jne	1f
	movl	d0,_whichqs
    1:	movl	d1,a1@(4)
	exg	d1,a1
	movl	d1,a1@
	clrl	a0@(P_RLINK)
	rts

__insque:
	movw	sr,d1
	orw	#PSL_HIGH,sr
	movl	sp@(4),a0		/* new */
	movl	sp@(8),a1		/* pred */
	movl	a1@,d0			/* succ */
	movl	d0,a0@
	movl	a1,a0@(4)
	movl	a0,a1@
	movl	d0,a1
	movl	a0,a1@(4)
	movw	d1,sr
	rts

__remque:
	movw	sr,d1
	orw	#PSL_HIGH,sr
	movl	sp@(4),a0
	movl	a0@,a1
	movl	a0@(4),d0
	movl	d0,a1@(4)
	exg	d0,a0
	movl	a1,a0@
	movw	d1,sr
	rts

	.globl	_swtch
	.globl	_waitloc
/*
 * swtch: switch to another process.
 */
_swtch:	movw	sr,_u+PCB_PSL+2
	movl	#1,_noproc
	clrl	_runrun

	/* determine highst priority nonempty queue */
    1:	orw	#PSL_HIGH,sr		/* disable interrupts */
	movl	_whichqs,d0
	movq	#0,d1
	jra	3f
    2:	addw	#1,d1
    3:	lsrl	#1,d0			/* find an active queue */
	jcs	4f			/* jump if active */
	jne	2b

	bclr	#AST_NET,_ast		/* no active queue, check ast's */
	jne	2f
	bclr	#AST_TIC,_ast
	jne	3f
	stop	#PSL_IPL0		/* no ast's, go idle */

_waitloc:
	jra	1b			/* try again */

    2:	movw	#PSL_IPLN,sr		/* service network ast */
#ifdef	VB
	jsr	_vbintr
#endif	VB
	bclr	#NETISR_RAW,_netisr+3
	jeq	2f
	jsr	_rawintr
    2:
#ifdef	INET
	bclr	#NETISR_IP,_netisr+3
	jeq	2f
	jsr	_ipintr
    2:
#endif	INET
#ifdef	NS
	bclr	#NETISR_NS,_netisr+3
	jeq	2f
	jsr	_nsintr
    2:
#endif	NS
	jra	1b

    3:	movw	#PSL_IPLC,sr		/* service clock ast */
	movl	#PSL_IPL0,sp@-
	pea	_waitloc		/* push pc (idle address) */
	jsr	_softclock		/* softclock(pc,psl) */
	addl	#8,sp
	jra	1b

	/* found nonempty run queue, remove first entry */
    4:	movw	d1,d0
	lslw	#3,d0
	lea	_qs,a1
	lea	a1@(0,d0:w),a1		/* a1 -> queue header */
	movl	a1@,a0			/* a0 -> first entry in queue */
	cmpl	a1,a0			/* make sure queue not empty */
	jne	1f
    2:	pea	panic_swtch
	jsr	_panic

    1:	movl	a0@,d0			/* unlink item from queue */
	movl	d0,a1@			/* unlink from queue header */
	exg	d0,a1
	movl	d0,a1@(4)		/* unlink from successor */
	cmpl	d0,a1			/* if queue is now empty, */
	jne	1f
	movl	_whichqs,d0		/* mark queue empty */
	bclr	d1,d0
	movl	d0,_whichqs

    1:	clrl	_noproc
	tstl	a0@(P_WCHAN)
	jne	2b
	cmpb	#SRUN,a0@(P_STAT)
	jne	2b
	clrl	a0@(P_RLINK)
	movl	a0@(P_ADDR),a1
	movl	a1@,d0
	movl	d0,_masterpaddr
	INC	(V_SWTCH)

	movml	#0xFCFC,_u		/* save 68020 registers */
	tstb	_ctx			/* if context is system context */
	jeq	6f			/* dont save floating point state */

#ifdef	FP_68881
	.globl	_save_68881
	.globl	_restore_68881
_save_68881:
	tstb	_have_68881		/* if we have 68881 chip, save state */
	jeq	1f
	lea	_u+U_68881_STATE,a1
#ifdef	NEWAS
	fsave	a1@			/* save state frame */
#else	NEWAS
	.word	0xf311
#endif	NEWAS
	tstb	a1@			/* if null, dont save registers */
	beq	1f
	lea	_u+U_68881_REGS,a1
#ifdef	NEWAS
	fmovemx	#<f0-f7>,a1@		/* save programmers model */
#else	NEWAS
	.long	0xf211f0ff
#endif	NEWAS
	addl	#8*12,a1
#ifdef	NEWAS
	fmoveml	#<fpcr,fpsr,fpiar>,a1@
#else	NEWAS
	.long	0xf211bc00
#endif	NEWAS
    1:
#endif	FP_68881
#ifdef	FP_SKY
	.globl	_save_sky
	.globl	_restore_sky
_save_sky:
	movl	_skybase,a2		/* SKY FPP save context */
	jeq	5f
	tstb	a0@(P_FLAG)		/* high bit of p_flag is sky map bit */
	jge	5f
	movw	a2@(SKYSTC),d2
	andw	#SKYMODE,d2
	cmpw	#SKYMODE_RUN,d2		/* dont save if mode not Run Enable */
	jne	5f
	lea	_u+U_SKY,a3
    1:	movw	a2@(SKYSTC),d2
	btst	#SKYIDLE,d2
	jeq	2f
	movw	#0x1063,a3@+		/* noop */
	jra	4f
    2:	btst	#SKYRDY,d2
	jeq	1b
	movw	#SKYMODE_SS,a2@(SKYSTC)	/* set single step mode */
    1:	movw	a2@(SKYSTC),d2
	btst	#SKYDIR,d2
	jeq	2f
	movw	a2@(SKYDT1),d2
	jra	3f
    2:	movw	d2,a2@(SKYDT1)
    3:	movw	a2@(SKYSTC),d2
	btst	#SKYRDY,d2
	jne	1b
    	movw	a2@(SKYCOM),d2
	subqw	#1,d2
	movw	d2,a3@+
    	movw	#SKYRESET,a2@(SKYSTC)	/* set reset bit */
	movw	#0x1000,a2@(SKYCOM)	/* initialize */
	movw	#0x1000,a2@(SKYCOM)	/* initialize */
	movw	#0x1001,a2@(SKYCOM)	/* sp_r add */
	movw	#SKYMODE_RUN,a2@(SKYSTC)
    4:	movw	#0x1063,a2@(SKYCOM)	/* noop */
    	movw	#0x1040,a2@(SKYCOM)	/* context save */
	lea	a2@(SKYDT1),a2
	movq	#8-1,d2
    1:	movl	a2@,a3@+
	dbra	d2,1b
    5:
#endif	FP_SKY

    6:	movb	a0@(P_CONTEXT),d1	/* get new context */
	jeq	2f			/* jump if system context */

    	movq	#0,d2			/* update vc_lastaccess for lru */
	movb	d1,d2			/* context allocation scheme */
	lslw	#3,d2
	movl	_vc_tick,d3
	addl	#1,d3
	movl	d3,_vc_tick
	lea	_vc_context,a1
	movl	d3,a1@(0,d2:w)

	movl	#TBUF_INVALID,d3
	movl	#TBUF_INCR,d4
	lea	TBUF_BASE_USR,a1	/* Invalidate user TBUF */
    	movl	#(NTBUFS/4)-1,d2
    1:	movl	d3,a1@;		addl	d4,a1
	movl	d3,a1@;		addl	d4,a1
	movl	d3,a1@;		addl	d4,a1
	movl	d3,a1@;		addl	d4,a1
	dbra	d2,1b

    2:	movl	#(CCACHE_CLEAR|CCACHE_ENABLE),d2
#ifdef	NEWAS
	movl	d2,ccr			/* Invalidate 020 cache */
#else	NEWAS
	.long	0x4E7B2002
#endif	NEWAS
	movb	d1,_ctx
	orb	_ctx_mask,d1		/* preserve clock and parity */
	movb	d1,CTX			/* set new context */

	andl	#~PG_PROT,d0		/* remove users _u area protection */
	orl	#PG_V|PG_KW,d0		/* kernel can write the _u area */
/* 
 * NOTE: If a level 7 interrupt gets acknoldged between the next two 
 * instructions the system may hang/crash/wierd-out!! CTH
 * Also, dont reference uarea in level 7 interrupt handler!
 */
	lea	0x800,sp		/* KLUDGE temporary stack, for NMI's! */
	movl	d0,_Umap		/* map new _u area */
	clrl	_TBUF_S_u		/* invalidate old _u area translation */
   	movml	_u,#0xFCFC		/* restore 68020 registers */
#ifdef	KPROF
	tstb	_kprof_enable+3
	jeq	1f
	addql	#1,_kprof_swtch		/* kprof: count context switches */
    1:
#endif	KPROF
	tstb	_ctx			/* if new context is system context, */
	jeq	3f			/* dont restore floating point state */

#ifdef	FP_68881
_restore_68881:
	tstb	_have_68881		/* if we have a 68881, restore state */
	jeq	2f
	lea	_u+U_68881_STATE,a0
	tstb	a0@			/* skip if no saved model */
	jeq	1f
	lea	_u+U_68881_REGS,a1
#ifdef	NEWAS
	fmovemx	a1@,#<f0-f7>
#else	NEWAS
	.long	0xf211d0ff
#endif	NEWAS
	addl	#8*12,a1
#ifdef	NEWAS
	fmoveml	a1@,#<fpcr,fpsr,fpiar>	/* restore programers model */
    1:	frestore	a0@		/* restore state frame */
#else	NEWAS
	.long	0xf2119c00
    1:	.word	0xf350
#endif	NEWAS
    2:
#endif	FP_68881
#ifdef	FP_SKY
_restore_sky:
	movl	_skybase,a0
	jeq	2f
	movl	_u+U_PROCP,a1		/* u.u_procp */
	tstb	a1@(P_FLAG)		/* high bit of p_flag is sky map bit */
	jge	2f
	movw	a0@(SKYSTC),d0
	andw	#SKYMODE,d0
	cmpw	#SKYMODE_RUN,d0
	jne	2f
	movw	#0x1041,a0@(SKYCOM)	/* context restore */
	lea	_u+U_SKY,a1
	movw	a1@+,d0
	movq	#8-1,d1
    1:	movl	a1@+,a0@(SKYDT1)
	dbra	d1,1b
    	movw	d0,a0@(SKYCOM);
    2:
#endif	FP_SKY

    3:	movl	_u+PCB_SSWAP,d0
	jeq	1f
	clrl	_u+PCB_SSWAP
	movl	d0,sp@
	movw	_u+PCB_PSL+2,sr
	jsr	_longjmp

    1:	movq	#0,d1
	movw	_u+PCB_PSL+2,d1
	jra	splx

	.globl	_setjmp
	.globl	_longjmp
	.globl	_resume
/*
 * Non-local goto's
 */
_setjmp:movl	sp@+,a1			/* return address */
	movl	sp@,a0			/* jmpbuf */
	movml	#0xFCFC,a0@		/* d2-d7, a2-a7 */
	movl	a1,a0@(12*4)		/* return pc */
	movq	#0,d0			/* zero return value */
	jmp	a1@			/* return */

_longjmp:
	movl	sp@(4),a0		/* jmpbuf */
	movml	a0@+,#0x7CFC		/* d2-d7, a2-a6 */
	movl	a0@+,a1			/* to be new sp */
	cmpl	sp,a1			/* must be a pop */
	jge	1f
	pea	panic_ljmp
	jsr	_panic
    1:	movl	a1,sp
	movl	a0@,a1			/* return pc */
	movl	a0,d0			/* nonzero return value */
	jmp	a1@			/* return */

_resume:movw	sr,_u+PCB_PSL+2
	movml	#0xFCFC,_u
	rts

	.globl	_setsoftclock
	.globl	_setsoftnet
_setsoftclock:
	movw	sr,d0
	andw	#PSL_HIGH,d0		/* are we running at low priority? */
	jeq	1f
	bset	#AST_TIC,_ast		/*   no -- set ast pending & return */
	rts

    1:	movw	#PSL_IPLC,sr
	pea	PSL_IPL0
	movl	sp@(4),sp@-
	jsr	_softclock		/* softclock(pc,psl) */
	addl	#8,sp
	movw	#PSL_IPL0,sr
	rts

_setsoftnet:
	movw	sr,d0
	andw	#PSL_HIGH,d0		/* are we running at low priority? */
	jeq	1f
	bset	#AST_NET,_ast
	rts

    1:	movw	#PSL_IPLN,sr
#ifdef	VB
	jsr	_vbintr
#endif	VB
	bclr	#NETISR_RAW,_netisr+3
	jeq	2f
	jsr	_rawintr
    2:
#ifdef	INET
	bclr	#NETISR_IP,_netisr+3
	jeq	2f
	jsr	_ipintr
    2:
#endif	INET
#ifdef	NS
	bclr	#NETISR_NS,_netisr+3
	jeq	2f
	jsr	_nsintr
    2:
#endif	NS
	movw	#PSL_IPL0,sr
	rts

	.globl	_splx
	.globl	_spl
	.globl	_spl0
	.globl	_spl1
	.globl	_splnet
	.globl	_spl4
	.globl	_spl5
	.globl	_splimp
	.globl	_spl6
	.globl	_spl7
_splx:	movl	sp@(4),d1
splx:	movw	d1,d0
	andw	#PSL_HIGH,d0
	jeq	_spl0
	clrl	d0
	movw	sr,d0
	movw	d1,sr
	rts

_spl:	clrl	d0
	movw	sr,d0
	rts

_spl0:	clrl	d0
	movw	sr,d0
    1:	movw	#PSL_IPL7,sr		/* raise priority to protect ast */
	tstb	_ast
	jeq	2f
	bclr	#AST_NET,_ast
	jne	3f
	bclr	#AST_TIC,_ast
	jne	4f
    2:	andw	#PSL_LOW,sr		/* drop to low priority */
	rts

    3:	movw	#PSL_IPLN,sr
	movl	d0,sp@-			/* save previous sr */
#ifdef	VB
	jsr	_vbintr
#endif	VB
	bclr	#NETISR_RAW,_netisr+3
	jeq	3f
	jsr	_rawintr
    3:
#ifdef	INET
	bclr	#NETISR_IP,_netisr+3
	jeq	3f
	jsr	_ipintr
    3:
#endif	INET
#ifdef	NS
	bclr	#NETISR_NS,_netisr+3
	jeq	3f
	jsr	_nsintr
    3:
#endif	NS
	movl	sp@+,d0			/* return value */
	jra	1b

    4:	movw	#PSL_IPLC,sr
	movl	d0,sp@-			/* save previous sr */
	pea	PSL_CURMOD
	movl	sp@(8),sp@-		/* push pc (return address) */
	jsr	_softclock		/* softclock(pc,psl) */
	addl	#8,sp
	movl	sp@+,d0			/* return value */
	jra	1b

_splnet:clrl	d0
	movw	sr,d0
	movw	#PSL_IPLN,sr
	rts

_spl1:	clrl	d0
	movw	sr,d0
	movw	#PSL_IPL1,sr
	rts

_spl4:	clrl	d0
	movw	sr,d0
	movw	#PSL_IPL4,sr
	rts

_splimp:clrl	d0
	movw	sr,d0
	movw	#PSL_IPL5,sr
	rts

_spl5:	clrl	d0
	movw	sr,d0
	movw	#PSL_IPL5,sr
	rts

_spl6:	clrl	d0
	movw	sr,d0
	movw	#PSL_IPL6,sr
	rts

_spl7:	clrl	d0
	movw	sr,d0
	orw	#PSL_HIGH,sr
	rts

	.globl	_pcopyin
	.globl	_pcopyout
	.globl	_pcopy
	.globl	_copyin
	.globl	_copyout
	.globl	_fubyte
	.globl	_fuibyte
	.globl	_fuword
	.globl	_fuiword
	.globl	_subyte
	.globl	_suibyte
	.globl	_suword
	.globl	_suiword
_pcopyin:				/* pcopyin(ps, kd, bcount) */
_pcopyout:				/* pcopyout(ks, pd, bcount) */
_pcopy:					/* pcopy(ps, pd, bcount) */
	jmp	_bcopy

_copyin:				/* copyin(us, kd, bcount) */
#ifdef	BARF
	tstl	_u+U_RCLIENT
	jne	_Wcopyin
#endif	BARF
	movl	sp@(4),d0
	andl	#NONT_MASK,d0
	orl	#USRV_BASE,d0		/* user source */
	movl	d0,a0
	movl	sp@(8),a1		/* kernel destination */
	movw	a1,d1
	jra	1f

_copyout:				/* copyout(ks, ud, bcount) */
#ifdef	BARF
	tstl	_u+U_RCLIENT
	jne	_Wcopyout
#endif	BARF
	movl	sp@(4),a0		/* kernel source */
	movw	a0,d0
	movl	sp@(8),d1
	andl	#NONT_MASK,d1
	orl	#USRV_BASE,d1		/* user destination */
	movl	d1,a1			/* fall through ... */

    1:	eorw	d1,d0			/* common copyin/copyout code */
	movl	sp@(12),d1		/* byte count */
	jle	4f
	movl	_nofault,sp@-
	movl	#5f,_nofault
	lsrw	#1,d0
	jcs	3f
	movw	a0,d0			/* check for both addrs odd */
	lsrw	#1,d0
	jcc	1f
	movb	a0@+,a1@+
	subl	#1,d1
    1:	movl	d1,d0
	lsrl	#5,d0
	andl	#0x1F,d1
	jra	2f
    1:	movl	a0@+,a1@+; movl	a0@+,a1@+; movl	a0@+,a1@+; movl	a0@+,a1@+;
	movl	a0@+,a1@+; movl	a0@+,a1@+; movl	a0@+,a1@+; movl	a0@+,a1@+;
    2:	dbra	d0,1b
	addw	#1,d0
	subl	#1,d0
	jge	1b
	jra	3f
    1:	movb	a0@+,a1@+
    3:	dbra	d1,1b
	addw	#1,d1
	subl	#1,d1
	jge	1b
	movl	sp@+,_nofault
    4:	movq	#0,d0
	rts

    5:	movl	sp@+,_nofault
	movl	#EFAULT,d0
	rts

_fubyte:
_fuibyte:
#ifdef	BARF
	tstl	_u+U_RCLIENT
	jne	_Wfubyte
#endif	BARF
	movl	sp@(4),a0
	movl	_nofault,sp@-
	movl	#1f,_nofault
	clrl	d0
	movsb	a0@,d0
	movl	sp@+,_nofault
	rts

_fuword:
_fuiword:
#ifdef	BARF
	tstl	_u+U_RCLIENT
	jne	_Wfuword
#endif	BARF
	movl	sp@(4),a0
	movl	_nofault,sp@-
	movl	#1f,_nofault
	movsl	a0@,d0
	movl	sp@+,_nofault
	rts

_subyte:
_suibyte:
#ifdef	BARF
	tstl	_u+U_RCLIENT
	jne	_Wsubyte
#endif	BARF
	movl	sp@(4),a0
	movl	sp@(8),d0
	movl	_nofault,sp@-
	movl	#1f,_nofault
	movsb	d0,a0@
	clrl	d0
	movl	sp@+,_nofault
	rts

_suword:
_suiword:
#ifdef	BARF
	tstl	_u+U_RCLIENT
	jne	_Wsuword
#endif	BARF
	movl	sp@(4),a0
	movl	sp@(8),d0
	movl	_nofault,sp@-
	movl	#1f,_nofault
	movsl	d0,a0@
	clrl	d0
	movl	sp@+,_nofault
	rts
    1:	movq	#-1,d0
	movl	sp@+,_nofault
	rts

	.globl	_copyseg
	.globl	_clearseg
_copyseg:
	movl	sp@(8),d0		/* page frame number */
	movl	#PGSHIFT,d1
	asll	d1,d0
	movl	d0,a1			/* non translated address destination */
	movl	sp@(4),d0
	andl	#NONT_MASK,d0
	orl	#USRV_BASE,d0		/* user virtual space */
	movl	d0,a0
	movw	#(NBPG>>5)-1,d0		/* 8 longs (32 bytes) per loop */
    1:	movl	a0@+,a1@+; movl	a0@+,a1@+; movl	a0@+,a1@+; movl	a0@+,a1@+;
	movl	a0@+,a1@+; movl	a0@+,a1@+; movl	a0@+,a1@+; movl	a0@+,a1@+;
	dbra	d0,1b
	movq	#0,d0
	rts

_clearseg:
	movl	sp@(4),d0		/* page frame number */
	movl	#PGSHIFT,d1
	asll	d1,d0
	movl	d0,a0			/* non translated address */
	movq	#0,d0			/* return value too */
	movw	#(NBPG>>5)-1,d1		/* 8 longs (32 bytes) per loop */
    1:	movl	d0,a0@+; movl	d0,a0@+; movl	d0,a0@+; movl	d0,a0@+;
	movl	d0,a0@+; movl	d0,a0@+; movl	d0,a0@+; movl	d0,a0@+;
	dbra	d1,1b
	rts

	.globl	_blkclr
	.globl	_ovbcopy
_blkclr: jmp	_bzero
_ovbcopy:jmp	_bcopy

	.globl	_getmeml
_getmeml:
	movl	sp@(4),d0		/* physical address */
	andl	#NONT_MASK,d0		/* non-translated */
	movl	d0,a0
	movl	a0@,d0
	rts

	.globl	_putmeml
_putmeml:
	movl	sp@(4),d0		/* physical address */
	andl	#NONT_MASK,d0		/* non-translated */
	movl	d0,a0
	movl	sp@(8+4),a0@
	rts

	.globl	_doadump
_doadump:
    1:	stop	#PSL_CURMOD
	jra	1b

	.globl	__reboot
__reboot:
	movl	_howto,d7
	movl	_devtype,d6
	jmp	PROM_REBOOT

	.globl	_parityon
_parityon:
	movb	_ctx_mask,d0
	orb	#CTX_PARITY,d0
	movb	d0,_ctx_mask
	orb	_ctx,d0
	movb	d0,CTX
	rts

	.globl	_parityoff
_parityoff:
	movb	_ctx_mask,d0
	andb	#~CTX_PARITY,d0
	movb	d0,_ctx_mask
	orb	_ctx,d0
	movb	d0,CTX
	rts

	.globl	_cacheon
_cacheon:
	movl	#CCACHE_CLEAR|CCACHE_ENABLE,d0
#ifdef	NEWAS
	movl	d0,cacr
#endif	NEWAS
	rts

	.globl	_cacheoff
_cacheoff:
	movl	#CCACHE_CLEAR,d0
#ifdef	NEWAS
	movl	d0,cacr
#endif	NEWAS
	rts

	.globl	_have68881
	/* 
	 * Determine if 68881 coprocessor present.
	 *   o	Rev A1 boards: FPCS* tied to FPSCAK[01]* causes proto vio
	 *   o	Later boards use jumper J?? and cause bus errors (which)the 
	 *	68020 turns into F-line emulation traps.
	 */
_have68881:
	clrl	d0
#ifdef	FP_68881
	movl	0+SCB_EM1111,a0		/* reprogram vectors */
	movl	0+SCB_COPROC,a1
	movl	sp,d1
	movl	#1f,0+SCB_EM1111
	movl	#1f,0+SCB_COPROC
#ifdef	NEWAS
	fnop
#else	NEWAS
	.long	0xf2800000
#endif	NEWAS
	movl	#1,d0
    1:	movl	a0,0+SCB_EM1111
	movl	a1,0+SCB_COPROC
	movl	d1,sp
#endif	FP_68881
	movb	d0,_have_68881
	rts

/* TODO: This should be in C */
	.globl	_ulock
_ulock:	jbsr	_suser
	tstl	d0
	jeq	1f
	movl	_u+U_PROCP,a0		/* p = u.u_procp; */
	orl	#SULOCK,a0@(P_FLAG)	/* p->p_flag |= SULOCK; */
    1:	rts

	.globl	_byterev
_byterev:
	movl	sp@(4),a0		/* address of byte string */
	movl	a0,a1
	movl	sp@(8),d1		/* length of string */
	addl	#1,d1
	lsrl	#1,d1
	jra	2f
    1:	movw	a1@,d0
	rolw	#8,d0
	movw	d0,a1@+
    2:	dbra	d1,1b
	addw	#1,d1
	subl	#1,d1
	jge	1b
	movl	a1,d0
	rts

/*
 * cksum(sum, string, len, sumlen)
 *  	16 bit checksum of byte string s
 */ 
	.globl	_cksum
_cksum:	movl	d2,sp@-			/* save d2 */
	movl	sp@(8),d0		/* sum */
	movl	sp@(12),a0		/* address of byte string */
	movl	a0,d2
	tstl	sp@(16)			/* length of string */
	jeq	9f			/* zero length string, return */
	andb	#0xF,cc			/* X clerar x bit */
	btst	#0,sp@(20+3)		/* swap bytes ?? */
	jne	4f

	/* sum is word alligned, dont swap bytes */
	btst	#0,d2
	jeq	1f

	/* odd start address, do first byte, and then swap bytes */
	subl	#1,sp@(16)	
	clrl	d2
	movb	a0@+,d2
	rolw	#8,d2
	addw	d2,d0			/* X */
	jra	5f

	/* even address, sum alligned */
    1:	movl	sp@(16),d1
	andb	#0xFE,d1
	rorl	#1,d1
	jra	3f
    2:	movw	a0@+,d2
	addxw	d2,d0			/* X */
    3:	dbra	d1,2b
	btst	#0,sp@(16+3)
	jeq	8f

	/* odd length, take care of last byte */
	clrl	d2
	movb	a0@+,d2
	rolw	#8,d2
	addxw	d2,d0			/* X */
	jra	8f

	/* sum is not word alligned, swap bytes */
    4:	btst	#0,d2
	jeq	5f

	/* odd start address, do first byte, and then dont swap bytes */
	subl	#1,sp@(16)		/* X */
	clrl	d2
	movb	a0@+,d2
	addw	d2,d0			/* X */
	jra	1b

	/* even address, sum misalligned, swap bytes */
    5:	movl	sp@(16),d1
	andb	#0xFE,d1
	rorl	#1,d1
	jra	7f
    6:	movw	a0@+,d2
	rolw	#8,d2
	addxw	d2,d0			/* X */
    7:	dbra	d1,6b
	btst	#0,sp@(16+3)
	jeq	8f

	/* odd length, take care of last byte */
	clrl	d2
	movb	a0@+,d2
	addxw	d2,d0			/* X */

	/* fold in last carry bit */
    8:	clrl	d2
	addxw	d2,d0			/* X */
    9:	movl	sp@+,d2			/* restore d2 */
	rts

	.globl	_invutbuf
_invutbuf:
	movl	#TBUF_INVALID,d0
	movl	#TBUF_INCR,a1
	movw	#(NTBUFS/4)-1,d1
    	lea	TBUF_BASE_USR,a0
    1:	movl	d0,a0@;		addl	a1,a0
	movl	d0,a0@;		addl	a1,a0
	movl	d0,a0@;		addl	a1,a0
	movl	d0,a0@;		addl	a1,a0
	dbra	d1,1b
	rts

#ifndef	C_newptes
	.globl	_newptes
_newptes:
	movl	sp@(4),a0		/* pointer to pte */
	cmpl	#_eSysmap,a0		/* if in Sysmap */
	jhs	1f			/* invalidate system TBUF */
	cmpl	#_Sysmap,a0		/* else invalidate user TBUF */
	jlo	1f
	lea	TBUF_BASE_SYS,a0
	jra	2f
    1:	lea	TBUF_BASE_USR,a0
    2:	movl	sp@(12),d1		/* get count */
	jeq	3f			/* if zero, return */
	cmpl	#20,d1			/* if we have 10 or less, */
	jle	4f			/* only invalidate those that changed */
	movl	#TBUF_INVALID,d0
	movw	#(NTBUFS/4)-1,d1
	movl	#TBUF_INCR,a1
    1:	movl	d0,a0@;		addl	a1,a0
	movl	d0,a0@;		addl	a1,a0
	movl	d0,a0@;		addl	a1,a0
	movl	d0,a0@;		addl	a1,a0
	dbra	d1,1b
    3:	rts
    4:	movl	sp@(8),d0		/* get virtual address */
	movl	d1,a1
	movl	#PGSHIFT,d1
	lsll	d1,d0
	movl	a1,d1
	andl	#TBUF_INDEX_MASK,d0	/* compute index into tbuf */
	addl	d0,a0			/* compute start tbuf address */
	movl	#TBUF_INVALID,d0
	movl	#TBUF_INCR,a1
	jra	2f
    1:	movl	d0,a0@;		addl	a1,a0
    2:	dbra	d1,1b
	rts
#endif	C_newptes

/************************************************************************/

#define	SIOCONT(cont)	cont*10

SCBVEC(sio):
	IBEG
	clrl sp@-;  jsr _sioint;  addl #4,sp
	RTE (V_INTR)

#ifdef	SIOPDMA
/*
 * SIO pseudo dma routine:
 *	d0 - port number * sizeof(struct pdma)
 */
	.align	1
	.globl	siodma
siodma:	addl	#_sio_pdma,d0
	movl	d0,a1			/* pdma structure base */
	movl	a1@+,a0			/* device register base address */
	movb	#SIOW0_TXPEND,a0@(SIO_CTRL)	/* reset transmit int pending */
	jra	2f
    1:	movl	a1@+,d1			/* p_mem */
	cmpl	a1@+,d1			/* p_end > p_mem ? */
	bhs	4f			/* no, go call sioxint */
	exg	d1,a1
	movb	a1@+,a0@		/* adata = *p_mem++ */
	exg	d1,a1
	movl	d1,a1@(-8)
    2:	movl	d0,a1			/* pdma structure base */
	movl	a1@+,a0			/* device register base address */
	movb	a0@(SIO_CTRL),d1
	andb	#SIOR0_TXRDY,d1
	jne	1b			/* if not TXRDY, all done */
    3:	movl	#SIO0_ADR+SIO_CTRL,a0	/* force to PORTA */
	movb	#SIOW0_RETINT,a0@
	RTE	(V_PDMA)
    4:	movl	d0,sp@-			/* save d0 */
	movl	a1@+,sp@-		/* push tty address as arg */
	movl	a1@,a1			/* get address of interrupt routine */
	jsr	a1@			/* call interrupt routine */
	addl	#4,sp			/* pop arg (tty address) */
	movl	sp@+,d0			/* restore d0 */
	jra	3b
#endif	SIOPDMA

	.data				/* DATA */
	.align	1

/* icode */
#include <syscall.h>
	.globl	_icode
	.globl	_szicode
	.globl	_initflg
	.globl	_initi
icode:	movml	pc@(2f),#0x0303		/* load syscall args into regs */
	trap	#1			/* do execve syscall */
    1:	jra	1b			/* loop here if cannot execute init */
    2:	.long	SYS_execve		/* d0: syscall: SYS_execve */
	.long	5f-icode		/* d1: file: "/etc/init" */
	.long	3f-icode		/* a0: argv: ("init", "-?", NULL) */
	.long	4f-icode		/* a1: envp: (NULL) */
    3:	.long	initi-icode		/* "init" */
	.long	6f-icode		/* "?" -> to 'm' or 's' in startup */
    4:	.long	0			/* NULL */
    5:	.ascii	"/etc/"
initi:	.asciz	"init"
    6:	.byte	0x2D			/* '-' */
initflg:.byte	0x3F			/* '?' multi/single user flag */
	.byte	0x00			/* '\0' */
	.align	1
_icode:		.long	icode		/* pointer to icode */
_szicode:	.long	_icode-icode	/* length of icode */
_initflg:	.long	initflg		/* pointer to init flag */
_initi:		.long	initi		/* pointer to first letter of "init" */

/* signal trampoline code */
	.globl	_sigcode
	.globl	_szsigcode
	.align	1
sigcode:
	bras	1f			/* +0:  stack format 0 entry */
	bras	2f			/* +2:  stack format 2 entry */
	bras	3f			/* +4:  stack format 8 entry */
	bras	4f			/* +6:  stack format 9 entry */
	bras	5f			/* +8:  stack format A entry */
	bras	6f			/* +10: stack format B entry */
		/* stack format 0 */
    1:	bsrs	8f			/* save regs and call handler */
    1:	trap	#8			/* restore sig mask and return */
	bras	1b
		/* stack format 2 */
    2:	bsrs	8f			/* save regs and call handler */
    1:	trap	#6			/* restore sig mask and return */
	bras	1b
		/* stack format 8 */
    3:	bsrs	8f			/* save regs and call handler */
    1:	trap	#5			/* restore sig mask and return */
	bras	1b
		/* stack format 9 */
    4:	bsrs	8f			/* save regs and call handler */
    1:	trap	#4			/* restore sig mask and return */
	bras	1b
		/* stack format A */
    5:	bsrs	8f			/* save regs and call handler */
    1:	trap	#3			/* restore sig mask and return */
	bras	1b
		/* stack format B */
    6:	bsrs	8f			/* save regs and call handler */
    1:	trap	#2			/* restore sig mask and return */
	bras	1b
    8:	link	a6,#-16			/* just like a real stack frame */
	movml	#0x0303,a6@(-16)	/* save regs d0-d1, a0-a1 */
	movml	a6@(8),#0x0303		/* get our args and handler ptr */
	movml	#0xC0C0,sp@-		/* push our args as args to handler */
	jsr	a1@			/* handler(sig, code, psigctx) */
	movml	a6@(-16),#0x0303	/* restore regs */
	unlk	a6			/* just like a real stack frame */
	rtd	#16			/* pop the args we were called with */
	.align	1
_sigcode:	.long	sigcode
_szsigcode:	.long	_sigcode-sigcode

/************************************************************************/
	.globl	_ast
	.globl	_cpu
	.globl	_nofault
	.globl	_howto
	.globl	_devtype
	.globl	_masterpaddr
	.globl	_bus
	.globl	_have_68881
	.globl	is68020
_ast:		.byte	0
_have_68881:	.byte	0
	.align	1
_cpu:		.long	68020
is68020:	.long	0xFFFFFFFF
_nofault:	.long	0
_howto:		.long	0
_devtype:	.long	0
_masterpaddr:	.long	0
tictoc:		.word	0
_bus:		.asciz	"VME"
N2C:		.asciz	"0123456789ABCDEF"
panic_ljmp:	.asciz	"longjmp"
panic_setrq:	.asciz	"setrq"
panic_remrq:	.asciz	"remrq"
panic_swtch:	.asciz	"swtch"
panic_iret:	.asciz	"iret"
	.text
