/*#define NOSKY	/**/
/*#define KPROF	0x10000	/* enable kernel profiling */
/*	locore.s	83/12/02	*/

#include "../machine/psl.h"
#include "../machine/pte.h"
#include "../machine/pcb.h"

#include "../h/errno.h"
#include "../h/param.h"

#include "../machine/trap.h"
#include "../machine/board.h"
#include "../is68kdev/sioreg.h"
#include "../is68kdev/ctcreg.h"

#include "dl.h"
#include "dz.h"
#include "dh.h"

/*
 *	Debug trace skeleton:
 */
/*#define	STACK_FIRE_WALL	/* */
/*#define	LOCOREDEBUG	/* */
#ifdef	LOCOREDEBUG
#define TRACE(xxx)			movb	#xxx,SIO0_ADR		\
					movl	d4,sp@-			\
					movl	#0x1000,d4		\
			9:		dbra	d4,9b			\
					movl	sp@+,d4

#define TRACEOUT			jmp	0xC0004A
#else	LOCOREDEBUG
#define TRACE(xxx)
#endif	LOCOREDEBUG

/*
 * User structure is UPAGES at top of kernel space.
 */
	.globl	_u
	.set	_u,	0x400000 - 2*NBPG - UPAGES*NBPG
	.set	CADDR1,	_u - NBPG
	.set	CADDR2,	CADDR1 - NBPG

	.set	CADDRa,	0x400000 - 16*NBPG
	.set	CADDRb,	CADDRa + NBPG
	.set	CADDRc,	CADDRb + NBPG
	.set	CADDRd,	CADDRc + NBPG

/*
 * Translate virtual address to corresponding page register.
 * Assumes that the address is even and the mapping is straight thru!
 */
#define	PGREG(a)	(0x800000 + a)
#define	FC_UD		1		/* function code for user data */
#define	FC_UC		2		/* function code for user code */

#define	PSL_IPLN	PSL_IPL1	/* must be greater than IPLC */
#define	PSL_IPLC	PSL_IPL0

/*
 * Initialization
 */
	.text
	.globl	start
start:
	movw	#PSL_IPL7,sr	/* make sure interrupts are disabled */
	movl	d7,_howto	/* how to boot */
	movl	d6,_devtype	/* major number of boot device */
	lea	start,sp	/* temporary stack */

	lea	_scb,a0		/* copy initial scb to vector region at 0 */
	lea	0,a1
	movw	#256-1,d0
    1:	movl	a0@+,a1@+
	dbra	d0,1b

	lea	0+SCB_ILLINS,a1	/* catch illegal instruction traps */
	movl	a1@,d0
	lea	1f,a0		/* arg to die */
	movl	#die,a1@

	lea	0,a2		/* set vector base */
	movl	a2,vb		/* this will trap to die on the 68000 */

	.data
    1:	.asciz	"You need a 68010 processor, instead of a 68000.\r\n"
	.text

	movl	d0,a1@		/* no trap...  replace illins trap vector */

	/*
	 * Initialize the source and destiniation function code registers for
	 * move space ("movs[bwl]") instructions. 
	 */
	movq	#FC_UD,d0
	movl	d0,sfc		/* set source function code reg to user data */
	movl	d0,dfc		/* set dest function code reg to user data */
	movw	#(1<<4),CXW	/* set user context to #1 */

	/*
	 * Initialize all the segment registers.  Context #0 maps straight
	 * thru to the page registers, supervisor/user read/write. Contexts
	 * #1 thru #15 are all made invalid.  Because of the way in which the
	 * segment registers are addressed, the outer loop iterates thru the
	 * segments (0 to 63) while the inner loop iterates thru the contexts
	 * (0 to 15). We're assuming that the bootstrapper has set us up in an 
	 * environment consistent with this, and that we're not blowing our 
	 * feet out from under ourselves.
	 */
	movq	#0x80,d3	/* segment read/write, page register set #0 */
	movq	#0,d0		/* invalid segment */
	lea	0x400000,a0	/* a0 -> first segment register of context #0 */
	movq	#64-1,d1	/* number of segments to be set up */
    1:	movw	d3,a0@		/* set up the segment register for context #0 */
	addqw	#1,d3		/* d3 selects next page register set */
	lea	a0@(0x1000),a0	/* a0 -> segment register for next context */

	movq	#15-1,d2	/* number of additional contexts to be set up */
    2:	movw	d0,a0@		/* invalidate the segment in this context */
	lea	a0@(0x1000),a0	/* a0 -> next segment register */
	dbra	d2,2b		/* loop thru all 16 contexts for this segment */

	dbra	d1,1b		/* loop thru all 64 segments */

	/*
	 * Now for the page registers.  They go straight through too.
	 */
	lea	PGREG(0),a0	/* a0 -> first page register */
	movq	#0,d2		/* page frame #0 */
	movw	#1024-1,d1	/* number of page registers to be set up */
    1:	movw	d2,a0@		/* set up this page register */
	addqw	#4,d2		/* d2 selects next page frame */
	lea	a0@(0x1000),a0	/* a0 -> next page register */
	dbra	d1,1b		/* loop thru all 1024 page registers */

	/*
	 * Size & zero memory.
	 */
	lea	_edata,a0	/* beginning of region to be zeroed */
	movl	#0x400000-(4*4096)-4,d1	/* maximum end of region to be zeroed */
	subl	a0,d1		/* maximum number of bytes to be zeroed */
	lsrl	#2,d1		/* maximum number of longs to be zeroed */

	lea	0+SCB_BUSERR,a1
	movl	a1@,d0		/* hang on to bus error vector */
	movl	#2f,a1@		/* put in our own bus error vector */
	movw	#0xDEAD,d3

    1:	movw	d3,a0@		/* test memory...  may cause bus error trap */
	cmpw	a0@,d3
	jne	2f
	clrl	a0@+		/* clear memory */
	dbra	d1,1b
	addqw	#1,d1
	subql	#1,d1
	jge	1b		/* loop till bus error or max */

    2:	movl	d0,a1@		/* replace bus error vector */
	movl	a0,d0
	movq	#PGSHIFT,d1	/* convert pointer to page number */
	lsrl	d1,d0
	subl	_detachedmem,d0
	movl	d0,_maxmem
	movl	d0,_physmem
	movl	d0,_freemem

	movl	#_end+NBPG-1,d1	/* get first page for proc 0 page table */
	andw	#-NBPG,d1
	movq	#PGSHIFT,d0
	lsrl	d0,d1		/* d1 = page frame number */
	movl	d1,d2
	orl	#PG_V+PG_KW,d1
	movl	d1,_Usrptmap	/* map it into usrpt */
	movl	d1,d0
	lslw	#2,d0
	movw	d0,PGREG(_usrpt)

	addql	#1,d1		/* next page is for proc 0 _u area */
	movl	d1,_usrpt+NBPG-4
	lslw	#2,d1
	movw	d1,PGREG(_u)
	lea	_u+(UPAGES*NBPG),sp

	subqw	#1,d2		/* last logical page in use */
	lsrw	#4,d2		/* highest segment in use */
	movl	d2,_maxsysseg

	/*
	 * invalidate unused system segments
	 */
	addqw	#1,d2		/* first unused logical segment */
	movq	#0x40,d0
	addw	d2,d0
	swap	d0
	movl	d0,a0
	negw	d2
	addw	#64-2,d2
	clrw	d0

    1:	movw	d0,a0@
	addl	#0x10000,a0
	dbra	d2,1b

	lea	_u,a0		/* initialize (slightly) the pcb */
	movl	sp,a0@(PCB_SP)
	movw	sr,a0@(PCB_PSL+2)
	movl	#_usrpt,a0@(PCB_P0BR)
	movl	#0,a0@(PCB_P0LR)
	movb	#4,a0@(PCB_P0LR)	/* disable ast */
	movl	#_usrpt+0x400-4,a0@(PCB_P1BR)
	movl	#0x400,a0@(PCB_P1LR)
	movl	#1,a0@(PCB_SZPT)

	movl	#_end+NBPG-1,d0
	andw	#-NBPG,d0
	movq	#PGSHIFT,d1
	lsrl	d1,d0
	addql	#UPAGES+1,d0
	movl	d0,sp@-

	jsr	_main

	addql	#4,sp

	lea	NBPG,a0
	movl	a0,usp
	movw	#0,sp@-
	movl	#0,sp@-		/* user pc */
	movw	#PSL_USERSET,sp@-
	rte

	.data
	.align	1
	.globl	_cpu
_cpu:	.long	68010
	.globl	_maxsysseg
_maxsysseg:
	.long	0
	.globl	_minusrseg
_minusrseg:
	.long	63
	.text

die:
    1:	movw	#0x8000,d0
	movb	a0@+,SIO0_ADR
    2:	dbra	d0,2b
	jne	1b
	jmp	PROM_REBOOT	/* go back to the prom */

/************************************************************************/

/*
 * System page table
 */
#define	vaddr(x)	((((x)-_Sysmap)/4)*NBPG+0)
#define	SYSMAP(mname, vname, npte)		\
_/**/mname:	.globl	_/**/mname;		\
	.space	npte*4;				\
	.globl	_/**/vname;			\
	.set	_/**/vname,vaddr(_/**/mname)

	.data
	.align	1
	SYSMAP(Sysmap	,Sysbase	,SYSPTSIZE	)
	SYSMAP(Usrptmap	,usrpt		,USRPTSIZE	)
	SYSMAP(Forkmap	,forkutl	,UPAGES		)
	SYSMAP(Xswapmap	,xswaputl	,UPAGES		)
	SYSMAP(Xswap2map,xswap2utl	,UPAGES		)
	SYSMAP(Swapmap	,swaputl	,UPAGES		)
	SYSMAP(Pushmap	,pushutl	,UPAGES		)
	SYSMAP(Vfmap	,vfutl		,UPAGES		)
	SYSMAP(mcrmap	,mcr		,1		)
	SYSMAP(mmap	,vmmap		,1		)
	SYSMAP(msgbufmap,msgbuf		,MSGBUFPTECNT	)
	SYSMAP(camap	,cabase		,16*CLSIZE	)
	SYSMAP(ecamap	,calimit	,0		)
	SYSMAP(Mbmap	,mbutl		,NMBCLUSTERS*CLSIZE)

	.globl	_eSysmap
_eSysmap:
	.globl	_Syssize
	.set	_Syssize,(_eSysmap-_Sysmap)/4
	.text

/************************************************************************/
/*
 * Interrupt vector routines
 */
	.globl	_waittime
	.globl	traps
	.globl	iret
	.globl	dorte

#define	SCBVEC(name)	.align 1;  .globl _X/**/name;  _X/**/name
#define	TRAP(x)		PEEXT(x); jra traps
#define	PEEXT(x)	clrw sp@-; pea x	/* push exception extention */
#ifdef	CAPTURE
#define	PUSHR		movml #0xC0C0,sp@-; jsr	_capture
#else	CAPTURE
#define	PUSHR		movml #0xC0C0,sp@-	/* save temp regs ([da][01]) */
#endif	CAPTURE
#define	POPR		movml sp@+,#0x0303	/* restore temp regs */
#define	PUSHED		16			/* offset around saved regs */
#define	TCODE		PUSHED			/* offset to trap code */
#define	TTYPE		(PUSHED+2)		/* offset to trap type */
#define	EEXT		6			/* size exception extension */
#define	ESF		(EEXT+PUSHED)		/* offset to exception frame */
#define	INC(counter)	addl #1,_cnt+counter
#define	IBEG		subl #EEXT,sp; PUSHR	/* null execption extention */
#define	RTE(n)		INC(n); jra iret

/*
 * collapse various stack formats to 4-word format 0 if ESF_SOFT bit is on in 
 * the stack format/vector offset word. Used to send signals to process, and 
 * for nofault recovery.
 */
#define	COLLAPSE(x)	\
    3:	cmpw	#ESF_FMT/**/x,sp@(ESF_VEC); jne 3f; /* stack format x to */    \
	movw	#ESF_FMT0,sp@(ESF_VEC+ESF_ISIZE/**/x-ESF_ISIZE0); /* fmt0 */   \
	movl	sp@(ESF_PC),sp@(ESF_PC+ESF_ISIZE/**/x-ESF_ISIZE0);/* copy pc */\
	movw	sp@(ESF_SW),sp@(ESF_SW+ESF_ISIZE/**/x-ESF_ISIZE0);/* copy sr */\
	lea	sp@(ESF_ISIZE/**/x-ESF_ISIZE0),sp; rte /* collapse stack size */

SCBVEC(stray):
SCBVEC(ctcint0):
SCBVEC(ctcint1):
SCBVEC(ctcint2):	TRAP(T_STRAY)
SCBVEC(adderr):		clrb sp@(ESF_FADDR)
			TRAP(T_ADDERR)
SCBVEC(illins):		TRAP(T_RESOPFLT)
SCBVEC(zerodiv):	TRAP(T_ZERODIV)
SCBVEC(chk):		TRAP(T_CHK)
SCBVEC(trapv):		TRAP(T_TRAPV)
SCBVEC(privvio):	TRAP(T_PRIVINFLT)
SCBVEC(l1010em):	TRAP(T_L1010EM)
SCBVEC(l1111em):	TRAP(T_L1111EM)
SCBVEC(trace):		TRAP(T_TRCTRAP)
SCBVEC(fmterr):		TRAP(T_FMTERR)
SCBVEC(trap0):		TRAP(T_TRAP+(0<<16))
SCBVEC(trap9):		TRAP(T_TRAP+(9<<16))
SCBVEC(trap10):		TRAP(T_TRAP+(10<<16))
SCBVEC(trap11):		TRAP(T_TRAP+(11<<16))
SCBVEC(trap12):		TRAP(T_TRAP+(12<<16))
SCBVEC(trap13):		TRAP(T_TRAP+(13<<16))
SCBVEC(trap14):		TRAP(T_TRAP+(14<<16))
SCBVEC(trap15):		TRAP(T_BPTFLT)

traps:	PUSHR				/* save temporary registers */
traps0:	movl	usp,a0			/* save user sp */
	pea	a0@
	jsr	_trap			/* call generic trap handler */
	movl	sp@+,a0
	movl	a0,usp			/* restore user sp */
	INC	(V_TRAP)		/* keep count */

iret:	movw	#PSL_IPL7,sr		/* raise priority to protect ast */
	tstb	_ast
	jne	4f			/* branch if pending async soft trap */
    1:	POPR				/* restore [da][01] */
	addl	#EEXT,sp		/* pop exception extention */

dorte:	bclr	#ESF_SOFT_BIT,sp@(ESF_VEC)
	jne	3f			/* branch if frame must be collapsed */
    2:	rte				/* return from trap/interrupt */

    3:	andw	#ESF_FMTMSK,sp@(ESF_VEC)/* isolate stack format */
	cmpw	#ESF_FMT0,sp@(ESF_VEC)	/* format 0 does not collapse */
	jeq	2b
#ifdef	M68020
	COLLAPSE(A)
	COLLAPSE(B)
	COLLAPSE(9)
	COLLAPSE(2)
#else	M68020
	COLLAPSE(8)
#endif	M68020
    3:	pea	panic_iret		/* bad stack format */
	jsr	_panic
	.align	1
panic_iret:	.asciz	"iret"
	.align	1

    4:	movw	sp@(ESF+ESF_SW),d0	/* Handle asynchronious soft trap */
	andw	#PSL_HIGH,d0		/* are we returning to low priority? */
	jne	1b			/* no, leave ast pending */
	bclr	#AST_NET,_ast		/* check/clear net ast */
	jne	_Xnetintr
	bclr	#AST_TIC,_ast		/* check/clear softclock ast */
	jne	_Xsoftclock
	btst	#AST_USR,_ast		/* check/clear user resched ast */
	jeq	1b
	movw	sp@(ESF+ESF_SW),d0	/* must be user ast */
	andw	#PSL_CURMOD,d0		/* leave pending */
	jne	1b			/* if not return to user mode */
	bclr	#AST_USR,_ast		/* clear ast and go service in trap */
	movw	#T_ASTFLT,sp@(TTYPE)
	jra	traps0

SCBVEC(softclock):
	/* exception extension stuff and regs are already pushed */
	movw	#PSL_IPLC,sr
	movw	sp@(ESF+ESF_SW),sp@-
	clrw	sp@-
	movl	sp@(4+ESF+ESF_PC),sp@-
	jsr	_softclock	/* softclock(pc,psl) */
	addql	#8,sp
	jra	iret

#include "../net/netisr.h"
	.globl	_netisr
SCBVEC(netintr):
	/* exception extension stuff and regs are already pushed */
	movw	#PSL_IPLN,sr
	bclr	#NETISR_RAW,_netisr+3
	jeq	1f
	jsr	_rawintr
    1:
#ifdef	INET
#include "../netinet/in_systm.h"
	bclr	#NETISR_IP,_netisr+3
	jeq	1f
	jsr	_ipintr
    1:
#endif	INET
#ifdef	NS
	bclr	#NETISR_NS,_netisr+3
	jeq	1f
	jsr	_nsintr
    1:
#endif	NS
	jra	iret

/*
 * T_SEGVIO:  attempt to access location outside of user address space
 * T_PROTFLT: attempt to write into a read-only page
 * T_SEGFLT:  attempt to access valid location with no page bank resources
 * T_PAGEFLT: attempt to access valid logical location in currently invalid page
 * T_BUSERR:  bummer
 */
SCBVEC(buserr):
#ifdef	KPROF
	tstb	_kprof_enable+3
	jeq	1f
	addql	#1,_kprof_buse	/* kprof: count bus errors */
    1:
#endif	KPROF
	clrb	sp@(ESF_FADDR)	/* might not always be zero!!! */
	clrw	sp@-		/* upper processor status longword */
	pea	T_PAGEFLT	/* hopeful trap type (code=0) */
	PUSHR			/* save temporary registers */

	movq	#0x40,d0	/* segment register bank select */
	orw	sp@(ESF+ESF_FADDR),d0	/* or in upper word of fault addr */
	swap	d0		/* shift to upper word of d0 */
	movb	CXR,d0
	lslw	#8,d0		/* get context in bits 15-12 */
	movl	d0,a0
	btst	#10,d0		/* check invalid page bit */
	jeq	3f
				/* page reg is marked invalid (3FC or 3FD) */
	movw	a0@,d0		/* get contents of segment register */
	andw	#0x003F,d0	/* mask all but page register set number */
	orw	#0x0080,d0	/* select page register bank */
	swap	d0
	movw	sp@(ESF+ESF_FADDR+2),d0	/* get lower word of fault addr */
	clrb	d0		/* only need bits 15-12; bit 0 must be zero */
	movl	d0,a0
	movw	a0@,d0		/* get contents of page register */
	lsrw	#3,d0		/* paged-out page (3FC as opposed to 3FD)? */
	jcc	traps0		/*   yes, go service page fault */
    2:	movw	#T_SEGVIO,sp@(TTYPE)
	jra	traps0		/*   no, go service segmentation violation */
    4:	movw	#T_SEGFLT,sp@(TTYPE)
	jra	traps0

    3:	btst	#9,d0		/* check protection bit */
	jeq	4f
	cmpw	#0x40,sp@(ESF+ESF_FADDR)
	jhs	2b		/* if user access to on-board IO, go SEGVIO */
	movw	a0@,d0		/* get contents of segment register */
	andw	#0xFF,d0	/* */
	jeq	2b		/* seg vio */
	cmpw	#1,d0		/* */
	jeq	4b		/* seg fault */
	movw	#T_PROTFLT,sp@(TTYPE)
	jra	traps0		/* must be a write to a read-only segment */

    4:	movw	#T_BUSERR,sp@(TTYPE)
	jra	traps0		/* not invalid page bit & not protection bit */

SCBVEC(nmi):
#ifndef	KPROF
	clrw sp@-;  movw #T_NMI,sp@-;  movw BSR,sp@-;  movw d0,BSR;  jra traps
#else	KPROF
	/*
	 * To prepare QBUS 68010 CPU board for kprof profiling at level 7:
	 *	- Inject profile clock into 8A (8640) pin 7, BHALTL.
	 */
	.data
	.globl	_kprof_magic
_kprof_magic:	.long	0x12345678
	.comm	_kprof_enable,4
	.comm	_kprof_su,2*4
	.comm	_kprof_spsl,8*4
	.comm	_kprof_upsl,8*4
	.comm	_kprof,KPROF*4
	.comm	_kprof_swtch,4
	.comm	_kprof_buse,4
	.comm	_kprof_sysc,4
	.comm	_kprof_pid,(20+32)*4	/* first 20 plus last 32 pid's */
	.comm	_kprof_pid_cnt,(20+32)*4
	.comm	_kprof_pid_nam,(20+32)*8
	.text

	IBEG
	tstb	_kprof_enable+3		/* skip if not enabled */
	jeq	3f
	cmpl	#0x800,sp		/* dont look at pid if swtching */
	jle	2f
	clrl	d0
	movl	_u+U_PROCP,a0		
	movw	a0@(P_PID),d0
	movl	d0,d1
	cmpw	#20,d0
	jle	1f
	andw	#0x1F,d0
	addl	#20,d0
    1:	lsll	#2,d0
	lea	_kprof_pid,a0
	addl	d0,a0
	movl	d1,a0@
	lea	_kprof_pid_cnt,a0
	addl	d0,a0
	addql	#1,a0@
	lea	_kprof_pid_nam,a0
	lsll	#1,d0
	addl	d0,a0
	lea	_u+U_COMM,a1		
	movl	a1@+,a0@+
	movl	a1@,a0@
    2:	clrl	d0
	movw	sp@(ESF+ESF_SW),d0	/* get psl */
	movw	d0,d1
	andl	#PSL_HIGH,d0
	lsrw	#PSL_IPL_SHIFT-2,d0	/* define kprof_[su]psl index */
	andl	#PSL_CURMOD,d1		/* test system mode */
	jeq	1f			/* jump if user mode */
	addql	#1,_kprof_su+4		/* accumulate system mode stats */
	jmi	4f;			/* jump if auto-shutoff */
	movl	sp@(ESF+ESF_PC),d1	/* get pc */
	andl	#NONT_MASK,d1
	lsrl	#2,d1			/* >>4, &(KPROF-1), <<2 */
	andl	#((KPROF-1)<<2),d1
	lea	_kprof,a0
	addl	d1,a0
	addql	#1,a0@
	lea	_kprof_spsl,a0
	jra	2f
    1:	addql	#1,_kprof_su		/* user mode */
	jmi	4f;			/* jump if auto-shutoff */
	lea	_kprof_upsl,a0
    2:	addl	d0,a0
	addql	#1,a0@
    3:	jra	iret
    4:	clrl	_kprof_enable		/* disable */
	jra	iret
#endif	KPROF

SCBVEC(ctcint3):
	movb	#CTC_RETI0,CTC_RETI	/* clear the interupt */
	movb	#CTC_RETI1,CTC_RETI

SCBVEC(lclock):			/* line time clock for system clock */
	IBEG
	movw	sp@(ESF+ESF_SW),sp@-
	clrw	sp@-
	movl	sp@(4+ESF+ESF_PC),sp@-
	jsr	_hardclock	/* hardclock(pc,psl) */
	addql	#8,sp
	RTE	(V_INTR)	/* temp so not to break vmstat -= HZ */

/*
 * System call service: Trap #1 is typical user system call. Signal and longjmp
 * cleanup use traps 2-8, and go to Sigcleanup() via a negative-number syscall.
 * The traps are 4-word stack format 0, but may need to return with a larger 
 * stack format obtained from the user. Here we allocate larger exception stack
 * frame, slide the 4-word format up to the top of the allocated area, and 
 * change its format so that when actually used, it will collapse to 4 words.
 */
#define	SIG_CLEAN_SYSCALL(x,n)	\
	subl	#(ESF_ISIZE/**/x-ESF_ISIZE0),sp;/* allocate for format x */ \
	movw	sp@(ESF_SW+ESF_ISIZE/**/x-ESF_ISIZE0),sp@(ESF_SW);	\
	movl	sp@(ESF_PC+ESF_ISIZE/**/x-ESF_ISIZE0),sp@(ESF_PC);	\
	movw	#(ESF_SOFT|ESF_FMT/**/x),sp@(ESF_VEC);			\
	PEEXT(T_SYSCALL + (-n << 16)); jra 2b	/* syscall -n */

SCBVEC(trap1):
#ifdef	KPROF
	tstb	_kprof_enable+3
	jeq	1f
	addql	#1,_kprof_sysc		/* kprof: count system calls */
    1:
#endif	KPROF
	clrw	sp@-			/* align psl, part of EEXT */
	movw	#T_SYSCALL,sp@-		/* push type, part of EEXT */
	movw	d0,sp@-			/* push code, part of EEXT */
	jne	1f
	movw	d1,sp@
	movml	#0x7F00,_u+U_ARG
	jra	2f
    1:	movml	#0x7F02,_u+U_ARG
    2:	PUSHR				/* save temp regs */
	movl	usp,a0			/* save user sp */
	pea	a0@
	jsr	_syscall		/* call system call handler */
	movl	sp@+,a0
	movl	a0,usp			/* restore user sp */
	RTE	(V_SYSCALL)		/* return */

SCBVEC(trap2):	SIG_CLEAN_SYSCALL(B,7)	/* trampoline format B, syscall -7 */
SCBVEC(trap3):	SIG_CLEAN_SYSCALL(A,6)	/* trampoline format A, syscall -6 */
SCBVEC(trap4):	SIG_CLEAN_SYSCALL(9,5)	/* trampoline format 9, syscall -5 */
SCBVEC(trap5):	SIG_CLEAN_SYSCALL(8,4)	/* trampoline format 8, syscall -4 */
SCBVEC(trap6):	SIG_CLEAN_SYSCALL(2,3)	/* trampoline format 2, syscall -3 */
SCBVEC(trap8):				/* trampoline format 0, syscall -2 */
	PEEXT(T_SYSCALL + (-2 << 16)); jra	2b
SCBVEC(trap7):				/* longjmp cleanup, syscall -1 */
	PEEXT(T_SYSCALL + (-1 << 16)); jra	2b

	.data
	.globl	_ast
_ast:	.byte	0
	.text

/************************************************************************/

/*
 * Primitives
 */

/*
 * badaddr(addr, len)
 *	See if access addr with a len type instruction causes
 *	a bus or address error.
 *	Len is length of access (1=byte, 2=short, 4=long).
 */
	.globl	_badaddr
_badaddr:
	movl	sp@(4),a0		/* address to be tested */
	movl	sp@(8),d1		/* size of operand (1, 2, or 4) */
	movw	sr,d0
	movl	d0,a1			/* save old sr in a1 */
	movq	#0,d0			/* hopeful return value: 0 */
	orw	#PSL_HIGH,sr		/* disable interrupts */
	movl	0+SCB_BUSERR,sp@-	/* save old bus error vector */
	movl	0+SCB_ADRERR,sp@-	/* save old address error vector */
	movl	#8f,0+SCB_BUSERR	/* set new bus error vector */
	movl	#9f,0+SCB_ADRERR	/* set new address error vector */
	lsrw	#1,d1			/* byte operation? */
	jcc	1f			/*   no */
	tstb	a0@			/*   yes -- try to access byte */
    1:	lsrw	#1,d1			/* short operation? */
	jcc	2f			/*   no */
	tstw	a0@			/*   yes -- try to access short */
    2:	lsrw	#1,d1			/* long operation? */
	jcc	3f			/*   no */
	tstl	a0@			/*   yes -- try to access long */
    3:	movl	sp@+,0+SCB_ADRERR	/* restore old address error vector */
	movl	sp@+,0+SCB_BUSERR	/* restore old bus error vector */
	movl	a1,d1
	movw	d1,sr			/* restore old interrupt priority */
	rts				/* return value in d0 */

    8:					/* BUS ERROR */
	addqw	#1,d0			/* modify return value */
	orw	#0x8000,sp@(ESF_SSW)	/* set software rerun flag in SSW */
	jra	dorte			/* return from bus error exception */

    9:					/* ADDRESS ERROR */
	addqw	#8,d0			/* modify return value */
	orw	#0x8000,sp@(ESF_SSW)	/* set software rerun flag in SSW */
	jra	dorte			/* return from address error exceptn */

/* addupc(pc, &u.u_prof, nticks)
/*	struct uprof {			/* profile arguments */
/*		short	*pr_base;	/* buffer base */
/*		unsigned pr_size;	/* buffer size */
/*		unsigned pr_off;	/* pc offset */
/*		unsigned pr_scale;	/* pc scaling */
/*	} u_prof;
/* */
	.globl	_addupc
_addupc:
	movl	sp@(8),a1	/* &u.u_prof */
	movl	sp@(4),d0
	subl	a1@(8),d0	/* corrected pc */
	jlt	9f
	lsrl	#1,d0		/* logical right shift */
	movl	a1@(12),d1
	lsrl	#1,d1		/* ditto for scale */

	movl	d0,sp@-
	movl	d1,sp@-
	jsr	ulqmul
	addql	#8,sp

	lsll	#1,d0		/* quad right shift 14 */
	roxll	#1,d1
	jcs	9f
	lsll	#1,d0
	roxll	#1,d1
	jcs	9f
	movw	d1,d0
	clrw	d1
	swap	d0
	swap	d1
	jne	9f

	andw	#0xFFFE,d0
	cmpl	a1@(4),d0	/* length */
	jhs	9f
	addl	a1@,d0		/* base */
	movl	d0,a0

	movl	_nofault,sp@-
	movl	#8f,_nofault
	movsw	a0@,d1
	addl	sp@(16),d1
	movsw	d1,a0@
    7:
	movl	sp@+,_nofault
    9:
	rts
    8:
	clrl	a1@(12)
	jra	7b

ulqmul:
	movl	d2,sp@-
	movw	sp@(10),d0	/* d0 = alo */
	mulu	sp@(12),d0	/* d0 = bhi*alo */
	movw	sp@(14),d1	/* d1 = blo */
	mulu	sp@(8),d1	/* d1 = ahi*blo */
	addl	d1,d0		/* d0 = (ahi*blo) + (bhi*alo) ... carry in x */
	movq	#0,d1
	addxl	d1,d1		/* d1 = carry from previous add */
				/* d0-1 = (ahi*blo) + (bhi*alo) */
	swap	d1
	swap	d0
	movw	d0,d1
	clrw	d0		/* d0-1 = ((ahi*blo) + (bhi*alo)) * (2**16) */

	movw	sp@(14),d2	/* d2 = blo */
	mulu	sp@(10),d2	/* d2 = alo*blo */
	addl	d2,d0		/* add (alo*blo) to d0 ... carry in x */

	movw	sp@(12),d2	/* d2 = bhi */
	mulu	sp@(8),d2	/* d2 = ahi*bhi */
	addxl	d2,d1		/* add (ahi*bhi) to d1, plus carry from prev */
	movl	sp@+,d2
	rts

	.globl	_copyin
_copyin:
#ifdef	BARF
	tstl	_u+U_RCLIENT
	jne	_Wcopyin
#endif	BARF
	cmpl	#512,sp@(12)
	jhs	_bcopyin
	movl	sp@(4),a0
	movl	sp@(8),a1

	movw	a0,d0		/* check for one addr even & one addr odd */
	movw	a1,d1
	eorw	d1,d0
	movl	sp@(12),d1
	jle	5f
	movl	_nofault,sp@-
	movl	#6f,_nofault
	lsrw	#1,d0
	jcs	4f

	movw	a0,d0		/* check for both addrs odd */
	lsrw	#1,d0
	jcc	1f
	movsb	a0@+,d0
	movb	d0,a1@+
	subql	#1,d1
	movl	d1,sp@(16)	/* adjust count! */
    1:
	lsrl	#2,d1
	jra	2f

    1:	movsl	a0@+,d0
	movl	d0,a1@+
    2:	dbf	d1,1b
	addqw	#1,d1
	subql	#1,d1
	jge	1b

	movl	sp@(16),d1
	andl	#3,d1
	jra	4f

    3:	movsb	a0@+,d0
	movb	d0,a1@+
    4:	dbf	d1,3b
	addqw	#1,d1
	subql	#1,d1
	jge	3b

	movl	sp@+,_nofault
    5:	movq	#0,d0
	rts
    6:
	movl	sp@+,_nofault
	movl	#EFAULT,d0
	rts

	.globl	_copyout
_copyout:
#ifdef	BARF
	tstl	_u+U_RCLIENT
	jne	_Wcopyout
#endif	BARF
	cmpl	#512,sp@(12)
	jhs	_bcopyout
	movl	sp@(4),a0
	movl	sp@(8),a1

	movw	a0,d0		/* check for one addr even & one addr odd */
	movw	a1,d1
	eorw	d1,d0
	movl	sp@(12),d1
	jle	5f
	movl	_nofault,sp@-
	movl	#6f,_nofault
	lsrw	#1,d0
	jcs	4f

	movw	a0,d0		/* check for both addrs odd */
	lsrw	#1,d0
	jcc	1f
	movb	a0@+,d0
	movsb	d0,a1@+
	subql	#1,d1
	movl	d1,sp@(16)	/* adjust count! */
    1:
	lsrl	#2,d1
	jra	2f

    1:	movl	a0@+,d0
	movsl	d0,a1@+
    2:	dbf	d1,1b
	addqw	#1,d1
	subql	#1,d1
	jge	1b

	movl	sp@(16),d1
	andl	#3,d1
	jra	4f

    3:	movb	a0@+,d0
	movsb	d0,a1@+
    4:	dbf	d1,3b
	addqw	#1,d1
	subql	#1,d1
	jge	3b

	movl	sp@+,_nofault
    5:	movq	#0,d0
	rts
    6:
	movl	sp@+,_nofault
	movl	#EFAULT,d0
	rts

/*
 * Non-local goto's
 */
	.globl	_setjmp
_setjmp:
	movl	sp@+,a1		/* return address */
	movl	sp@,a0		/* jmpbuf */
	movml	#0xFCFC,a0@	/* d2-d7, a2-a7 */
	movl	a1,a0@(12*4)	/* return pc */
	movq	#0,d0		/* zero return value */
	jmp	a1@		/* return */

	.globl	_longjmp
_longjmp:
	movl	sp@(4),a0	/* jmpbuf */
	movml	a0@+,#0x7CFC	/* d2-d7, a2-a6 */
	movl	a0@+,a1		/* to be new sp */
	cmpl	sp,a1		/* must be a pop */
	jge	lj2
#ifdef	LJMPDEBUG
	.data
lj3:	.asciz	"longjmp a0=%x a1=%x sp=%x\n"
	.text
movl	sp,sp@-
movl	a1,sp@-
movl	a0,sp@-
pea	lj3
jsr	_printf
lea	sp@(16),sp
#endif	LJMPDEBUG
	pea	lj1
	jsr	_panic
lj2:
	movl	a1,sp
	movl	a0@,a1		/* return pc */
	movl	a0,d0		/* nonzero return value */
	jmp	a1@		/* return */

	.data
lj1:	.asciz	"longjmp"
	.text


	.globl	_whichqs
	.globl	_qs
	.globl	_noproc
	.comm	_noproc,4
	.globl	_runrun
	.comm	_runrun,4

/*
 * setrq(p)
 *
 * Called at spl6().  p->p_stat should be SRUN.
 */
	.globl	_setrq
_setrq:
	movl	sp@(4),a0
	tstl	a0@(P_RLINK)
	jeq	set1
	pea	set2
	jsr	_panic
set1:
	movq	#0,d1
	movb	a0@(P_PRI),d1
	lsrw	#2,d1		/* put on queue which is p->p_pri / 4 */
	movl	d1,d0
	lslw	#3,d0
	lea	_qs,a1
	lea	a1@(0,d0:w),a1

	movl	a1,a0@		/* insert at end of queue */
	movl	a1@(4),d0
	movl	d0,a0@(4)
	movl	a0,a1@(4)
	movl	d0,a1
	movl	a0,a1@

	lea	_whichqs,a1	/* mark queue non-empty */
	movl	a1@,d0
	bset	d1,d0
	movl	d0,a1@

	rts

	.data
set2:	.asciz	"setrq"
	.text

/*
 * remrq(p)
 *
 * Called at spl6().
 */
	.globl	_remrq
_remrq:
	movl	sp@(4),a0
	movq	#0,d1
	movb	a0@(P_PRI),d1
	lsrw	#2,d1

	movl	_whichqs,d0
	bclr	d1,d0
	jne	rem1
	movl	d0,_whichqs
	pea	rem3
	jsr	_panic
rem1:
	movl	a0@,a1
	movl	a0@(4),d1
	cmpl	d1,a1
	jne	1f
	movl	d0,_whichqs
    1:	movl	d1,a1@(4)
	exg	d1,a1
	movl	d1,a1@

	clrl	a0@(P_RLINK)
	rts

	.data
rem3:	.asciz	"remrq"
	.text

/*
 * Masterpaddr is the p->p_addr of the running process on the master
 * processor.
 */
	.globl	_masterpaddr
	.data
	.align	1
_masterpaddr:
	.long	0
	.text

	.data
sw0:	.asciz	"swtch"
	.text
/*
 * swtch
 */
	.globl	_swtch
	.globl	_waitloc
_swtch:
	movw	sr,_u+PCB_PSL+2
	movl	#1,_noproc
	clrl	_runrun
sw1:				/* DETERMINE HIGHEST PRIORITY NONEMPTY QUEUE */
	orw	#PSL_HIGH,sr	/* disable interrupts */
	movl	_whichqs,d0
	movq	#0,d1
	jra	2f
    1:	addqw	#1,d1
    2:	lsrl	#1,d0		/* find an active queue */
	jcs	sw1a
	jne	1b

	bclr	#AST_NET,_ast
	jne	1f
	bclr	#AST_TIC,_ast
	jne	2f
	stop	#PSL_IPL0	/* idle */
_waitloc:
	jra	sw1		/* try again */

    1:
	movw	#PSL_IPLN,sr
	bclr	#NETISR_RAW,_netisr+3
	jeq	1f
	jsr	_rawintr
    1:
#ifdef	INET
	bclr	#NETISR_IP,_netisr+3
	jeq	1f
	jsr	_ipintr
    1:
#endif	INET
#ifdef	NS
	bclr	#NETISR_NS,_netisr+3
	jeq	1f
	jsr	_nsintr
    1:
#endif	NS
	jra	sw1

    2:
	movl	#PSL_IPL0,sp@-
	pea	_waitloc	/* push pc (idle address) */
	jsr	_softclock	/* softclock(pc,psl) */
	addql	#8,sp
	jra	sw1

sw1a:				/* REMOVE FIRST ENTRY FROM QUEUE */
	movl	d1,d0
	lslw	#3,d0
	lea	_qs,a1
	lea	a1@(0,d0:w),a1	/* a1 -> queue header */

	movl	a1@,a0		/* a0 -> first entry in queue */
	cmpl	a1,a0		/* make sure queue not empty */
	jne	1f
sw1b:
	pea	sw0
	jsr	_panic
    1:
	movl	a0@,d0		/* unlink item from queue */
	movl	d0,a1@		/* unlink from queue header */
	exg	d0,a1
	movl	d0,a1@(4)	/* unlink from successor */

	cmpl	d0,a1		/* if queue is now empty, */
	jne	1f
	movl	_whichqs,d0	/*    then mark queue empty */
	bclr	d1,d0
	movl	d0,_whichqs
    1:
	clrl	_noproc
	tstl	a0@(P_WCHAN)
	jne	sw1b
	cmpb	#SRUN,a0@(P_STAT)
	jne	sw1b
	clrl	a0@(P_RLINK)

	movl	a0@(P_ADDR),a1
	movl	a1@,d0
	movl	d0,_masterpaddr

	INC	(V_SWTCH)

	movb	CXR,d1
	andb	#0xF,d1
	orb	#(1<<4),d1	/* user context #1 */
	movw	d1,CXW

	movml	#0xFCFC,_u
	lslw	#2,d0		/* convert vax pte to is68k pte */
	movw	d0,d2

	movq	#0,d0
	movw	_u+PCB_P0LR+2,d0
	movl	d0,sp@-			/* num of ptes */
	clrl	sp@-			/* virtual page */
	movl	_u+PCB_P0BR,sp@-	/* pte */
	jsr	_refptes
	addql	#8,sp

	movq	#0,d0
	movw	_u+PCB_P1LR+2,d0
	movl	#0x400,d1
	subw	d0,d1
	movl	d1,sp@			/* num of ptes */
	movl	d0,sp@-			/* virtual page */
	movl	_u+PCB_P1BR,d1
	lslw	#2,d0
	addl	d0,d1
	movl	d1,sp@-			/* pte */
	jsr	_refptes
	lea	sp@(12),sp

#ifndef	NOSKY
/*
 * SKY support...  this stuff really belongs in a driver.
 */
#define	SKYCOM	0
#define	SKYSTC	2
#define	SKYDT1	4
#define	SKYDT2	6
#define	SKYMC1	8
#define	SKYMC2	10

#define	SKYRDY	15
#define	SKYIDLE	14
#define	SKYDIR	13
	tstw	_skybase
	jeq	nosky
	movl	_u+U_PROCP,a0		/* u.u_procp */
	tstb	a0@(P_FLAG)		/* high bit of p_flag is sky map bit */
	jge	nosky

	movl	_skybase,a0
	lea	_u+U_SKY,a1
	movw	a0@(SKYSTC),d0
	andw	#0x60,d0
	cmpw	#0x40,d0
	jne	nosky
step1:	movw	a0@(SKYSTC),d0
	btst	#SKYIDLE,d0
	jeq	step2
	movw	#0x1063,a1@+
	jra	step8
step2:	btst	#SKYRDY,d0
	jeq	step1
step3:	movw	#0x0060,a0@(SKYSTC)
step4:	movw	a0@(SKYSTC),d0
	btst	#SKYDIR,d0
	jeq	s4
	movw	a0@(SKYDT1),d0
	jra	step5
s4:	movw	d0,a0@(SKYDT1)
step5:	movw	a0@(SKYSTC),d0
	btst	#SKYRDY,d0
	jne	step4
step6:	movw	a0@(SKYCOM),d0
	subqw	#1,d0
	movw	d0,a1@+
step7:	movw	#0x0080,a0@(SKYSTC)
	movw	#0x1000,a0@(SKYCOM)
	movw	#0x1000,a0@(SKYCOM)
	movw	#0x1001,a0@(SKYCOM)
	movw	#0x0040,a0@(SKYSTC)
step8:	movw	#0x1063,a0@(SKYCOM)
step9:	movw	#0x1040,a0@(SKYCOM)
	lea	a0@(SKYDT1),a0
	movl	a0@,a1@+
	movl	a0@,a1@+
	movl	a0@,a1@+
	movl	a0@,a1@+
	movl	a0@,a1@+
	movl	a0@,a1@+
	movl	a0@,a1@+
	movl	a0@,a1@+
nosky:
#endif	SKY
	lea	0x800,sp		/* KLUDGE temporary stack, for NMI's! */
	movw	d2,PGREG(_u)
#ifdef	KPROF
	tstb	_kprof_enable+3
	jeq	1f
	addql	#1,_kprof_swtch		/* kprof: count context switches */
    1:
#endif	KPROF

#ifdef	SWTCHDEBUG
	movml	_u,#0xFCFC		/* make sure our new sp is set up! */
	movl	_u+U_PROCP,sp@-		/* u.u_procp */
	andl	#0xFF,d0
	movl	d0,sp@-			/* _u_pfnum */
	movl	a1,sp@-			/* P_ADDR */
	movl	a0,sp@-			/* p */
	movw	a0@(P_PPID),d0
	movl	d0,sp@-			/* PPID */
	movw	a0@(P_PID),d0
	movl	d0,sp@-			/* PID */
	.data
___sw0:	.asciz	"swtch: PID=%d PPID=%d p=0x%x P_ADDR=0x%x _u_pfnum=0x%x u.u_procp=0x%x\n"
	.text
	pea	___sw0
	jsr	_printf
	lea	sp@(7*4),sp
#endif	SWTCHDEBUG

	/*
	 * Invalidate all 64 segments for the user context.
	 */
	lea	0x400000+(1<<12),a0	/* user context #1 */
	movl	#0x10000,d1
	movq	#0,d0
	movq	#64-1,d2
    1:	movw	d0,a0@
	addl	d1,a0
	dbra	d2,1b

	movml	_u,#0xFCFC
	movl	#63,_minusrseg

	movq	#0,d0
	movw	_u+PCB_P0LR+2,d0
	movl	d0,sp@-			/* num of ptes */
	clrl	sp@-			/* virtual page */
	movl	_u+PCB_P0BR,sp@-	/* pte */
	jsr	_newptes
	addql	#8,sp

	movq	#0,d0
	movw	_u+PCB_P1LR+2,d0
	movl	#0x400,d1
	subw	d0,d1
	movl	d1,sp@			/* num of pages */
	movl	d0,sp@-			/* virtual page */
	movl	_u+PCB_P1BR,d1
	lslw	#2,d0
	addl	d0,d1
	movl	d1,sp@-			/* pte */
	jsr	_newptes
	lea	sp@(12),sp

#ifndef	NOSKY
/***** BEGIN SKY KLUDGE STUFF *****/
	tstw	_skybase
	jeq	1f
	movl	_u+U_PROCP,a0		/* u.u_procp */
	tstb	a0@(P_FLAG)		/* high bit of p_flag is sky map bit */
	jge	1f
	btst	#6,a0@(P_FLAG)		/* old sky map bit */
	jeq	2f			/* skip if not set */
	jsr	sky1
    2:	movl	_skybase,a0
	lea	_u+U_SKY,a1
	movw	a0@(SKYSTC),d0
	andw	#0x60,d0
	cmpw	#0x40,d0
	jne	1f
	movw	a1@+,d0
	movw	#0x1041,a0@
	lea	a0@(SKYDT1),a0
	movl	a1@+,a0@
	movl	a1@+,a0@
	movl	a1@+,a0@
	movl	a1@+,a0@
	movl	a1@+,a0@
	movl	a1@+,a0@
	movl	a1@+,a0@
	movl	a1@+,a0@
	movl	_skybase,a0
	movw	d0,a0@
    1:
/***** END SKY KLUDGE STUFF *****/
#endif	SKY

	movl	_u+PCB_SSWAP,d0
	jeq	res1
	clrl	_u+PCB_SSWAP
	movl	d0,sp@
	movw	_u+PCB_PSL+2,sr
	jsr	_longjmp
res1:
	movq	#0,d1
	movw	_u+PCB_PSL+2,d1
	jra	splx

	.globl	_resume
_resume:
	movw	sr,_u+PCB_PSL+2
	movml	#0xFCFC,_u
	rts

/***** BEGIN SKY KLUDGE STUFF *****/
	.globl	_sky
_sky:
#ifndef	NOSKY
	tstw	_skybase
	jeq	2f
	movl	_u+U_PROCP,a0		/* u.u_procp */
	bset	#7,a0@(P_FLAG)		/* high bit of p_flag is sky map bit */
	bset	#6,a0@(P_FLAG)		/* old sky map bit */
	movw	#0x1063,_u+U_SKY
sky1:	pea	2			/* 2 4-kbyte pages */
	pea	0x340			/* user virtual address of io page */
	pea	1f			/* address of two vax pte's */
	jsr	_newptes
	lea	sp@(12),sp
    2:

	.data
	.align	1
    1:	.long	0xA00003FE		/* valid, anybody read-write, iopage0 */
	.long	0xA00003FF		/* valid, anybody read-write, iopage1 */
	.text
/***** END SKY KLUDGE STUFF *****/
#endif
	rts

/***** BEGIN USER LOCK IN CORE KLUDGE STUFF *****/
	.globl	_ulock
_ulock:
	jbsr	_suser
	tstl	d0
	jeq	1f
	movl	_u+U_PROCP,a0		/* p = u.u_procp; */
	orl	#SULOCK,a0@(P_FLAG)	/* p->p_flag |= SULOCK; */
    1:	rts
/***** END USER LOCK IN CORE KLUDGE STUFF *****/

	.globl	_refbits
_refbits:
	movq	#0,d0
	movw	_u+PCB_P0LR+2,d0
	movl	d0,sp@-			/* num of ptes */
	clrl	sp@-			/* virtual page */
	movl	_u+PCB_P0BR,sp@-	/* pte */
	jsr	_refptes
	addql	#8,sp

	movq	#0,d0
	movw	_u+PCB_P1LR+2,d0
	movl	#0x400,d1
	subw	d0,d1
	movl	d1,sp@			/* num of ptes */
	movl	d0,sp@-			/* virtual page */
	movl	_u+PCB_P1BR,d1
	lslw	#2,d0
	addl	d0,d1
	movl	d1,sp@-			/* pte */
	jsr	_refptes
	lea	sp@(12),sp
	rts

	.globl	__insque
__insque:
	movw	sr,d1
	orw	#PSL_HIGH,sr
	movl	sp@(4),a0	/* new */
	movl	sp@(8),a1	/* pred */
	movl	a1@,d0		/* succ */
	movl	d0,a0@
	movl	a1,a0@(4)
	movl	a0,a1@
	movl	d0,a1
	movl	a0,a1@(4)
	movw	d1,sr
	rts

	.globl	__remque
__remque:
	movw	sr,d1
	orw	#PSL_HIGH,sr
	movl	sp@(4),a0
	movl	a0@,a1
	movl	a0@(4),d0
	movl	d0,a1@(4)
	exg	d0,a0
	movl	a1,a0@
	movw	d1,sr
	rts

	.globl	_setsoftclock
_setsoftclock:
	movw	sr,d0
	andw	#PSL_HIGH,d0		/* are we running at low priority? */
	jeq	1f
	bset	#AST_TIC,_ast		/*   no -- set ast pending & return */
	rts
    1:					/*   yes */
	movl	#PSL_IPL0,sp@-
	movl	sp@(4),sp@-
	jsr	_softclock	/* softclock(pc,psl) */
	addql	#8,sp
	movw	#PSL_IPL0,sr
	rts

	.globl	_setsoftnet
_setsoftnet:
	movw	sr,d0
	andw	#PSL_HIGH,d0		/* are we running at low priority? */
	jeq	1f
	bset	#AST_NET,_ast
	rts
    1:
	movw	#PSL_IPLN,sr
	bclr	#NETISR_RAW,_netisr+3
	jeq	2f
	jsr	_rawintr
    2:
#ifdef	INET
	bclr	#NETISR_IP,_netisr+3
	jeq	2f
	jsr	_ipintr
    2:
#endif	INET
#ifdef	NS
	bclr	#NETISR_NS,_netisr+3
	jeq	2f
	jsr	_nsintr
    2:
#endif	NS
	movw	#PSL_IPL0,sr
	rts

	.globl	_splx
_splx:
	movl	sp@(4),d1
splx:
	movw	d1,d0
	andw	#PSL_HIGH,d0
	jeq	_spl0
	clrl	d0
	movw	sr,d0
	movw	d1,sr
	rts

	.globl	_spl
_spl:
	clrl	d0
	movw	sr,d0
	rts

	.globl	_spl0
_spl0:
	clrl	d0
	movw	sr,d0
    1:
	movw	#PSL_IPL7,sr		/* raise priority to protect ast */
	tstb	_ast
	jeq	6f

	bclr	#AST_NET,_ast
	jne	2f
	bclr	#AST_TIC,_ast
	jne	3f
    6:
	andw	#PSL_LOW,sr	/* drop to low priority */
	rts
    2:
	movw	#PSL_IPLN,sr
	movl	d0,sp@-		/* save previous sr */

	bclr	#NETISR_RAW,_netisr+3
	jeq	4f
	jsr	_rawintr
    4:
#ifdef	INET
	bclr	#NETISR_IP,_netisr+3
	jeq	4f
	jsr	_ipintr
    4:
#endif	INET
#ifdef	NS
	bclr	#NETISR_NS,_netisr+3
	jeq	4f
	jsr	_nsintr
    4:
#endif	NS
	movl	sp@+,d0		/* return value */
	jra	1b
    3:
	movl	d0,sp@-		/* save previous sr */
	movl	#PSL_CURMOD,sp@-
	movl	sp@(8),sp@-	/* push pc (return address) */
	jsr	_softclock	/* softclock(pc,psl) */
	addql	#8,sp
	movl	sp@+,d0		/* return value */
	jra	1b

	.globl	_splnet
_splnet:
	.globl	_spl4
_spl4:
	.globl	_spl5
_spl5:
	.globl	_splimp
_splimp:
	.globl	_spl6
_spl6:
	.globl	_spl7
_spl7:
	clrl	d0
	movw	sr,d0
	orw	#PSL_HIGH,sr
	rts

	.globl	_spl1
_spl1:
	clrl	d0
	movw	sr,d0
	movw	#PSL_IPL1,sr
	rts


	.globl	_fubyte
_fubyte:
	.globl	_fuibyte
_fuibyte:
#ifdef	BARF
	tstl	_u+U_RCLIENT
	jne	_Wfubyte
#endif	BARF
	movl	sp@(4),a0
	movl	_nofault,sp@-
	movl	#fserr,_nofault
	clrl	d0
	movsb	a0@,d0
	movl	sp@+,_nofault
	rts

	.globl	_fuword
_fuword:
	.globl	_fuiword
_fuiword:
#ifdef	BARF
	tstl	_u+U_RCLIENT
	jne	_Wfuword
#endif	BARF
	movl	sp@(4),a0
	movl	_nofault,sp@-
	movl	#fserr,_nofault
	movsl	a0@,d0
	movl	sp@+,_nofault
	rts

	.globl	_subyte
_subyte:
	.globl	_suibyte
_suibyte:
#ifdef	BARF
	tstl	_u+U_RCLIENT
	jne	_Wsubyte
#endif	BARF
	movl	sp@(4),a0
	movl	sp@(8),d0
	movl	_nofault,sp@-
	movl	#fserr,_nofault
	movsb	d0,a0@
	clrl	d0
	movl	sp@+,_nofault
	rts

	.globl	_suword
_suword:
	.globl	_suiword
_suiword:
#ifdef	BARF
	tstl	_u+U_RCLIENT
	jne	_Wsuword
#endif	BARF
	movl	sp@(4),a0
	movl	sp@(8),d0
	movl	_nofault,sp@-
	movl	#fserr,_nofault
	movsl	d0,a0@
	clrl	d0
	movl	sp@+,_nofault
	rts

fserr:	movq	#-1,d0
	movl	sp@+,_nofault
	rts

	.globl	_copyseg
_copyseg:
	movl	sp@(8),d0	/* page frame number */
	lslw	#2,d0
	movl	sp@(4),a0	/* user virtual source */
	movw	PGREG(CADDR2),sp@-
	movw	d0,PGREG(CADDR2)
	lea	CADDR2,a1	/* kernel virtual destination */
	movw	#(NBPG/4)-1,d0	/* long count */
    1:	movsl	a0@+,d1
	movl	d1,a1@+
	dbra	d0,1b
	movw	sp@+,PGREG(CADDR2)
	movq	#0,d0
	rts

	/* 
	 * quick block copy a page
	 */
	.globl	_qbcopyp
_qbcopyp:
	movl	sp@(4),a0	/* source */
	movl	sp@(8),a1	/* destination */
	movw	#(NBPG>>2)-1,d0	/* change to long count (truncated) */
    1:	movl	a0@+,a1@+	/* long copy loop */
	dbf	d0,1b		/* entry point of long copy loop */
	rts

	.globl	_clearseg
_clearseg:
	movl	sp@(4),d0	/* page frame number */
	lslw	#2,d0
	movw	PGREG(CADDR1),sp@-
	movw	d0,PGREG(CADDR1)
	movq	#0,d1
	lea	CADDR1,a0
	movw	#(NBPG/4)-1,d0	/* long count */
    1:	movl	d1,a0@+
	dbra	d0,1b
	movw	sp@+,PGREG(CADDR1)
	movq	#0,d0
	rts

	.globl	_getmeml
_getmeml:
	movl	sp@(4),d0	/* physical address */
	movq	#PGSHIFT,d1
	lsrl	d1,d0		/* physical page */
	movw	sp@(4+2),d1
	andw	#NBPG-1,d1	/* offset within page */
	lea	CADDRa,a0	/* virtual page address */
	lslw	#2,d0
	movw	PGREG(CADDRa),sp@-
	movw	PGREG(CADDRb),sp@-
	movw	d0,PGREG(CADDRa)
	addqw	#(1<<2),d0
	movw	d0,PGREG(CADDRb)
	movl	a0@(0,d1:w),d0
	movw	sp@+,PGREG(CADDRb)
	movw	sp@+,PGREG(CADDRa)
	rts

	.globl	_putmeml
_putmeml:
	movl	sp@(4),d0	/* physical address */
	movq	#PGSHIFT,d1
	lsrl	d1,d0		/* physical page */
	movw	sp@(4+2),d1
	andw	#NBPG-1,d1	/* offset within page */
	lea	CADDRa,a0	/* virtual page address */
	lslw	#2,d0
	movw	PGREG(CADDRa),sp@-
	movw	PGREG(CADDRb),sp@-
	movw	d0,PGREG(CADDRa)
	addqw	#(1<<2),d0
	movw	d0,PGREG(CADDRb)
	movl	sp@(8+4),a0@(0,d1:w)
	movw	sp@+,PGREG(CADDRb)
	movw	sp@+,PGREG(CADDRa)
	rts

	.globl	_useracc
_useracc:
#ifdef	BARF
	tstl	_u+U_RCLIENT
	jne	_Wuseracc
#endif	BARF
	movl	#NBPG,d1
	movl	sp@(4),a0	/* user virtual address */
	movl	a0,a1
	addl	sp@(8),a1
	subql	#1,a1		/* address of last byte */
	movl	_nofault,sp@-
	movl	#uaerr,_nofault
	tstl	sp@(16)		/* access mode */
	jeq	useraw

    1:	movsb	a0@,d0
	addl	d1,a0
	cmpl	a0,a1
	jgt	1b
	movsb	a1@,d0
	jra	2f
useraw:
    1:	movsb	a0@,d0
	movsb	d0,a0@
	addl	d1,a0
	cmpl	a0,a1
	jgt	1b
	movsb	a1@,d0
	movsb	d0,a1@
    2:	movq	#1,d0
    3:	movl	sp@+,_nofault
	rts
uaerr:
	movq	#0,d0
	jra	3b

	.globl	_kernacc
_kernacc:
	movq	#1,d0
	rts

	.globl	_doadump
_doadump:
    1:	stop	#PSL_CURMOD
	jra	1b

	.globl	_ovbcopy
_ovbcopy:
	jmp	_bcopy

	.globl	_blkclr
_blkclr:
	jmp	_bzero

	.globl	__reboot
__reboot:
	movl	_howto,d7
	movl	_devtype,d6
	jmp	PROM_REBOOT

	.globl	_byterev
_byterev:
	movl	sp@(4),a0		/* address of byte string */
	movl	a0,a1
	movl	sp@(8),d1		/* length of string */
	addql	#1,d1
	lsrl	#1,d1
	jra	2f

    1:	movw	a1@,d0
	rolw	#8,d0
	movw	d0,a1@+
    2:	dbf	d1,1b
	addqw	#1,d1
	subql	#1,d1
	jge	1b

	movl	a1,d0
	rts

/*
 * cksum(sum, string, len, sumlen)
 *  	16 bit checksum of byte string s
 */ 
	.globl	_cksum
_cksum:
	movl	d2,sp@-			/* save d2 */
	movl	sp@(8),d0		/* sum */
	movl	sp@(12),a0		/* address of byte string */
	movl	a0,d2
	tstl	sp@(16)			/* length of string */
	jeq	9f			/* zero length string, return */
	andb	#0xF,cc			/* X clerar x bit */
	btst	#0,sp@(20+3)			/* swap bytes ?? */
	jne	4f

	/* sum is word alligned, dont swap bytes */
	btst	#0,d2
	jeq	1f

	/* odd start address, do first byte, and then swap bytes */
	subl	#1,sp@(16)		/* X */
	clrl	d2
	movb	a0@+,d2
	rolw	#8,d2
	addw	d2,d0			/* X */
	jra	5f

	/* even address, sum alligned */
    1:	movl	sp@(16),d1
	andl	#0xFFFFFFFE,d1
	rorl	#1,d1
	jra	3f
    2:	movw	a0@+,d2
	addxw	d2,d0			/* X */
    3:	dbf	d1,2b
	btst	#0,sp@(16+3)
	jeq	8f

	/* odd length, take care of last byte */
	clrl	d2
	movb	a0@+,d2
	rolw	#8,d2
	addxw	d2,d0			/* X */
	jra	8f

	/* sum is not word alligned, swap bytes */
    4:	btst	#0,d2
	jeq	5f

	/* odd start address, do first byte, and then dont swap bytes */
	subl	#1,sp@(16)		/* X */
	clrl	d2
	movb	a0@+,d2
	addw	d2,d0			/* X */
	jra	1b

	/* even address, sum misalligned, swap bytes */
    5:	movl	sp@(16),d1
	andl	#0xFFFFFFFE,d1
	rorl	#1,d1
	jra	7f
    6:	movw	a0@+,d2
	rolw	#8,d2
	addxw	d2,d0			/* X */
    7:	dbf	d1,6b
	btst	#0,sp@(16+3)
	jeq	8f

	/* odd length, take care of last byte */
	clrl	d2
	movb	a0@+,d2
	addxw	d2,d0			/* X */

	/* fold in last carry bit */
    8:	clrl	d2
	addxw	d2,d0			/* X */

    9:	movl	sp@+,d2			/* restore d2 */
	rts


	.data
	.align	1
	.globl	_nofault
_nofault:
	.long	0
	.globl	_howto
_howto:
	.long	0
	.globl	_devtype
_devtype:
	.long	0
	.text

/************************************************************************/

#define	SIOCONT(cont)	cont*20

SCBVEC(siorint0):
	IBEG
	clrl sp@-;  jsr _siorint;  addql #4,sp
	RTE (V_INTR)

SCBVEC(siosint0):
	IBEG
	clrl sp@-;  jsr	_siosint;  addql #4,sp
	RTE (V_INTR)

SCBVEC(sioeint0):
	IBEG
	clrl sp@-;  jsr	_sioeint;  addql #4,sp
	RTE (V_INTR)

SCBVEC(sioxint0):
	IBEG
	movl	#SIOCONT(0),d0
	jra	siodma


SCBVEC(siorint1):
	IBEG
	pea 1;  jsr _siorint;  addql #4,sp
	RTE (V_INTR)

SCBVEC(siosint1):
	IBEG
	pea 1;  jsr _siosint;  addql #4,sp
	RTE (V_INTR)

SCBVEC(sioeint1):
	IBEG
	pea 1;  jsr _sioeint;  addql #4,sp
	RTE (V_INTR)

SCBVEC(sioxint1):
	IBEG
	movl	#SIOCONT(1),d0
	jra	siodma


/*
 * SIO pseudo dma routine:
 *	d0 - port number * sizeof(struct pdma)
 */
	.align	1
	.globl	siodma
siodma:
	addl	#_sio_pdma,d0
	movl	d0,a1		/* pdma structure base */
	movl	a1@+,a0		/* device register base address */
	movb	#SIOW0_TXPEND,a0@(SIO_CTRL)	/* reset transmit int pending */
	jra	2f
    1:
	movl	a1@+,d1		/* p_mem */
	cmpl	a1@+,d1		/* p_end > p_mem ? */
	bhs	4f		/* no, go call sioxint */
	exg	d1,a1
	movb	a1@+,a0@	/* adata = *p_mem++ */
	exg	d1,a1
	movl	d1,a1@(-8)
    2:
	movl	d0,a1		/* pdma structure base */
	movl	a1@+,a0		/* device register base address */
	movb	a0@(SIO_CTRL),d1
	andb	#SIOR0_TXRDY,d1
	jne	1b		/* if not TXRDY, all done */
    3:
	movl	#SIO0_ADR+SIO_CTRL,a0	/* force to PORTA */
	movb	#SIOW0_RETINT,a0@
	RTE	(V_PDMA)
    4:
	movl	d0,sp@-		/* save d0 */
	movl	a1@+,sp@-	/* push tty address as arg */
	movl	a1@,a1		/* get address of interrupt routine */
	jsr	a1@		/* call interrupt routine */
	addql	#4,sp		/* pop arg (tty address) */
	movl	sp@+,d0		/* restore d0 */
	jra	3b

/************************************************************************/

#include <syscall.h>

	.data
	.align	1
icode:
#define	ZERO	icode		/* unrelocation constant */
	movml	pc@(2f),#0x0303	/* load syscall args into regs */
	trap	#1		/* do execve syscall */
    1:	jra	1b		/* loop here if cannot execute init */

    2:	.long	SYS_execve	/* d0: syscall: SYS_execve */
	.long	5f-ZERO		/* d1: file: "/etc/init" */
	.long	3f-ZERO		/* a0: argv: ("init", "-?", NULL) */
	.long	4f-ZERO		/* a1: envp: (NULL) */

    3:	.long	6f-ZERO		/* "init" */
	.long	7f-ZERO		/* "-?" '?' rewriten to 'm' or 's' in startup */
    4:	.long	0		/* NULL */

    5:	.ascii	"/etc/"
    6:	.asciz	"init"
    7:	.byte	0x2d		/* '-' */
initflg:
	.byte	0x3f		/* '?' multi/single user flag */
	.byte	0x00		/* '\0' */

	.align	1
	.globl	_icode
	.globl	_szicode
	.globl	_initflg
_icode:				/* pointer to icode */
	.long	icode
_szicode:			/* length of icode */
	.long	_icode-ZERO
_initflg:			/* pointer to init flag */
	.long	initflg
#undef	ZERO

/************************************************************************/

/* signal trampoline code */
	.globl	_sigcode
	.globl	_szsigcode
	.data
	.align	1
sigcode:
	bras	1f			/* +0:  stack format 0 entry */
	bras	2f			/* +2:  stack format 2 entry */
	bras	3f			/* +4:  stack format 8 entry */
	bras	4f			/* +6:  stack format 9 entry */
	bras	5f			/* +8:  stack format A entry */
	bras	6f			/* +10: stack format B entry */
		/* stack format 0 */
    1:	bsrs	8f			/* save regs and call handler */
    1:	trap	#8			/* restore sig mask and return */
	bras	1b
		/* stack format 2 */
    2:	bsrs	8f			/* save regs and call handler */
    1:	trap	#6			/* restore sig mask and return */
	bras	1b
		/* stack format 8 */
    3:	bsrs	8f			/* save regs and call handler */
    1:	trap	#5			/* restore sig mask and return */
	bras	1b
		/* stack format 9 */
    4:	bsrs	8f			/* save regs and call handler */
    1:	trap	#4			/* restore sig mask and return */
	bras	1b
		/* stack format A */
    5:	bsrs	8f			/* save regs and call handler */
    1:	trap	#3			/* restore sig mask and return */
	bras	1b
		/* stack format B */
    6:	bsrs	8f			/* save regs and call handler */
    1:	trap	#2			/* restore sig mask and return */
	bras	1b
    8:	link	a6,#-16			/* just like a real stack frame */
	movml	#0x0303,a6@(-16)	/* save regs d0-d1, a0-a1 */
	movml	a6@(8),#0x0303		/* get our args and handler ptr */
	movml	#0xC0C0,sp@-		/* push our args as args to handler */
	jsr	a1@			/* handler(sig, code, psigctx) */
	movml	a6@(-16),#0x0303	/* restore regs */
	unlk	a6			/* just like a real stack frame */
	rtd	#16			/* pop the args we were called with */
	.align	1
_sigcode:	.long	sigcode
_szsigcode:	.long	_sigcode-sigcode

/************************************************************************/

	.text
#if NDL > 0 || Ndl > 0
#define	DLCONT(cont)	cont*20
/*
 * DL pseudo dma routine:
 *	d0 - controller number * 20
 */
	.align	1
	.globl	dldma
dldma:
	addl	#_dlpdma,d0
	jra	2f
    1:
	movl	a1@+,d1		/* p_mem */
	cmpl	a1@+,d1		/* p_mem < p_end ? */
	bhs	3f		/* no, go call dlxint */
	exg	d1,a1
	movb	a1@+,a0@(7)	/* dl_xbuf = *p_mem++ !!!QBUS BYTE ACCESS!!! */
	exg	d1,a1
	movl	d1,a1@(-8)
    2:
	movl	d0,a1		/* pdma structure base */
	movl	a1@+,a0		/* device register address */
	movb	a0@(5),d1	/* get dl_xcsr status !!QBUS BYTE ACCESS!! */
	jlt	1b		/* if not TRDY, all done */
	RTE	(V_PDMA)
    3:
	clrb	a0@(5)		/* turn off XIE int dl_xcsr */
	movl	d0,sp@-		/* save d0 */
	movl	a1@+,sp@-	/* push tty address as arg */
	movl	a1@,a1		/* get address of interrupt routine */
	jsr	a1@		/* call interrupt routine */
	addql	#4,sp		/* pop arg (tty address) */
	movl	sp@+,d0		/* restore d1 */
	RTE	(V_PDMA)
#endif

#if NDZ > 0 || Ndz > 0
#define	DZCONT(cont)	cont*8*20
/*
 * DZ pseudo dma routine:
 *	d0 - controller number * 8 * 20
 */
	.align	1
	.globl	dzdma
dzdma:
	addl	#_dzpdma,d0
	jra	2f
    1:
	andw	#7,d1		/* clear garbage bits (word!) */
	mulu	#20,d1
	addl	d1,a1		/* point at line's pdma structure */
	movl	a1@+,d1		/* p_mem */
	cmpl	a1@+,d1		/* p_mem < p_end ? */
	bhs	3f		/* no, go call dzxint */
	exg	d1,a1
	movb	a1@+,a0@(7)	/* dztbuf = *p_mem++ !!!QBUS BYTE ACCESS!!! */
	exg	d1,a1
	movl	d1,a1@(-8)
    2:
	movl	d0,a1		/* pdma structure base */
	movl	a1@+,a0		/* device register address */
	movb	a0@,d1		/* get line number !!!QBUS BYTE ACCESS!!! */
	jlt	1b		/* if not TRDY, all done */
	RTE	(V_PDMA)
    3:
	movl	d0,sp@-		/* save d0 */
	movl	a1@+,sp@-	/* push tty address as arg */
	movl	a1@,a1		/* get address of interrupt routine */
	jsr	a1@		/* call interrupt routine */
	addql	#4,sp		/* pop arg (tty address) */
	movl	sp@+,d0		/* restore d1 */
	jra	2b		/* check for another line */
#endif

/************************************************************************/

	.text
	.align	1
	.globl	_buffers18
_buffers18:
	.long	buffers18
buffers18:
	.space	NBUF18*MAXBSIZE

#if NDH > 0 || Ndh > 0
	.align	1
	.globl	_dh_buf
_dh_buf:
	.space	CBSIZE*NDH*16
#endif

#include "rx.h"
#if NRX > 0 | Nrx > 0
	.align	1
	.globl	_rxerr
_rxerr:	.space	Nrx*6*2		/* 6 shorts per device */
#endif

/************************************************************************/
	.text
	.globl	_segptes
/*	segptes(pte, maxlen) */
_segptes:
	link	a6,#_Fsegptes
	movml	#_Ssegptes,a6@(_Fsegptes)
	movq	#0,d5
	movl	d5,d4
	movw	a6@(12+2),d7
	jle	3f
	movw	#((PG_PROT>>16)&0xFFFF),d3
	movw	#((PG_V>>16)&0xFFFF),d2
	movl	a6@(8),a0
	movw	a0@,d6
	andw	d3,d6
	jra	2f
1:	movw	a0@,d0
	movw	d0,d1
	andw	d3,d0
	cmpw	d0,d6
	jne	3f
	andw	d2,d1
	orw	d1,d4
	addqw	#1,d5
	addql	#4,a0
2:	dbra	d7,1b
3:	movl	d5,d0
	tstw	d4
	jne	1f
	negl	d0
1:	movml	a6@(_Fsegptes),#_Ssegptes
	unlk	a6
	rts
_Fsegptes = -(6 * 4)
_Ssegptes = 0x00fC		/* d7,d6,d5,d4,d3,d2 */

#ifndef	C_newptes
is68k_prot:		/* this is a read-only array */
	.byte	0, 0, 0x80, 0x40, 0x80, 0, 0, 0
	.byte	0, 0, 0, 0, 0, 0, 0, 0x40

	.globl	_newptes
/*	newptes(pte, v, size) */
_newptes:
	link	a6,#_Fnewptes
	movml	#_Snewptes,a6@(_Fnewptes)
	movw	a6@(16+2),d7		/* d7   size: if (size <= 0) return; */
	jle	7f
	movl	a6@(8),a5		/* a5   pointer to pte */
	lea	is68k_prot,a3		/* a3   pointer to protection vector */
	movl	#0x10000,d3		/* d3   seg reg incr */
	movq	#0,d4
	movb	CXR,d4
	lsrw	#4,d4			/* d4   context # */
	cmpl	#_eSysmap,a5
	jhs	1f
	cmpl	#_Sysmap,a5
	jlo	1f
	movq	#0,d4
    1:	movq	#0,d0			/*      get virtual page address */
	movw	a6@(12+2),d0
	movl	d0,d5
	andw	#15,d5
	movl	d4,d1
	rorl	#4,d1
	movw	d0,d1
	lsrw	#4,d1
	orw	#0x40,d1
	swap	d1
	movl	d1,a4			/* a4   pointer to seg */
	movq	#16,d0
	subw	d5,d0
	rorl	#4,d5			/* d5   page offset in upper half */
    9:	tstw	d7			/*      DONE if size <= 0 */
	jle	7f
	cmpw	d7,d0			/*      i = min(i,size) */
	jle	1f
	movw	d7,d0
    1:	movq	#0,d2
	movb	a5@,d2			/* d2   get pte protection */
	lsrw	#3,d2
	andw	#15,d2
	movl	d0,sp@-
	pea	a5@
	jbsr	_segptes
	addql	#8,sp
	movw	d0,d6			/* d6   pages in bank to program (i) */
	jeq	7f
	jlt	8f
	movw	a4@,d0			/*      contents of seg register */
	movw	d0,d1
	andw	#0xC0,d1
	jne	6f
	movl	d4,sp@-			/*      00 -> SEGPROT_NO access */
	jbsr	_segalloc
	addql	#4,sp
	movw	d0,a4@
    6:	andw	#0x3F,d0
	movw	d0,d5			/*      get bank number */
	orb	a3@(0,d2:w),d0
	movw	d0,a4@			/*      update segment protection */
	orw	#0x80,d5
	swap	d5
	movl	d5,a0			/* a0   is pointer to page register */
	jra	4f
    1:	movl	a5@,d0
	jge	2f			/*      is page valid bit set ? */
	andw	#PG_PFNUM,d0
	lslw	#2,d0
	movw	d0,a0@			/*      valid page register */
	jra	3f
    2:	movw	#0xff0,a0@		/*      paged out */
    3:	subqw	#1,d7
	addl	#0x1000,a0
	addql	#4,a5			/*      on to next pte */
    4:	dbra	d6,1b
    1: 	addl	d3,a4			/*      increment segment reg pointer */
    	movq	#16,d0			/*      next segment */
    	movq	#0,d5
	movl	a4,d1			/*	!(seg & 0x10000) */
	andl	d3,d1
	jeq	9b
    	movq	#0,d1			/*	pte->pg_prot != prot */
	movb	a5@,d1
	lsrw	#3,d1
	andw	#15,d1
	cmpw	d2,d1
	jeq	9b
	movl	_u+U_PROCP,a0
	tstb	a0@(P_NEWIMAGE)
	jeq	9b			/*      !u.u_procp->p_newimage */
	addl	d3,a4
	jra	9b
    8:	negw	d6
	movw	a4@,d0			/*      contents of seg register */
	movw	d0,d1
	andw	#0xC0,d1
	jne	6b			/*	jump if seg allocated */
    	movw	#1,a4@
	subw	d6,d7			/*      size -= i */
	aslw	#2,d6
	addw	d6,a5			/*      pte += i */
	jra	1b
    7:	movml	a6@(_Fnewptes),#_Snewptes
	unlk	a6
	rts
_Fnewptes = -(9 * 4)
_Snewptes = 0x38fC			 /*      d7,d6,d5,d4,d3,d2   a5,a4,a3 */
#endif	C_newptes

	.globl _un_mod
_un_mod:
	movl	sp@(4),a0
	movl	a0@,d0
	bclr	#PG_M_BIT,d0
	movl	d0,a0@
	rts

	.globl _un_ref
_un_ref:
	movl	sp@(4),a0
	movl	a0@,d0
	bclr	#PG_R_BIT,d0
	movl	d0,a0@
	rts

	.globl _reload_pt
_reload_pt:
	movq	#0,d0
	movw	_u+PCB_P0LR+2,d0
	movl	d0,sp@-			/* num of ptes */
	clrl	sp@-			/* virtual page */
	movl	_u+PCB_P0BR,sp@-	/* pte */
	jsr	_newptes
	addql	#8,sp

	movq	#0,d0
	movw	_u+PCB_P1LR+2,d0
	movl	#0x400,d1
	subw	d0,d1
	movl	d1,sp@			/* num of pages */
	movl	d0,sp@-			/* virtual page */
	movl	_u+PCB_P1BR,d1
	lslw	#2,d0
	addl	d0,d1
	movl	d1,sp@-			/* pte */
	jsr	_newptes
	lea	sp@(12),sp
	rts

	/* system virtual to physical address translation through hardware */
	.globl	_svtop
_svtop:	movl	sp@(4),d0	/* virtual address */
	movl	d0,d1
	movl	d0,a1
	andl	#0x3f0000,d0	/* form segment register address */
	orl	#0x400001,d0
	movl	d0,a0
	movb	a0@,d0		/* pick up contents of segment register */
	andl	#0x3F,d0	/* form page register address */
	swap	d0
	andl	#0xf000,d1
	orl	d1,d0
	orl	#0x800000,d0
	movl	d0,a0
	movw	a0@,d0		/* pick up contents of page register */
	andl	#0xffc,d0	/* align physical page */
	movq	#10,d1
	asll	d1,d0
	movl	a1,d1
	andl	#0xfff,d1	/* or in page offset */
	orl	d1,d0		/* return physical address */
	rts

	/* user virtual to physical address translation through hardware */
	.globl	_uvtop
_uvtop:
	movl	sp@(4),d0	/* virtual address */
	movl	d0,d1
	movl	d0,a1
	andl	#0x3f0000,d0	/* form segment register address */
	orl	#0x401001,d0	/* context #1 hardcoded! */
	movl	d0,a0
	movb	a0@,d0		/* pick up contents of segment register */
	andl	#0x3F,d0	/* form page register address */
	swap	d0
	andl	#0xf000,d1
	orl	d1,d0
	orl	#0x800000,d0
	movl	d0,a0
	movw	a0@,d0		/* pick up contents of page register */
	andl	#0xffc,d0	/* align physical page */
	movq	#10,d1
	asll	d1,d0
	movl	a1,d1
	andl	#0xfff,d1	/* or in page offset */
	orl	d1,d0		/* return physical address */
	rts

	.data

	.globl	_VSCR0
	.globl	_VSCR1
	.globl	_VSCR2
	.globl	_VSCR3

	.set	_VSCR0,	CADDRa
	.set	_VSCR1,	CADDRb
	.set	_VSCR2,	CADDRc
	.set	_VSCR3,	CADDRd

	.globl	_SCR0
	.globl	_SCR1
	.globl	_SCR2
	.globl	_SCR3

	.set	_SCR0,	PGREG(_VSCR0)
	.set	_SCR1,	PGREG(_VSCR1)
	.set	_SCR2,	PGREG(_VSCR2)
	.set	_SCR3,	PGREG(_VSCR3)

	.text
