/*	in_cksum.c	6.1	83/07/29	*/

#include "../h/types.h"
#include "../h/mbuf.h"
#include "../netinet/in.h"
#include "../netinet/in_systm.h"

/*
 * Checksum routine for Internet Protocol family headers (IS68K Version).
 *
 * This routine is very heavily used in the network code and should be modified
 * for each CPU to be as fast as possible.
 */

in_cksum(m, len)
	register struct mbuf *m;
	register int len;
{
	register u_short sum = 0;
	register int mlen = 0;
	register int slen = 0;

	while (m && slen < len) {
		mlen = m->m_len;
		if (mlen > (len-slen))
			mlen = len-slen;
		sum = cksum(sum, mtod(m, u_short *), mlen, slen);
		slen += mlen;
		m = m->m_next;
	}
	if (slen != len)
		printf("cksum: out of data\n");
	return (~sum);
}
