#include "../h/param.h"
#include "../h/buf.h"
#include "../h/vmmeter.h"
#include "../h/vmparam.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/cmap.h"
#include "../h/map.h"
#include "../h/proc.h"
#include "../h/text.h"
#include "../h/mbuf.h"
#include "../h/msgbuf.h"

#include "../machine/pte.h"
#include "../machine/scb.h"
#include "../machine/trap.h"

main()
{
	register struct proc *p = (struct proc *)0;
	register struct vmmeter *vm = (struct vmmeter *)0;
	register struct user *up = (struct user *)0;
	register struct rusage *rup = (struct rusage *)0;
	struct text *tp = (struct text *)0;
	struct pcb *pcbp = (struct pcb *)0;
	struct scb *scbp = (struct scb *)0;
	union esf *esfp = (union esf *)0;

	printf("#ifdef LOCORE\n");
	printf("#define\tP_LINK %d\n", &p->p_link);
	printf("#define\tP_RLINK %d\n", &p->p_rlink);
	printf("#define\tP_XLINK %d\n", &p->p_xlink);
	printf("#define\tP_ADDR %d\n", &p->p_addr);
	printf("#define\tP_PRI %d\n", &p->p_pri);
	printf("#define\tP_CONTEXT %d\n", &p->p_context);
	printf("#define\tP_STAT %d\n", &p->p_stat);
	printf("#define\tP_WCHAN %d\n", &p->p_wchan);
	printf("#define\tP_TSIZE %d\n", &p->p_tsize);
	printf("#define\tP_SSIZE %d\n", &p->p_ssize);
	printf("#define\tP_P0BR %d\n", &p->p_p0br);
	printf("#define\tP_SZPT %d\n", &p->p_szpt);
	printf("#define\tP_TEXTP %d\n", &p->p_textp);
	printf("#define\tP_FLAG %d\n", &p->p_flag);
	printf("#define\tP_PID %d\n", &p->p_pid);
	printf("#define\tP_PPID %d\n", &p->p_ppid);
#ifdef	QBUS
	printf("#define\tP_NEWIMAGE %d\n", &p->p_newimage);
#endif	QBUS
	printf("#define\tSSLEEP %d\n", SSLEEP);
	printf("#define\tSRUN %d\n", SRUN);
	printf("#define\tSULOCK %d\n", SULOCK);
	printf("#define\tX_CADDR %d\n", &tp->x_caddr);
	printf("#define\tV_SWTCH %d\n", &vm->v_swtch);
	printf("#define\tV_TRAP %d\n", &vm->v_trap);
	printf("#define\tV_SYSCALL %d\n", &vm->v_syscall);
	printf("#define\tV_INTR %d\n", &vm->v_intr);
	printf("#define\tV_PDMA %d\n", &vm->v_pdma);
	printf("#define\tV_FAULTS %d\n", &vm->v_faults);
	printf("#define\tV_PGREC %d\n", &vm->v_pgrec);
	printf("#define\tV_FASTPGREC %d\n", &vm->v_fastpgrec);
	printf("#define\tSYSPTSIZE %d\n", SYSPTSIZE);
	printf("#define\tUSRPTSIZE %d\n", USRPTSIZE);
	printf("#define\tMSGBUFPTECNT %d\n", btoc(sizeof (struct msgbuf)));
	printf("#define\tNMBCLUSTERS %d\n", NMBCLUSTERS);
	printf("#define\tU_ARG %d\n", &up->u_arg[0]);
	printf("#define\tU_PROCP %d\n", &up->u_procp);
	printf("#define\tU_CMASK %d\n", &up->u_cmask);
	printf("#define\tU_OFILE %d\n", &up->u_ofile[0]);
	printf("#define\tU_RU %d\n", &up->u_ru);
	printf("#define\tU_COMM %d\n", &up->u_comm[0]);
	printf("#define\tU_SKY %d\n", &up->u_sky);
	printf("#define\tU_RCLIENT %d\n", &up->u_Rclient);
	printf("#define\tU_68881_STATE %d\n", &up->u_68881_state[0]);
	printf("#define\tU_68881_REGS %d\n", &up->u_68881_regs[0]);
	printf("#define\tU_STACK %d\n", &up->u_stack[0]);
	printf("#define\tRU_MINFLT %d\n", &rup->ru_minflt);
	printf("#define\tPCB_SP %d\n", &pcbp->pcb_sp);
	printf("#define\tPCB_PC %d\n", &pcbp->pcb_pc);
	printf("#define\tPCB_PSL %d\n", &pcbp->pcb_psl);
	printf("#define\tPCB_P0BR %d\n", &pcbp->pcb_p0br);
	printf("#define\tPCB_P0LR %d\n", &pcbp->pcb_p0lr);
	printf("#define\tPCB_P1BR %d\n", &pcbp->pcb_p1br);
	printf("#define\tPCB_P1LR %d\n", &pcbp->pcb_p1lr);
	printf("#define\tPCB_SZPT %d\n", &pcbp->pcb_szpt);
	printf("#define\tPCB_SSWAP %d\n", &pcbp->pcb_sswap);
	printf("#define\tSCB_BUSERR %d\n", &scbp->scb_vec.scb_ivec.scb_buserr);
	printf("#define\tSCB_ADRERR %d\n", &scbp->scb_vec.scb_ivec.scb_adrerr);
	printf("#define\tSCB_ILLINS %d\n", &scbp->scb_vec.scb_ivec.scb_illins);
	printf("#define\tSCB_EM1111 %d\n", &scbp->scb_vec.scb_ivec.scb_l1111em);
	printf("#define\tSCB_COPROC %d\n", &scbp->scb_vec.scb_ivec.scb_coproc);
	printf("#define\tESF_SW %d\n", &esfp->f0.esf_sw);
	printf("#define\tESF_PC %d\n", &esfp->f0.esf_pc);
	printf("#define\tESF_VEC %d\n", &esfp->f0.esf_vec);
#ifdef	M68020
	printf("#define\tESF_SSW %d\n", &esfp->fa.esf_ssw);
	printf("#define\tESF_FADDR %d\n", &esfp->fa.esf_faddr);
#else	M68020
	printf("#define\tESF_SSW %d\n", &esfp->f8.esf_ssw);
	printf("#define\tESF_FADDR %d\n", &esfp->f8.esf_faddr);
#endif	M68020
	printf("#else\n");
	printf("asm(\".set\tU_ARG,%d\");\n", up->u_arg);
/*	printf("asm(\".set\tU_QSAVE,%d\");\n", up->u_qsave); /* */
	printf("#endif\n");
	return 0;
}
