/*	conf.c	6.1	83/07/29	*/

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/buf.h"
#include "../h/tty.h"
#include "../h/conf.h"

int	nulldev();
int	nodev();

#ifdef QBUS

#include "el.h"
#if NEL > 0 || Nel > 0
int	elopen(),elstrategy(),elread(),elwrite();
int	elreset(),eldump(),elsize();
#else
#define	elopen		nodev
#define	elstrategy	nodev
#define	elread		nodev
#define	elwrite		nodev
#define	elreset		nulldev
#define	eldump		nodev
#define	elsize		0
#endif

#include "hp.h"
#if NHP > 0 || Nhp > 0
int	hpopen(),hpstrategy(),hpread(),hpwrite(),hpdump(),hpioctl(),hpsize();
#else
#define	hpopen		nodev
#define	hpstrategy	nodev
#define	hpread		nodev
#define	hpwrite		nodev
#define	hpdump		nodev
#define	hpioctl		nodev
#define	hpsize		0
#endif
 
#else	QBUS

#include "sd.h"
#if NSD > 0 || Nsd > 0
int	sdopen(),sdstrategy(),sdread(),sdwrite();
int	sdreset(),sddump(),sdsize();
#else
#define	sdopen		nodev
#define	sdstrategy	nodev
#define	sdread		nodev
#define	sdwrite		nodev
#define	sdreset		nulldev
#define	sddump		nodev
#define	sdsize		0
#endif

#include "sm.h"
#if NSM > 0 || Nsm > 0
int	smopen(),smstrategy(),smread(),smwrite();
int	smreset(),smdump(),smsize();
#else
#define	smopen		nodev
#define	smstrategy	nodev
#define	smread		nodev
#define	smwrite		nodev
#define	smreset		nulldev
#define	smdump		nodev
#define	smsize		0
#endif

#endif	QBUS

#include "rk.h"
#if NRK > 0 || Nrk > 0
int	rkopen(),rkstrategy(),rkread(),rkwrite(),rkintr();
int	rkdump(),rkreset(),rksize();
#else
#define	rkopen		nodev
#define	rkstrategy	nodev
#define	rkread		nodev
#define	rkwrite		nodev
#define	rkintr		nodev
#define	rkdump		nodev
#define	rkreset		nodev
#define	rksize		0
#endif

#include "ra.h"
#if NRA > 0 || Nra > 0
int	raopen(),rastrategy(),raread(),rawrite(),rareset(),radump(),rasiz();
#else
#define	raopen		nodev
#define	rastrategy	nodev
#define	raread		nodev
#define	rawrite		nodev
#define	rareset		nulldev
#define	radump		nodev
#define	rasiz		0
#endif

#include "rl.h"
#if NRL > 0 || Nrl > 0
int	rlopen(),rlstrategy(),rlread(),rlwrite();
int	rlreset(),rldump(),rlsize();
#else
#define	rlopen		nodev
#define	rlstrategy	nodev
#define	rlread		nodev
#define	rlwrite		nodev
#define	rlreset		nulldev
#define	rldump		nodev
#define	rlsize		0
#endif

#include "rd.h"
#if NRD > 0 || Nrd > 0
int	rdopen(),rdstrategy(),rdread(),rdwrite();
int	rdreset(),rddump(),rdsize();
#else
#define	rdopen		nodev
#define	rdstrategy	nodev
#define	rdread		nodev
#define	rdwrite		nodev
#define	rdreset		nulldev
#define	rddump		nodev
#define	rdsize		0
#endif

#include "rx.h"
#if NRX > 0 || Nrx > 0
int	rxopen(),rxstrategy(),rxclose(),rxread(),rxwrite(),rxreset(),rxioctl();
#else
#define	rxopen		nodev
#define rxstrategy	nodev
#define	rxclose		nodev
#define	rxread		nodev
#define	rxwrite		nodev
#define	rxreset		nulldev
#define	rxioctl		nodev
#endif

#include "tm.h"
#if NTM > 0 || Ntm > 0
int	tmopen(),tmclose(),tmstrategy(),tmread(),tmwrite();
int	tmioctl(),tmdump(),tmreset();
#else
#define	tmopen		nodev
#define	tmclose		nodev
#define	tmstrategy	nodev
#define	tmread		nodev
#define	tmwrite		nodev
#define	tmioctl		nodev
#define	tmdump		nodev
#define	tmreset		nodev
#endif

#include "ts.h"
#if NTS > 0 || Nts > 0
int	tsopen(),tsclose(),tsstrategy(),tsread(),tswrite();
int	tsioctl(),tsdump(),tsreset();
#else
#define	tsopen		nodev
#define	tsclose		nodev
#define	tsstrategy	nodev
#define	tsread		nodev
#define	tswrite		nodev
#define	tsioctl		nodev
#define	tsdump		nodev
#define	tsreset		nodev
#endif

#define	SWAPMAJ		0			/* major of swap */
int	swstrategy(), swread(), swwrite();

struct bdevsw	bdevsw[] =
{
	{ nodev,	nodev,		swstrategy,	nodev,		/*0*/
	  0,		0 },
#ifdef	QBUS
	{ elopen,	nodev,		elstrategy,	eldump,		/*1*/
	  elsize,	0 },
	{ hpopen,	nulldev,	hpstrategy,	hpdump,		/*2*/
	  hpsize,	0 },
#else	QBUS
	{ sdopen,	nodev,		sdstrategy,	sddump,		/*1*/
	  sdsize,	0 },
	{ smopen,	nodev,		smstrategy,	smdump,		/*2*/
	  smsize,	0 },
#endif	QBUS
	{ rkopen,	nulldev,	rkstrategy,	rkdump,		/*3*/
	  rksize,	0 },
	{ raopen,	nulldev,	rastrategy,	nodev,		/*4*/
	  rasiz,	0 },
	{ rlopen,	nodev,		rlstrategy,	rldump,		/*5*/
	  rlsize,	0 },
	{ rdopen,	nulldev,	rdstrategy,	rddump,		/*6*/
	  rdsize,	0 },
	{ rxopen,	rxclose,	rxstrategy,	nodev,		/*7*/
	  0,		B_18BIT },
	{ tmopen,	tmclose,	tmstrategy,	tmdump,		/*8*/
	  0,		B_18BIT|B_TAPE },
	{ tsopen,	tsclose,	tsstrategy,	tsdump,		/*9*/
	  0,		B_TAPE },
};
int	nblkdev = sizeof (bdevsw) / sizeof (bdevsw[0]);

int	sioopen(),sioclose(),sioread(),siowrite(),sioioctl(),siostop();
struct tty sio_tty[];

#ifdef	QBUS

#include "dh.h"
#if NDH > 0 || Ndh > 0
int	dhopen(),dhclose(),dhread(),dhwrite(),dhioctl(),dhstop(),dhreset();
struct	tty dh_tty[];
#else
#define	dhopen	nodev
#define	dhclose	nodev
#define	dhread	nodev
#define	dhwrite	nodev
#define	dhioctl	nodev
#define	dhstop	nodev
#define	dhreset	nulldev
#define	dh_tty	0
#endif

#else	QBUS

#include "cp.h"
#if NCP > 0 || Ncp > 0
int	cpopen(),cpclose(),cpread(),cpwrite(),cpioctl(),cpstop(),cpreset();
struct	tty cp_tty[];
#else
#define	cpopen	nodev
#define	cpclose	nodev
#define	cpread	nodev
#define	cpwrite	nodev
#define	cpioctl	nodev
#define	cpstop	nodev
#define	cpreset	nulldev
#define	cp_tty	0
#endif

#endif	QBUS

#include "dz.h"
#if NDZ > 0 || Ndz > 0
int	dzopen(),dzclose(),dzread(),dzwrite(),dzioctl(),dzstop(),dzreset();
struct	tty dz_tty[];
#else
#define	dzopen	nodev
#define	dzclose	nodev
#define	dzread	nodev
#define	dzwrite	nodev
#define	dzioctl	nodev
#define	dzstop	nodev
#define	dzreset	nulldev
#define	dz_tty	0
#endif

#include "lp.h"
#if NLP > 0 || Nlp > 0
int	lpopen(),lpclose(),lpwrite(),lpreset();
#else
#define	lpopen		nodev
#define	lpclose		nodev
#define	lpwrite		nodev
#define	lpreset		nulldev
#endif

#include "dl.h"
#if NDL > 0 || Ndl > 0
int	dlopen(),dlclose(),dlread(),dlwrite(),dlioctl(),dlstop(),dlreset();
struct	tty dl_tty[];
#else
#define	dlopen	nodev
#define	dlclose	nodev
#define	dlread	nodev
#define	dlwrite	nodev
#define	dlioctl	nodev
#define	dlstop	nodev
#define	dlreset	nulldev
#define	dl_tty	0
#endif

#include "ib.h"
#if NIB > 0 || Nib > 0
int	ibopen(),ibclose(),ibread(),ibwrite(),ibioctl();
#else
#define	ibopen	nodev
#define	ibclose	nodev
#define	ibread	nodev
#define	ibwrite	nodev
#define	ibioctl	nodev
#endif

int	syopen(), syread(), sywrite(), syioctl(), syselect();

int 	mmread(), mmwrite(), mmmap();

#include "pty.h"
#if NPTY > 0 || Npty > 0
int	ptsopen(),ptsclose(),ptsread(),ptswrite(),ptsstop();
int	ptcopen(),ptcclose(),ptcread(),ptcwrite(),ptcselect();
int	ptyioctl();
struct	tty pt_tty[];
#else
#define ptsopen		nodev
#define ptsclose	nodev
#define ptsread		nodev
#define ptswrite	nodev
#define ptcopen		nodev
#define ptcclose	nodev
#define ptcread		nodev
#define ptcwrite	nodev
#define ptyioctl	nodev
#define	pt_tty		0
#define	ptcselect	nodev
#define	ptsstop		nulldev
#endif

#include "enetfilter.h"
#if NENETFILTER > 0 || Nenetfilter > 0
int	enetopen(),enetclose(),enetread(),enetwrite(),enetioctl(),enetselect();
#else
#define enetopen	nodev
#define enetclose	nodev
#define enetread	nodev
#define enetwrite	nodev
#define enetioctl	nodev
#define	enetselect	nulldev
#endif

#ifdef	GWS
#include "gp.h"
#if NGP > 0 || Ngp > 0
int	vtopen(),vtclose(),vtread(),vtwrite(),vtioctl();
struct	tty vt_tty[];
int	fntopen(),fntclose(),fntread(),fntwrite(),fntioctl();
#else
#define vtopen		nodev
#define vtclose		nodev
#define vtread		nodev
#define vtwrite		nodev
#define vtioctl		nodev
#define vt_tty		0
#define fntopen		nodev
#define	fntclose	nodev
#define	fntread		nodev
#define	fntwrite	nodev
#define	fntioctl	nodev
#endif
#else	GWS
#include "rp.h"
#if NRP > 0 || Nrp > 0
int	rpopen(),rpclose(),rpread(),rpwrite(),rpioctl();
#else
#define rpopen		nodev
#define rpclose		nodev
#define rpread		nodev
#define rpwrite		nodev
#define rpioctl		nodev
#endif
#endif	GWS

#include "enp.h"
#if NENP > 0
int	enpioctl(), enpreconfig();
int	enpr_read(), enpr_write(), enpr_ioctl();
#else
#define enpioctl	nodev
#define enpreconfig	nodev
#define enpr_read	nodev
#define enpr_write	nodev
#define enpr_ioctl	nodev
#endif

int	ttselect(), seltrue();

struct cdevsw	cdevsw[] =
{
    {	nulldev,	nulldev,	swread,		swwrite,	/*0*/
	nodev,		nodev,		nulldev,	0,
	nodev,		nodev					},
#ifdef	QBUS
    {	elopen,		nodev,		elread,		elwrite,	/*1*/
	nodev,		nodev,		elreset,	0,
	seltrue,	nodev					},
    {	hpopen,		nulldev,	hpread,		hpwrite,	/*2*/
	hpioctl,	nodev,		nulldev,	0,
	seltrue,	nodev					},
#else	QBUS
    {	sdopen,		nodev,		sdread,		sdwrite,	/*1*/
	nodev,		nodev,		sdreset,	0,
	seltrue,	nodev					},
    {	smopen,		nodev,		smread,		smwrite,	/*2*/
	nodev,		nodev,		smreset,	0,
	seltrue,	nodev					},
#endif	QBUS
    {	rkopen,		nulldev,	rkread,		rkwrite,	/*3*/
	nodev,		nodev,		rkreset,	0,
	seltrue,	nodev					},
    {	raopen,		nulldev,	raread,		rawrite,	/*4*/
	nodev,		nodev,		rareset,	0,
	seltrue,	nodev					},
    {	rlopen,		nodev,		rlread,		rlwrite,	/*5*/
	nodev,		nodev,		rlreset,	0,
	seltrue,	nodev					},
    {	rdopen,		nulldev,	rdread,		rdwrite,	/*6*/
	nodev,		nodev,		rdreset,	0,
	seltrue,	nodev					},
    {	rxopen,		rxclose,	rxread,		rxwrite,	/*7*/
	rxioctl,	nodev,		rxreset,	0,
	seltrue,	nodev					},
    {	tmopen,		tmclose,	tmread,		tmwrite,	/*8*/
	tmioctl,	nodev,		tmreset,	0,
	seltrue,	nodev					},
    {	tsopen,		tsclose,	tsread,		tswrite,	/*9*/
	tsioctl,	nodev,		tsreset,	0,
	seltrue,	nodev					},
/*
Would be nice to leave hole here for future block device expansion.
    {	nodev,		nodev,		nodev,		nodev,		
	nodev,		nodev,		nulldev,	0,
	nodev,		nodev					},
*/
    {	sioopen,	sioclose,	sioread,	siowrite,	/*10*/
	sioioctl,	siostop,	nulldev,	sio_tty,
	ttselect,	nodev					},
    {	syopen,		nulldev,	syread,		sywrite,	/*11*/
	syioctl,	nulldev,	nulldev,	0,
	syselect,	nodev					},
    {	nulldev,	nulldev,	mmread,		mmwrite,	/*12*/
	nodev,		nulldev,	nulldev,	0,
	seltrue,	mmmap					},
    {	dzopen,		dzclose,	dzread,		dzwrite,	/*13*/
	dzioctl,	dzstop,		dzreset,	dz_tty,
	ttselect,	nodev					},
#ifdef	QBUS
    {	dhopen,		dhclose,	dhread,		dhwrite,	/*14*/
	dhioctl,	dhstop,		dhreset,	dh_tty,
	ttselect,	nodev					},
#else	QBUS
    {	cpopen,		cpclose,	cpread,		cpwrite,	/*14*/
	cpioctl,	cpstop,		cpreset,	cp_tty,
	ttselect,	nodev					},
#endif	QBUS
    {	lpopen,		lpclose,	nodev,		lpwrite,	/*15*/
	nodev,		nodev,		lpreset,	0,
	seltrue,	nodev					},
    {	ptsopen,	ptsclose,	ptsread,	ptswrite,	/*16*/
	ptyioctl,	ptsstop,	nodev,		pt_tty,
	ttselect,	nodev					},
    {	ptcopen,	ptcclose,	ptcread,	ptcwrite,	/*17*/
	ptyioctl,	nulldev,	nodev,		pt_tty,
	ptcselect,	nodev					},
    {	dlopen,		dlclose,	dlread,		dlwrite,	/*18*/
	dlioctl,	dlstop,		nulldev,	dl_tty,
	ttselect,	nodev					},
    {	ibopen,		ibclose,	ibread,		ibwrite,	/*19*/
	ibioctl,	nodev,		nulldev,	0,
	seltrue,	nodev					},
    {	enetopen,	enetclose,	enetread,	enetwrite,	/*20*/
	enetioctl,	nodev,		nulldev,	0,
	enetselect,	nodev					},
#ifndef	GWS
    {	rpopen,		rpclose,	rpread,		rpwrite,	/*21*/
	rpioctl,	nodev,		nulldev,	0,
	seltrue,	nodev					},
    {	nodev,		nodev,		nodev,		nodev,		/*22*/
	nodev,		nodev,		nulldev,	0,
	nodev,		nodev					},
#else	GWS
    {	vtopen,		vtclose,	vtread,		vtwrite,	/*21*/
	vtioctl,	nulldev,	nulldev,	vt_tty,
	ttselect,	nodev					},
    {	fntopen,	fntclose,	fntread,	fntwrite,	/*22*/
	fntioctl,	nulldev,	nulldev,	0,
	nodev,		nodev					},
#endif	GWS
    {	nulldev,	nulldev,	nodev,		nodev,		/*23*/
	enpioctl,	nodev,		nulldev,	0,
	nodev,		nodev					},
    {	nulldev,	nulldev,	enpr_read,	enpr_write,	/*24*/
	enpr_ioctl,	nodev,		nulldev,	0,
	nodev,		nodev					},
};
int	nchrdev = sizeof (cdevsw) / sizeof (cdevsw[0]);

int	mem_no = 13; 	/* major device number of memory special file */
#ifdef	BARF
int	ipcmaj = 6;
#endif	BARF

/*
 * Swapdev is a fake device implemented in sw.c used only internally to get to 
 * swstrategy. It cannot be provided to the users, because the swstrategy 
 * routine munches the b_dev and b_blkno entries before calling the appropriate
 * driver.  This would horribly confuse, e.g. the hashing routines. Instead, 
 * /dev/drum is provided as a character (raw) device.
 */
dev_t	swapdev = makedev(SWAPMAJ, 0);
