/*
 * IS-68K20 VME CPU board constants
 */

#define	MEMR_MASK	0xF0000000	/* memory region mask */
#define	NONT_BASE	0x00000000	/* non translated address */
#define	MAXU_ADDR	0x10000000	/* size of user virtual space */
#define	SYSV_BASE	0x10000000	/* system virtual base */
#define	USRV_BASE	0x20000000	/* user virtual base */
#define	NONT_MASK	0x0FFFFFFF	/* non-translated address space mask */

/* TRANSLATION BUFFER CONSTANTS */
#define TBUF_BASE_SYS	0x30000000
#define TBUF_BASE_USR	0x40000000
#define TBUF_INCR	0x00001000
#define	TBUF_INDEX_MASK	0x001FF000
#define TBUF_MASK	0xFFF0FFFF
#define	TBUF_MATCH_MASK	0x07F00000
#define TBUF_VALID	0x08000000
#define TBUF_INVALID	0x00000000
#define NTBUFS		512		/* for each mode */
#define	TBUF_BITS	"\20\40PG_V\37PG_RO\36PG_M\35PG_R"

/* ONBOARD IO SPACE REGISTERS */
#ifdef	LOCORE
#define	CTX		0x50000000	/* context register, write only */
#define	PROM		0x54000000	/* prom */
#define	IIV		0x5C000000	/* interproces int vec, write only */
#else	LOCORE
#define	CTX		((unsigned char *)0x50000000)
#define	PROM		((unsigned char *)0x54000000)
#define	IIV		((unsigned char *)0x5C000000)
unsigned char ctx, ctx_mask;		/* software copy of hardware register */
#endif	LOCORE

#define	PROM_BASE	PROM
#define PROM_REBOOT	PROM+8
#define	BSR		CTX		/* board status jumper reg, read only */
#define	ESR		IIV		/* error source reg, read only */

#define	CTX_PARITY	0x08		/* 1 => enable parity */
#define	CTX_CLOCK	0x10		/* 1 => enable 60Hz clock */
#define	CTX_LEV2	0x20
#define	CTX_LEV1	0x40
#define	CTX_LED		0x80		/* 1 => turn OFF led */
#define	CTX_MASK	0x07
#define NCTX		8		/* Number of Contexts */
#define CTX_SYS		0	
#define CTX_INVALID	7		/* unallocated context */

#define	ESR_PTP_OK	0x01		/* if 0 && PROT_OK==0 then PTP_ABORT */
#define	ESR_PTP_OK_BIT	0
#define	ESR_HSBER	0x02		/* if 0 the bus error on vme bus */
#define	ESR_HSBER_BIT	1
#define	ESR_ADDR_OK	0x04		/* if 0 the illegal address */
#define	ESR_ADDR_OK_BIT	2
#define	ESR_PROT_OK	0x08		/* if 0 && PTP_OK==1 then PROTECT VIO */
#define	ESR_PROT_OK_BIT	3
#define	ESR_PG_V	0x40		/* if 0 then page not valid */
#define	ESR_PG_V_BIT	6
#define	ESR_AC_OK	0x10		/* if 0 then ac power ok */
#define	ESR_PARITY_OK	0x20		/* if 0 then parity error */
#define	ESR_NMIMASK	0x30
#define	ESR_BERMASK	0x4F
#define	ESR_NMIBITS	"\20\6PARITY_OK\5POWER_OK"
#define	ESR_BERBITS	"\20\4ADDR_OK\3PROT_OK\2HSBERR\1PTP_OK"

#define	BSR_E24		0x80		/* jumpered reads as zero */
#define	BSR_E25		0x40		/* jumpered reads as zero */
#define	BSR_BAUD	(BSR_E24|BSR_E25)/* E24 and E25 determine baud rate */
#define BSR_BAUD_9600	(BSR_E24|BSR_E25)/* no jumpers at E24 or E25 */
#define BSR_BAUD_19200	(BSR_E24)	/* E25 jumpered */
#define BSR_BAUD_1200	(BSR_E25)	/* E24 jumpered */
#define BSR_BAUD_300	(0) 		/* E24 and E25 jumpered */
#define	BSR_CNODE	0x0F		/* cluster node number */

/* PAGE TABLE POINTER CONSTANTS */
#define PTP_BASE	0x60000000
#define PTP_INCR	0x00200000
#define PTP_MASK	0x001007FF
#define	PTP_LSB		0x00100000
#define PTP_ADRMASK	0x0FFFF800
#define	PTP_ADRSHIFT	11
#define PTP_LSBMASK	0x00000800
#define PTP_LSBSHIFT	9
#define PTP_INVALID	0x00000780
#define	PTP_PGMAX	0x700		/* highest page PTP can point to */
#define	PTP_PG		PTP_PGMAX	/* CORRECT DEFINITION */
/*#define	PTP_PG		0x180		/* DEBUG DEFINITION*/
#define NPTPS		128		/* for each context */

/* 68020 ON CHIP CACHE */
#define	CCACHE_CLEAR	0x08
#define	CCACHE_CE	0x04
#define	CCACHE_FREEZE	0x02
#define	CCACHE_ENABLE	0x01
