/*
 * IS68010 Qbus CPU card constants:
 */

#define	MEMR_MASK	0xFFC00000	/* memory region mask */
#define	MAXU_ADDR	0x00400000	/* size of user virtual space */
#define	SYSV_BASE	0x00000000	/* system virtual base */
#define	NONT_MASK	0x003FFFFF	/* non-translated address space mask */

/* CONTEXT/EXCEPTION REGISTER (CXR) */

#ifdef LOCORE
#define	CXW	0xC10000		/* must be written with a word access */
#define	CXR	0xC10001		/* must be read with a byte access */
#else  LOCORE
#define	CXW	((u_short *)0xC10000)	/* must be written with a word access */
#define	CXR	((u_char *)0xC10001)	/* must be read with a byte access */
#endif LOCORE

#define	CX_PARITYENABLE	0x01
#define	CX_INVALIDPAGE	0x02
#define	CX_PROTECTION	0x04
#define	CX_BUSTIMEOUT	0x08
#define	CX_CONTEXT	0xF0

/* BOARD STATUS REGISTER (BSR) */

#ifdef LOCORE
#define	BSR	0xC30000		/* board status register */
#else  LOCORE
#define	BSR	((u_short *)0xC30000)	/* board status register */
#endif LOCORE

#define	BSR_SWITCH8	0x0001
#define BSR_NSPEEDS	2
#define	BSR_CPUSPEED	(BSR_SWITCH8)
#define	BSR_CPUSPEED10	(0)		/* switch 8 on */
#define	BSR_CPUSPEED12	(BSR_SWITCH8)	/* switch 8 off */

#define	BSR_SWITCH7	0x0002
#define BSR_DISK	(BSR_SWITCH7)
#define	BSR_DISK_EHP	(BSR_SWITCH7)	/* EMMULEX hp controler, switch 7 off */

#define	BSR_SWITCH6	0x0004
#define	BSR_SWITCH5	0x0008
#define	BSR_BAUD	(BSR_SWITCH5|BSR_SWITCH6)
#define BSR_BAUD_9600	(0)		/* switch 5 and 6 on */
#define BSR_BAUD_19200	(BSR_SWITCH6)	/* switch 5 on, switch 6 off */
#define BSR_BAUD_1200	(BSR_SWITCH5)	/* switch 5 off, switch 6 on */
#define BSR_BAUD_300	(BSR_SWITCH5|BSR_SWITCH6) /* switch 5 and 6 off */

#define	BSR_IBHALTL	0x0010
#define	BSR_IBPOKH	0x0020
#define	BSR_HALT	0x0040
#define	BSR_LOCALPARITY	0x0080
#define	BSR_BUSPARITY	0x0100
#define	BSR_POWERFAIL	0x0200

/* PROM */
#ifdef LOCORE
#define	PROM	0xC00000
#else  LOCORE
#define	PROM	((u_short *)0xC00000)
#endif LOCORE

#define	PROM_BASE	PROM
#define PROM_REBOOT	PROM+8

/* SEGMENT REGISTERS */
#define	SEGREGBASE	0x400001

/* PAGE REGISTERS */
#define	PAGREGBASE	0x800000
