/*	vmmac.h	6.1	83/07/29	*/

/*
 * Virtual memory related conversion macros
 */

/* Core clicks to number of pages of page tables needed to map that much */
#define	ctopt(x)	(((x)+NPTEPG-1)/NPTEPG)

/* Virtual page numbers to text|data|stack segment page numbers and back */
#define	vtotp(p, v)	((int)(v)-LOWPAGES)
#ifndef	QBUS
#define	vtodp(p, v)	((int)((v) - stoc(ctos((p)->p_tsize)) - LOWPAGES))
#else	QBUS
#define	vtodp(p, v)	((p)->p_newimage ? vtodpnew(p, v) : vtodpold(p, v))
#define	vtodpnew(p, v)	((int)((v) - stoc   (ctos   ((p)->p_tsize)) - LOWPAGES))
#define	vtodpold(p, v)	((int)((v) - stocold(ctosold((p)->p_tsize)) - LOWPAGES))
#endif	QBUS
#define	vtosp(p, v)	((int)(btop(USRSTACK) - 1 - (v)))
#define	tptov(p, i)	((unsigned)(i) + LOWPAGES)
#ifndef	QBUS
#define	dptov(p, i)	((unsigned)(stoc(ctos((p)->p_tsize)) + (i) + LOWPAGES))
#else	QBUS
#define	dptov(p, v)	((p)->p_newimage ? dptovnew(p, v) : dptovold(p, v))
#define	dptovnew(p, i)	((unsigned)(stoc   (ctos   ((p)->p_tsize)) + \
			(i) + LOWPAGES))
#define	dptovold(p, i)	((unsigned)(stocold(ctosold((p)->p_tsize)) + \
			(i) + LOWPAGES))
#endif	QBUS
#define	sptov(p, i)	((unsigned)(btop(USRSTACK) - 1 - (i)))

/* Tell whether virtual page numbers are in text|data|stack segment */
#define	isassv(p, v)	((v) >= btop(USRSTACK) - (p)->p_ssize)
#define	isatsv(p, v)	(((v) - LOWPAGES) < (p)->p_tsize)
#ifndef	QBUS
#define	isadsv(p, v)	(((v) - LOWPAGES) >= stoc(ctos((p)->p_tsize)) && \
				!isassv(p, v))
#else	QBUS
#define	isadsv(p, v)	((p)->p_newimage ? isadsvnew(p, v) : isadsvold(p, v))
#define	isadsvnew(p, v)	(((v) - LOWPAGES) >= stoc   (ctos   ((p)->p_tsize)) && \
				!isassv(p, v))
#define	isadsvold(p, v)	(((v) - LOWPAGES) >= stocold(ctosold((p)->p_tsize)) && \
				!isassv(p, v))
#endif	QBUS

/* Tell whether pte's are text|data|stack */
#define	isaspte(p, pte)		((pte) > sptopte(p, (p)->p_ssize))
#define	isatpte(p, pte)		((pte) < dptopte(p, 0))
#define	isadpte(p, pte)		(!isaspte(p, pte) && !isatpte(p, pte))

/* Text|data|stack pte's to segment page numbers and back */
#define	ptetotp(p, pte)		((pte) - (p)->p_p0br)
#ifdef	M68020
#define	ptetodp(p, pte)		((pte) - ((p)->p_p0br+stoc(ctos((p)->p_tsize))))
#else	M68020
#define	ptetodp(p, pte)		((pte) - ((p)->p_p0br + (p)->p_tsize))
#endif	M68020
#define	ptetosp(p, pte)	\
	(((p)->p_p0br + (p)->p_szpt*NPTEPG - UPAGES - 1) - (pte))

#define	tptopte(p, i)		((p)->p_p0br + (i))
#ifdef	M68020
#define	dptopte(p, i)		((p)->p_p0br + stoc(ctos((p)->p_tsize)) + (i))
#else	M68020
#define	dptopte(p, i)		((p)->p_p0br + (p)->p_tsize + (i))
#endif	M68020
#define	sptopte(p, i) \
	(((p)->p_p0br + (p)->p_szpt*NPTEPG - UPAGES - 1) - (i))

/* Bytes to pages without rounding, and back */
#define	btop(x)		(((unsigned)(x)) >> PGSHIFT)
#define	ptob(x)		((caddr_t)((x) << PGSHIFT))

/* Turn virtual addresses into kernel map indices */
#define	kmxtob(a)	(usrpt + (a) * NPTEPG)
#define	btokmx(b)	(((b) - usrpt) / NPTEPG)

/* User area address and pcb bases */
#define	uaddr(p)	(&((p)->p_p0br[(p)->p_szpt * NPTEPG - UPAGES]))
#ifdef vax
#define	pcbb(p)		((p)->p_addr[0].pg_pfnum)
#else
#define	pcbb(p)		((p)->p_addr)
#endif

/* Average new into old with aging factor time */
#define	ave(smooth, cnt, time) \
	smooth = ((time - 1) * (smooth) + (cnt)) / (time)

/* Abstract machine dependent operations */
#ifdef vax
#define	setp0br(x)	(u.u_pcb.pcb_p0br = (x), mtpr(P0BR, x))
#define	setp0lr(x)	(u.u_pcb.pcb_p0lr = \
			    (x) | (u.u_pcb.pcb_p0lr & AST_CLR), \
			 mtpr(P0LR, x))
#define	setp1br(x)	(u.u_pcb.pcb_p1br = (x), mtpr(P1BR, x))
#define	setp1lr(x)	(u.u_pcb.pcb_p1lr = (x), mtpr(P1LR, x))
#define	initp1br(x)	((x) - P1PAGES)
#else
#define	setp0br(x)	(u.u_pcb.pcb_p0br = (x))
#define	setp0lr(x)	(u.u_pcb.pcb_p0lr = (x))
#define	setp1br(x)	(u.u_pcb.pcb_p1br = (x))
#define	setp1lr(x)	(u.u_pcb.pcb_p1lr = (x))
#ifdef	M68020
#define	initp1br(x)	((x) - P1PAGES)
#else	M68020
#define	initp1br(x)	((x) - P1PAGES - UPAGES)
#endif	M68020
#endif

#define	outofmem()	wakeup((caddr_t)&proc[2]);

/*
 * Page clustering macros.
 * 
 * dirtycl(pte)			is the page cluster dirty?
 * anycl(pte,fld)		does any pte in the cluster has fld set?
 * zapcl(pte,fld) = val		set all fields fld in the cluster to val
 * distcl(pte)			distribute high bits to cluster; note that
 *				distcl copies everything but pg_pfnum,
 *				INCLUDING pg_m!!!
 *
 * In all cases, pte must be the low pte in the cluster, even if
 * the segment grows backwards (e.g. the stack).
 */
#define	H(pte)	((struct hpte *)(pte))

#if CLSIZE==1
#define	dirtycl(pte)	dirty(pte)
#define	anycl(pte,fld)	((pte)->fld)
#define	anycl_mod(pte)	anycl(pte,pg_m)
#define	anycl_ref(pte)	anycl(pte,pg_r)
#define	zapcl(pte,fld)	(pte)->fld
#define	distcl(pte)
#endif

#if CLSIZE==2
#define	dirtycl(pte)	(dirty(pte) || dirty((pte)+1))
#define	anycl(pte,fld)	((pte)->fld || (((pte)+1)->fld))
#define	anycl_mod(pte)	anycl(pte,pg_m)
#define	anycl_ref(pte)	anycl(pte,pg_r)
#define	zapcl(pte,fld)	(pte)[1].fld = (pte)[0].fld
#endif

#if CLSIZE==4
#define	dirtycl(pte) \
    (dirty(pte) || dirty((pte)+1) || dirty((pte)+2) || dirty((pte)+3))
#define	anycl(pte,fld) \
    ((pte)->fld || (((pte)+1)->fld) || (((pte)+2)->fld) || (((pte)+3)->fld))
#define	anycl_mod(pte)	anycl(pte,pg_m)
#define	anycl_ref(pte)	anycl(pte,pg_r)
#define	zapcl(pte,fld) \
    (pte)[3].fld = (pte)[2].fld = (pte)[1].fld = (pte)[0].fld
#endif

#ifndef distcl
#define	distcl(pte)	zapcl(H(pte),pg_high)
#endif
