/*	cmap.h	6.3	84/02/07	*/

/*
 * core map entry
 *
 * Limits imposed by this structure (4k page, 512 byte disk block):
 *
 *		limit		     cur. size		fields
 *	Physical memory			256 Mb	c_next, c_prev, c_hlink
 *	Mounted filesystems		255	c_mdev
 *	size of a process segment	256 Mb	c_page
 *	filesystem size			8 Gb	c_blkno
 *	proc, text table size		64 k	c_ndx
 */
#ifndef	LOCORE
struct cmap
{
unsigned short 	c_next,		/* 16 index of next free list entry */
		c_prev,		/* 16 index of previous free list entry */
		c_hlink,	/* 16 hash link for <blkno,mdev> */
		c_page;		/* 16 virtual page number in segment */
unsigned long	c_blkno;	/* 32 disk block this is a copy of */
unsigned short	c_ndx;		/* 16 index of owner proc or text */
unsigned short	c_mdev:8,	/*  8 which mounted dev */
		c_remote:1,	/*  1 associated block is from remote machine */
		c_lock:1,	/*  1 locked for raw i/o or pagein */
		c_want:1,	/*  1 wanted */
		c_intrans:1,	/*  1 intransit bit */
		c_free:1,	/*  1 on the free list */
		c_gone:1,	/*  1 associated page has been released */
		c_type:2;	/*  2 type CSYS or CTEXT or CSTACK or CDATA */
				/* 128 bits */
};
#else	LOCORE
/*
 * bit offsets of elements in cmap
 */
#define	C_INTRANS	123
#define	C_FREE		124
#define	SZ_CMAP		16		/* sizeof(struct cmap) */

#define	MAXMEM		256*1024	/* maximum memory, in Kbytes */
#endif	LOCORE

#define	CMHEAD	0

/*
 * Shared text pages are not totally abandoned when a process
 * exits, but are remembered while in the free list hashed by <mdev,blkno>
 * off the cmhash structure so that they can be reattached
 * if another instance of the program runs again soon.
 */
#define	CMHSIZ	512		/* SHOULD BE DYNAMIC */
#define	CMHASH(bn)	((bn)&(CMHSIZ-1))

#ifndef	LOCORE
#ifdef	KERNEL
struct	cmap *cmap;
struct	cmap *ecmap;
int	ncmap;
struct	cmap *mfind();
int	firstfree, maxfree;
int	ecmx;			/* cmap index of ecmap */
short	cmhash[CMHSIZ];
#endif

/* bits defined in c_type */

#define	CSYS		0		/* none of below */
#define	CTEXT		1		/* belongs to shared text segment */
#define	CDATA		2		/* belongs to data segment */
#define	CSTACK		3		/* belongs to stack segment */

#define	pgtocm(x)	((((x)-firstfree) / CLSIZE) + 1)
#define	cmtopg(x)	((((x)-1) * CLSIZE) + firstfree)
#endif	LOCORE
