#define	WRETRY			5
#define	WTIMEOUT		(3*hz)
#define	PREC_WIPC		26	/* priority to receive a message */
#define	PREP_WIPC		5	/* priority to get a reply */

#define	MAX_APPENDED_SEGMENT	(1024+256+128)

#define	IPC_SEND		1
#define	IPC_REPLY		2
#define	IPC_FORWARD		3
#define	IPC_RECEIVE_SPECIFIC	4
#define	IPC_BREATH_OF_LIFE	5
#define	IPC_GET_PID		6
#define	IPC_GET_PID_REPLY	7
#define	IPC_COPY_FROM_REQ	8
#define	IPC_COPY_FROM_REP	9
#define	IPC_COPY_TO_REQ		10
#define	IPC_COPY_TO_REP		11
#define	IPC_NACK		12

#define	RCODE_REPLY		0x8000
#define	RCODE_PHYS_SEGMENT	0x4000
#define	RCODE_IDEMPOTENT	0x2000
#define	RCODE_USER_SEGMENT	0x1000
#define	RCODE_SEGMENT_READ	0x0800
#define	RCODE_SEGMENT_WRITE	0x0400
#define	RCODE_KERN_SEGMENT	0x0000
#define	RCODE_SEGMENT		\
	(RCODE_PHYS_SEGMENT|RCODE_USER_SEGMENT|RCODE_KERN_SEGMENT)

#define	RCODE_BARF		0x0200
#define	RCODE_ANY_COUSIN	0x0100

#define	FORCE_SEG_USER(n)	((n) |= ((n) & 0x0C00) ? 0x1000 : 0)
#define	SEG_KERNEL(n)		(!((n) & 0x1000))
#define	SEG_PHYS(n)		((n) & 0x4000)
#define	SEG_READ(n)		((n) & 0x0800)
#define	SEG_WRITE(n)		((n) & 0x0400)
#define	SEG_USER_READ(n)	(((n) & 0x1800) == 0x1800)
#define	SEG_USER_WRITE(n)	(((n) & 0x1400) == 0x1400)

/*
 * InterProcess Communication packet, compatible with Stanford V-System.
 *  "Src" and "Dest" refer to the sender & receiver of this packet
 *  (which may or may not correspond to the original "Send"er & "Receive"r).
 */
struct ipc {
	unsigned short	ipcPacketType;		/* one of the above types */
	unsigned short	ipcSequenceNo;		/* sequence number */
	unsigned long	ipcSrcPid;		/* source process id */
	unsigned long	ipcDestPid;		/* destination process id */
	unsigned long	ipcForwarder;		/* forwarder process id */
	unsigned long	ipcUserNo;		/* user number (unused?) */
	unsigned long	ipcDataLength;		/* len of this packet's data */
	union {
	 char		*u0_ipcSrcAddress;	/* ptr to source's data space */
	 unsigned long	u0_ipcCopyLength;	/* total data len */
	} ipc_u0;
	union {
	 char		*u1_ipcDestAddress;	/* ptr to dest's data space */
	 unsigned long	u1_ipcDataOff;
	} ipc_u1;
#define	ipcSrcAddress	ipc_u0.u0_ipcSrcAddress
#define	ipcCopyLength	ipc_u0.u0_ipcCopyLength
#define	ipcDestAddress	ipc_u1.u1_ipcDestAddress
#define	ipcDataOff	ipc_u1.u1_ipcDataOff
};

#define	MSGLEN	32
#define	FSIZ MSGLEN-sizeof(unsigned short)-sizeof(char *)-sizeof(unsigned long)

struct request {
	unsigned short	reqRequestCode;
	char		reqFiller[FSIZ];
	char		*reqSegPtr;
	unsigned long	reqSegLength;
};

struct reply {
	unsigned short	repReplyCode;
	char		repFiller[FSIZ];
	char		*repSegPtr;
	unsigned long	repSegLength;
};

struct Wrproc {
	struct Wrproc	*Wp_next;		/* list link (must be first!) */
	struct ipc	Wp_ipc;			/* ipc structure */
	struct request	Wp_msg;			/* message (optional) */
						/* data may follow (optional) */
};

unsigned short	SeqNo;
unsigned long	Mid;
