#define	RCODE_REPLY		0x8000
#define	RCODE_PHYS_SEGMENT	0x4000
#define	RCODE_IDEMPOTENT	0x2000
#define	RCODE_USER_SEGMENT	0x1000
#define	RCODE_SEGMENT_READ	0x0800
#define	RCODE_SEGMENT_WRITE	0x0400
#define	RCODE_KERN_SEGMENT	0x0000
#define	RCODE_SEGMENT		\
	(RCODE_PHYS_SEGMENT|RCODE_USER_SEGMENT|RCODE_KERN_SEGMENT)

#define	RCODE_BARF		0x0200
#define	RCODE_ANY_COUSIN	0x0100

struct Request {
	union {
		struct {
			unsigned short	requestcode;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	GET_MID		(RCODE_BARF|RCODE_IDEMPOTENT|0xFF)

struct GetMid {
	union {
		struct {
			unsigned short	requestcode;
			unsigned long	myrpid;
			char		myname[11+1];
			char		name[11+1];
		} Req;
		struct {
			unsigned short	replycode;
			unsigned long	rpid;
		} Rep;
	} Un;
};


#define	CREATE_COUSIN	(RCODE_BARF|0xFE)

struct CreateCousin {
	union {
		struct {
			unsigned short	requestcode;
			short		pid;
			short		uid;
			short		gid;
			short		groups[NGROUPS];
		} Req;
		struct {
			unsigned short	replycode;
			unsigned long	rpid;
		} Rep;
	} Un;
};


#define	AM_ALIVE	(RCODE_BARF|RCODE_IDEMPOTENT|0xFD)

struct AmAlive {
	union {
		struct {
			unsigned short	requestcode;
			unsigned long	rpid;
			char		machname[11+1];
		} Req;
		/* no reply! */
	} Un;
};


#define	UNIX_FORK	(RCODE_BARF|0x00)

struct UnixFork {
	union {
		struct {
			unsigned short	requestcode;
			unsigned short	cdirmid;
			unsigned short	rdirmid;
		} Req;
		struct {
			unsigned short	replycode;
			unsigned long	rpid;
		} Rep;
	} Un;
};


#define	UNIX_COPEN	(RCODE_BARF|RCODE_SEGMENT_READ|RCODE_SEGMENT_WRITE|RCODE_ANY_COUSIN|0x01)

struct UnixCopen {
	union {
		struct {
			unsigned short	requestcode;
			unsigned short	accessmode;
			unsigned short	createmode;
			unsigned short	unused[6];
			short		pid;
			short		uid;
			short		gid;
			char		*pathname;
			unsigned	pathlen;
		} Req;
		struct {
			unsigned short	replycode;
			unsigned long	rpid;
			short		rfdes;
			unsigned short	mode;
		} Rep;
	} Un;
};


#define	UNIX_CLOSE	(RCODE_BARF|0x02)

struct UnixClose {
	union {
		struct {
			unsigned short	requestcode;
			short		rfdes;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_EXIT	(RCODE_BARF|0x03)

struct UnixExit {
	union {
		struct {
			unsigned short	requestcode;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_READ	(RCODE_BARF|RCODE_USER_SEGMENT|RCODE_SEGMENT_WRITE|0x04)
#define	UNIX_WRITE	(RCODE_BARF|RCODE_USER_SEGMENT|RCODE_SEGMENT_READ|0x05)
#define	UNIX_APPEND	(RCODE_BARF|RCODE_USER_SEGMENT|RCODE_SEGMENT_READ|0x06)

struct UnixReadWrite {
	union {
		struct {
			unsigned short	requestcode;
			short		rfdes;
			int		offset;
			short		unused[8];
			char		*base;
			int		length;
		} Req;
		struct {
			unsigned short	replycode;
			int		resid;
		} Rep;
	} Un;
};


#define	UNIX_IOCTL	(RCODE_BARF|RCODE_SEGMENT_WRITE|RCODE_SEGMENT_READ|0x07)

struct UnixIoctl {
	union {
		struct {
			unsigned short	requestcode;
			unsigned short	rfdes;
			int		com;
			unsigned short	unused[8];
			char		*data;
			unsigned	datalen;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_SELECT	(RCODE_BARF|0x08)

struct UnixSelect {
	union {
		struct {
			unsigned short	requestcode;
			unsigned short	rfdes;
			int		which;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_STAT	\
  (RCODE_BARF|RCODE_IDEMPOTENT|RCODE_SEGMENT_WRITE|RCODE_SEGMENT_READ|RCODE_ANY_COUSIN|0x0A)

struct UnixStat {
	union {
		struct {
			unsigned short	requestcode;
			unsigned short	follow;
			unsigned short	unused[7];
			short		pid;
			short		uid;
			short		gid;
			char		*pathname;
			unsigned	pathlen;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_FSTAT	\
  (RCODE_BARF|RCODE_IDEMPOTENT|RCODE_USER_SEGMENT|RCODE_SEGMENT_WRITE|0x0A)
#define	UNIX_KFSTAT	(RCODE_BARF|RCODE_IDEMPOTENT|RCODE_SEGMENT_WRITE|0x0B)

struct UnixFstat {
	union {
		struct {
			unsigned short	requestcode;
			unsigned short	rfdes;
			unsigned short	unused[10];
			char		*sb;
			unsigned long	buflen;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_ACCESS	\
  (RCODE_BARF|RCODE_IDEMPOTENT|RCODE_SEGMENT_READ|RCODE_ANY_COUSIN|0x0C)

struct UnixAccess {
	union {
		struct {
			unsigned short	requestcode;
			unsigned short	fmode;
			unsigned short	unused[7];
			short		pid;
			short		uid;
			short		gid;
			char		*pathname;
			unsigned	pathlen;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_CHDIR	(RCODE_BARF|RCODE_SEGMENT_READ|RCODE_ANY_COUSIN|0x0D)
#define	UNIX_CHROOT	(RCODE_BARF|RCODE_SEGMENT_READ|RCODE_ANY_COUSIN|0x0E)

struct UnixChdirec {
	union {
		struct {
			unsigned short	requestcode;
			unsigned short	unused[8];
			short		pid;
			short		uid;
			short		gid;
			char		*pathname;
			unsigned	pathlen;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_UNLINK	(RCODE_BARF|RCODE_SEGMENT_READ|RCODE_ANY_COUSIN|0x0F)

struct UnixUnlink {
	union {
		struct {
			unsigned short	requestcode;
			unsigned short	unused[8];
			short		pid;
			short		uid;
			short		gid;
			char		*pathname;
			unsigned	pathlen;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_LINK	(RCODE_BARF|RCODE_SEGMENT_READ|RCODE_ANY_COUSIN|0x10)

struct UnixLink {
	union {
		struct {
			unsigned short	requestcode;
			char		*path1;
			char		*path2;
			unsigned short	unused[4];
			short		pid;
			short		uid;
			short		gid;
			char		*pathbuf;
			unsigned	pathbuflen;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_SYMLINK	(RCODE_BARF|RCODE_SEGMENT_READ|RCODE_ANY_COUSIN|0x11)

struct UnixSymlink {
	union {
		struct {
			unsigned short	requestcode;
			char		*path1;
			char		*path2;
			unsigned short	unused[4];
			short		pid;
			short		uid;
			short		gid;
			char		*pathbuf;
			unsigned	pathbuflen;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_READLINK	\
  (RCODE_BARF|RCODE_IDEMPOTENT|RCODE_SEGMENT_WRITE|RCODE_SEGMENT_READ|RCODE_ANY_COUSIN|0x12)

struct UnixReadlink {
	union {
		struct {
			unsigned short	requestcode;
			unsigned short	unused[8];
			short		pid;
			short		uid;
			short		gid;
			char		*buf;
			unsigned	buflen;
		} Req;
		struct {
			unsigned short	replycode;
			int		linklen;
		} Rep;
	} Un;
};


#define	UNIX_MKNOD	(RCODE_BARF|RCODE_SEGMENT_READ|RCODE_ANY_COUSIN|0x13)

struct UnixMknod {
	union {
		struct {
			unsigned short	requestcode;
			int		fmode;
			int		dev;
			unsigned short	unused[4];
			short		pid;
			short		uid;
			short		gid;
			char		*pathname;
			unsigned	pathlen;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_MKDIR	(RCODE_BARF|RCODE_SEGMENT_READ|RCODE_ANY_COUSIN|0x14)

struct UnixMkdir {
	union {
		struct {
			unsigned short	requestcode;
			int		dmode;
			unsigned short	unused[6];
			short		pid;
			short		uid;
			short		gid;
			char		*pathname;
			unsigned	pathlen;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_RMDIR	(RCODE_BARF|RCODE_SEGMENT_READ|RCODE_ANY_COUSIN|0x15)

struct UnixRmdir {
	union {
		struct {
			unsigned short	requestcode;
			unsigned short	unused[8];
			short		pid;
			short		uid;
			short		gid;
			char		*pathname;
			unsigned	pathlen;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_CHMOD	\
  (RCODE_BARF|RCODE_IDEMPOTENT|RCODE_SEGMENT_READ|RCODE_ANY_COUSIN|0x16)

struct UnixChmod {
	union {
		struct {
			unsigned short	requestcode;
			int		fmode;
			unsigned short	unused[6];
			short		pid;
			short		uid;
			short		gid;
			char		*pathname;
			unsigned	pathlen;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_FCHMOD	(RCODE_BARF|0x17)

struct UnixFchmod {
	union {
		struct {
			unsigned short	requestcode;
			int		rfdes;
			int		fmode;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_CHOWN	\
  (RCODE_BARF|RCODE_IDEMPOTENT|RCODE_SEGMENT_READ|RCODE_ANY_COUSIN|0x18)

struct UnixChown {
	union {
		struct {
			unsigned short	requestcode;
			int		newuid;
			int		newgid;
			unsigned short	unused[4];
			short		pid;
			short		uid;
			short		gid;
			char		*pathname;
			unsigned	pathlen;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_FCHOWN	(RCODE_BARF|0x19)

struct UnixFchown {
	union {
		struct {
			unsigned short	requestcode;
			int		rfdes;
			int		newuid;
			int		newgid;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_TRUNCATE	\
  (RCODE_BARF|RCODE_IDEMPOTENT|RCODE_SEGMENT_READ|RCODE_ANY_COUSIN|0x20)

struct UnixTruncate {
	union {
		struct {
			unsigned short	requestcode;
			unsigned long	length;
			unsigned short	unused[6];
			short		pid;
			short		uid;
			short		gid;
			char		*pathname;
			unsigned	pathlen;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_FTRUNCATE	(RCODE_BARF|0x21)

struct UnixFtruncate {
	union {
		struct {
			unsigned short	requestcode;
			int		rfdes;
			unsigned long	length;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_UTIMES	\
  (RCODE_BARF|RCODE_IDEMPOTENT|RCODE_SEGMENT_READ|RCODE_ANY_COUSIN|0x22)

struct UnixUtimes {
	union {
		struct {
			unsigned short	requestcode;
			long		asec;
			long		msec;
			unsigned short	unused[4];
			short		pid;
			short		uid;
			short		gid;
			char		*pathname;
			unsigned	pathlen;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_FSYNC	(RCODE_BARF|0x23)

struct UnixFsync {
	union {
		struct {
			unsigned short	requestcode;
			int		rfdes;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_RENAME	(RCODE_BARF|RCODE_SEGMENT_READ|RCODE_ANY_COUSIN|0x24)

struct UnixRename {
	union {
		struct {
			unsigned short	requestcode;
			char		*path1;
			char		*path2;
			unsigned short	unused[4];
			short		pid;
			short		uid;
			short		gid;
			char		*pathbuf;
			unsigned	pathbuflen;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_CHEXEC	\
  (RCODE_BARF|RCODE_SEGMENT_WRITE|RCODE_SEGMENT_READ|RCODE_ANY_COUSIN|0x25)

struct UnixChExec {
	union {
		struct {
			unsigned short	requestcode;
			unsigned short	unused[8];
			short		pid;
			short		uid;
			short		gid;
			char		*pathname;
			unsigned	pathlen;
		} Req;
		struct {
			unsigned short	replycode;
			int		newuid;
			int		newgid;
			int		newimage;
		} Rep;
	} Un;
};


#define	UNIX_LOAD	(RCODE_BARF|RCODE_USER_SEGMENT|RCODE_SEGMENT_WRITE|0x26)

struct UnixLoad {
	union {
		struct {
			unsigned short	requestcode;
			int		offset;
			short		unused[9];
			char		*base;
			int		length;
		} Req;
		struct {
			unsigned short	replycode;
			int		resid;
		} Rep;
	} Un;
};


#define	UNIX_FLOCK	(RCODE_BARF|0x27)

struct UnixFlock {
	union {
		struct {
			unsigned short	requestcode;
			int		rfdes;
			long		how;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	UNIX_LOCKF	(RCODE_BARF|0x28)

struct UnixLockf {
	union {
		struct {
			unsigned short	requestcode;
			int		rfdes;
			long		flag;
			long		size;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	SWAP_INIT	(RCODE_BARF|0x30)

struct SwapInit {
	union {
		struct {
			unsigned short	requestcode;
			int		mode;
			unsigned long	nblocks;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	SWAP_IN		\
    (RCODE_BARF|RCODE_IDEMPOTENT|RCODE_PHYS_SEGMENT|RCODE_SEGMENT_WRITE|0x31)
#define	SWAP_OUT	\
    (RCODE_BARF|RCODE_IDEMPOTENT|RCODE_PHYS_SEGMENT|RCODE_SEGMENT_READ|0x32)

struct Swap {
	union {
		struct {
			unsigned short	requestcode;
			int		devx;
			unsigned long	blkno;
			short		unused[7];
			char		*addr;
			int		bcount;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};


#define	GET_INODE	\
    (RCODE_BARF|RCODE_IDEMPOTENT|RCODE_KERN_SEGMENT|RCODE_SEGMENT_WRITE|0x33)

struct GetInode {
	union {
		struct {
			unsigned short	requestcode;
			int		rfdes;
			short		unused[9];
			char		*base;
			int		length;
		} Req;
		struct {
			unsigned short	replycode;
		} Rep;
	} Un;
};
