#include <stdio.h>
#define	HUGE	0x7FFFFFFF

main(ac, av)
  int ac;
  char **av;
  {
	register int tic, cpu;

	if (ac != 2  &&  ac != 3)
		usage();
	if ((tic = atoi(av[1])) <= 0)
		usage();
	if (ac == 3) {
		cpu = atoi(av[2]);
		switch (cpu) {
		  case 8:	cpu = 8000000; break;
		  case 10:	cpu = 10000000; break;
		  case 11:	cpu = 11059200; break;
		  case 12:	cpu = 11592000; break;
		  default:	if (cpu < 1000000) usage();  break;
		}
		calculate(tic, cpu);
	} else {
		calculate(tic, 8000000);
		calculate(tic, 10000000);
		calculate(tic, 11592000);
	}
	return 0;
}

calculate(tic, cpu)
  register tic, cpu;
  {
	register int diff, odiff;
	register int i;
	int j, oi, oj, scale;
	register char *mode;

	odiff = HUGE;
	for (i = 1;  i <= 256;  i++) {
		if ((diff = closest(&j, i, tic, cpu, 4)) < odiff) {
			if (j < 1  ||  j > 256)
				continue;
			mode = "CNTRa";
			scale = 4;
			oi = i;
			oj = j;
			if ((odiff = diff) == 0)
				goto gotit;
		}
	}

	for (i = 1;  i <= 256;  i++) {
		if ((diff = closest(&j, i, tic, cpu, 4 * 16)) < odiff) {
			if (j < 1  ||  j > 256)
				continue;
			mode = "TIMRa";
			scale = 4 * 16;
			oi = i;
			oj = j;
			if ((odiff = diff) == 0)
				break;
		}
	}
  gotit:
	if (oi == 256) oi = 0;
	if (oj == 256) oj = 0;
	printf("	{ %s, %3d, CNTRb, %3d },", mode, oi, oj);
	if (oi == 0) oi = 256;
	if (oj == 0) oj = 256;
	printf("	/* %6.3f MHz cpu: %7.3f Hz tic */\n",
		(double)cpu/1000000.0,
		(double)cpu / ( (double)oi*(double)oj*(double)scale ) );
}

int
closest(aj, i, tic, cpu, scale)
  int *aj;
  register int i, cpu;
  {
	register int j, diff, odiff, oj;

	i *= scale * tic;
	odiff = HUGE;
	for (j = 1;  j <= 256;  j++) {
		diff = cpu - (i * j);
		if (diff < 0)
			diff = -diff;
		if (diff < odiff) {
			oj = j;
			if ((odiff = diff) == 0)
				break;
		}
	}
	*aj = oj;
	return odiff;
}

usage()
  {
	fprintf(stderr, "usage: tcalc tic [ cpu ]\n");
	exit(1);
}
