#include <nlist.h>

struct nlist nl[] = {
	{ "_freemempt" },
	{ "" },
};

main(argc, argv)
	int argc;
	char *argv[];
{
	register char *kmemf = "/dev/kmem";
	register char *kernelf = "/vmunix";
	int loc, word, kmem;

	if (argc >= 2)
		nl[0].n_name = argv[1];
	nlist(kernelf, nl);
	if (nl[0].n_type == 0) {
		printf("%s not found in %s's namelist\n",nl[0].n_name,kernelf);
		exit(0);
	}
	loc = nl[0].n_value;
	kmem = open(kmemf, 0);
	if (kmem < 0) {
		printf("cannot open %s\n",kmemf);
		exit(0);
	}
	printf("%s at location %x in %s\n",nl[0].n_name,loc,kmemf);

	while (1) {
		lseek(kmem, (long)loc&0x0fffffff, 0);
		if (read(kmem, (char *)&word, sizeof (word)) != sizeof (word))
			return(0);
		printf("%s = %x\n",nl[0].n_name,word);
	}
}

int kmem;

havebatteryclock()
{
	register struct nlist *nlp;

	if (nl[0].n_type != 0) {
		if (openkmem())
			return (getw(nl[0].n_value));
	}
	return (0);
}

openkmem()
{
	register char *kmemf = "/dev/kmem";

	kmem = open(kmemf, 0);
	if (kmem < 0)
		return(0);
	return(1);
}

getw(loc)
	unsigned long loc;
{
	long word;

	lseek(kmem, (long)loc&0x0fffffff, 0);
	if (read(kmem, (char *)&word, sizeof (word)) != sizeof (word))
		return(0);
	return (word);
}
