typedef struct {
    unsigned short	addrhigh,
    			addrmid,
			addrlow;
} NetAddress;

typedef struct {
    NetAddress		dsthost;
    NetAddress		srchost;
    unsigned short	packettype;
} NetworkHeader;

struct BootPacket {
	NetworkHeader		bp_eh;
	int			bp_pkid;	/* packet id */
	char			bp_cmd;		/* command */
#define	BOOT_CONNECT		0x0
#define	BOOT_OPEN		0x1
#define	BOOT_READ		0x2
#define	BOOT_WRITE		0x3
#define	BOOT_CLOSE		0x4
	int			bp_offset;	/* offset */
	int			bp_len;		/* length */
#define	BOOT_DATACNT		512
	char			bp_data[BOOT_DATACNT];	/* data */
};

#ifdef SERVER
char *bootstate[] = {
	"WAIT OPEN:    ",
	"OPENED:       ",
	"ACTIVE:       ",
	"ACTIVE:       ",
	"WAIT CONNECT: "
};
#endif
