#include <stdio.h>
#define	HUGE	0x7FFFFFFF

int brate[] = { 50, 75, 110, /*134.5, */ 150, 200, 300, 600, 1200, 1800, 2400, 
	4800, 9600, 19200, 38400, 0
};

main(ac, av)
int ac;
char **av;
{
	register int tic, cpu;

	if (ac != 2  &&  ac != 3)
		usage();
	if ((tic = atoi(av[1])) <= 0)
		usage();
	if (ac == 3) {
		cpu = atoi(av[2]);
		switch (cpu) {
		  case 8:	cpu = 8000000; break;
		  case 10:	cpu = 10000000; break;
		  case 11:	cpu = 11059200; break;
		  case 12:	cpu = 11592000; break;
		  default:	if (cpu < 1000000) usage();  break;
		}
		ctccalc(tic, cpu, 4); siocalc(cpu, 4);

		ctccalc(tic, cpu, 8); siocalc(cpu, 8);
	} else {
		ctccalc(tic, 8000000, 4); siocalc(8000000, 4);
		ctccalc(tic, 10000000, 4); siocalc(10000000, 4);
		ctccalc(tic, 11059200, 4); siocalc(11059200, 4);
		ctccalc(tic, 11592000, 4); siocalc(11592000, 4);

		ctccalc(tic, 8000000, 8); siocalc(8000000, 8);
		ctccalc(tic, 10000000, 8); siocalc(10000000, 8);
		ctccalc(tic, 11059200, 8); siocalc(11059200, 8);
		ctccalc(tic, 11592000, 8); siocalc(11592000, 8);
	}
	return 0;
}

ctccalc(tic, cpu, div)
register tic, cpu, div;
{
	register int diff, odiff;
	register int i;
	int j, oi, oj, scale;
	register char *mode;

	odiff = HUGE;
	for (i = 1;  i <= 256;  i++) {
		if ((diff = closest(&j, i, tic, cpu, div)) < odiff) {
			if (j < 1  ||  j > 256)
				continue;
			mode = "CNTRa";
			scale = div;
			oi = i;
			oj = j;
			if ((odiff = diff) == 0)
				goto gotit;
		}
	}

	for (i = 1;  i <= 256;  i++) {
		if ((diff = closest(&j, i, tic, cpu, div * 16)) < odiff) {
			if (j < 1  ||  j > 256)
				continue;
			mode = "TIMRa";
			scale = div * 16;
			oi = i;
			oj = j;
			if ((odiff = diff) == 0)
				break;
		}
	}
  gotit:
	if (oi == 256) oi = 0;
	if (oj == 256) oj = 0;
	printf("	{ %s, %3d, CNTRb, %3d },", mode, oi, oj);
	if (oi == 0) oi = 256;
	if (oj == 0) oj = 256;
	printf("	/* %6.4f MHz / %d: %7.3f Hz tic */\n",
		(double)cpu/1000000.0, div,
		(double)cpu / ( (double)oi*(double)oj*(double)scale ) );
}

int
closest(aj, i, tic, cpu, scale)
int *aj;
register int i, cpu;
{
	register int j, diff, odiff, oj;

	i *= scale * tic;
	odiff = HUGE;
	for (j = 1;  j <= 256;  j++) {
		diff = cpu - (i * j);
		if (diff < 0)
			diff = -diff;
		if (diff < odiff) {
			oj = j;
			if ((odiff = diff) == 0)
				break;
		}
	}
	*aj = oj;
	return odiff;
}

siocalc(cpu, div)
register int cpu;
{
	register int i;
	register int x16, y16, x64, y64;
	int siodv, ctctc;
	double err;

printf("				/* %6.4f MHz / %d */\n",
		(double)cpu/1000000.0, div);
	cpu /= div;
	for (i = 0; brate[i] ; i++) {
		x16 = cpu / 16 / brate[i];
		x64 = cpu / 64 / brate[i];
		y16 = abs(cpu - (x16 * 16 * brate[i]));
		if (y16 > abs(cpu - ((x16+1) * 16 * brate[i]))) {
			x16++;
			y16 = abs(cpu - (x16 * 16 * brate[i]));
		}
		y64 = abs(cpu - (x64 * 64 * brate[i]));
		if (y64 > abs(cpu - ((x64+1) * 64 * brate[i]))) {
			x64++;
			y64 = abs(cpu - (x64 * 64 * brate[i]));
		}
		if (x16 < 256 && x64 < 256) {
			if (y16 <= y64) {
				siodv = 16;
				ctctc = x16;
			} else {
				siodv = 64;
				ctctc = x64;
			}
		} else if (x16 < 256) {
			siodv = 16;
			ctctc = x16;
		} else if (x64 < 256) {
			siodv = 64;
			ctctc = x64;
		} else {
printf("	0,	0,		/* %d (NOT SUPPORTED) */\n",
				brate[i]);
			continue;
		}
printf("	%d,	SIOW4_X%d,	/* %d ", ctctc, siodv, brate[i]);
		err = ((double)( brate[i] - (cpu / siodv / ctctc) ) / 
			(double)brate[i] ) * 100.0;
		if (abs(err) > 0.1)
			printf("(%4.1f%% error) */\n",err);
		else
			printf(" */\n");
	}
}

usage()
{
	fprintf(stderr, "usage: tcalc tic [ cpu ]\n");
	exit(1);
}
