
/*
 * usrqbglue.s: user-configurable qbus glue
 */
#define	SCBVEC(name)	.align 1;  .globl _X/**/name;  _X/**/name

#define	PUSHR		movml #0xC0C0,sp@-	/* save temp regs ([da][01]) */
#define	POPR		movml sp@+,#0x0303	/* restore temp regs */
#define	PUSHED		16		/* offset to get around saved regs */
#define	TTYPE		(PUSHED+2)	/* offset to trap type */
#define	EEXT		6		/* size of exception extension stuff */
#define	ESF		(EEXT+PUSHED)	/* offset to exception stack frame */
#define	INC(counter)	addql #1,_cnt+counter
#define	IBEG		subql #EEXT,sp;  PUSHR
#define	RTE(n)		INC(n);  jra iret

#if 0	/* example */
SCBVEC(elintr0):
	IBEG
	clrl sp@-;  jsr _elintr;  addql #4,sp
	RTE	(V_INTR)
SCBVEC(elintr1):
	IBEG
	pea 1;  jsr _elintr;  addql #4,sp
	RTE	(V_INTR)
#endif

