/*	conf.c	6.1	83/07/29	*/

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/buf.h"
#include "../h/tty.h"
#include "../h/conf.h"

int	nulldev();
int	nodev();

#ifdef QBUS
int	elopen(),elstrategy(),elread(),elwrite();
int	elreset(),eldump(),elsize();
#else	QBUS
int	sdopen(),sdstrategy(),sdread(),sdwrite();
int	sdreset(),sddump(),sdsize();
#endif	QBUS

#ifdef	QBUS
int	hpopen(),hpstrategy(),hpread(),hpwrite(),hpdump(),hpioctl(),hpsize();
#else	QBUS
int	smopen(),smstrategy(),smread(),smwrite();
int	smreset(),smdump(),smsize();
#endif	QBUS

#ifdef	QBUS
int	raopen(),rastrategy(),raread(),rawrite(),rareset(),radump(),rasiz();
#else	QBUS
int	ldopen(),ldstrategy(),ldread(),ldwrite();
int	ldioctl(),ldreset(),lddump(),ldsize();
#endif QBUS
 
# ifdef QBUS 

int	rkopen(),rkstrategy(),rkread(),rkwrite(),rkintr();
int	rkdump(),rkreset(),rksize();

int	rlopen(),rlstrategy(),rlread(),rlwrite();
int	rlreset(),rldump(),rlsize();

int	rxopen(),rxstrategy(),rxclose(),rxread(),rxwrite(),rxreset(),rxioctl();

int	tmopen(),tmclose(),tmstrategy(),tmread(),tmwrite();
int	tmioctl(),tmdump(),tmreset();

#endif QBUS

int	rdopen(),rdstrategy(),rdread(),rdwrite(),rdreset(),rddump(),rdsize();
int	tsopen(),tsclose(),tsstrategy(),tsread(),tswrite();
int	tsioctl(),tsdump(),tsreset();

#define	SWAPMAJ		0			/* major of swap */
int	swstrategy(), swread(), swwrite();

struct bdevsw	bdevsw[] =
{
	{ nodev,	nodev,		swstrategy,	nodev,		/*0*/
	  0,		0 },
#ifdef	QBUS
	{ elopen,	nodev,		elstrategy,	eldump,		/*1*/
	  elsize,	0 },
#else	QBUS
	{ sdopen,	nodev,		sdstrategy,	sddump,		/*1*/
	  sdsize,	0 },
#endif	QBUS

#ifdef	QBUS
	{ hpopen,	nulldev,	hpstrategy,	hpdump,		/*2*/
	  hpsize,	0 },
#else	QBUS
	{ smopen,	nulldev,	smstrategy,	smdump,		/*2*/
	  smsize,	0 },
#endif	QBUS

#ifdef	QBUS
	{ rkopen,	nulldev,	rkstrategy,	rkdump,		/*3*/
	  rksize,	0 },
#else	QBUS
	{ nodev,	nodev,		nodev,		nodev,		/*3*/
	  nodev,	0 },
#endif	QBUS
#ifdef	QBUS
	{ raopen,	nulldev,	rastrategy,	nodev,		/*4*/
	  rasiz,	0 },
#else	QBUS
	{ ldopen,	nodev,		ldstrategy,	lddump,		/*4*/
	  ldsize,	0 },
#endif	QBUS
#ifdef	QBUS
	{ rlopen,	nodev,		rlstrategy,	rldump,		/*5*/
	  rlsize,	0 },
#else	QBUS
	{ nodev,	nodev,		nodev,		nodev,		/*5*/
	  nodev,	0 },
#endif	QBUS

	{ rdopen,	nulldev,	rdstrategy,	rddump,		/*6*/
	  rdsize,	0 },
#ifdef	QBUS
	{ rxopen,	rxclose,	rxstrategy,	nodev,		/*7*/
	  0,		B_18BIT },
	{ tmopen,	tmclose,	tmstrategy,	tmdump,		/*8*/
	  0,		B_18BIT|B_TAPE },
#else	QBUS
	{ nodev,	nodev,		nodev,		nodev,		/*7*/
	  nodev,	0 },
	{ nodev,	nodev,		nodev,		nodev,		/*8*/
	  nodev,	0 },
#endif	QBUS
	{ tsopen,	tsclose,	tsstrategy,	tsdump,		/*9*/
	  0,		B_TAPE },
};

int	nblkdev = sizeof (bdevsw) / sizeof (bdevsw[0]);

int	sioopen(),sioclose(),sioread(),siowrite(),sioioctl(),siostop();
struct tty sio_tty[];

#ifdef	QBUS

int	dhopen(),dhclose(),dhread(),dhwrite(),dhioctl(),dhstop(),dhreset();
struct	tty dh_tty[];

#else	QBUS

int	cpopen(),cpclose(),cpread(),cpwrite(),cpioctl(),cpstop(),cpreset();
struct	tty cp_tty[];

#endif	QBUS

#ifdef	QBUS

int	dzopen(),dzclose(),dzread(),dzwrite(),dzioctl(),dzstop(),dzreset();
struct	tty dz_tty[];

int	lpopen(),lpclose(),lpwrite(),lpreset();

int	dlopen(),dlclose(),dlread(),dlwrite(),dlioctl(),dlstop(),dlreset();
struct	tty dl_tty[];

int	ibopen(),ibclose(),ibread(),ibwrite(),ibioctl();

#endif QBUS


int	syopen(), syread(), sywrite(), syioctl(), syselect();

int 	mmread(), mmwrite(), mmmap();

int	ptsopen(),ptsclose(),ptsread(),ptswrite(),ptsstop();
int	ptcopen(),ptcclose(),ptcread(),ptcwrite(),ptcselect();
int	ptyioctl();
struct	tty pt_tty[];


int	enetopen(),enetclose(),enetread(),enetwrite(),enetioctl(),enetselect();


#ifdef	QBUS

int	rpopen(),rpclose(),rpread(),rpwrite(),rpioctl();

#else	QBUS

int	vtopen(),vtclose(),vtread(),vtwrite(),vtioctl();
struct	tty vt_tty[];
int	fntopen(),fntclose(),fntread(),fntwrite(),fntioctl();

int	enpioctl(), enpreconfig();
int	enpr_read(), enpr_write(), enpr_ioctl();

#endif	QBUS

int	ttselect(), seltrue();

struct cdevsw	cdevsw[] =
{
	nulldev,	nulldev,	swread,		swwrite,	/*0*/
	nodev,		nodev,		nulldev,	0,
	nodev,		nodev,
#ifdef	QBUS
	elopen,		nodev,		elread,		elwrite,	/*1*/
	nodev,		nodev,		elreset,	0,
	seltrue,	nodev,
#else	QBUS
	sdopen,		nodev,		sdread,		sdwrite,	/*1*/
	nodev,		nodev,		sdreset,	0,
	seltrue,	nodev,
#endif	QBUS
#ifdef	QBUS
	hpopen,		nulldev,	hpread,		hpwrite,	/*2*/
	hpioctl,	nodev,		nulldev,	0,
	seltrue,	nodev,
#else	QBUS
	smopen,		nulldev,	smread,		smwrite,	/*2*/
	nodev,		nodev,		smreset,	0,
	seltrue,	nodev,
#endif	QBUS

#ifdef	QBUS
	rkopen,		nulldev,	rkread,		rkwrite,	/*3*/
	nodev,		nodev,		rkreset,	0,
	seltrue,	nodev,
#else	QBUS
	nodev,		nodev,		nodev,		nodev,		/*3*/
	nodev,		nodev,		nodev,		0,
	nodev,		nodev,
#endif	QBUS
#ifdef	QBUS
	raopen,		nulldev,	raread,		rawrite,	/*4*/
	nodev,		nodev,		rareset,	0,
	seltrue,	nodev,
#else	QBUS
	ldopen,		nodev,		ldread,		ldwrite,	/*4*/
	ldioctl,	nodev,		ldreset,	0,
	seltrue,	nodev,
#endif	QBUS
#ifdef	QBUS
	rlopen,		nodev,		rlread,		rlwrite,	/*5*/
	nodev,		nodev,		rlreset,	0,
	seltrue,	nodev,
#else	QBUS
	nodev,		nodev,		nodev,		nodev,		/*5*/
	nodev,		nodev,		nodev,		0,
	nodev,		nodev,
#endif	QBUS
	rdopen,		nulldev,	rdread,		rdwrite,	/*6*/
	nodev,		nodev,		rdreset,	0,
	seltrue,	nodev,
#ifdef	QBUS
	rxopen,		rxclose,	rxread,		rxwrite,	/*7*/
	rxioctl,	nodev,		rxreset,	0,
	seltrue,	nodev,
	tmopen,		tmclose,	tmread,		tmwrite,	/*8*/
	tmioctl,	nodev,		tmreset,	0,
	seltrue,	nodev,
#else	QBUS
	nodev,		nodev,		nodev,		nodev,		/*7*/
	nodev,		nodev,		nodev,		0,
	nodev,		nodev,
	nodev,		nodev,		nodev,		nodev,		/*8*/
	nodev,		nodev,		nodev,		0,
	nodev,		nodev,
#endif	QBUS
	tsopen,		tsclose,	tsread,		tswrite,	/*9*/
	tsioctl,	nodev,		tsreset,	0,
	seltrue,	nodev,
/*
Would be nice to leave hole here for future block device expansion.
	nodev,		nodev,		nodel,		nodev,		
	nodev,		nodev,		nulldev,	0,
	nodev,		nodev,
*/
	sioopen,	sioclose,	sioread,	siowrite,	/*10*/
	sioioctl,	siostop,	nulldev,	sio_tty,
	ttselect,	nodev,
	syopen,		nulldev,	syread,		sywrite,	/*11*/
	syioctl,	nulldev,	nulldev,	0,
	syselect,	nodev,
	nulldev,	nulldev,	mmread,		mmwrite,	/*12*/
	nodev,		nulldev,	nulldev,	0,
	seltrue,	mmmap,
# ifdef QBUS 
	dzopen,		dzclose,	dzread,		dzwrite,	/*13*/
	dzioctl,	dzstop,		dzreset,	dz_tty,
	ttselect,	nodev,
# else QBUS 
	nodev,		nodev,		nodev,		nodev,		/*13*/
	nodev,		nodev,		nodev,		0,
	nodev,		nodev,
# endif QBUS 

#ifdef	QBUS
	dhopen,		dhclose,	dhread,		dhwrite,	/*14*/
	dhioctl,	dhstop,		dhreset,	dh_tty,
	ttselect,	nodev,
#else	QBUS
	cpopen,		cpclose,	cpread,		cpwrite,	/*14*/
	cpioctl,	cpstop,		cpreset,	cp_tty,
	ttselect,	nodev,
#endif	QBUS

#ifdef	QBUS
	lpopen,		lpclose,	nodev,		lpwrite,	/*15*/
	nodev,		nodev,		lpreset,	0,
	seltrue,	nodev,
#else	QBUS
	nodev,		nodev,		nodev,		nodev,		/*15*/
	nodev,		nodev,		nulldev,	0,
	nodev,		nodev,
#endif	QBUS
	ptsopen,	ptsclose,	ptsread,	ptswrite,	/*16*/
	ptyioctl,	ptsstop,	nodev,		pt_tty,
	ttselect,	nodev,
	ptcopen,	ptcclose,	ptcread,	ptcwrite,	/*17*/
	ptyioctl,	nulldev,	nodev,		pt_tty,
	ptcselect,	nodev,
# ifdef QBUS
	dlopen,		dlclose,	dlread,		dlwrite,	/*18*/
	dlioctl,	dlstop,		nulldev,	dl_tty,
	ttselect,	nodev,
	ibopen,		ibclose,	ibread,		ibwrite,	/*19*/
	ibioctl,	nodev,		nulldev,	0,
	seltrue,	nodev,
# else QBUS
	nodev,		nodev,		nodev,		nodev,		/*18*/
	nodev,		nodev,		nodev,		0,
	nodev,		nodev,
	nodev,		nodev,		nodev,		nodev,		/*19*/
	nodev,		nodev,		nodev,		0,
	nodev,		nodev,
# endif QBUS
	enetopen,	enetclose,	enetread,	enetwrite,	/*20*/
	enetioctl,	nodev,		nulldev,	0,
	enetselect,	nodev,
#ifdef	QBUS
	rpopen,		rpclose,	rpread,		rpwrite,	/*21*/
	rpioctl,	nodev,		nulldev,	0,
	seltrue,	nodev,
#else	QBUS
    	vtopen,		vtclose,	vtread,		vtwrite,	/*21*/
	vtioctl,	nulldev,	nulldev,	vt_tty,
	ttselect,	nodev,
    	fntopen,	fntclose,	fntread,	fntwrite,	/*22*/
	fntioctl,	nulldev,	nulldev,	0,
	nodev,		nodev,
    	nulldev,	nulldev,	nodev,		nodev,		/*23*/
	enpioctl,	nodev,		nulldev,	0,
	nodev,		nodev,
    	nulldev,	nulldev,	enpr_read,	enpr_write,	/*24*/
	enpr_ioctl,	nodev,		nulldev,	0,
	nodev,		nodev,
#endif	QBUS
};

int	nchrdev = sizeof (cdevsw) / sizeof (cdevsw[0]);

int	mem_no = 13; 	/* major device number of memory special file */

int	ipcmaj = 6;

/*
 * Swapdev is a fake device implemented in sw.c used only internally to get to 
 * swstrategy. It cannot be provided to the users, because the swstrategy 
 * routine munches the b_dev and b_blkno entries before calling the appropriate
 * driver.  This would horribly confuse, e.g. the hashing routines. Instead, 
 * /dev/drum is provided as a character (raw) device.
 */
dev_t	swapdev = makedev(SWAPMAJ, 0);
