/* unsigned long remainder: a = a % b */

#include "DEFS.h"

ASENTRY(ulrem)

#ifdef	MC68020
	tstb	is68020
	jeq	2f
    	movl	sp@(4),d1
	divull	sp@(8),d0:d1
	rts
#endif	MC68020

    2:	link	a6,#0
	moveml	#0x3000,sp@-	/* need d2,d3 registers */
	movl	a6@(8),d0	/* dividend */
	movl	d0,d2		/* save dividend */
	movl	a6@(12),d1	/* divisor */

	cmpl	#0x10000,d1	/* divisor < 2 ** 16? */
	jge	1f		/* no, divisor must be < 2 ** 16 */
	clrw	d0		/* d0 = */
	swap	d0		/*    dividend high */
	divu	d1,d0		/* yes, divide */
	movw	d2,d0		/* d0 = remainder high + quotient low */
	divu	d1,d0		/* divide */
	clrw	d0		/* d0 =  */
	swap	d0		/*    remainder */
	jra	4f		/* return */
1:
	movl	d1,d3		/* save divisor */
2:
	asrl	#0x1,d0		/* shift dividend */
	asrl	#0x1,d1		/* shift divisor */
	andl	#0x7FFFFFFF,d0	/* assure positive */
	andl	#0x7FFFFFFF,d1	/*   sign bit */
	cmpl	#0x10000,d1	/* divisor < 2 ** 16? */
	jge	2b		/* no, continue shift */
	divu	d1,d0		/* yes, divide */
	andl	#0xFFFF,d0	/* erase remainder */
	movl	d0,sp@-		/* call ulmul with quotient */
	movl	d3,sp@-		/*   and saved divisor on stack */
	jsr	ulmul		/*   as arguments */
	addql	#0x8,sp		/* restore sp */
	cmpl	d0,d2		/* original dividend >= lmul result? */
				/* (do unsigned compare) */
	jcc	3f		/* yes, quotient should be correct */
	subl	d3,d0		/* no, fixup  */
3:
	subl	d2,d0		/* calculate */
	negl	d0		/*   remainder */
4:
	moveml	sp@+,#0x000C	/* restore registers */
	unlk	a6
	rts
