#include "../h/param.h"
#include "../h/buf.h"
#include "../h/map.h"
#include "../h/vm.h"

#include "../is68kdev/qbvar.h"

#define C (unsigned short *)


extern struct qb_driver GPdriver;
extern Xgpintr0();
struct ivecvec GPint0[] = { {0, Xgpintr0}, {0, 0} };
extern struct qb_driver SDdriver;
extern Xsdintr0();
struct ivecvec SDint0[] = { {0, Xsdintr0}, {0, 0} };
extern struct qb_driver SDdriver;
extern Xsdintr1();
struct ivecvec SDint1[] = { {0, Xsdintr1}, {0, 0} };
extern struct qb_driver LDdriver;
extern Xldintr0();
struct ivecvec LDint0[] = { {0, Xldintr0}, {0, 0} };
extern struct qb_driver LDdriver;
extern Xldintr1();
struct ivecvec LDint1[] = { {0, Xldintr1}, {0, 0} };
extern struct qb_driver SMdriver;
extern Xsmintr0();
struct ivecvec SMint0[] = { {0, Xsmintr0}, {0, 0} };
extern struct qb_driver SMdriver;
extern Xsmintr1();
struct ivecvec SMint1[] = { {0, Xsmintr1}, {0, 0} };
extern struct qb_driver SMdriver;
extern Xsmintr2();
struct ivecvec SMint2[] = { {0, Xsmintr2}, {0, 0} };
extern struct qb_driver TSdriver;
extern Xtsintr0();
struct ivecvec TSint0[] = { {0, Xtsintr0}, {0, 0} };
extern struct qb_driver TSdriver;
extern Xtsintr1();
struct ivecvec TSint1[] = { {0, Xtsintr1}, {0, 0} };
extern struct qb_driver CPdriver;
extern Xcpint0();
struct ivecvec CPint0[] = { {0, Xcpint0}, {0, 0} };
extern struct qb_driver CPdriver;
extern Xcpint1();
struct ivecvec CPint1[] = { {0, Xcpint1}, {0, 0} };
extern struct qb_driver CPdriver;
extern Xcpint2();
struct ivecvec CPint2[] = { {0, Xcpint2}, {0, 0} };
extern struct qb_driver SKdriver;
extern Xskyint0();
struct ivecvec SKint0[] = { {0, Xskyint0}, {0, 0} };
extern struct qb_driver EXdriver;
extern Xexintr0();
struct ivecvec EXint0[] = { {0, Xexintr0}, {0, 0} };
extern struct qb_driver EXdriver;
extern Xexintr1();
struct ivecvec EXint1[] = { {0, Xexintr1}, {0, 0} };
extern struct qb_driver VBdriver;
extern Xvbintr0();
struct ivecvec VBint0[] = { {0, Xvbintr0}, {0, 0} };
extern struct qb_driver ENPdriver;
extern Xenpintr0();
struct ivecvec ENPint0[] = { {0, Xenpintr0}, {0, 0} };

struct qb_ctlr qbcinit[] = {
/*	 driver,	ctlr,	alive,	addr,		intr */
	{ &GPdriver,	0,	0,	C 0x0,	GPint0 },
	{ &SDdriver,	0,	0,	C 0x0,	SDint0 },
	{ &SDdriver,	1,	0,	C 0x0,	SDint1 },
	{ &LDdriver,	0,	0,	C 0x0,	LDint0 },
	{ &LDdriver,	1,	0,	C 0x0,	LDint1 },
	{ &SMdriver,	0,	0,	C 0x0,	SMint0 },
	{ &SMdriver,	1,	0,	C 0x0,	SMint1 },
	{ &SMdriver,	2,	0,	C 0x0,	SMint2 },
	{ &TSdriver,	0,	0,	C 0x0,	TSint0 },
	{ &TSdriver,	1,	0,	C 0x0,	TSint1 },
	{ &CPdriver,	0,	0,	C 0x0,	CPint0 },
	{ &CPdriver,	1,	0,	C 0x0,	CPint1 },
	{ &CPdriver,	2,	0,	C 0x0,	CPint2 },
	{ &SKdriver,	0,	0,	C 0x0,	SKint0 },
	{ &EXdriver,	0,	0,	C 0x0,	EXint0 },
	{ &EXdriver,	1,	0,	C 0x0,	EXint1 },
	{ &VBdriver,	0,	0,	C 0x0,	VBint0 },
	{ &ENPdriver,	0,	0,	C 0x0,	ENPint0 },
	0
};

struct qb_device qbdinit[] = {
	/* driver,  unit, ctlr,  slave,   addr,    pri,    dk, flags*/
	{ &GPdriver,   0,     0,     0,   /* C 0x0, 0, */  0,  0x0 },
	{ &SDdriver,   0,     0,     0,   /* C 0x0, 0, */  1,  0x0 },
	{ &SDdriver,   1,     0,     1,   /* C 0x0, 0, */  1,  0x0 },
	{ &SDdriver,   2,     0,     2,   /* C 0x0, 0, */  1,  0x0 },
	{ &SDdriver,   3,     0,     3,   /* C 0x0, 0, */  1,  0x0 },
	{ &SDdriver,   4,     1,     0,   /* C 0x0, 0, */  1,  0x0 },
	{ &SDdriver,   5,     1,     1,   /* C 0x0, 0, */  1,  0x0 },
	{ &SDdriver,   6,     1,     2,   /* C 0x0, 0, */  1,  0x0 },
	{ &SDdriver,   7,     1,     3,   /* C 0x0, 0, */  1,  0x0 },
	{ &LDdriver,   0,     0,     0,   /* C 0x0, 0, */  1,  0x0 },
	{ &LDdriver,   1,     0,     1,   /* C 0x0, 0, */  1,  0x0 },
	{ &LDdriver,   2,     0,     0,   /* C 0x0, 0, */  1,  0x0 },
	{ &LDdriver,   3,     0,     1,   /* C 0x0, 0, */  1,  0x0 },
	{ &SMdriver,   0,     0,     0,   /* C 0x0, 0, */  1,  0x0 },
	{ &SMdriver,   1,     0,     1,   /* C 0x0, 0, */  1,  0x0 },
	{ &SMdriver,   2,     0,     2,   /* C 0x0, 0, */  1,  0x0 },
	{ &SMdriver,   3,     0,     3,   /* C 0x0, 0, */  1,  0x0 },
	{ &SMdriver,   4,     1,     0,   /* C 0x0, 0, */  1,  0x0 },
	{ &SMdriver,   5,     1,     1,   /* C 0x0, 0, */  1,  0x0 },
	{ &SMdriver,   6,     1,     2,   /* C 0x0, 0, */  1,  0x0 },
	{ &SMdriver,   7,     1,     3,   /* C 0x0, 0, */  1,  0x0 },
	{ &SMdriver,   8,     2,     0,   /* C 0x0, 0, */  1,  0x0 },
	{ &SMdriver,   9,     2,     1,   /* C 0x0, 0, */  1,  0x0 },
	{ &SMdriver,  10,     2,     2,   /* C 0x0, 0, */  1,  0x0 },
	{ &SMdriver,  11,     2,     3,   /* C 0x0, 0, */  1,  0x0 },
	{ &TSdriver,   0,     0,     0,   /* C 0x0, 0, */  0,  0x0 },
	{ &TSdriver,   1,     1,     0,   /* C 0x0, 0, */  0,  0x0 },
	{ &CPdriver,   0,     0,     0,   /* C 0x0, 0, */  0,  0x0 },
	{ &CPdriver,   1,     1,     0,   /* C 0x0, 0, */  0,  0x0 },
	{ &CPdriver,   2,     2,     0,   /* C 0x0, 0, */  0,  0x0 },
	{ &SKdriver,   0,     0,     0,   /* C 0x0, 0, */  0,  0x0 },
	{ &EXdriver,   0,     0,     0,   /* C 0x0, 0, */  0,  0x0 },
	{ &EXdriver,   1,     1,     0,   /* C 0x0, 0, */  0,  0x0 },
	{ &VBdriver,   0,     0,     0,   /* C 0x0, 0, */  0,  0x0 },
	{ &ENPdriver,   0,     0,     0,   /* C 0x0, 0, */  0,  0x0 },
	0
};
