/*	param.c	6.3	84/01/09	*/

/*
 * System parameter formulae.
 *
 * This file is copied into each directory where we compile
 * the kernel; it should be modified there to suit local taste
 * if necessary.
 *
 * Compiled with -DHZ=xx -DTIMEZONE=x -DDST=x -DMAXUSERS=xx
 */

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/socket.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/text.h"
#include "../h/inode.h"
#include "../h/file.h"
#include "../h/callout.h"
#include "../h/clist.h"
#include "../h/cmap.h"
#include "../h/buf.h"
#include "../h/mbuf.h"
#include "../h/nami.h"
#include "../h/quota.h"
#include "../h/kernel.h"

#define	HZ 60
int	hz = HZ;
int	tick = 1000000 / HZ;
struct	timezone tz = { TIMEZONE, DST };

int	rrtimeslice = 10;	/* nth of second round robin time slice */
int	bufpages = 0;		/* user defineable kernel buffers in pages */
int	lockablemem = 0;	/* user defineable lockable mem in pages */
int	detachedmem = 0;	/* user defineable detached mem in pages */

int	maxuprc = MAXUPRC;	/* max number of user processes */
int	monitor_debug = 1;	/* turning on kernel messges */

#define	NPROC (20 + 8 * MAXUSERS)
int	nproc = NPROC;

#ifdef	INET
#define	NETSLOP	20		/* for all the lousy servers */
#else	INET
#define	NETSLOP	0
#endif	INET

#define NCHSIZE (60 + 2 * MAXUSERS)
int	nchsize =	NCHSIZE;
int	ntext = 	24 + MAXUSERS + NETSLOP;
int	ninode = 	(NPROC + 16 + MAXUSERS + (2 * NCHSIZE / 3)) + 32;
int	nfile = 	16 * (NPROC + 16 + MAXUSERS) / 10 + 32 + 2 * NETSLOP;
int	ncallout = 	16 + NPROC;
int	nclist = 	100 + 16 * MAXUSERS;
int	nport = 	NPROC / 2;
int     nmbclusters = 	NMBCLUSTERS;
#ifdef	QUOTA
int	nquota = 	(MAXUSERS * 9)/7 + 3;
int	ndquot = 	(MAXUSERS*NMOUNT)/4 + NPROC;
#endif	QUOTA

/*
 * These are initialized at bootstrap time
 * to values dependent on memory size
 */
int	nbuf, nswbuf;

/*
 * These have to be allocated somewhere; allocating
 * them here forces loader errors if this file is omitted.
 */
struct	proc *proc, *procNPROC;
struct	text *text, *textNTEXT;
struct	inode *inode, *inodeNINODE;
struct	file *file, *fileNFILE;
struct 	callout *callout;
struct	cblock *cfree;
struct	buf *buf, *buf18, *swbuf;
short	*swsize;
int	*swpf;
char	*buffers, *buffers18;
struct	cmap *cmap, *ecmap;
struct	nch *nch;
#ifdef	QUOTA
struct	quota *quota, *quotaNQUOTA;
struct	dquot *dquot, *dquotNDQUOT;
#endif	QUOTA

#ifdef	LOCKF
struct locklist *locklist, *locklistNRLOCKS;
#endif	LOCKF

#ifndef	GWS
GP_fork(){}
GP_initialize() { return 0 ;}
#endif	GWS

#ifndef	BARF
BarfServer(){}
Rexit(n){exit(n);}
MidToRpid(){return 0;}
REMchdirec(){return 1;}
#endif	BARF

#ifndef	WIPC
Wrelse(){}
#endif	WIPC

#ifndef	QUOTA
qtinit(){}
struct quota *
getquota(){ return (struct quota *)0; }
#endif	QUOTA

#include "kg.h"
#if	NKG == 0  &&  Nkg == 0
startkgclock(){}
#endif	NKG == 0  &&  Nkg == 0

#ifndef	GPROF
kmstartup(){}
#endif	GPROF

#ifndef	VB
int vbnum = 0;
int vbreboot(){}
#endif	VB
