# ifndef lint
static char *rcsid ="$Header: order.c,v 1.6 85/08/12 11:25:16 wendyt Exp $";
# endif

# include "mfile2"

/* Ugly macro definitions: */
# ifdef MC68881
# define SUGT(p,q) ((p)->in.su > (q)->in.su || ((p)->in.su == (q)->in.su && (p)->in.sua > (q)->in.sua) || ((p)->in.su == (q)->in.su && (p)->in.sua == (q)->in.sua && (p)->in.suf > (q)->in.suf))
# define SUGE(p,q) ((p)->in.su > (q)->in.su || ((p)->in.su == (q)->in.su && (p)->in.sua > (q)->in.sua) || ((p)->in.su == (q)->in.su && (p)->in.sua == (q)->in.sua && (p)->in.suf >= (q)->in.suf))
# define SUNULL(x) ((x)->in.su == 0 && (x)->in.sua == 0 && (x)->in.suf == 0)
# else MC68881
# define SUGT(p,q) ((p)->in.su > (q)->in.su || ((p)->in.su == (q)->in.su && (p)->in.sua > (q)->in.sua))
# define SUGE(p,q) ((p)->in.su > (q)->in.su || ((p)->in.su == (q)->in.su && (p)->in.sua >= (q)->in.sua))
# define SUNULL(x) ((x)->in.su == 0 && (x)->in.sua == 0)
# endif MC68881

int floatused = 0;
# ifdef SKY
int skyused = 0;	/* in case Sky board accessed for non-floating stuff */
# endif SKY

/*
**	Should the assignment op p be stored, given that it lies as
**	the right operand of o? (or the left, if o==UNARY MUL)
*/
stoasg( p, o ) register NODE *p; {
	return( shltype(p->in.left->in.op, p->in.left ) );

}

/* should we delay the INCR or DECR operation p */
deltest( p ) register NODE *p; {
# ifndef MULTILEVEL
	if ( p->in.op == INCR  && p->in.left->in.op == REG
	  && spsz( p->in.left->in.type, p->in.right->tn.lval )
	  && DECREF(p->in.left->in.type) != DOUBLE )
		return( 0 );		/* STARREG */
# else
	if ( mlmatch(p,DEFINCDEC,INCR)
	  && spsz( p->in.left->in.type, p->in.right->tn.lval ) )
		return( 0 ); /* STARREG */
# endif

	p = p->in.left;
	if ( p->in.op == UNARY MUL ) p = p->in.left;
	return( p->in.op == NAME || p->in.op == OREG || p->in.op == REG );
}

# ifdef FORT
autoincr( p ) NODE *p; {
	register NODE *q = p->in.left, *r;

	if ( q->in.op == INCR && (r=q->in.left)->in.op == REG &&
	    ISPTR(q->in.type) && p->in.type == DECREF(q->in.type) &&
	    tlen(p) == q->in.right->tn.lval ) return(1);

	return(0);
}
# endif FORT

mkadrs(p) register NODE *p; {
	register o;

	if (odebug)
		printf("mkadrs(%o)\n", (long)p);
	o = p->in.op;

	if ( asgop(o) ) {
		if ( SUGE( p->in.left, p->in.right ) ) {
			if ( p->in.left->in.op == UNARY MUL ) {
				if ( !SUNULL( p->in.left ) ) {
					if (p->in.left->in.left->in.op != OREG)
						SETSTO( p->in.left->in.left,
							INTEMP );
					else
						SETSTO( p->in.right, INTEMP);
				} else {
					if ( !SUNULL ( p->in.right ) )
						SETSTO( p->in.right, INTEMP );
					else cerror( "store finds both sides trivial" );
				}
			} else if ( p->in.left->in.op == FLD
			  && p->in.left->in.left->in.op == UNARY MUL )
				SETSTO( p->in.left->in.left->in.left, INTEMP );
			else {
				if (p->in.left->in.op == OREG)
					SETSTO( p->in.right, INTEMP );
				else
					SETSTO( p->in.left, INTEMP );
			}
		} else SETSTO( p->in.right, INTEMP );
	} else {
		if ( SUGT( p->in.left, p->in.right ) )
			SETSTO( p->in.left, INTEMP );
		else
			SETSTO( p->in.right, INTEMP );
	}
}

/*
**	Is it legal to make an OREG or NAME entry which has an ** offset of off,
**	(from a register of r), if the resulting thing had type t?
*/
notoff( t, r, off, cp) TWORD t; CONSZ off; char *cp; {

	if ( off>=-32768 && off<=32767 && *cp=='\0' && r>=A0 && r<=SP )
		return(0);	/* YES */
	return( 1 );  /* NO */
}

# define max(x,y) ((x)<(y)?(y):(x))
# define min(x,y) ((x)<(y)?(x):(y))


# define ZCHAR 01
# define ZLONG 02
# define ZFLOAT 04

# ifdef BOZO
/*
** OK, I'll admit it; I don't see the good of this,
** and it seems to cause trouble -WAT-
*/
zum( p, zap ) register NODE *p; {
	/* zap Sethi-Ullman number for chars, longs, floats */
	/* in the case of longs, only STARNM's are zapped */
	/* ZCHAR, ZLONG, ZFLOAT are used to select the zapping */

	register su;

	su = p->in.su;

	switch( p->in.type ) {

	case CHAR:
	case UCHAR:
		if ( !(zap&ZCHAR) ) break;
		if ( su==0 && p->in.op!=ICON ) p->in.su = su = 1;
		break;

	case LONG:
	case ULONG:
		if ( !(zap&ZLONG) ) break;
		if ( p->in.op == UNARY MUL && su == 0 ) p->in.su = su = 2;
		break;

	case FLOAT:
		if ( !(zap&ZFLOAT) ) break;
		if ( su == 0 ) p->in.su = su = 1;

	}

	return( su );
}
# else BOZO
zum( p, zap ) register NODE *p; {
	return (p->in.su);
}
# endif BOZO

sucomp( p ) register NODE *p; {

	/* set the su field in the node to the sethi-ullman
	   number, or local equivalent */

	register o, ty, sul, sur;
	register nr;
	int sual, suar;
# ifdef MC68881
	int sufl, sufr;
# endif MC68881

	ty = optype( o=p->in.op);
	nr = szty( p->in.type );
	p->in.su = 0;
	p->in.sua = 0;
# ifdef MC68881
	p->in.suf = 0;
# endif MC68881

# ifndef BOZO
	if ( ty == LTYPE )
		return;
# else BOZO
	if ( ty == LTYPE ) {
		if ( o == REG ) {
			if ( istreg(p->tn.rval) ) {
				if ( ISFLOAT(p->in.type) ) {
# ifdef MC68881
					p->in.suf = 1;
# else MC68881
					if ( p->in.type == DOUBLE ) {
/*						Bug fix? */
						if ( fregs > 2 )
							p->in.su = 2;
						else
							p->in.su = fregs+1;
					}
					else
						p->in.su = 1;
# endif MC68881
				}
				else if ( ISPTR(p->in.type) )
					p->in.sua = 1;
				else
					p->in.su = 1;
			}
		}
		return;
	}
# endif BOZO
	else if ( ty == UTYPE ) {
		switch( o ) {
		case UNARY CALL:
		case UNARY STCALL:
# ifdef FORT
		case UNARY FORTCALL:
# endif FORT
			p->in.su = fregs;  	/* all data regs needed */
			p->in.sua = faregs;	/* all address regs, too */
# ifdef MC68881
			p->in.suf = ffregs;	/* ditto for floating regs */
# endif MC68881
			return;

		case UNARY MUL:
			if ( shumul( p->in.left ) ) return;

		default:
# ifdef MC68881
			if ( ISFLOAT( p->in.type ) ) {
				p->in.suf = max( p->in.left->in.suf, 1);
				p->in.su = p->in.left->in.su;
			} else {
				p->in.suf = p->in.left->in.suf;
				p->in.su = max( p->in.left->in.su, nr);
			}
# else MC68881
			p->in.su = max( p->in.left->in.su, nr);
# endif MC68881
			if ( ISPTR( p->in.type ) )
				p->in.sua = max( p->in.left->in.sua, 1);
			else
				p->in.sua = p->in.left->in.sua;
			return;
		}
	}


	/* If rhs needs n, lhs needs m, regular su computation */

	sul = p->in.left->in.su;
	sur = p->in.right->in.su;
	sual = p->in.left->in.sua;
	suar = p->in.right->in.sua;
# ifdef MC68881
	sufl = p->in.left->in.suf;
	sufr = p->in.right->in.suf;
# endif MC68881

	if ( o == ASSIGN ) {

asop:  /* also used for +=, etc., to memory */

# ifdef MC68881
		if ( sul==0 && sual==0 && sufl==0) {
			/* don't need to worry about the left side */
			if ( ISFLOAT(p->in.type) ) {
				p->in.su = sur;
				p->in.sua = suar;
				p->in.suf = max( sufr, 1 );
			} else if ( ISPTR(p->in.type) ) {
				p->in.su = sur;
				p->in.sua = max( suar, nr );
				p->in.suf = sufr;
			} else {
				p->in.su = max( sur, nr );
				p->in.sua = suar;
				p->in.suf = sufr;
			}
		} else {
			/* right, left address, op */
			if ( sur == 0 && suar == 0 && sufr == 0 ) {
				/* just get the lhs address into a register */
				/* and mov; the `nr' covers the case where */
				/* value is in reg afterwards */
				if ( ISPTR(p->in.type) ) {
					p->in.su = sul;
					p->in.sua = max( sual, nr );
					p->in.suf = sufl;
				} else if ( ISFLOAT(p->in.type) ) {
					p->in.su = sul;
					p->in.sua = sual;
					p->in.suf = max( sufl, 1 );
				} else {
					p->in.su = max( sul, nr );
					p->in.sua = sual;
					p->in.suf = sufl;
				}
			} else {
				if ( ISPTR(p->in.type) ) {
					p->in.su = sul;
					p->in.sua = max( suar, nr+sual );
					p->in.suf = sufl;
				} else if ( ISFLOAT(p->in.type) ) {
					p->in.su = sul;
					p->in.sua = sual;
					p->in.suf = max( sufr, 1+sufl );
				} else {
					p->in.su = max( sur, nr+sul );
					p->in.sua = sual;
					p->in.suf = sufl;
				}
			}
		}
		return;
# else MC68881
		if ( sul==0 && sual==0 ) {
			/* don't need to worry about the left side */
			if ( ISPTR(p->in.type) ) {
				p->in.su = sur;
				p->in.sua = max( suar, nr );
			} else {
				p->in.su = max( sur, nr );
				p->in.sua = suar;
			}
		} else {
			/* right, left address, op */
			if ( sur == 0 && suar == 0 ) {
				/* just get the lhs address into a register */
				/* and mov; the `nr' covers the case where */
				/* value is in reg afterwards */
				if ( ISPTR(p->in.type) ) {
					p->in.su = sul;
					p->in.sua = max( sual, nr );
				} else {
					p->in.su = max( sul, nr );
					p->in.sua = sual;
				}
			} else {
				if ( ISPTR(p->in.type) ) {
					p->in.su = sul;
					p->in.sua = max( suar, nr+sual );
				} else {
					p->in.su = max( sur, nr+sul );
					p->in.sua = sual;
				}
			}
		}
		return;
# endif MC68881
	}

	if ( o == CALL || o == STCALL ) {
		/* in effect, takes all free registers */
		p->in.su = fregs;
		p->in.sua = faregs;
		p->in.suf = ffregs;
		return;
	}

	if ( o == STASG ) {
		/* right, then left */
		p->in.su = max( max( sul+nr, sur), fregs );
		return;
	}

	if ( logop(o) ) {
		/* do the harder side, then the easier side, into registers */
		/* left then right, max(sul,sur+nr) */
		/* right then left, max(sur,sul+nr) */
		/* to hold both sides in regs: nr+nr */
		nr = szty( p->in.left->in.type );
# ifdef BOZO
		sul = zum( p->in.left, ZLONG|ZCHAR|ZFLOAT );
		sur = zum( p->in.right, ZLONG|ZCHAR|ZFLOAT );
		p->in.su = min( max(sul,sur+nr), max(sur,sul+nr) );
# endif BOZO
# ifdef MC68881
		if (ISPTR(p->in.type)) {
			p->in.su = max(sul, sur);
			p->in.sua = min(max(sual, nr+suar), max(suar, nr+sual));
			p->in.suf = max(sufl, sufr);
		} else if (ISFLOAT(p->in.type)) {
			p->in.su = max(sul, sur);
			p->in.sua = max(sual, suar);
			p->in.suf = min(max(sufl, nr+sufr), max(sufr, nr+sufl));
		} else {
			p->in.su = min(max(sul, nr+sur), max(sur, nr+sul));
			p->in.sua = max(sual, suar);
			p->in.suf = max(sufl, sufr);
		}
# else MC68881
		if (ISPTR(p->in.type)) {
			p->in.su = max(sul, sur);
			p->in.sua = min(max(sual, nr+suar), max(suar, nr+sual));
		} else {
			p->in.su = min(max(sul, nr+sur), max(sur, nr+sul));
			p->in.sua = max(sual, suar);
		}
# endif MC68881
		return;
	}

	if ( asgop(o) ) {
		/* computed by doing right, doing left address, doing left, op, and store */
		switch( o ) {
		  case INCR:
		  case DECR:
# ifdef MC68881
			if ( !ISFLOAT(p->in.type) )
				break;
# else MC68881
			/* do as binary op */
			break;
# endif MC68881

		  case ASG PLUS:
		  case ASG MINUS:
		  case ASG AND:
		  case ASG ER:
		  case ASG OR:
			if ( p->in.type == INT || p->in.type == UNSIGNED
			  || ISPTR(p->in.type) ) goto asop;

		  default:
# ifdef BOZO
			sur = zum( p->in.right, ZCHAR|ZLONG|ZFLOAT );
			if ( sur == 0 ) { /* easy case: if addressable,
				do left value, op, store */
				if ( sul == 0 ) p->in.su = nr;
				/* harder: left adr, val, op, store */
				else p->in.su = max( sul, nr+1 );
			} else { /* do right, left adr, left value, op, store */
				if ( sul == 0 ) /* right, left value,op,store */
					p->in.su = max( sur, nr+nr );
				else
					p->in.su = max( sur,
					  max( sul+nr, 1+nr+nr ) );
			}
# else BOZO
			if ( SUNULL(p->in.right) ) {
				/* easy case: */
				/*if addressable, do left value, op, store */
				if ( SUNULL(p->in.left) ) {
					if (ISPTR(p->in.type))
						p->in.sua = nr;
# ifdef MC68881
					else if (ISFLOAT(p->in.type))
						p->in.suf = 1;
# endif MC68881
					else
						p->in.su = nr;
				} else {
				/* harder: left adr, val, op, store */
# ifdef MC68881
					if (ISPTR(p->in.type)) {
						p->in.su = sul;
						p->in.sua = max(sual, nr+1);
						p->in.suf = sufl;
					} else if (ISFLOAT(p->in.type)) {
						p->in.su = sul;
						p->in.sua = sual;
						p->in.suf = max(sufl, 2);
					} else {
						p->in.su = max(sul, nr+1);
						p->in.sua = sual;
						p->in.suf = sufl;
					}
# else MC68881
					if (ISPTR(p->in.type)) {
						p->in.su = sul;
						p->in.sua = max(sual, nr+1);
					} else {
						p->in.su = max(sul, nr+1);
						p->in.sua = sual;
					}
# endif MC68881
				}
			} else { /* do right, left adr, left value, op, store */
				if (SUNULL(p->in.left)) {
				/* right, left value,op,store */
# ifdef MC68881
					if (ISPTR(p->in.type)) {
						p->in.su = sur;
						p->in.sua = max(suar, nr+nr);
						p->in.suf = sufr;
					} else if (ISFLOAT(p->in.type)) {
						p->in.su = sur;
						p->in.sua = suar;
						p->in.suf = max(sufr, 2);
					} else {
						p->in.su = max(sur, nr+nr);
						p->in.sua = suar;
						p->in.suf = sufr;
					}
# else MC68881
					if (ISPTR(p->in.type)) {
						p->in.su = sur;
						p->in.sua = max(suar, nr+nr);
					} else {
						p->in.su = max(sur, nr+nr);
						p->in.sua = suar;
					}
# endif MC68881
				} else {
# ifdef MC68881
					if (ISPTR(p->in.type)) {
						p->in.su = sur;
						p->in.sua = max(suar,
						  max(sual+nr, 1+nr+nr));
						p->in.suf = sufr;
					} else if (ISFLOAT(p->in.type)) {
						p->in.su = sur;
						p->in.sua = suar;
						p->in.suf = max(sufr,
						  max(sufl+1, 3));
					} else {
						p->in.su = max(sur,
						  max(sul+nr, 1+nr+nr));
						p->in.sua = suar;
						p->in.suf = sufr;
					}
# else MC68881
					if (ISPTR(p->in.type)) {
						p->in.su = sur;
						p->in.sua = max(suar,
						  max(sual+nr, 1+nr+nr));
					} else {
						p->in.su = max(sur,
						  max(sul+nr, 1+nr+nr));
						p->in.sua = suar;
					}
# endif MC68881
				}
			}
# endif BOZO
			return;
		}
	}

	switch( o ) {
	  case ANDAND:
	  case OROR:
	  case QUEST:
	  case COLON:
	  case COMOP:
		p->in.su = max( max(sul,sur), nr);
		p->in.sua = max(sual,suar);
# ifdef MC68881
		p->in.suf = max(sufl,sufr);
# endif MC68881
		return;
	}

# ifdef MC68881

	if ( ISFLOAT( p->in.type ) && (o == PLUS || o == MUL) ) {
		if (!(istnode( p->in.left ) || SUGT(p->in.left, p->in.right))) {
			NODE *s;
			int ssu;

			ssu = sul;  sul = sur; sur = ssu;
			ssu = sual;  sual = suar; suar = ssu;
			ssu = sufl;  sufl = sufr; sufr = ssu;

			s = p->in.left;
			p->in.left = p->in.right;
			p->in.right = s;
		}
/*
**	Since I don't see the good of zum, I'll ignore it for now
**	sur = zum( p->in.right, ZCHAR|ZLONG|ZFLOAT );
*/
		if ( sur == 0 && suar == 0 && sufr == 0 ) {
			/* get left value into a register, do op */
			/* Use 1 instead of nr; doubles fit in one fp reg */
			p->in.su = sul;
			p->in.sua = sual;
			p->in.suf = max( 1, sufl );
		}
		else {
			/* do "harder into a register, then "easier" */
/*
** There are still problems with this scheme,
** but let's try it for now.
*/
			if ( SUGT(p->in.left, p->in.right) ) {
				p->in.su = sul;
				p->in.sua = sual;
				p->in.suf = max( 1, sufl );
			} else {
				p->in.su = sur;
				p->in.sua = suar;
				p->in.suf = max( 1, sufr );
			}
		}
	}

# endif MC68881

	if ( o==LS || o==RS )
		if ( p->in.right->in.op != ICON  || p->in.right->tn.lval > 8)
			nr += 1;
# ifdef MC68020
	if ( o == MUL && p->in.right->in.op == ICON && !ISFLOAT(p->in.type) )
		nr += 1;
# else MC68020
	if ( !ISFLOAT(p->in.type) ) {
		if ( o==DIV || o==MOD || o==MUL ) 
			if ( o == MUL && p->in.right->in.op == ICON)
				nr += 1;
			else
				nr = fregs;
	}
# endif MC68020


	if ( o==PLUS || o==MUL || o==OR || o==ER ) {
		/* AND is ruined by the hardware */
		/* permute: get the harder on the left */

		register rt, lt;

		if ( istnode( p->in.left ) || SUGT(p->in.left, p->in.right) )
			goto noswap;

		/* look for a funny type on the left, one on the right */

		lt = p->in.left->in.type;
		rt = p->in.right->in.type;

# ifndef MC68881
		if ( rt == FLOAT && lt == DOUBLE ) goto swap;
# endif MC68881

		if ( (rt==CHAR||rt==UCHAR)
		  && (lt==INT||lt==UNSIGNED||ISPTR(lt)) ) goto swap;

		if ( lt==LONG || lt==ULONG ) {
			if ( rt==LONG || rt==ULONG ) {
				/* if one is a STARNM, swap */
				if ( p->in.left->in.op == UNARY MUL
				  && SUNULL(p->in.left) )
					goto noswap;
				if ( p->in.right->in.op == UNARY MUL
				  && p->in.left->in.op != UNARY MUL )
					goto swap;
				goto noswap;
			}
			else if ( p->in.left->in.op == UNARY MUL
			  && SUNULL(p->in.left) )
				goto noswap;
			else
				goto swap;  /* long on right, unless STARNM */
		}

		/* we are finished with the type stuff now;  */
		/* if one is addressable, put it on the right */

		if ( SUNULL(p->in.left) && !SUNULL(p->in.right) ) {

			NODE *s;
			int ssu;

swap:
			ssu = sul;  sul = sur; sur = ssu;
			ssu = sual;  sual = suar; suar = ssu;
# ifdef MC68881
			ssu = sufl;  sufl = sufr; sufr = ssu;
# endif MC68881
			s = p->in.left;
			p->in.left = p->in.right;
			p->in.right = s;

		}
	}
noswap:

	sur = zum( p->in.right, ZCHAR|ZLONG|ZFLOAT ); /* NO WAY this is right */
# ifdef MC68881
	if ( sur == 0 && suar == 0 && sufr == 0 ) {
		/* get left value into a register, do op */
		if ( ISFLOAT(p->in.type) ) {
			p->in.su = sul;
			p->in.sua = sual;
			p->in.suf = max( 1, sufl );
		} else if ( ISPTR(p->in.type) ) {
			p->in.su = sul;
			p->in.sua = max( 1, sual );
			p->in.suf = sufl;
		} else {
			p->in.su = max( nr, sul );
			p->in.sua = sual;
			p->in.suf = sufl;
		}
	} else {
		/* do harder into a register, then easier */

		if ( ISFLOAT(p->in.type) ) {
			p->in.su = max(sul,sur);
			p->in.sua = max(sual,suar);
			p->in.suf = max( 2,
			  min( max( sufl, 1+sufr ), max( sufr, 1+sufl ) ) );
		} else if ( ISPTR(p->in.type) ) {
			p->in.su = max(sul,sur);
			p->in.sua = max( 2,
			  min( max( sual, 1+suar ), max( suar, 1+sual ) ) );
			p->in.suf = max(sufl,sufr);
		} else {
			p->in.su = max( nr+nr,
			  min( max( sul, nr+sur ), max( sur, nr+sul ) ) );
			p->in.sua = max(sual,sufl);
			p->in.suf = max(sufl,sufr);
		}
	}
# else MC68881
	if ( sur == 0 && suar == 0 ) {
		/* get left value into a register, do op */
		if ( ISPTR(p->in.type) ) {
			p->in.su = sul;
			p->in.sua = max( 1, sual );
		} else {
			p->in.su = max( nr, sul );
			p->in.sua = sual;
		}
	} else { /* do harder into a register, then easier */

		if ( ISPTR(p->in.type) ) {
			p->in.su = max(sul,sur);
			p->in.sua = max( 2,
			  min( max( sual, 1+suar ), max( suar, 1+sual ) ) );
		} else {
			p->in.su = max( nr+nr,
			  min( max( sul, nr+sur ), max( sur, nr+sul ) ) );
			p->in.sua = max(sual,suar);
		}
	}
# endif MC68881
}

int radebug = 0;

# ifdef BOZO
THIS SEEMS NOT TO BE NEEDED -- ONLY FOR VAX?
mkrall( p, r ) register NODE *p; {
	/* insure that the use of p gets done with register r; in effect, */
	/* simulate offstar */

	if ( p->in.op == FLD ) {
		p->in.left->in.rall = p->in.rall;
		p = p->in.left;
	}

	if ( p->in.op != UNARY MUL ) return;  /* no more to do */
	p = p->in.left;
	if ( p->in.op == UNARY MUL ) {
		p->in.rall = r;
		p = p->in.left;
	}
	if ( p->in.op == PLUS && p->in.right->in.op == ICON ) {
		p->in.rall = r;
		p = p->in.left;
	}
	rallo( p, r );
}
# endif BOZO

rallo( p, down ) register NODE *p; {
	/* do register allocation */
	register o, type, down1, down2, ty;

	if ( radebug ) {
		printf( "rallo( %lo, %o )\n", (long)p, down );
		if (radebug > 1) {
			printf("on rallo entry, p is:\n");
			fwalk(p, eprint, 0);
		}
	}

/*	Let's try to keep the D1|MUSTDO under ASG MUL, etc. WAT */

	if (((o = p->in.op) == ASG MUL || o == ASG DIV || o == ASG MOD)
	  && p->in.right->in.rall == (D1|MUSTDO) && p->in.right->in.op != ICON
	  && (p->in.right->in.op != REG || p->in.right->tn.rval != D1))
		down2 = D1|MUSTDO;
	else
		down2 = NOPREF;

	p->in.rall = down;
	down1 = ( down &= ~MUSTDO );

	ty = optype( o = p->in.op );
	type = p->in.type;


# ifdef MC68881
	if ( type == DOUBLE || type == FLOAT ) {
		if ( o == FORCE ) down1 = F0|MUSTDO;
		floatused = 1;
	}
# else MC68881
	if ( type == DOUBLE || type == FLOAT ) {
		if ( o == FORCE ) down1 = D0|MUSTDO;
		floatused = 1;
	}
# endif MC68881
	else switch( o ) {
	  case ASSIGN:	
		down1 = NOPREF;
		down2 = down;
		break;

/*	  case ASG MUL:
/*	  case ASG DIV:
/*	  case ASG MOD:
/*		/* keep the addresses out of the hair of (r0,r1) */
/*		if (fregs == 2 ) {
/*			/* lhs in (r0,r1), nothing else matters */
/*			down1 = D1|MUSTDO;
/*			down2 = NOPREF;
/*			break;
/*			}
/*		/* at least 3 regs free */
/*		/* compute lhs in (r0,r1), address of left in r2 */
/*		p->in.left->in.rall = D1|MUSTDO;
/*		mkrall( p->in.left, D2|MUSTDO );
/*		/* now, deal with right */
/*		if ( fregs == 3 ) rallo( p->in.right, NOPREF );
/*		else {
/*			/* put address of long or value here */
/*			p->in.right->in.rall = D3|MUSTDO;
/*			mkrall( p->in.right, D3|MUSTDO );
/*			}
/*		return;
/* */

# ifndef MC68020 /* */
# ifndef NFSKY
	  case MUL:
	  case DIV:
	  case MOD:
		if ((p->in.type == INT || p->in.type == UNSIGNED ||
		     ISPTR(p->in.type)) && p->in.right->in.op != ICON) {
			down1 = D0|MUSTDO;
			down2 = D1|MUSTDO;
		}
		break;
# endif NFSKY
# endif MC68020 /* */

	  case CALL:
	  case STASG:
	  case EQ:
	  case NE:
	  case GT:
	  case GE:
	  case LT:
	  case LE:
	  case NOT:
	  case ANDAND:
	  case OROR:
		down1 = NOPREF;
		break;

	  case FORCE:	
		down1 = D0|MUSTDO; /* Note FLOAT/DOUBLE handled above */
		break;

	}

	if ( ty != LTYPE ) rallo( p->in.left, down1 );
	if ( ty == BITYPE ) rallo( p->in.right, down2 );

	if (radebug > 1) {
		printf("on rallo exit, p is:\n");
		fwalk(p, eprint, 0);
	}
}

/* handle indirections */
offstar( p ) register NODE *p; {

	if ( p->in.op == UNARY MUL ) p = p->in.left;

	if ( p->in.op == PLUS || p->in.op == MINUS ) {
		if ( p->in.right->in.op == ICON && p->in.right->in.name[0]=='\0'
		  && p->in.right->tn.lval >= -32768
		  && p->in.right->tn.lval <= 32767 ) {
			order( p->in.left , INTBREG|INBREG );
			return;
		}
	}
	order( p, INTBREG|INBREG );
}

setincr( p ) NODE *p; {
	return( 0 );	/* for the moment, don't bother */
}

niceuty( p ) register NODE *p; {
	register TWORD t;

	return( p->in.op == UNARY MUL && (t=p->in.type)!=CHAR && t!= UCHAR
# ifndef MC68881
	  && t!= FLOAT
# endif MC68881
	  && shumul( p->in.left) != STARREG );
}

setbin( p ) register NODE *p; {
	register NODE *r, *l;

	r = p->in.right;
	l = p->in.left;

	if ( SUNULL(p->in.right) ) { /* rhs is addressable */
		if ( logop( p->in.op ) ) {
			if ( l->in.op == UNARY MUL && l->in.type != FLOAT
			  && shumul( l->in.left ) != STARREG )
				offstar( l->in.left );
# ifdef MC68881
			else if (ISFLOAT(l->in.type))
				order( l, INFREG|INTFREG|INTEMP );
# endif MC68881
			else order( l, INAREG|INTAREG|INBREG|INTBREG|INTEMP );
			return( 1 );
		}
		if ( !istnode( l ) ) {
			if ((p->in.op == PLUS  ||  p->in.op == MINUS)) {
				if (ISPTR(p->in.type)) {
					order( l, INBREG );
					return( 1 );
				}
# ifdef MC68881
				else if (ISFLOAT(p->in.type)) {
					order( l, INFREG );
					return( 1 );
				}
# endif MC68881
				order( l, INAREG|INBREG );
				return( 1 );
			}
# ifdef MC68881
			if (ISFLOAT(p->in.type)) /* changed l to p - WAT */
				order( l, INFREG );
			else
				order( l, INAREG );
# else MC68881
			order( l, INAREG );
# endif MC68881
# ifndef MC68020 /* */
			if ((p->in.type == INT || p->in.type == UNSIGNED) &&
			  (p->in.op == DIV || p->in.op == MOD ||
			  (p->in.op == MUL && p->in.right->in.op != ICON)))
				order( r, INAREG );
# endif MC68020 /* */
			return( 1 );
		}
		/* rewrite */
		return( 0 );
	}
	/* now, rhs is complicated: must do both sides into registers */
	/* do the harder side first */

	if ( logop( p->in.op ) ) {
		/* relational: do both sides into regs if need be */

		if ( SUGT(r, l) ) {
			if ( niceuty(r) ) {
				offstar( r->in.left );
				return( 1 );
			} else if ( !istnode( r ) ) {
# ifdef MC68881
				if ( ISFLOAT(r->in.type ))
					order( r, INTFREG|INFREG|INTEMP );
				else
					order( r, INTAREG|INAREG|INTBREG
					  |INBREG|INTEMP );
# else MC68881
				order(r, INTAREG|INAREG|INTBREG|INBREG|INTEMP);
# endif MC68881
				return( 1 );
			}
		}
		if ( niceuty(l) ) {
			offstar( l->in.left );
			return( 1 );
		} else if ( !istnode( l ) ) {
# ifdef MC68881
			if ( ISFLOAT(l->in.type ))
				order( l, INTFREG|INFREG|INTEMP );
			else
				order( l, INTAREG|INAREG|INTBREG|INBREG|INTEMP );
# else MC68881
			order( l, INTAREG|INAREG|INTBREG|INBREG|INTEMP );
# endif MC68881
			return( 1 );
		} else if ( niceuty(r) ) {
			offstar( r->in.left );
			return( 1 );
		}
		if ( !istnode( r ) ) {
# ifdef MC68881
			if ( ISFLOAT(r->in.type ))
				order( r, INTFREG|INFREG|INTEMP );
			else
				order( r, INTAREG|INAREG|INTBREG|INBREG|INTEMP );
# else MC68881
			order( r, INTAREG|INAREG|INTBREG|INBREG|INTEMP );
# endif MC68881
			return( 1 );
		}
		cerror( "setbin can't deal with %s", opst[p->in.op] );
	}

	/* ordinary operator */

	if ( !istnode(r) && SUGT(r,l)) {
		/* if there is a chance of making it addressable, try it... */
		if ( niceuty(r) ) {
			offstar( r->in.left );
			return( 1 );  /* hopefully, it is addressable by now */
		}

# ifdef MC68881
		if ( ISFLOAT(r->in.type ))
			order( r, INTFREG|INFREG|INTEMP );
		else
			order( r, INTAREG|INAREG|INTEMP );
# else MC68881
		order( r, INTAREG|INAREG|INTEMP );
# endif MC68881
		return( 1 );
	} else {
		if ( !istnode( l ) ) {
			if ((p->in.op == PLUS  ||  p->in.op == MINUS)) {
				if (ISPTR(p->in.type)) {
					order( l, INBREG );
					return( 1 );
				}
# ifdef MC68881
				else if (ISFLOAT(p->in.type)) {
					order( l, INFREG );
					return( 1 );
				}
# endif MC68881
				order( l, INAREG|INBREG );
				return( 1 );
			}
# ifdef MC68881
			if (ISFLOAT(l->in.type))
				order( l, INFREG );
			else
				order( l, INAREG );
# else MC68881
			order( l, INAREG );
# endif MC68881
			return( 1 );
		}
		/* rewrite */
		return( 0 );
	}
}

setstr( p ) register NODE *p; { /* structure assignment */
	if ( p->in.right->in.op != REG ) {
		order( p->in.right, INTBREG );
		return(1);
	}
	p = p->in.left;
	if ( p->in.op != NAME && p->in.op != OREG ) {
		if ( p->in.op != UNARY MUL ) cerror( "bad setstr" );
		order( p->in.left, INTBREG );
		return( 1 );
	}
	return( 0 );
}

/* setup for assignment operator */
setasg( p, cookie ) register NODE *p; {

# ifdef NOTNOW
/*	This code has caused many problems; let's try leaving it out */

	if ( p->in.left->in.op == REG && p->in.right->in.op == SCONV &&
# ifdef SKY
 	    p->in.right->in.left->in.type != DOUBLE &&
 	    p->in.right->in.left->in.type != FLOAT &&
# endif SKY
	    p->in.right->in.left->in.type != CHAR &&
	    p->in.right->in.left->in.type != SHORT &&
	    (cookie & (INTAREG|INTBREG)) == 0 ) {

		register NODE *q = p->in.right;
		register t = q->in.left->in.type;
		NODE temp;

		p->in.type = t;
		p->in.left->in.type = t;
		ncopy (&temp, p);
		ncopy (p, q);
		ncopy (q, &temp);
		q->in.right = p->in.left;
		p->in.left = q;
		if (p->in.right == q) p->in.right = p;	/* tidy */
		return(1);
	}

# endif NOTNOW

	if ( p->in.right->in.su != 0 && p->in.right->in.op != REG ) {
		if ( p->in.right->in.op == UNARY MUL )
			offstar( p->in.right->in.left );
# ifdef MC68881
		else if (p->in.right->in.op == ASSIGN) {
			if ( ISFLOAT(p->in.right->in.type) )
				order( p->in.right, INFREG );
			else
				order( p->in.right, INAREG|INBREG );
		} else {
			if ( ISFLOAT(p->in.right->in.type) )
				order( p->in.right, INFREG|SOREG|SNAME|SCON );
			else
				order( p->in.right,
				  INAREG|INBREG|SOREG|SNAME|SCON );
		}
# else MC68881
		else if (p->in.right->in.op == ASSIGN)
			order( p->in.right, INAREG|INBREG );
		else
			order( p->in.right, INAREG|INBREG|SOREG|SNAME|SCON );
# endif MC68881
		return(1);
	}
	if ( p->in.left->in.op == UNARY MUL
	  && !tshape( p->in.left, STARREG|STARNM ) ) {
		offstar( p->in.left->in.left );
		return(1);
	}
	if ( p->in.left->in.op == FLD
	  && p->in.left->in.left->in.op == UNARY MUL ) {
		offstar( p->in.left->in.left->in.left );
		return(1);
	}
	/* if things are really strange, get rhs into a register */
	if ( p->in.right->in.op != REG ) {
# ifdef MC68881
		if ( ISFLOAT(p->in.right->in.type) )
			order( p->in.right, INFREG );
		else
			order( p->in.right, INAREG|INBREG );
# else MC68881
		order( p->in.right, INAREG|INBREG );
# endif MC68881
		return( 1 );
	}
	return(0);
}


setasop( p ) register NODE *p; {
	/* setup for =ops */
	register sul, sual;
# ifdef MC68881
	register sufl;
# endif MC68881
	register NODE *q, *p2;

	sul = p->in.left->in.su;
	sual = p->in.left->in.sua;
# ifdef MC68881
	sufl = p->in.left->in.suf;
# endif MC68881

	switch( p->in.op ) {
	  case ASG PLUS:
	  case ASG MINUS:
	  case ASG OR:
	  case ASG ER:
	  case ASG AND:
# ifdef MC68881
		if (p->in.right->in.op != REG && sul == 0 && sual == 0
		  && sufl == 0) {
			if (ISFLOAT(p->in.type)) {
				if (p->in.right->in.op == SCONV
				  && SUNULL(p->in.right->in.left)) {
					p2 = tcopy( p->in.right->in.left );
					reclaim( p->in.right, RNULL, 0 );
					p->in.right = p2;
				} else
		  			order(p->in.right,INFREG|INTFREG);
			} else
		  		order(p->in.right,INAREG|INTAREG);
			return(1);
		} else break;
# else MC68881
		if (p->in.right->in.op != REG && sul == 0 && sual == 0) {
			order(p->in.right,INAREG|INTAREG);
			return(1);
		} else break;
# endif MC68881

	  case ASG LS:
	  case ASG RS:
		if ( niceuty(p->in.left) )
			offstar( p->in.left );
		if (p->in.left->in.op != REG) return(0);
		if (p->in.right->in.op == REG ||
		  (p->in.right->in.op==ICON && p->in.right->tn.lval>=1
		  && p->in.right->tn.lval<=8))
			break;
		order(p->in.right,INAREG|INTAREG);
		return(1);

	  case ASG MUL:
	  case ASG DIV:
	  case ASG MOD:
# ifdef MC68020
# ifdef MC68881
		if (sul == 0 && sual == 0 && sufl == 0
		  && !SUNULL(p->in.right)) {
			if (ISFLOAT(p->in.type)) {
				if (p->in.right->in.op == SCONV
				  && SUNULL(p->in.right->in.right)) {
					p2 = tcopy( p->in.right->in.left );
					reclaim( p->in.right, RNULL, 0 );
					p->in.right = p2;
				} else
		  			order(p->in.right,INFREG|INTFREG);
			} else
		  		order(p->in.right,INAREG|INTAREG);
			return(1);
		} else break;
# else MC68881
		if (sul == 0 && sual == 0 && !SUNULL(p->in.right)) {
			order(p->in.right,INAREG|INTAREG);
			return(1);
		} else break;
# endif MC68881
# else MC68020
# ifdef SKY
		if (ISFLOAT(p->in.left->in.type))
		  && optype(p->in.right->in.op) != LTYPE
		  && (sul == 0 || p->in.left->in.op == OREG)) {
			order(p->in.right,INAREG|INTAREG);
			return(1);
		}
# endif SKY
/*
**		Passing parameters to mul, div, etc. was done too quickly.
**		Some loose ends were left around.  One problem was that
**		the D1|MUSTDO was sometimes not taking effect; another was
**		that under some circumstances the compiler wished to take
**		D1 op D0 rather than D0 op D1.  The following kludge handles
**		these problems.       - The Unknown Programmer
*/
		if (p->in.right->in.rall == (D1|MUSTDO)) {
			if (p->in.right->in.op == REG) {
				if (p->in.right->tn.rval == D0 &&
				  p->in.left->tn.rval == D1) {
					NODE *pp;

					expand(p, FOREFF, "\texg\td0,d1\n");
					pp = p->in.left;
					p->in.left = p->in.right;
					p->in.right = pp;
					p->in.right->in.rall = D1|MUSTDO;
					p->in.left->in.rall = D0|MUSTDO;
				} else if (p->in.right->tn.rval != D1) {
					order(p->in.right, INTAREG|INTAREG);
					return 1;
				}
			} else if (p->in.right->in.op != ICON ||
			  p->in.op != ASG MUL) {
				order( p->in.right, INAREG|INTAREG);
				return 1;
			}
		}
/*
**		End of kludge
*/
# endif MC68020
		if (p->in.right->in.op == REG || SUNULL(p->in.right)) break;
		order(p->in.right,INAREG|INTAREG);
		/* RHS is now simple */
		if (p->in.left->in.op == REG) return (1);
	}

	if ( SUNULL(p->in.right) ) {

	leftadr:
		/* easy case: if addressable, do left value, op, store */
		if ( SUNULL(p->in.left) ) goto rew;  /* rewrite */

		/* harder; make aleft address, val, op, and store */

		if ( p->in.left->in.op == UNARY MUL ) {
			offstar( p->in.left->in.left );
			return( 1 );
		}
		if ( p->in.left->in.op == FLD
		  && p->in.left->in.left->in.op == UNARY MUL ) {
			offstar( p->in.left->in.left->in.left );
			return( 1 );
		}

	rew:	/* rewrite, accounting for autoincrement and autodecrement */

		q = p->in.left;
		if ( q->in.op == FLD ) q = q->in.left;
		if ( q->in.op != UNARY MUL || shumul(q->in.left) != STARREG )
			return(0); /* let reader.c do it */

		/* mimic code from reader.c */

		p2 = tcopy( p );
		p->in.op = ASSIGN;
		reclaim( p->in.right, RNULL, 0 );
		p->in.right = p2;

		/* now, zap INCR on right, ASG MINUS on left */

		if ( q->in.left->in.op == INCR ) {
			q = p2->in.left;
			if ( q->in.op == FLD ) q = q->in.left;
			if ( q->in.left->in.op != INCR )
				cerror( "bad incr rewrite" );
		} else if ( q->in.left->in.op != ASG MINUS )
			cerror( " bad -= rewrite" );

		q->in.left->in.right->in.op = FREE;
		q->in.left->in.op = FREE;
		q->in.left = q->in.left->in.left;

		/* now, resume reader.c rewriting code */

		canon(p);
		rallo( p, p->in.rall );
# ifdef MC68881
		if ( ISFLOAT(p2->in.left->in.type) )
			order( p2->in.left, INTFREG );
		else
			order( p2->in.left, INTBREG|INTAREG );
		if ( ISFLOAT(p2->in.type) )
			order( p2, INTFREG );
		else
			order( p2, INTBREG|INTAREG );
# else MC68881
		order( p2->in.left, INTBREG|INTAREG );
		order( p2, INTBREG|INTAREG );
# endif MC68881
		return( 1 );
	}

	/* harder case: do right, left address, left value, op, store */

	if ( p->in.right->in.op == UNARY MUL && p->in.left->in.op==REG) {
		offstar( p->in.right->in.left );
		return( 1 );
	}
	/* sur> 0, since otherwise, done above */
	if ( p->in.right->in.op == REG ) goto leftadr;
# ifdef MC68881
	if ( ISFLOAT(p->in.right->in.type) )
		order( p->in.right, INFREG );
	else
		order( p->in.right, INAREG|INBREG );
# else MC68881
	order( p->in.right, INAREG|INBREG );
# endif MC68881
	return( 1 );
}

int crslab = 10000;

getlab() {
	return( crslab++ );
}

deflab( l ) {
	printf( "L%d:\n", (int)l );
}

genargs( p) register NODE *p; {
	register size,inc;

	/* generate code for the arguments */

	/*  first, do the arguments on the right (last->first) */
	while( p->in.op == CM ) {
		genargs( p->in.right );
		p->in.op = FREE;
		p = p->in.left;
	}

	if ( p->in.op == STARG ) { /* structure valued argument */

		size = p->stn.stsize;
		if ( p->in.left->in.op == ICON ) {
			/* make into a name node */
			p->in.op = FREE;
			p= p->in.left;
			p->in.op = NAME;
		} else {
			/* make it look beautiful... */
			p->in.op = UNARY MUL;
			canon( p );  /* turn it into an oreg */
			while( p->in.op == UNARY MUL ) {
				offstar( p->in.left );
				canon( p );
			}
		}

		p->tn.lval += size;  /* end of structure */
		/* put on stack backwards */
		for( ; size>0; size -= inc ) {
			inc = (size>2) ? 4 : 2;
			p->tn.lval -= inc;
			expand( p, RNOP,
			  (inc==4) ? "\tmovl\tAR,Z-\n" : "\tmovw\tAR,Z-\n" );
		}
		reclaim( p, RNULL, 0 );
		return;
	}

	/* ordinary case */

	order( p, FORARG );
}

argsize( p ) register NODE *p; {
	register t;
	t = 0;
	if ( p->in.op == CM ) {
		t = argsize( p->in.left );
		p = p->in.right;
	}
# ifdef IEEE
	if (p->in.type == DOUBLE ) {
		SETOFF( t, 2 );
		return( t+8 );
	} else if (p->in.type == FLOAT ) {
		SETOFF( t, 2 );
		return( t+4 );
	}
# else IEEE
	if ( p->in.type == DOUBLE || p->in.type == FLOAT ) {
		SETOFF( t, 2 );
		return( t+8 );
	}
# endif IEEE
	else if ( p->in.op == STARG ) {
		SETOFF( t, p->stn.stalign );  /* alignment */
		return( t + p->stn.stsize );  /* size */
	} else {
		SETOFF( t, 2 );
		return( t+4 );
	}
}
