/* a lot of the machine dependent parts of the second pass */

# ifndef lint
static char *rcsid ="$Header: local2.c,v 1.5 85/08/12 11:46:41 wendyt Exp $";
# endif

# undef NOREGMULDIV
# include "mfile2"

# define BITMASK(n) ((1L<<n)-1)

# ifdef FORT
# define OLDPROLOG
# endif
# ifdef WENDY
extern int wdebug;
# endif WENDY

/* identify line l and file fn */
lineid( l, fn ) char *fn; {
	printf( "/*	line %d, file %s */\n", (int)l, fn );
}

CONSZ usedregs;	/* flag word for registers used in current routine */
# ifdef MC68881
CONSZ usedfregs; /* flag word for floating registers used in current routine */
		/* NOTE: bit order is opposite of usedregs */
# endif MC68881
int maxtoff = 0;
extern prtnum;

cntbits(i) register int i; {
	register int j,ans;

	for (ans=0, j=0; i!=0 && j<16; j++) {
		if (i&1) ans++;
		i>>= 1;
	}
	return(ans);
}

# ifdef ONEPASS
extern int retlab;
# endif ONEPASS

# define MAXSTACK 32767

eobl2(){
	OFFSZ spoff;	/* offset from stack pointer */

	spoff = maxoff;
	spoff /= SZCHAR;
	SETOFF(spoff,2);
	usedregs &= 0x3cfc;	/* only save regs used for reg vars */
# ifdef MC68881
# ifdef BACKWARDS
	usedfregs &= 0xfc;	/* only save regs used for reg vars */
# else BACKWARDS
	usedfregs &= 0x3f;	/* only save regs used for reg vars */
# endif BACKWARDS
# endif MC68881

# ifdef SKY
/*
**	In the past (OLDPROLOG), the mv of skyaddr into a5 (or a4) occurred at
**	the beginning of each routine.  It was, therefore, necessary to restore
**	a5 (or a4) at the end.
**
**	Now, however, the prolog code is actually generated at the end of
**	things, and the Sky register need not be saved unless it is used.
*/
# ifdef FORT
	usedregs |= 1<<(8+5);
	if (floatused || skyused)
		usedregs |= 1<<(8+4);
# else FORT
# ifdef OLDPROLOG
	usedregs |= 1<<(8+5);
# else OLDPROLOG
	if (floatused || skyused)
		usedregs |= 1<<(8+5);
# endif OLDPROLOG
# endif FORT
# endif SKY

	spoff += 4*cntbits(usedregs);	/* save at base of stack frame */
# ifdef MC68881
	spoff += 20*cntbits(usedfregs);	/* save at base of stack frame */
# endif MC68881

	if (prtnum)
		printf("/*epilog*/\n");

# ifdef OLDPROLOG
/*	Avoid illegal/incorrect link instruction */
	if (spoff > MAXSTACK)
		uerror("stack length > 32K");
# endif OLDPROLOG

# ifdef ONEPASS
	printf( "L%d:", (int)retlab);
# endif ONEPASS

# ifdef OLDPROLOG
	if (usedregs)
		printf( "	moveml	sp@,#0x%x\n", (int)usedregs );
# ifdef MC68881
	if (usedfregs) {
		if (usedregs)
			printf( "	fmovemx	sp@(%d),#0x%x\n",
				4*cntbits(usedregs), (int)usedfregs );
		else
			printf( "	fmovemx	sp@,#0x%x\n", (int)usedfregs );
	}
# endif MC68881
	printf( "	unlk	fp\n" );
	printf( "	rts\n" );
# else OLDPROLOG
# ifdef MC68881
	if (usedregs || usedfregs) {
# else MC68881
	if (usedregs) {
# endif MC68881
		if (spoff >= 32768) {
			printf("\taddl\t#_F%d,fp\n", ftnno);
			if (mypow2(usedregs) >= 0)
				printf( "\tmovl\tfp@,%s\n",
					rnames[mypow2(usedregs)] );
			else if (usedregs > 0)
				printf("\tmoveml\tfp@,#0x%x\n", (int)usedregs);
# ifdef MC68881
			if (usedfregs > 0)
				printf("\tfmovemx\tfp@,#0x%x\n",(int)usedfregs);
# endif MC68881
			printf("\tsubl\t#_F%d,fp\n", ftnno);
		} else {
			if (mypow2(usedregs) >= 0)
				printf( "\tmovl\tfp@(_F%d),%s\n", ftnno,
					rnames[mypow2(usedregs)] );
			else if (usedregs > 0)
				printf( "	moveml	fp@(_F%d),#0x%x\n",
					ftnno, (int)usedregs );
# ifdef MC68881
			if (usedfregs > 0) {
				if (mypow2(usedfregs) >= 0)
				    printf("\tfmovx\tfp@(_F%d+%d),%s\n",
				      ftnno, 4*cntbits(usedregs),
# ifdef BACKWARDS
				      rnames[mypow2(usedfregs)+F0]);
# else BACKWARDS
				      rnames[F7-mypow2(usedfregs)]);
# endif BACKWARDS
				else 
				    printf("\tfmovemx\tfp@(_F%d+%d),#0x%x\n",
				      ftnno, 4*cntbits(usedregs),
				      (int)usedfregs );
			}
# endif MC68881
		}
	}
	printf( "	unlk	fp\n" );
	printf( "	rts\n" );
	prprolog(spoff);
# endif OLDPROLOG

	printf( "_F%d = %d\n", (int)ftnno, -(int)spoff );
	printf( "_S%d = 0x%x\n", (int)ftnno, (int)usedregs );
# ifdef MC68881
	printf( "_G%d = %d\n", (int)ftnno, 4*cntbits(usedregs) );
	printf( "_T%d = 0x%x\n", (int)ftnno, (int)usedfregs );
# endif MC68881
/*	printf( "| M%d = %d\n", (int)ftnno, (int)maxtoff );
/* */
	maxtoff = 0;
	if ( floatused ) {
		floatused = 0;
		printf( "	.globl	fltused\n" );
	}
}


# ifndef OLDPROLOG
extern int	prolab, pblab;

prprolog(spoff) OFFSZ spoff; {
	if (prtnum)
		printf("/*prolog*/\n");

	deflab(prolab);

	if (spoff >= 32768) {
		printf("	movl	fp,sp@-\n");
		printf("	movl	sp,fp\n");
		printf("	addl	#_F%d,sp\n", ftnno);
	} else
		printf( "	link	fp,#_F%d\n", ftnno );

	if (usedregs) {
		if (mypow2(usedregs) >= 0)
			printf( "\tmovl\t%s,sp@\n", rnames[mypow2(usedregs)] );
		else
			printf( "	moveml	#0x%x,sp@\n", (int)usedregs );
	}
# ifdef MC68881
	if (usedfregs) {
		int froff;

		if (mypow2(usedfregs) >= 0)
# ifdef BACKWARDS
			printf("\tfmovx\t%s,sp@", rnames[mypow2(usedfregs)+F0]);
# else BACKWARDS
			printf("\tfmovx\t%s,sp@", rnames[F7-mypow2(usedfregs)]);
# endif BACKWARDS
		else
			printf( "	fmovemx	#0x%x,sp@", (int)usedfregs );

		if (froff = 4*cntbits(usedregs))
			printf("(%d)\n", froff);
		else
			printf("\n");
	}
# endif MC68881
# ifdef SKY
	if (floatused || skyused) {
		printf("	movl	_skyaddr,");
		skyref();
		printf("\n");
		printf("\taddql	#4,");
		skyref();
		printf("\n");
		skyused = 0;
	}
# endif SKY
	branch(pblab);
}
# endif OLDPROLOG

struct hoptab { int opmask; char * opstring; } ioptab[]= {

	ASG PLUS, "add",
	ASG MINUS, "sub",
	ASG OR,	"or",
	ASG AND, "and",
	ASG ER,	"eor",
	ASG MUL, "mul",
	ASG DIV, "div",
	ASG MOD, "div",
	ASG LS,	"sl",
	ASG RS,	"sr",

	-1, ""    };

hopcode( f, o ){
	/* output the appropriate string from the above table */

	register struct hoptab *q;

	for( q = ioptab;  q->opmask>=0; ++q ){
		if ( q->opmask == o ){
			printf( "%s", q->opstring );
			if ( f == 'F' ) printf( "f" );
			return;
		}
	}
	cerror( "no hoptab for %s", opst[o] );
}

char *
rnames[]= {  /* keyed to register number tokens */

	"d0", "d1", "d2", "d3", "d4", "d5", "d6", "d7",
	"a0", "a1", "a2", "a3", "a4", "a5", "fp", "sp",
# ifdef MC68881
	"f0", "f1", "f2", "f3", "f4", "f5", "f6", "f7",
# endif MC68881
	};

int rstatus[] = {
	SAREG|STAREG, SAREG|STAREG,
	SAREG|STAREG, SAREG|STAREG,
	SAREG|STAREG, SAREG|STAREG,
	SAREG|STAREG, SAREG|STAREG,

	SBREG|STBREG, SBREG|STBREG,
	SBREG|STBREG, SBREG|STBREG,
	SBREG|STBREG, SBREG|STBREG,
	SBREG,	      SBREG,

# ifdef MC68881
	SFREG|STFREG, SFREG|STFREG,
	SFREG|STFREG, SFREG|STFREG,
	SFREG|STFREG, SFREG|STFREG,
	SFREG|STFREG, SFREG|STFREG,
# endif MC68881
};

tlen(p) NODE *p; {
	switch (p->in.type) {
	  case CHAR:
	  case UCHAR:
		return(1);

	  case SHORT:
	  case USHORT:
		return(2);

	  case DOUBLE:
		return(8);

	  default:
		return(4);
	}
}

NODE *brnode;
int brcase;

int toff = 0; /* number of stack locations used for args */
static int regval ;  /* kludge for (ptr double)++ stuff */

/*
**	I've hacked this zzzcode to recieve a pointer to a character,
**	return the number of char positions to increment the pointer
**	(normally zero).  This allows for zzzcode with more than one
**	character, e.g., Zlr.		-WAT-
*/
zzzcode( p, pc ) NODE *p; char *pc; {
	register m,temp;
	register char c = *pc;

	switch ( c ){

	  case 'C':
		switch (p->in.left->in.op) {
		  case ICON:	if ( p->in.left->in.name[0] == '\0' )
					printf("\tjsr\t");
				else
					printf("\tjbsr\t");
				acon(p->in.left);
				return 0;

		  case REG:	printf("\tjsr\t");
				adrput(p->in.left);
				printf("@");
				return 0;

		  case NAME:
		  case OREG:	printf("\tmovl\t");
				adrput(p->in.left);
				printf(",a0\n\tjsr\ta0@");
				return 0;

		  default:	cerror("bad subroutine name");
		}

	  case 'B':	/* output b if type is byte */
		if (logop(p->in.op)) p = p->in.left;
		if ( p->in.type == CHAR || p->in.type == UCHAR ) printf( "b" );
		else if ( p->in.type == SHORT || p->in.type == USHORT )
			printf( "w" );
		else printf( "l" );
		return 0;

	  case 'N':  /* logical ops, turned into 0-1 */
		/* use register given by register 1 */
		cbgen( 0, m=getlab(), 'I' );
		deflab( p->bn.label );
		printf( "	clrl	%s\n",
		  rnames[temp = getlr( p, '1' )->tn.rval] );
		usedregs |= 1<<temp;
		deflab( m );
		p->in.type = INT;
		return 0;

	  case 'I':
	  case 'F':
# ifdef MC68881
	  case 'J':
	  case 'K':
# endif MC68881
		cbgen( p->in.op, p->bn.label, c );
		return 0;

		/* stack management macros */
# ifdef MC68881
	  case '=':
		toff += 4;	/* Need double increment */
# endif MC68881
	  case '-':
		printf( "sp@-" );
	  case 'P':
		toff += 4;
		if (toff > maxtoff) maxtoff = toff;
		return 0;

	  case '0':
		toff = 0; return 0;

	  case '~':
		/* complimented CR */
		p->in.right->tn.lval = ~p->in.right->tn.lval;
		conput( getlr( p, 'R' ) );
		p->in.right->tn.lval = ~p->in.right->tn.lval;
		return 0;

	  case 'M':
		/* negated CR */
		p->in.right->tn.lval = -p->in.right->tn.lval;
	  case 'O':
# ifdef FORT
		if ((p->in.right->tn.lval != 0) || p->in.right->in.name ) {
# else FORT
		if (p->in.right->tn.lval != 0) {
# endif FORT
			printf ("(");
			conput( getlr( p, 'R' ) );
			printf (")");
		}
		p->in.right->tn.lval = -p->in.right->tn.lval;
		return 0;

	  case 'T':
		/* Truncate longs for type conversions:
		    INT|UNSIGNED -> CHAR|UCHAR|SHORT|USHORT
		   increment offset to second word */

		m = p->in.type;
		p = p->in.left;
		switch ( p->in.op ){
		  case OREG:
# ifdef MC68020
			if (p->in.type==SHORT || p->in.type==USHORT)
				temp = (m==CHAR || m==UCHAR) ? 1 : 0;
			else temp = (m==CHAR || m==UCHAR) ? 3 : 2;
			if (p->orn.memind)
				p->orn.odisp += temp;
			else
				p->orn.disp += temp;
			return 0;
# endif MC68020
		  case NAME:
			if (p->in.type==SHORT || p->in.type==USHORT)
				p->tn.lval += (m==CHAR || m==UCHAR) ? 1 : 0;
			else p->tn.lval += (m==CHAR || m==UCHAR) ? 3 : 2;
			return 0;
		  case REG:
# ifdef FORT
		  case ICON:
# endif FORT
			return 0;

		  default:
			cerror( "Illegal ZT type conversion" );
			return 0;

		}

	  case 'U':
		cerror( "Illegal ZU" );
		/* NO RETURN */

	  case 'W':	/* structure size */
		if ( p->in.op == STASG )
			printf( "%d", (int)p->stn.stsize);
		else	cerror( "Not a structure" );
		return 0;

	  case 'S':  /* structure assignment */
		{
			register NODE *l, *r;
			register size, i;

			if ( p->in.op == STASG ){
				l = p->in.left;
				r = p->in.right;
			} else if ( p->in.op == STARG )
			/* store an arg onto the stack */
				r = p->in.left;
			else cerror( "STASG bad" );

			if ( r->in.op == ICON ) r->in.op = NAME;
			else if ( r->in.op == REG ) {
				r->in.op = OREG;
# ifdef MC68020
				r->orn.memind = 0;
				r->orn.index = -1;
				r->orn.scale = 0;
# endif MC68020
			} else if ( r->in.op != OREG ) cerror( "STASG-r" );

			size = p->stn.stsize;

			while( size ){ /* simple load/store loop */
				if (size == 1) {
					i = size;
					expand( r, FOREFF,"\tmovb\tAR,");
				} else {
					i = (size > 3) ? 4 : 2;
					expand( r, FOREFF,
					  (i==2)?"\tmovw\tAR,":"\tmovl\tAR," );
				}
				expand( l, FOREFF, "AR\n" );
				size -= i;
				r->tn.lval += i;
				l->tn.lval += i;
			}
			r->tn.lval -= size;
			l->tn.lval -= size;

			if ( r->in.op == NAME ) r->in.op = ICON;
			else if ( r->in.op == OREG ) r->in.op = REG;

		}
		break;

	  case 'D':  /* kudge to fix up increment on ptr to double */
		if (p->in.op == OREG && regval != -1)
			printf("\taddql\t#4,%s\n",rnames[regval]);
		break;

# ifdef FORT
	  case 'G':
		switch (p->in.left->in.op) {

		  case ICON:	printf("\tjra\t");
				acon(p->in.left);
				return 0;

		  case REG:	printf("\tjmp\t");
				adrput(p->in.left);
				printf("@");
				return 0;

		  case NAME:
		  case OREG:	printf("\tmovl\t");
				adrput(p->in.left);
				printf(",a0\n\tjmp\ta0@");
				return 0;

		  default:	cerror("bad subroutine name");
		}
# endif FORT

# ifdef SKY
	  case 'L':	/* implement delay code for Sky board */
		deflab(temp=getlab());
		expand(p, FOREFF, "\ttstw\tZA@(-2)\n");
		printf("\tbges\tL%d\n", temp);
		return 0;

# ifdef BOZO
/* appears to me this isn't used anywhere, so I'll use the Zl case elsewhere */
	  case 'l':	/* another flavor of Sky delay */
		deflab(temp=getlab());
		expand(p, FOREFF, "\tmovw\tZA@(-2),A1\n\tbtst\t#14,A1\n");
		printf("\tbeqs\tL%d\n", temp);
		return 0;
# endif BOZO

	  case 'A':	/* reference register with Sky board data reg address */
		skyref();
		return 0;

	  case 'u':	/* Turn on skyused so sky address will go in register */
		skyused = 1;
		return 0;

	  case 'v':	/* Do other Sky unsigned to float/double conversions */
		skyuconv(p);
		return 0;
# else SKY
	  case 'H':	/* Rerun hardops on trees produced from ++,-- */
		{
		NODE *sresc;

		ncopy( sresc=talloc(), resc );
		if (prtnum) printf("/* ZH */\n");
		expand(p, FOREFF, "\tmovl\tAL,A1\n");
		if (p->in.left->in.type == DOUBLE) {
			if (prtnum) printf("/* ZH */\n");
			expand(p, FOREFF, "\tmovl\tUL,U1\n");
		}
		if (p->in.op == INCR)
			p->in.op = ASG PLUS;
		else if (p->in.op == DECR)
			p->in.op = ASG MINUS;
		else
			cerror("zzzcode: bad H op");
		hardops(p);
		order(p, INAREG);
		ncopy(resc, sresc);	/* restore A1, I hope */
		tfree(sresc);
		return 0;
		}

# ifdef MC68881
	  case 'v':	/* UINT->FLOAT|DOUBLE conversions */
		if (prtnum)
				printf("/* UINT->FLOAT|DOUBLE */\n");
		expand(p, FOREFF, "\tmovl\tAL,A1\n\tbclr\t#31,A1\n\tfmovl\tA1,A2\n");
		temp = getlab();
		printf("\tbeqs\tL%d\n", temp);
		expand(p, FOREFF, "\tfaddd\t#0f2147483648.,A2\n");
		deflab(temp);
		return;
# endif MC68881
# endif SKY

# ifdef MC68881
	  case 'f':
	  case 'l':
	  case 'r':
	  case '1':
	  case '2':
	  case '3':
		setatype(p, c, *++pc);	/* Do 68881 address type */
		return 1;
	  case 'w':
		setrndmd(p, *++pc, *++pc); /* Set rounding mode */
		return 2;
	  case 'x':
		clrrndmd(p); /* Reset rounding mode */
		return 0;
# endif MC68881

	  case 'V':	/* Do conversions for calls */
		faconv(p);
		return 0;

# ifndef OLDMUL
	  case 'm':	/* do multiplies by shifting and adding */
		if (mulshift(p, 0)) {
			if (prtnum)
				printf("/* Zm: (*=%d) */\n",
				  p->in.right->tn.lval);
# ifdef MC68020
			expand(p, FOREFF, "\tmulsl\tAR,AL\n");
# else MC68020
# ifdef NFSKY
			expand(p, FOREFF,
			  "\tmovw\t#0x1046,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tAR,ZA@\n\tmovl\tZA@,AL\n");

# else NFSKY
			expand(p, FOREFF,
			  "\tmovl\tAL,Z-\n\tmovl\tAR,Z-\n\tjsr\tlmul\n\taddql\t#8,sp\n");
# endif NFSKY
# endif MC68020
		} else
			mulshift(p,1);
		return 0;
# endif OLDMUL

	  default:
		cerror( "illegal zzzcode (%c)", c);
	}
	return 0;
}

# ifdef MC68881
int rndmdset = 0;
/*
**	This is another one of those awful kludges.  Its purpose is
**	to set the rounding mode for float/double->int/char/short conversions.
*/
setrndmd( p, c, d ) NODE *p; {
	NODE *t1, *t2, *t3;

	if (rndmdset)
		cerror("setrndmd: out of phase");
	switch (c) {
	  case 'f':
		t1 = p;
		break;
	  case 'l':
		t1 = p->in.left;
		break;
	  case 'r':
		t1 = p->in.right;
		break;
	  case '1':
		t1 = &resc[0];
		break;
	  case '2':
		t1 = &resc[1];
		break;
	  case '3':
		t1 = &resc[2];
		break;
	  default:
		cerror("setrndmd: illegal argument(%c)", c);
	}

	switch (d) {
	  case 'f':
		t2 = p;
		break;
	  case 'l':
		t2 = p->in.left;
		break;
	  case 'r':
		t2 = p->in.right;
		break;
	  case '1':
		t2 = &resc[0];
		break;
	  case '2':
		t2 = &resc[1];
		break;
	  case '3':
		t2 = &resc[2];
		break;
	  default:
		cerror("setrndmd: illegal argument(%c)", d);
	}

	if (t1 && t1->in.op == REG && isfreg(t1->tn.rval)) {
		if (t2 && t2->in.op == REG && isfreg(t2->tn.rval)) {
			return;		/* Leave rounding mode alone */
		} else {
			t3 = t2;
		}
	} else if (t2 && t2->in.op == REG && isfreg(t2->tn.rval)) {
		t3 = t1;
	} else cerror("setrndmd: Neither side is FREG");
	if (!ISFLOAT(t3->in.type)) {
		expand(p, FOREFF, "\tfmovl\t#0x20,fpcr\n");
		rndmdset = 1;
	}
}

clrrndmd(p) NODE *p; {
	if (rndmdset) {
		rndmdset = 0;
		expand(p, FOREFF, "\tfmovl\t#0x0,fpcr\n");
	}
}

setatype( p, c, d ) NODE *p; {
	NODE *t1, *t2, *t3;

	switch (c) {
	  case 'f':
		t1 = p;
		break;
	  case 'l':
		t1 = p->in.left;
		break;
	  case 'r':
		t1 = p->in.right;
		break;
	  case '1':
		t1 = &resc[0];
		break;
	  case '2':
		t1 = &resc[1];
		break;
	  case '3':
		t1 = &resc[2];
		break;
	  default:
		cerror("setatype: illegal argument(%c)", c);
	}

	switch (d) {
	  case 'f':
		t2 = p;
		break;
	  case 'l':
		t2 = p->in.left;
		break;
	  case 'r':
		t2 = p->in.right;
		break;
	  case '1':
		t2 = &resc[0];
		break;
	  case '2':
		t2 = &resc[1];
		break;
	  case '3':
		t2 = &resc[2];
		break;
	  default:
		cerror("setatype: illegal argument(%c)", d);
	}

	if (t1 && t1->in.op == REG && isfreg(t1->tn.rval)) {
		if (t2 && t2->in.op == REG && isfreg(t2->tn.rval)) {
			printf( "x" );
			return;
		} else {
			t3 = t2;
		}
	} else if (t2 && t2->in.op == REG && isfreg(t2->tn.rval)) {
		t3 = t1;
	} else cerror("setatype: Neither side is FREG");
	if ( t3->in.type == CHAR || t3->in.type == UCHAR ) printf( "b" );
	else if ( t3->in.type == SHORT || t3->in.type == USHORT ) printf( "w" );
	else if ( t3->in.type == FLOAT ) printf( "s" );
	else if ( t3->in.type == DOUBLE ) printf( "d" );
	else printf( "l" );
	return;
}
# endif MC68881


# ifdef SKY
skyref() {
# ifdef FORT
	printf("a4");
# else FORT
	printf("a5");
# endif FORT
}
# endif

/*
**	The following unwholesome routine is a desperate attempt to
**	deal with some serious conversion problems.  It deals with type
**	conversions in things ordered FORARG.
**	It is hoped that this routine will keep table.c somewhat readable
**	and make compilation a bit faster.
**
**	If cases seem to be missing, it is either because the work is done
**	elsewhere or because I am rather dense. -WT-
*/
faconv(p) NODE *p; {
	int type, ltype, savregnum;
# ifdef SKY
	int lab;
# endif SKY


	if (edebug) {
		printf("faconv(0x%x->0x%x)\n", p->in.type,p->in.left->in.type);
		printf("A1 is %d, A2 is %d, A3 is %d\n", resc[0].tn.rval,
			resc[1].tn.rval, resc[2].tn.rval);
	}
	if (edebug > 1)
		fwalk(p, eprint, 0);


# ifdef MC68881
	if (!tshape(p->in.left, SNAME|SOREG|SCON|STARREG|SAREG|SBREG|SFREG)) {
# else MC68881
	if (!tshape(p->in.left, SNAME|SOREG|SCON|STARREG|SAREG|SBREG)) {
# endif MC68881
/*
**	Yuk! The order below may come up with a different A1, which may not
**	be an AREG (for instance, if the order created an OREG).
**	In that case, reassign the original A1.
*/
		savregnum = resc[0].tn.rval;

# ifdef MC68881
		if ( ISFLOAT(p->in.left->in.type) )
			order( p->in.left, INFREG|INTFREG|INTEMP );
		else
			order( p->in.left, INAREG|INTAREG|INTEMP );
# else MC68881
		order( p->in.left, INAREG|INTAREG|INTEMP );
# endif MC68881
		if (edebug) {
			printf("after order, A1 is %d, A2 is %d, A3 is %d\n",
			    resc[0].tn.rval, resc[1].tn.rval, resc[2].tn.rval);
		}
		if (resc[0].tn.rval != savregnum)
			resc[0].tn.rval = savregnum;
	}

	type = p->in.type;
	if (ISPTR(type))
		type = UNSIGNED;
	ltype = p->in.left->in.type;
	if (ISPTR(ltype))
		ltype = UNSIGNED;

	switch (type) {
	  case SHORT:
		switch (ltype) {
		  case INT:
		  case LONG:
		  case UNSIGNED:
		  case ULONG:
			if (prtnum)
				printf("/* (U)INT->SHORT->INT */\n");
			expand( p, FOREFF, "\tmovw\tAL,A1\n\textl\tA1\n\tmovl\tA1,Z-\n");
			return;
		  default:
			cerror("bad conversion (%d->%d)", ltype, type);
		}
	  case USHORT:
		switch (ltype) {
		  case INT:
		  case LONG:
		  case UNSIGNED:
		  case ULONG:
			if (prtnum)
				printf("/* (U)INT->USHORT->INT */\n");
			expand( p, FOREFF, "\tmovw\tAL,A1\n\tandl\t#0xffff,A1\n\tmovl\tA1,Z-\n");	/* Don't want to clobber AL if AL==A1 */
			return;
		  default:
			cerror("bad conversion (%d->%d)", ltype, type);
		}
	  case INT:
	  case LONG:
	  case UNSIGNED:
	  case ULONG:
		switch (ltype) {
		  case INT:
		  case LONG:
		  case UNSIGNED:
		  case ULONG:
			if (prtnum)
				printf("/* (U)INT->(U)INT */\n");
			expand( p,FOREFF, "\tmovl\tAL,Z-\n");
			return;
# ifdef SKY
		  case FLOAT:
			if (prtnum)
				printf("/* FLOAT->(U)INT */\n");
			expand(p, FOREFF, "\tmovw\t#0x1027,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tZA@,Z-\n");
			return;
		  case DOUBLE:
			if (prtnum)
				printf("/* DOUBLE->(U)INT */\n");
			expand(p, FOREFF, "\tmovw\t#0x1045,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tUL,ZA@\n\tmovl\tZA@,Z-\n");
			return;
# endif SKY
# ifdef MC68881
		  case FLOAT:
			if (prtnum)
				printf("/* FLOAT->(U)INT */\n");
			expand(p, FOREFF, "\tfmovs\tAL,A1\n\tfmovl\tA1,Z-\n");
			return;
		  case DOUBLE:
			if (prtnum)
				printf("/* DOUBLE->(U)INT */\n");
			expand(p, FOREFF, "\tfmovd\tAL,A1\n\tfmovl\tA1,Z-\n");
			return;
# endif MC68881
		  case CHAR:
			if (prtnum)
				printf("/* CHAR->(U)INT */\n");
			expand( p,FOREFF, "\tmovb\tAL,A1\n\textw\tA1\n\textl\tA1\n\tmovl\tA1,Z-\n");
			return;
		  case SHORT:
			if (prtnum)
				printf("/* SHORT->(U)INT */\n");
			expand( p,FOREFF, "\tmovw\tAL,A1\n\textl\tA1\n\tmovl\tA1,Z-\n");
			return;
		  case UCHAR:
/*
**	Unfortunately, A1 may have been used as the register into which to
**	evaluate p->left.  In this case, starting out by clearing A1 is a
**	losing proposition.  I could go back and get an A2, but I prefer to
**	do it this way.  The extra cost should be fairly rare.
*/
			if (prtnum)
				printf("/* UCHAR->(U)INT */\n");
			if (p->in.left->in.op == REG
			  && p->in.left->tn.rval == resc[0].tn.rval)
				expand( p,FOREFF, "\tandl\t#0xff,A1\n\tmovl\tA1,Z-\n");
			else
				expand( p,FOREFF, "\tclrl\tA1\n\tmovb\tAL,A1\n\tmovl\tA1,Z-\n");
			return;

		  case USHORT:
			if (prtnum)
				printf("/* USHORT->(U)INT */\n");
			if (p->in.left->in.op == REG
			  && p->in.left->tn.rval == resc[0].tn.rval)
				expand( p,FOREFF, "\tandl\t#0xffff,A1\n\tmovl\tA1,Z-\n");
			else
				expand( p,FOREFF, "\tclrl\tA1\n\tmovw\tAL,A1\n\tmovl\tA1,Z-\n");
			return;

		  default:
			cerror("bad conversion (%d->%d)", ltype, type);
		}
# ifdef SKY
	  case FLOAT:
		switch (ltype) {
		  case INT:
		  case LONG:
			if (prtnum)
				printf("/* INT->FLOAT */\n");
# ifdef FORT
			expand( p,FOREFF, "\tmovw\t#0x1024,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tZA@,Z-\n");
			return;

# else FORT

/*			Convert to double via single. Ugly, but correct */
			expand( p,FOREFF, "\tmovw\t#0x1024,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tZA@,A1\n\tmovw\t#0x1042,ZA@(-4)\n\tmovl\tA1,ZA@\n\tmovl\tZA@,A1\n\tmovl\tZA@,Z-\n\tmovl\tA1,Z-\n");
			return;
# endif FORT

		  case UNSIGNED:
		  case ULONG:
/*			Convert to double via single. Ugly, but correct */
			if (prtnum)
				printf("/* UINT->FLOAT */\n");
			expand(p, FOREFF, "\tmovl\tAL,A1\n\tbclr\t#31,A1\n\tmovw\t#0x1024,ZA@(-4)\n\tmovl\tA1,ZA@\n\ttstl\tAL\n");
			lab = getlab();
			printf("\tbges\tL%d\n", lab);
			expand(p, FOREFF, "\tmovl\tZA@,A1\n\tmovw\t#0x1001,ZA@(-4)\n\tmovl\tA1,ZA@\n\tmovl\t#0x4f000000,ZA@\n");
			deflab(lab);
			expand( p,FOREFF, "\tmovl\tZA@,A1\n\tmovw\t#0x1042,ZA@(-4)\n\tmovl\tA1,ZA@\n\tmovl\tZA@,A1\n\tmovl\tZA@,Z-\n\tmovl\tA1,Z-\n");
			return;

		  case FLOAT:
# ifdef FORT
			expand(p, FOREFF, "\tmovl\tAL,Z-\n");
# else FORT
/*			Convert to double via single. Ugly, but correct */
			expand(p, FOREFF, "\tmovw\t#0x1042,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tZA@,A1\n\tmovl\tZA@,Z-\tmovl\tA1,Z-\n");
# endif FORT
			return;
		  case DOUBLE:
# ifdef FORT
			expand(p, FOREFF, "\tmovw\t#0x1043,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tUL,ZA@\n\tmovl\tZA@,Z-\n");
# else FORT
			expand(p, FOREFF, "\tmovw\t#0x1043,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tUL,ZA@\n\tmovl\tZA@,A1\n\tmovw\t#0x1042,ZA@(-4)\n\tmovl\tA1,ZA@\n\tmovl\tZA@,A1\n\tmovl\tZA@,Z-\n\tmovl\tA1,Z-\n");
# endif FORT
			return;
		  case CHAR:
		  case SHORT:
		  case UCHAR:
		  case USHORT:
		  default:
			cerror("bad conversion (%d->%d)", ltype, type);
		}
	  case DOUBLE:
		switch (ltype) {
		  case INT:
		  case LONG:
			if (prtnum)
				printf("/* INT->DOUBLE */\n");
			expand(p, FOREFF, "\tmovw\t#0x1044,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tZA@,A1\n\tmovl\tZA@,Z-\n\tmovl\tA1,Z-\n");
			return;

		  case UNSIGNED:
		  case ULONG:
			if (prtnum)
				printf("/* UINT->DOUBLE */\n");
			expand(p, FOREFF, "\tmovl\tAL,A1\n\tbclr\t#31,A1\n\tmovw\t#0x1044,ZA@(-4)\n\tmovl\tA1,ZA@\n\ttstl\tAL\n");
			lab = getlab();
			printf("\tbges\tL%d\n", lab);
			expand(p, FOREFF, "\tmovl\tZA@,A1\n\tmovl\tZA@,U1\n\tmovw\t#0x1002,ZA@(-4)\n\tmovl\tA1,ZA@\n\tmovl\tU1,ZA@\n\tmovl\t#0x41e00000,ZA@\n\tclrl\tZA@\n");
			deflab(lab);
			expand(p, FOREFF, "\tmovl\tZA@,A1\n\tmovl\tZA@,Z-\n\tmovl\tA1,Z-\n");
			return;

		  case FLOAT:
			if (prtnum)
				printf("/* FLOAT->DOUBLE */\n");
			expand(p, FOREFF, "\tmovw\t#0x1042,ZA@(-4)\n\tmovl\tAL,ZA@\n\tmovl\tZA@,A1\n\tmovl\tZA@,Z-\n\tmovl\tA1,Z-\n");
			return;

		  case DOUBLE:
			if (prtnum)
				printf("/* DOUBLE->DOUBLE */\n");
			expand(p, FOREFF, "\tmovl\tUL,Z-\n\tmovl\tAL,Z-\n");
			return;

		  case CHAR:
		  case SHORT:
		  case UCHAR:
		  case USHORT:
		  default:
			cerror("bad conversion (%d->%d)", ltype, type);
		}
# endif SKY
# ifdef MC68881
	  case FLOAT:
		switch (ltype) {
		  case INT:
		  case LONG:
		  case UNSIGNED:	/* NOTE - this is incorrect */
		  case ULONG:		/* NOTE - this is incorrect */
			if (prtnum)
				printf("/* (U)INT->FLOAT */\n");
# ifdef FORT
			expand( p,FOREFF, "\tfmovl\tAL,A1\n\tfmovs\tA1,Z-\n");
			return;

# else FORT

/*			Skip conversion via single unless someone complains */
			expand( p,FOREFF, "\tfmovl\tAL,A1\n\tfmovd\tA1,Z=\n");
			return;
# endif FORT

		  case FLOAT:
			if (prtnum)
				printf("/* FLOAT->FLOAT */\n");
# ifdef FORT
			if (p->in.left->in.op == REG)
				expand(p, FOREFF, "\tfmovs\tAL,Z-\n");
			else
				expand(p, FOREFF, "\tmovl\tAL,Z-\n");
# else FORT
/*			Really should convert through single, but hard to do */
			if (p->in.left->in.op == REG)
				expand(p, FOREFF, "\tfmovd\tAL,Z=\n");
			else
				expand(p, FOREFF,
				  "\tfmovs\tAL,A1\n\tfmovd\tA1,Z=\n");
# endif FORT
			return;
		  case DOUBLE:
			if (prtnum)
				printf("/* DOUBLE->FLOAT */\n");
# ifdef FORT
			if (p->in.left->in.op == REG)
				expand(p, FOREFF, "\tfmovs\tAL,Z-\n");
			else
				expand(p, FOREFF,
				  "\tfmovd\tAL,A1\nfmovs\tA1,Z-\n");
# else FORT
/*			This is really hard to do, so don't do it */
			if (p->in.left->in.op == REG)
				expand(p, FOREFF, "\tfmovd\tAL,Z=\n");
			else
				expand(p, FOREFF,
				  "\tmovl\tUL,Z-\nmovl\tAL,Z-\n");
# endif FORT
			return;
		  case CHAR:
		  case SHORT:
		  case UCHAR:
		  case USHORT:
		  default:
			cerror("bad conversion (%d->%d)", ltype, type);
		}
	  case DOUBLE:
		switch (ltype) {
		  case INT:
		  case LONG:
		  case UNSIGNED:	/* These don't really belong here */
		  case ULONG:		/* These don't really belong here */
			if (prtnum)
				printf("/* (U)INT->DOUBLE */\n");
			expand(p, FOREFF, "\tfmovl\tAL,A1\n\tfmovd\tA1,Z=\n");
			return;

		  case FLOAT:
			if (prtnum)
				printf("/* FLOAT->DOUBLE */\n");
			if (p->in.left->in.op == REG)
				expand(p, FOREFF, "\tfmovd\tAL,Z=\n");
			else
				expand(p, FOREFF,
				  "\tfmovs\tAL,A1\n\tfmovd\tA1,Z=\n");
			return;

		  case DOUBLE:
			if (prtnum)
				printf("/* DOUBLE->DOUBLE */\n");
			if (p->in.left->in.op == REG)
				expand(p, FOREFF, "\tfmovd\tAL,Z=\n");
			else
				expand(p, FOREFF,
				  "\tmovl\tUL,Z-\nmovl\tAL,Z-\n");
			return;

		  case CHAR:
		  case SHORT:
		  case UCHAR:
		  case USHORT:
		  default:
			cerror("bad conversion (%d->%d)", ltype, type);
		}
# endif MC68881
	  default:
		cerror("bad conversion (%d->%d)", ltype, type);

	}
	return;
}

# ifdef SKY
/*
**	This routine does the (messy) conversions of unsigned ints to float
**	and double.
*/
skyuconv(p) NODE *p; {
	int lab;

	switch (p->in.left->in.type) {
	  case UNSIGNED:
	  case ULONG:
		break;
	  default:
		cerror("illegal Zv call: left type is %d\n",
		  p->in.left->in.type);
	}

	switch (p->in.type) {
	  case FLOAT:
		if (prtnum)
				printf("/* UINT->FLOAT */\n");
		expand(p, FOREFF, "\tmovl\tAL,A1\n\tbclr\t#31,A1\n\tmovw\t#0x1024,ZA@(-4)\n\tmovl\tA1,ZA@\n\ttstl\tAL\n");
		lab = getlab();
		printf("\tbges\tL%d\n", lab);
		expand(p, FOREFF, "\tmovl\tZA@,A1\n\tmovw\t#0x1001,ZA@(-4)\n\tmovl\tA1,ZA@\n\tmovl\t#0x4f000000,ZA@\n");
		deflab(lab);
		expand( p,FOREFF, "\tmovl\tZA@,A1\n");
		return;

	  case DOUBLE:
		if (prtnum)
				printf("/* UINT->DOUBLE */\n");
		expand(p, FOREFF, "\tmovl\tAL,A1\n\tbclr\t#31,A1\n\tmovw\t#0x1044,ZA@(-4)\n\tmovl\tA1,ZA@\n\ttstl\tAL\n");
		lab = getlab();
		printf("\tbges\tL%d\n", lab);
		expand(p, FOREFF, "\tmovl\tZA@,A1\n\tmovl\tZA@,U1\n\tmovw\t#0x1002,ZA@(-4)\n\tmovl\tA1,ZA@\n\tmovl\tU1,ZA@\n\tmovl\t#0x41e00000,ZA@\n\tclrl\tZA@\n");
		deflab(lab);
		expand(p, FOREFF, "\tmovl\tZA@,A1\n\tmovl\tZA@,U1\n");
		return;
	  default:
		cerror("illegal Zv call: type is %d\n", p->in.type);
	}
}
# endif SKY

# define WLEN 32
# define INSTLIMIT 15
# ifdef MC68020
# define CYCLELIMIT 41
# else MC68020
# ifdef NFSKY
# define CYCLELIMIT 72
# else NFSKY
# define CYCLELIMIT 200
# endif NFSKY
# endif MC68020

/*
**	This routine replaces multiplies by a combination of shifts and adds.
**	It is here because lmul is godawful slow.  This routine applies modern
**	parsing techniques (i.e., brute force) to the bit string of the constant
**	and spews forth code as appropriate.
**
**	Called with a second argument of zero, the routine figures out how many
**	instructions it will need to produce and returns a zero if that number
**	is greater than INSTLIMIT (15 as of this writing).  Called with a
**	second argument of 1, it actually produces the code.
**
**	A fair amount of effort is made to produce reasonably good code.
**	The peephole optimizer should remove any extraneous moves.
**
**	This code was generated organically: it grew from a tiny seed,
**	flourished in the California sun, and is already beginning to stink.
**	                   Wendy Thrash
*/
mulshift(p, l) NODE *p; {
	register int k, const2, shift;
	int instcnt = 0;
	int const;
	int tempset=0;
	int leftset=0;
	int cyclecnt = 0;

	const = p->in.right->tn.lval;

	if (edebug > 1) {
		printf("mulshift: p is\n");
		fwalk(p, eprint, 0);
	}

	if (l && prtnum)
		printf("/* mulshift: *= %d */\n", const);

	const2 = (const>=0 ? const : -const);
	shift = 0;
	for (k=0; k<WLEN; k++) {
		if ((const2 & 7) == 7) {
			if (tempset && leftset) {
				if (l)
					expand(p,FOREFF,"\tsubl\tA1,AL\n");
				else {
					instcnt++;
					cyclecnt += 8;
				}
			}
			else if (tempset) {
				if (l)
					expand(p,FOREFF,
					  "\tmovl\tA1,AL\n\tnegl\tAL\n");
				else {
					instcnt += 2;
					cyclecnt += 10;
				}
				leftset = 1;
			}
			else {
				if (l)
					expand(p,FOREFF,
					  "\tmovl\tAL,A1\n\tnegl\tAL\n");
				else {
					instcnt += 2;
					cyclecnt += 10;
				}
				tempset = 1;
				leftset = 1;
			}
			const2 >>= 3;
			shift = 3;
			while (const2 & 1) {
				shift++;
				const2 >>= 1;
			}
			if (shift >= 16) {
				if (l) {
					expand(p, FOREFF,
					  "\tswap\tA1\n\tclrw\tA1\n");
				}
				else {
					instcnt += 2;
					cyclecnt += 8;
				}
				shift -= 16;
			}
/*
**	The following case could be handled about 4 cycles faster by getting
**	an A2 in the template, using that to hold the shift count, but
**	templates that require A2 make me nervous.   -WT-
*/
			if (shift >= 8) {
				if (l)
					expand(p, FOREFF,"\tasll\t#8,A1\n");
				else {
					instcnt++;
					cyclecnt += 24;
				}
				shift -= 8;
			}
			if (shift) {
				if (l) {
					printf("\tasll\t#%d,", shift);
					expand(p, FOREFF,"A1\n");
				}
				else {
					instcnt++;
					cyclecnt += (8 + 2*shift);
				}
				shift = 0;
			}
			if (l)
				expand(p, FOREFF,"\taddl\tA1,AL\n");
			else {
				instcnt++;
				cyclecnt += 8;
			}
			continue;
		}
		else if (const2 & 1) {
			if (tempset && leftset) {
				if (l)
					expand(p, FOREFF, "\taddl\tA1,AL\n");
				else {
					instcnt++;
					cyclecnt += 8;
				}
			}
			else if (tempset) {
				if (l)
					expand(p, FOREFF, "\tmovl\tA1,AL\n");
				else {
					instcnt++;
					cyclecnt += 4;
				}
				leftset = 1;
			}
			else {
				if (l)
					expand(p, FOREFF, "\tmovl\tAL,A1\n");
				else {
					instcnt++;
					cyclecnt += 4;
				}
				tempset = 1;
				leftset = 1;
			}
		}
		const2 >>= 1;
		if (const2 == 0)
			break;
		if (const2 & 1) {
			if (!tempset) {
				if (l)
					expand(p, FOREFF, "\tmovl\tAL,A1\n");
				else {
					instcnt++;
					cyclecnt += 4;
				}
				tempset = 1;
			}
			if (shift >= 15) {
				if (l) {
					expand(p, FOREFF,
					  "\tswap\tA1\n\tclrw\tA1\n");
				}
				else {
					instcnt += 2;
					cyclecnt += 8;
				}
				shift -= 16;
			}
/*			See comment in similar case above */
			if (shift >= 7) {
				if (l) {
					expand(p, FOREFF, "\tasll\t#8,A1\n");
				}
				else {
					instcnt++;
					cyclecnt += 24;
				}
				shift -= 8;
			}
			if (shift >= 1) {
				if (l) {
					printf("\tasll\t#%d,", shift+1);
					expand(p, FOREFF, "A1\n");
				}
				else {
					instcnt++;
					cyclecnt += (8 + 2*(shift+1));
				}
				shift = -1;
			}
			if (shift == 0) {
				if (l)
					expand(p, FOREFF, "\taddl\tA1,A1\n");
				else {
					instcnt++;
					cyclecnt += 8;
				}
			}
			shift = 0;
		}
		else
			shift++;
	}

	if (const < 0)
		if (l)
			expand(p, FOREFF, "\tnegl\tAL\n");
		else {
			instcnt++;
			cyclecnt += 6;
		}

	if (const == 0)	/* almost forgot this case! */
		if (l)
			expand(p, FOREFF, "\tclrl\tAL\n");
		else {
			instcnt++;
			cyclecnt += 6;
		}

	if (!l) {
		if (prtnum)
			printf("/* mulshift: *= %d (%d instructions, %d cycles) */\n",
				const, instcnt, cyclecnt);
		if (edebug > 1) {
			printf("mulshift: instcnt = %d, cyclecnt = %d ",
				instcnt, cyclecnt);
			printf("(max acceptable %d instructions, %d cycles)\n",
				INSTLIMIT, CYCLELIMIT);
		}
		if (instcnt > INSTLIMIT || cyclecnt > CYCLELIMIT)
			return instcnt; /* too many instructions  -  multiply */
		else
			return 0;
	}
	return 0;	/* make lint happy */
}

rmove( rt, rs, t ) TWORD t; {
	if (prtnum)
		printf("/*rmove*/\n");

# ifdef MC68881
	if (ISFLOAT(t)) {
		printf("\t%s\t%s,%s\n","fmovx",rnames[rs],rnames[rt]);
# ifdef BACKWARDS
		usedfregs |= 1 << (rs - F0);
# else BACKWARDS
		usedfregs |= 1 << (F7 - rs);
# endif BACKWARDS
		return;
	}
# endif MC68881

	printf( "\t%s\t%s,%s\n","movl",rnames[rs],rnames[rt]);
	usedregs |= 1<<rs;
	usedregs |= 1<<rt;
	if (t == DOUBLE) {
		printf("\t%s\t%s,%s\n","movl",rnames[rs+1],rnames[rt+1]);
		usedregs |= 1<<(rs+1);
		usedregs |= 1<<(rt+1);
	}
}

struct respref
respref[] = {
	INTAREG|INTBREG,	INTAREG|INTBREG,
	INAREG|INBREG,	INAREG|INBREG,
	INAREG|INBREG,	INAREG|INBREG|SOREG|STARREG|SNAME|STARNM|SCON,
# ifdef MC68881
/*	This list is almost certainly incomplete; problems should show up */
	INTFREG,	INTFREG,
	INFREG,		INFREG,
	INFREG,		INFREG|SOREG|STARREG|SNAME|STARNM|SCON,
# endif MC68881
	INTEMP,	INTEMP,
	FORARG,	FORARG,
	INTAREG,	SOREG|SNAME,
	INTAREG,	INTAREG|INAREG,
	0,	0 };

setregs(){ /* set up temporary registers */
	register i;

	/* use any unused variable registers as scratch registers */
	fregs = maxtreg.dreg>=MINDRVAR ? maxtreg.dreg + 1 : MINDRVAR;
	faregs = maxtreg.areg>=MINARVAR ? maxtreg.areg + 1 : MINARVAR;
# ifdef MC68881
	ffregs = maxtreg.freg>=MINFRVAR ? maxtreg.freg + 1 : MINFRVAR;
# else MC68881
	ffregs = 8;
# endif MC68881
	if ( xdebug ){
		/* -x changes number of free regs to 2, -xx to 3, etc. */
		if ( (xdebug+1) < fregs ) fregs = xdebug+1;
	}

# ifdef FORT
/*	Let's track the registers that are really used */
# ifdef MC68881
	usedfregs = 0;
# endif MC68881
	usedregs = 0;
# endif FORT

	for( i=MINRVAR; i<=MAXRVAR; i++ )
		rstatus[i] = i<fregs ? SAREG|STAREG : SAREG;
	for( i=MINRVAR; i<=MAXRVAR; i++ )
		rstatus[i+8] = i<faregs ? SBREG|STBREG : SBREG;
# ifdef MC68881
	for( i=MINRVAR; i<=MAXRVAR; i++ )
		rstatus[i+16] = i<ffregs ? SFREG|STFREG : SFREG;
# endif MC68881
# ifdef WENDY
	if (wdebug) {
		printf("maxtreg = 0x%x, fregs = %d\n",
			(int)maxtreg, fregs);
		printf("faregs = %d, ffregs = %d\n", faregs, ffregs);
		for ( i=MINRVAR; i<=MAXRVAR; i++ )
			printf("rstatus[%d]=%x\n",i+8,rstatus[i+8]);
	}
# endif WENDY
}

szty(t) TWORD t; { /* size, in words, needed to hold thing of type t */
	/* really is the number of registers to hold type t */
	if (t == DOUBLE)
		return 2;
	return(1);
}

rewfld( p ) NODE *p; {
	return(1);
}

callreg(p) NODE *p; {
# ifdef MC68881
	if (ISFLOAT(p->in.type))
		return( F0 );
	else
		return( D0 );
# else MC68881
	return( D0 );
# endif MC68881
}

shltype( o, p ) NODE *p; {
	if ( o == NAME|| o==REG || o == ICON || o == OREG ) return( 1 );
	return( o==UNARY MUL && shumul(p->in.left) );
}

flshape( p ) register NODE *p; {
	register o = p->in.op;
	if ( o==NAME || o==REG || o==ICON || o==OREG ) return( 1 );
	return( o==UNARY MUL && shumul(p->in.left)==STARNM );
}

shtemp( p ) register NODE *p; {
	if ( p->in.op == UNARY MUL ) p = p->in.left;
	if ( p->in.op == REG || p->in.op == OREG )
		return( !istreg( p->tn.rval ) );
	return( p->in.op == NAME || p->in.op == ICON );
}

spsz( t, v ) TWORD t; CONSZ v; {

	/* is v the size to increment something of type t */

	if ( !ISPTR(t) ) return( 0 );
	t = DECREF(t);

	if ( ISPTR(t) ) return( v == 4 );

	switch ( t ){

	  case UCHAR:
	  case CHAR:
		return( v == 1 );

	  case SHORT:
	  case USHORT:
		return( v == 2 );

	  case INT:
	  case UNSIGNED:
	  case FLOAT:
		return( v == 4 );

	  case DOUBLE:
		return( v == 8 );
	}

	return( 0 );
}

indexreg( p ) register NODE *p; {
	if ( p->in.op==REG && p->tn.rval>=A0 && p->tn.rval<=SP) return(1);
	return(0);
}

shumul( p ) register NODE *p; {
	register o;

	o = p->in.op;
	if ( indexreg(p) ) return( STARNM );

	if ( o == INCR && indexreg(p->in.left) && p->in.right->in.op==ICON &&
	    p->in.right->in.name[0] == '\0' &&
	    spsz( p->in.left->in.type, p->in.right->tn.lval ) )
		return( STARREG );

	if ( o == ASG MINUS && indexreg(p->in.left) &&
	    p->in.right->in.op==ICON && p->in.right->in.name[0] == '\0' &&
	    spsz( p->in.left->in.type, p->in.right->tn.lval ) )
		return( STARREG );

	return( 0 );
}

adrcon( val ) CONSZ val; {
	printf( "0x%x", val );
}

conput( p ) register NODE *p; {
	switch ( p->in.op ){

	  case ICON:
		acon( p );
		return;

	  case REG:
		printf( "%s", rnames[p->tn.rval] );
# ifdef MC68881
		if (mc68881 && ISFLOAT(p->in.type))
# ifdef BACKWARDS
			usedfregs |= 1 << (p->tn.rval - F0);
# else BACKWARDS
			usedfregs |= 1 << (F7 - p->tn.rval);
# endif BACKWARDS
		else
# endif MC68881
			usedregs |= 1<<p->tn.rval;
		return;

	  default:
		cerror( "illegal conput" );
	}
}

insput( p ) NODE *p; {
	cerror( "insput" );
}

upput( p ) NODE *p; {
	/* output the address of the second word in the
	   pair pointed to by p (for LONGs)*/
	CONSZ save;

	if ( p->in.op == FLD ){
		p = p->in.left;
	}

	save = p->tn.lval;
	switch ( p->in.op ){

	  case NAME:
		p->tn.lval += SZINT/SZCHAR;
		acon( p );
		break;

	  case ICON:
		/* addressable value of the constant */
		p->tn.lval &= BITMASK(SZINT);
		printf( "#" );
		acon( p );
		break;

	  case REG:
		printf( "%s", rnames[p->tn.rval+1] );
		usedregs |= 1<<(p->tn.rval + 1);
		break;

	  case OREG:
#ifdef MC68020
		if ( p->orn.memind ) {
			int s;

			p->orn.odisp += SZINT/SZCHAR;
			if (p->orn.adreg == -1)
				printf( "za@" );
			else {
				printf( "%s@", rnames[p->orn.adreg] );
				usedregs |= 1<<p->orn.adreg;
			}
			if ( p->orn.disp != 0 || p->orn.name[0] != '\0' 
			  || p->orn.memind ) { /* as: an(0)@[0], not an@[0] */
				printf("(");
				acon( p );
				printf(")");
			}
			printf("[");
			if (HASINDEX(p)) {
				printf( "%s:L", rnames[p->orn.index] );
				usedregs |= 1<<p->orn.index;
				if ((s=p->orn.scale)==1)
					printf("*2,");
				else if (s==2)
					printf("*4,");
				else if (s==3)
					printf("*8,");
				else if (s != 0)
					cerror("adrput: scale (%d)", s);
			}
			printf("%d]", p->orn.odisp);
			p->orn.odisp -= SZINT/SZCHAR;	/* Restore odisp */
			break;
		} else {
			p->orn.disp += SZINT/SZCHAR;
		}
		if ( p->orn.adreg == A6 ){  /* in the argument region */
			if (HASINDEX(p) || p->orn.disp || p->orn.scale
			  || p->orn.name[0] != '\0') {
				printf( "fp@(" );
				acon(p);
				if ( HASINDEX(p) ) {
					int s;

					printf(",%s:L", rnames[p->orn.index] );
					usedregs |= 1<<p->orn.index;
					if ((s=p->orn.scale)==1)
						printf("*2");
					else if (s==2)
						printf("*4");
					else if (s==3)
						printf("*8");
					else if (s != 0)
						cerror("adrput: scale (%d)", s);
				}
				printf( ")" );
			} else printf ("fp@");
			break;
		}
		if (p->orn.adreg == -1)
			printf( "za@");
		else {
			printf( "%s@", rnames[p->orn.adreg] );
			usedregs |= 1<<p->orn.adreg;
		}
		if ( p->orn.disp != 0 || p->orn.name[0] != '\0') {
			printf("(");
			acon( p );
			if ( HASINDEX(p) ) {
				int s;

				printf(",%s:L", rnames[p->orn.index] );
				usedregs |= 1<<p->orn.index;
				if ((s=p->orn.scale)==1)
					printf("*2");
				else if (s==2)
					printf("*4");
				else if (s==3)
					printf("*8");
				else if (s != 0)
					cerror("adrput: scale (%d)", s);
			}
			printf(")");
		}
		break;
#else MC68020
		p->tn.lval += SZINT/SZCHAR;
		if ( p->tn.rval == A6 )  /* in the argument region */
			if ( p->in.name[0] != '\0' ) werror( "bad arg temp" );
		printf( "%s@", rnames[p->tn.rval] );
		usedregs |= 1<<p->tn.rval;
		if ( p->tn.lval != 0 || p->in.name[0] != '\0' )
		  { printf("("); acon( p ); printf(")"); }
		break;
#endif MC68020

	  case UNARY MUL:
		/* STARNM or STARREG found */
		if ( tshape(p, STARNM) ) {
			p->tn.lval += SZINT/SZCHAR;
			adrput( p->in.left);
			printf( "@" );
		} else {	/* STARREG - really auto inc or dec */
			/* turn into OREG so replacement node will
			   reflect the value of the expression */
			register NODE *q, *l, *n;

			ncopy( n=talloc(), p );
			l = n->in.left;
			q = l->in.left;

			n->in.op = OREG;
			n->in.rall = q->in.rall;
			n->tn.lval = q->tn.lval + SZINT/SZCHAR;
			n->tn.rval = q->tn.rval;
#ifndef FLEXNAMES
			{
			register i;

			for(i=0; i<NCHNAM; ++i)
				n->in.name[i] = q->in.name[i];
			}
#else
			n->in.name = q->in.name;
#endif
#ifdef MC68020
			n->orn.memind = 0;
			n->orn.index = -1;
			n->orn.scale = 0;
			n->orn.odisp = 0;
#endif MC68020
			if ( l->in.op == INCR )
				adrput( n );
			else 	/* l->in.op == ASG MINUS */
				adrput( n );
			tfree( n );
		}
		break;

	  default:
		cerror( "illegal upper address" );
		break;

	}
	p->tn.lval = save;

}

adrput( p ) register NODE *p; {
	/* output an address, with offsets, from p */


	regval = -1;
	if ( p->in.op == FLD )
		p = p->in.left;

	switch ( p->in.op ){

	  case NAME:
		acon( p );
		return;

	  case ICON:
		/* addressable value of the constant */
		if ( szty( p->in.type ) == 2 ) {
			/* print the high order value */
			CONSZ save;
			save = p->tn.lval;
			p->tn.lval = ( p->tn.lval >> SZINT ) & BITMASK(SZINT);
			printf( "#" );
			acon( p );
			p->tn.lval = save;
			return;
		}
		printf( "#" );
		acon( p );
		return;

	  case REG:
		printf( "%s", rnames[p->tn.rval] );
# ifdef MC68881
		if (mc68881 && ISFLOAT(p->in.type))
# ifdef BACKWARDS
			usedfregs |= 1 << (p->tn.rval - F0);
# else BACKWARDS
			usedfregs |= 1 << (F7 - p->tn.rval);
# endif BACKWARDS
		else
# endif MC68881
			usedregs |= 1<<p->tn.rval;
		return;

# ifdef MC68020
	  case OREG:
		if ( p->orn.memind ) {
			int s;

			if (p->orn.adreg == -1)
				printf( "za@" );
			else {
				printf( "%s@", rnames[p->orn.adreg] );
				usedregs |= 1<<p->orn.adreg;
			}
			if ( p->orn.disp != 0 || p->orn.name[0] != '\0' 
			  || p->orn.memind ) { /* as: an(0)@[0], not an@[0] */
				printf("(");
				acon( p );
				printf(")");
			}
			printf("[");
			if ( HASINDEX(p) ) {
				printf( "%s:L", rnames[p->orn.index] );
				usedregs |= 1<<p->orn.index;
				if ((s=p->orn.scale)==1)
					printf("*2,");
				else if (s==2)
					printf("*4,");
				else if (s==3)
					printf("*8,");
				else if (s != 0)
					cerror("adrput: scale (%d)", s);
			}
			printf("%d]", p->orn.odisp);
			return;
		}
		if ( p->orn.adreg == A6 ){  /* in the argument region */
			if (HASINDEX(p) || p->orn.disp || p->orn.scale
			 || p->orn.name[0] != '\0' || p->orn.memind) {
				printf( "fp@(" );
				acon(p);
				if ( HASINDEX(p) ) {
					int s;

					printf(",%s:L", rnames[p->orn.index] );
					usedregs |= 1<<p->orn.index;
					if ((s=p->orn.scale)==1)
						printf("*2");
					else if (s==2)
						printf("*4");
					else if (s==3)
						printf("*8");
					else if (s != 0)
						cerror("adrput: scale (%d)", s);
				}
				printf( ")" );
			} else printf ("fp@");
			return;
		}
		if (p->orn.adreg == -1)
			printf( "za@");
		else {
			printf( "%s@", rnames[p->orn.adreg] );
			usedregs |= 1<<p->orn.adreg;
		}
		if ( p->orn.disp != 0 || p->orn.name[0] != '\0' ||
		     HASINDEX(p) || p->orn.scale || p->orn.memind) {
			printf("(");
			acon( p );
			if ( HASINDEX(p) ) {
				int s;

				printf(",%s:L", rnames[p->orn.index] );
				usedregs |= 1<<p->orn.index;
				if ((s=p->orn.scale)==1)
					printf("*2");
				else if (s==2)
					printf("*4");
				else if (s==3)
					printf("*8");
				else if (s != 0)
					cerror("adrput: scale (%d)", s);
			}
			printf(")");
		}
		break;
# else MC68020
	  case OREG:
		if ( p->tn.rval == A6 ){  /* in the argument region */
			if ( p->in.name[0] != '\0' ) werror( "bad arg temp" );
			if (p->tn.lval != 0) {
				printf( "fp@(" );
				printf( CONFMT, p->tn.lval );
				printf( ")" );
			} else printf ("fp@");
			return;
		}
		printf( "%s@", rnames[p->tn.rval] );
		usedregs |= 1<<p->tn.rval;
		if ( p->tn.lval != 0 || p->in.name[0] != '\0'
		  || p->orn.memind ) {
			printf("(");
			acon( p );
			printf(")");
		}
		break;
# endif MC68020

	case UNARY MUL:
		/* STARNM or STARREG found */
		if ( tshape(p, STARNM) ) {
			adrput( p->in.left);
			printf( "@" );
		} else {	/* STARREG - really auto inc or dec */
			/* turn into OREG so replacement node will
			   reflect the value of the expression */
			register NODE *q, *l;

			l = p->in.left;
			q = l->in.left;
			p->in.op = OREG;
			p->in.rall = q->in.rall;
			p->tn.lval = q->tn.lval;
			p->tn.rval = q->tn.rval;
#ifndef FLEXNAMES
			{
			register i;

			for(i=0; i<NCHNAM; ++i)
				p->in.name[i] = q->in.name[i];
			}
#else
			p->in.name = q->in.name;
#endif
#ifdef MC68020
			p->orn.memind = 0;
			p->orn.index = -1;
			p->orn.scale = 0;
#endif MC68020
			if ( l->in.op == INCR ) {
				adrput( p );
				printf( "+" );
				p->tn.lval -= l->in.right->tn.lval;
			} else {	/* l->in.op == ASG MINUS */
				adrput( p );
				printf( "-" );
			}
			regval = p->tn.rval;
			tfree( l );
		}
		return;

	  case PLUS:
	  case MINUS:
		{
			register NODE *l, *r;

			l = p->in.left;
			r = p->in.right;
			p->in.rall = l->in.rall;
			p->tn.lval = r->tn.lval;
			p->tn.rval = l->tn.rval;
			if (p->in.op == MINUS) p->tn.lval = -p->tn.lval;
			p->in.op = OREG;
#ifdef MC68020
			p->orn.memind = 0;
			p->orn.index = -1;
			p->orn.scale = 0;
#endif MC68020

			adrput( p );
			tfree( l );
			tfree( r );
			return;
			}

	  default:
		cerror( "illegal address" );
		return;

	}

}

acon( p ) register NODE *p; { /* print out a constant */

	if ( p->in.name[0] == '\0' ){	/* constant only */
		if (p->tn.lval >= -256  &&  p->tn.lval <= 255)
			printf( CONFMT, p->tn.lval);
		else
			printf( "0x%x", p->tn.lval);
	} else if ( p->tn.lval == 0 ) {	/* name only */
#ifndef	FLEXNAMES
		printf( "%.8s", p->in.name );
#else
		printf( "%s", p->in.name );
#endif
	} else {				/* name + offset */
#ifndef	FLEXNAMES
		printf( "%.8s+", p->in.name );
#else
		printf( "%s+", p->in.name );
#endif
		printf( CONFMT, p->tn.lval );
	}
}

genscall( p, cookie ) register NODE *p; {
	/* structure valued call */
	return( gencall( p, cookie ) );
}

gencall( p, cookie ) register NODE *p; {
	/* generate the call given by p */
	register temp;
	register m;

	if ( p->in.right ) temp = argsize( p->in.right );
	else temp = 0;

	if ( p->in.right ) /* generate args */
		genargs( p->in.right );

	if ( !shltype( p->in.left->in.op, p->in.left ) )
		order( p->in.left, INBREG|SOREG );

	p->in.op = UNARY CALL;
# ifdef MC68881
	if ( ISFLOAT(p->in.type) )
		m = match( p, INTFREG) ;
	else
		m = match( p, INTAREG|INTBREG );
# else MC68881
	m = match( p, INTAREG|INTBREG );
# endif MC68881
	popargs( temp );
	return(m != MDONE);
}

popargs( size ) register size; {
	/* pop arguments from stack */

	toff -= size/2;
	if ( toff == 0 && size >= 2 ) size -= 2;
	if (size > 0) {
		if (size <= 8)
			printf ("	addql	#%d,sp\n", (int)size);
		else if (size <= 32767)
			printf ("	lea	sp@(0x%x),sp\n", (int)size);
		else
			printf ("	addl	#0x%x,sp\n", (int)size);
	}
}

char *
ccbranches[] = {
	"	jeq	L%d\n",
	"	jne	L%d\n",
	"	jle	L%d\n",
	"	jlt	L%d\n",
	"	jge	L%d\n",
	"	jgt	L%d\n",
	"	jls	L%d\n",
	"	jcs	L%d\n",		/* blo */
	"	jcc	L%d\n",		/* bhis */
	"	jhi	L%d\n",
};

/*	long branch table

   This table, when indexed by a logical operator,
   selects a set of three logical conditions required
   to generate long comparisons and branches.  A zero
   entry indicates that no branch is required.
   E.G.:  The <= operator would generate:
	cmp	AL,AR
	jlt	lable	/ 1st entry LT -> lable
	jgt	1f	/ 2nd entry GT -> 1f
	cmp	UL,UR
	jlos	lable	/ 3rd entry ULE -> lable
   1:
 */

int lbranches[][3] = {
	/*EQ*/	0,	NE,	EQ,
	/*NE*/	NE,	0,	NE,
	/*LE*/	LT,	GT,	ULE,
	/*LT*/	LT,	GT,	ULT,
	/*GE*/	GT,	LT,	UGE,
	/*GT*/	GT,	LT,	UGT,
	/*ULE*/	ULT,	UGT,	ULE,
	/*ULT*/	ULT,	UGT,	ULT,
	/*UGE*/	UGT,	ULT,	UGE,
	/*UGT*/	UGT,	ULT,	UGT,
};

/* logical relations when compared in reverse order (cmp R,L) */

# ifdef ONEPASS
extern short revrel[] ;
# else ONEPASS
short revrel[] ={ EQ, NE, GE, GT, LE, LT, UGE, UGT, ULE, ULT };
# endif ONEPASS

# ifdef MC68881

/* Wonder whether this is a complete table? */
/* These are the non-aware tests */
char *
fccbranches[] = {
	"	fjeq	L%d\n",
	"	fjne	L%d\n",
	"	fjle	L%d\n",
	"	fjlt	L%d\n",
	"	fjge	L%d\n",
	"	fjgt	L%d\n",
};

/*
**	For the moment, I haven't changed the code in optim.c
**	regarding branch reversal.  This will  cause no problems
**	unless an attempt is made to be more legitimate about IEEE
**	tests/branches.
*/
short frevrel[] ={ EQ, NE, GE, GT, LE, LT };

# endif MC68881

cbgen( o, lab, mode ) { /*   printf conditional and unconditional branches */
	register *plb;
	int lab1f;

	if (prtnum)
		printf("/*cbgen*/\n");
	if ( o == 0 ) printf( "	jra	L%d\n", (int)lab );
# ifdef MC68881
	else if ( mode == 'J' )
			printf( fccbranches[o-EQ], lab );
	else if ( mode == 'K' )
			printf( fccbranches[frevrel[o-EQ] - EQ], lab );
# endif MC68881
	else if ( o > UGT ) cerror( "bad conditional branch: %s", opst[o] );
	else {
		switch ( brcase ) {

		  case 'A':
		  case 'C':
			plb = lbranches[ o-EQ ];
			lab1f = getlab();
			expand( brnode, FORCC,
			  brcase=='C' ? "\tcmp\tAL,AR\n" : "\ttst\tAR\n" );
			if ( *plb != 0 )
				printf( ccbranches[*plb-EQ], lab);
			if ( *++plb != 0 )
				printf( ccbranches[*plb-EQ], lab1f);
			expand( brnode, FORCC,
			  brcase=='C' ? "\tcmp\tUL,UR\n" : "\ttst\tUR\n" );
			printf( ccbranches[*++plb-EQ], lab);
			deflab( lab1f );
			reclaim( brnode, RNULL, 0 );
			break;

		  default:
			if ( mode=='F' ) o = revrel[ o-EQ ];
			printf( ccbranches[o-EQ], lab );
			break;
		}

		brcase = 0;
		brnode = 0;
	}
}

nextcook( p, cookie ) NODE *p; {
	/* we have failed to match p with cookie; try another */
	if ( cookie == FORREW )
		return( 0 );  /* hopeless! */
# ifdef MC68881
	if ( ISFLOAT(p->in.type) ) {
		if ( !(cookie&INTFREG) )
			return( INTFREG );
		if ( !(cookie&INTEMP) && asgop(p->in.op) )
			return( INTEMP|INFREG|INTFREG );
		return( FORREW );
	}
# endif MC68881
	if ( !(cookie&(INTAREG|INTBREG)) && p->in.op != SCONV )
		return( INTAREG|INTBREG );
	if ( !(cookie&INTEMP) && asgop(p->in.op) )
		return( INTEMP|INAREG|INTAREG|INTBREG|INBREG );
	return( FORREW );
}

lastchance( p, cook ) NODE *p; {
	/* forget it! */
	return(0);
}

struct functbl {
	int fop;
	TWORD ftype;
	char *func;
} intopfunc[] = {
# ifndef NFSKY
# ifdef NOREGMULDIV
	MUL,		INT,	"lmul",
	DIV,		INT,	"ldiv",
	MOD,		INT,	"lrem",
	MUL,		UNSIGNED,	"ulmul",
	DIV,		UNSIGNED,	"uldiv",
	MOD,		UNSIGNED,	"ulrem",
# endif NOREGMULDIV
	ASG MUL,	INT,	"almul",
	ASG DIV,	INT,	"aldiv",
	ASG MOD,	INT,	"alrem",
	ASG MUL,	UNSIGNED,	"aulmul",
	ASG DIV,	UNSIGNED,	"auldiv",
	ASG MOD,	UNSIGNED,	"aulrem",
# endif NFSKY
	0,	0,	0 };

struct functbl fltopfunc[] = {
# ifndef SKY
# ifndef MC68881
# ifdef IEEE
	PLUS,		DOUBLE,	"dpadd",
	MINUS,		DOUBLE, "dpsub",
	MUL,		DOUBLE, "dpmul",
	DIV,		DOUBLE, "dpdiv",
	ASG PLUS,	DOUBLE,	"adadd",
	ASG MINUS,	DOUBLE, "adsub",
	ASG MUL,	DOUBLE, "admul",
	ASG DIV,	DOUBLE, "addiv",
# ifdef FORT
/*	As far as I can tell, f77 produces only ASG PLUS, that in DO loops */
/*	when the control variable is a float.   */
	ASG PLUS,	FLOAT,	"asaddf",
# else FORT
	ASG PLUS,	FLOAT,	"asadd",
	ASG MINUS,	FLOAT,	"assub",
	ASG MUL,	FLOAT,	"asmul",
	ASG DIV,	FLOAT,	"asdiv",
# endif FORT
# else IEEE
	PLUS,		DOUBLE,	"fadd",
	MINUS,		DOUBLE, "fsub",
	MUL,		DOUBLE, "fmul",
	DIV,		DOUBLE, "fdiv",
	UNARY MINUS,	DOUBLE, "fneg",
	UNARY MINUS,	FLOAT,	"fneg",
	ASG PLUS,	DOUBLE,	"afadd",
	ASG MINUS,	DOUBLE, "afsub",
	ASG MUL,	DOUBLE, "afmul",
	ASG DIV,	DOUBLE, "afdiv",
	ASG PLUS,	FLOAT,	"afaddf",
	ASG MINUS,	FLOAT,	"afsubf",
	ASG MUL,	FLOAT,	"afmulf",
	ASG DIV,	FLOAT,	"afdivf",
# endif IEEE
# ifdef FORT
# ifdef IEEE
	PLUS,		FLOAT,	"spadd",
	MINUS,		FLOAT,	"spsub",
	MUL,		FLOAT,	"spmul",
	DIV,		FLOAT,	"spdiv",
# else IEEE
	PLUS,		FLOAT,	"faddf",
	MINUS,		FLOAT,	"fsubf",
	MUL,		FLOAT,	"fmulf",
	DIV,		FLOAT,	"fdivf",
# endif IEEE
# endif FORT
# endif MC68881
# endif SKY
	0,	0,	0 };

/*
**  ASG MUL's, DIV's and MOD's on non-float rhs's and float lhs's have
**  to be mapped into the respective non-asgops,
**  worrying about side effects on the lhs
*/

/*
**  get rid of side effects on this tree (i.e., COMOP's, INCR's, DECR's)
*/

NODE * stripsa( p ) register NODE *p; {
	register o, ty;
	register NODE *q;

	if (odebug) {
		printf("stripsa: p is\n");
		fwalk(p, eprint,0);
	}
	o = p->in.op;
	ty = optype( o );

	switch ( o ){
	  case INCR:
	  case DECR:
		if (odebug)
			printf("stripsa: case INCR/DECR\n");
		q = p->in.left;
		p->in.right->in.op = FREE;
		ncopy( p, q );
		q->in.op = FREE;
		break;

	  default:
		if ( ty == BITYPE ) stripsa( p->in.right );
		if ( ty != LTYPE ) stripsa( p->in.left );
		break;
	}
	return p;
}

NODE *
localblock(op, type, left, right) int op; int type; NODE *left, *right; {
	register NODE *p;

	p = talloc();
	p->in.op = op;
	p->in.rall = NOPREF;
	p->in.type = type;
	p->in.left = left;
	p->in.right = right;
	return p;
}


# define ISHARDASOP(x) ((x) == ASG MUL || (x) == ASG DIV || (x) == ASG MOD)

NODE *
hardasop(p) register NODE *p; {
	register NODE *q,*r;

	
	if (ISHARDASOP(p->in.op) && !ISFLOAT(p->in.left->in.type) &&
	  p->in.right->in.op == SCONV && 
	  ISFLOAT((r = p->in.right->in.left)->in.type)) {
		if (r->in.type == FLOAT)
			r = localblock(SCONV,DOUBLE,r,NIL);
		q = localblock(SCONV,DOUBLE,
			tcopy(stripsa(p->in.left)),NIL);
		p->in.right->in.left = localblock(p->in.op-1,DOUBLE,q,r);
		p->in.op = ASSIGN;
		if (edebug) {
			printf("hardasop:\n");
			fwalk(p,eprint,0);
		}
	}
}


hardops(p)  register NODE *p; {
	/* change hard to do operators into function calls. */
	register NODE *q;
	register struct functbl *f;
	register o;
	register TWORD t;

	if (edebug > 1) {
		printf("hardops: p is:\n");
		fwalk(p, eprint, 0);
	}
	o = p->in.op;
	if (o==SCONV) { hardconv(p); return; }

	t = p->in.type;
	if (ISPTR(t))
		t = UNSIGNED;

	if (t==INT || t==UNSIGNED) {
		if (!mc68020)
			f = intopfunc;
		else
			return;
	} else if (t==DOUBLE || t==FLOAT) {
# ifdef MC68881
		if (!mc68881)
			f = fltopfunc;
		else
			return;
# else MC68881
		f = fltopfunc;
# endif MC68881
	} else
		return;

	for( ; f->fop; f++ )
		if ( o==f->fop && t==f->ftype ) goto convert;
	return;

	convert:
	if ((o == MUL || o == ASG MUL) &&
	    (p->in.right->in.op == ICON && p->in.right->in.name[0]=='\0') &&
	    (p->in.left->in.type == INT || p->in.left->in.type == UNSIGNED) &&
	    (p->in.right->in.type == INT || p->in.right->in.type == UNSIGNED) &&
	    !mulshift(p, 0))
		return;
	if (o == MUL  &&
	    (p->in.left->in.type == SHORT || p->in.left->in.type == USHORT)  &&
	    (p->in.right->in.type == SHORT || p->in.right->in.type == USHORT))
		return;
	if ( (o == DIV || o == MOD)  &&
	  (tlen(p) <= 2 ||
	    ((tlen(p->in.right) <= 2) &&
	    (p->in.left->in.type == INT || p->in.left->in.type == UNSIGNED))))
		return;

	/* need address of left node for ASG OP */
	/* WARNING - this won't work for long in a REG */
	if ( asgop( o ) ) {
		switch ( p->in.left->in.op ) {

		  case UNARY MUL:	/* convert to address */
			p->in.left->in.op = FREE;
			p->in.left = p->in.left->in.left;
			break;

		  case NAME:	/* convert to ICON pointer */
			p->in.left->in.op = ICON;
			p->in.left->in.type = INCREF( p->in.left->in.type );
			break;

		  case OREG:	/* convert OREG to address */
# ifdef MC68020
			if ( p->in.left->orn.memind || p->in.left->orn.odisp
			  || HASINDEX(p->in.left) ) {
				printf("hardops: error: p is\n");
				fwalk(p, eprint, 0);
				cerror("hardops: OREG too hard");
			}
# endif MC68020
			p->in.left->in.op = REG;
			p->in.left->in.type = INCREF( p->in.left->in.type );
			if ( p->in.left->tn.lval != 0 ||
			   p->in.left->in.name[0] != '\0' ) {
				q = talloc();
				q->in.op = PLUS;
				q->in.rall = NOPREF;
				q->in.type = p->in.left->in.type;
				q->in.left = p->in.left;
				q->in.right = talloc();

				q->in.right->in.op = ICON;
				q->in.right->in.rall = NOPREF;
				q->in.right->in.type = INT;
#ifdef FLEXNAMES
				if (p->in.left->in.name[0] != '\0')
					q->in.right->in.name =
						p->in.left->in.name;
				else
					q->in.right->in.name = "";
#else FLEXNAMES
				if (p->in.left->in.name[0] != '\0')
					strcpy(q->in.right->in.name,
						  p->in.left->in.name);
				else
					q->in.right->in.name[0] = '\0';
#endif FLEXNAMES
				q->in.right->tn.lval = p->in.left->tn.lval;
				q->in.right->tn.rval = 0;

				p->in.left->tn.lval = 0;
				p->in.left = q;
			}
			break;

		/* rewrite "foo <op>= bar" as "foo = foo <op> bar" */
		/* for foo in a reg */
		  case REG:
			q = talloc();
			q->in.op = p->in.op - 1; /* change <op>= to <op> */
			q->in.rall = p->in.rall;
			q->in.type = p->in.type;
			q->in.left = talloc();
			q->in.right = p->in.right;
			p->in.op = ASSIGN;
			p->in.right = q;
			q = q->in.left;		/* make a copy of "foo" */
			q->in.op = p->in.left->in.op;
			q->in.rall = p->in.left->in.rall;
			q->in.type = p->in.left->in.type;
			q->tn.lval = p->in.left->tn.lval;
			q->tn.rval = p->in.left->tn.rval;
			hardops(stripsa(p->in.right));
			return;

		  default:
			cerror( "Bad address for hard ops" );
			/* NO RETURN */

		}
	}

	/* build comma op for args to function */
	if ( optype(p->in.op) == BITYPE ) {
		q = talloc();
	 	q->in.op = CM;
	 	q->in.rall = NOPREF;
	 	q->in.type = INT;
	 	q->in.left = p->in.left;
	 	q->in.right = p->in.right;
	} else q = p->in.left;

	p->in.op = CALL;
	p->in.right = q;

	/* put function name in left node of call */
	p->in.left = q = talloc();
	q->in.op = ICON;
	q->in.rall = NOPREF;
	q->in.type = INCREF( FTN + p->in.type );
#ifndef	FLEXNAMES
	strncpy( q->in.name, f->func, NCHNAM );
#else
	q->in.name = f->func;
#endif
	q->tn.lval = 0;
	q->tn.rval = 0;

	return;
}

/* do fix and float conversions */
hardconv(p) register NODE *p; {
# ifdef SKY
/*	Skip most of this if there's a Sky board - just do f77 stuff */
# ifdef FORT
	register NODE *q;
	register TWORD t,tl;

	t = p->in.type;
	tl = p->in.left->in.type;

/*	Add short->int conversion if target float/double (and Sky board) */
	if ((tl == SHORT && (t == FLOAT || t == DOUBLE))
	  || (t == SHORT && (tl == FLOAT || tl == DOUBLE))) {
		q = talloc();
		*q = *p;
		p->in.left = q;
		q->in.type = INT;
	}
# endif FORT
# else SKY
# ifdef IEEE

	register TWORD t,tl;


	t = p->in.type;
	tl = p->in.left->in.type;

# ifdef MC68881
	if (mc68881) {
/*		Some conversions are a little too hard for the hardware */
		if (t == UNSIGNED || t == ULONG ) {
			if (tl == FLOAT)
				mkconvcall(p, "spufix");
			else if (tl == DOUBLE)
				mkconvcall(p, "dpufix");
		}
		return;
	}
# endif MC68881

	if (t == tl)
		return;

	if (t == FLOAT) {
		if (tl == DOUBLE)
			mkconvcall(p, "dptosp");
		else if (ISUNSIGNED(tl))
			mkconvcall(p, "spufloat");
		else
			mkconvcall(p, "spfloat");
	} else if (t == DOUBLE) {
		if (tl == FLOAT)
			mkconvcall(p, "sptodp");
		else if (ISUNSIGNED(tl))
			mkconvcall(p, "dpufloat");
		else
			mkconvcall(p, "dpfloat");
	} else if (tl == FLOAT)
		if (ISUNSIGNED(t))
			mkconvcall(p, "spufix");
		else
			mkconvcall(p, "spfix");
	else if (tl == DOUBLE)
		if (ISUNSIGNED(t))
			mkconvcall(p, "dpufix");
		else
			mkconvcall(p, "dpfix");
	else
		return;

# else IEEE

	register TWORD t,tl;
	int m,ml;

	t = p->in.type;
	tl = p->in.left->in.type;

	m = t==DOUBLE || t==FLOAT;
	ml = tl==DOUBLE || tl==FLOAT;

	if (m==ml) return;
	if (m)
		mkconvcall(p, "float");
	else
		mkconvcall(p, "fix");

# endif IEEE
# endif SKY
}

mkconvcall(p, pname) register NODE *p; register char *pname; {
	register NODE *q;

	p->in.op = CALL;
	p->in.right = p->in.left;

	/* put function name in left node of call */
	p->in.left = q = talloc();
	q->in.op = ICON;
	q->in.rall = NOPREF;
	q->in.type = INCREF( FTN + p->in.type );

# ifdef FLEXNAMES
	q->tn.name = pname;
# else FLEXNAMES
	strncpy( q->tn.name, pname, NCHNAM );
# endif FLEXNAMES

	q->tn.lval = 0;
	q->tn.rval = 0;
}

okshort(p, ty) register NODE *p; register TWORD ty; {
	if (p->in.op == SCONV) {
		switch (p->in.left->in.type) {
		  case CHAR:
		  case SHORT:
			/* short to unsigned can give wrong answers */
			/* for (sh * ush) or (ush * sh) */
			return (p->in.type == INT);
		  case UCHAR:
		  case USHORT:
			/* short to int is always OK */
			return 1;
		  default:
			return 0;
		}
	} else if (p->in.op == ICON && p->in.name[0] == '\0') {
		if (ISUNSIGNED(ty)) {
			if ((unsigned)p->tn.lval <= 0xFFFF) return 1;
		} else {
			if (p->tn.lval >= -32768  &&  p->tn.lval <= 32767)
				return 1;
		}
	}
	return 0;
}

NODE *
mkshort(p) register NODE *p; {
	if (p->in.op == SCONV) {
		switch (p->in.left->in.type) {
		  case SHORT:
		  case USHORT:
			p->in.op = FREE;
			return p->in.left;
		}
	}
	if (p->in.op == ICON  ||  p->in.op == SCONV)
		p->in.type = ISUNSIGNED(p->in.type) ? USHORT : SHORT;
	return p;
}

optim2( p ) register NODE *p; {
	/* do local tree transformations and optimizations */

	register NODE *q, *pl, *pll;
	register int i;
	register int ty;

	ty = p->in.type;
	switch ( p->in.op ) {
# ifdef MC68020
	  case ASG MUL:
# endif MC68020
	  case MUL:
		if (ty == INT || ty == UNSIGNED) {
			if (okshort(p->in.left,ty) && okshort(p->in.right,ty)) {
				/* Fix up the types and delete conversions */
				/* so hardops() can detect this case and */
				/* not force a call to rlmul() */
				p->in.left = mkshort(p->in.left);
				p->in.right = mkshort(p->in.right);
			}
		}
		return;
# ifdef MC68020
	  case ASG DIV:
	  case ASG MOD:
# endif MC68020
	  case DIV:
	  case MOD:
		if (ty == INT || ty == UNSIGNED) {
			if (okshort(p->in.left,ty) && okshort(p->in.right,ty)) {
				/* Fix up types and delete RHS conversions */
				/* so hardops() can detect these cases and */
				/* not force a call to rldiv or rlrem */
				/* LHS needs to be long, so leave it alone */
				/* Remember long/short may not be short */
				/* Also, long % short is short, but not */
				/* in the hardware */
				p->in.right = mkshort(p->in.right);
			}
		}
		return;
	  case SCONV:
		if (p->in.left->in.op == DIV  ||  p->in.left->in.op == MOD) {
			q = p->in.left;

/*			If possible, force the use of the 68000's divs. */
/*			Note: the okshort(q->in.left) makes sure that the */
/*			short divide/mod will not overflow */

/*			Why is this only done under SCONV nodes? */

			if (okshort(q->in.left,q->in.type)
			  && okshort(q->in.right,q->in.type))
				q->in.right = mkshort(q->in.right);
		}
		break;

# ifndef IEEE
	  case ASSIGN:
		q = p->in.right;
		pl = p->in.left;
		if (p->in.left->in.type == DOUBLE &&
		  (q->in.op == SCONV && q->in.left->in.type == FLOAT)) {
			p->in.right = q->in.left;	/* get rid of SCONV */
			q->in.op = FREE;
		}
		break;
# endif IEEE

/*
**	Much of the following functionality used to be in the peephole
**	optimizer.  As it did not quite work with our compiler, and as it
**	was really rather scary to have it there, it is now here.
**
**	Chris has pointed out that the btst optimization can mess up device
**	drivers that expect word accesses to their registers, so I have
**	added the -k option to kill btst optimization. -WT-
*/
	  case CBRANCH:
		if (killbtst)
			break;
		if (odebug) {
			printf("optim2: found CBRANCH node; p is\n");
			fwalk(p, eprint, 0);
		}
		pl = p->in.left;
		pll = pl->in.left;
		if (pl->in.op != AND || pl->in.right->in.op != ICON
		  || (i = mypow2(pl->in.right->tn.lval)) < 0)
			break;
		switch (pll->in.op) {
		  case UNARY MUL:
			switch (pll->in.left->in.op) {
			  case REG:
				pll->in.left->tn.lval += (3 - i/8);
				pl->in.right->tn.lval = i%8;
				goto changeop;
			
			  case MINUS:
			  	if (pll->in.left->in.right->in.op != ICON)
					goto nochange;
				pll->in.left->in.right->tn.lval -= (3 - i/8);
				pl->in.right->tn.lval = i%8;
				goto changeop;

			  default:
nochange:
				if (odebug) {
					printf("optim2: CBRANCH not changed\n");
					fwalk(p, eprint, 0);
				}
			}
			break;

		  case REG:
			pl->in.right->tn.lval = i;
			goto changeop;

		  case NAME:
			pll->tn.lval += (3 - i/8);
			pl->in.right->tn.lval = i%8;
changeop:
			pl->in.op = BTST;
			if (odebug) {
				printf("CBRANCH converted; p is\n");
				fwalk(p, eprint, 0);
			}
			break;
		}
		break;

	  case EQ:
	  case NE:
	  case LT:
	  case GT:
	  case LE:
	  case GE:

		pl = p->in.left;
		if (pl->in.op == SCONV && pl->in.type == INT
		  && pl->in.left->in.type == CHAR
		  && special(p->in.right,SCCON)) {
			p->in.left = pl->in.left;
			p->in.type = CHAR;
			pl->in.op = FREE;
			return;
		}
		break;
	}
}

/* ispow2() doesn't quite work for optim2 */
mypow2(n) register CONSZ n; {
	register int i, j;

	j = 1;
	for (i=0; i<32; i++) {
		if ((n & j) && !(n & ~j))
			return i;
		j <<= 1;
	}
	return -1;
}

myreader(p) register NODE *p; {
	if (p->in.op == INCR) p->in.op = ASG PLUS;	/* prevent delay */
	else if (p->in.op == DECR) p->in.op = ASG MINUS;
	walkf( p, optim2 );
	fwalk(p, hardasop, 0);	/* map hard asgops on floats */
	walkf( p, hardops );	/* convert ops to function calls */
	canon( p );		/* expands r-vals for fileds */
	toff = 0;  /* stack offset swindle */
}

special( p, shape ) register NODE *p; {
	/* special shape matching routine */

	switch ( shape ) {

	  case SCCON:
		if ( p->in.op == ICON && p->in.name[0]=='\0'
		  && p->tn.lval>= -128 && p->tn.lval <=127 ) return( 1 );
		break;

	  case SICON:
		if ( p->in.op == ICON && p->in.name[0]=='\0'
		  && p->tn.lval>= 0 && p->tn.lval <=32767 ) return( 1 );
		break;

	  case S8CON:
		if ( p->in.op == ICON && p->in.name[0]=='\0'
		  && p->tn.lval>= 1 && p->tn.lval <= 8) return( 1 );
		break;

	  default:
		cerror( "bad special shape" );

	}

	return( 0 );
}

# ifndef ONEPASS
main( argc, argv ) char *argv[]; {
	return( mainp2( argc, argv ) );
}
# endif

# ifdef MULTILEVEL
# ifdef BOZO
# include "mldec.h"
# endif

struct ml_node mltree[] ={

DEFINCDEC,	INCR,	0,
	INCR,	SANY,	TANY,
		OPANY,	SAREG|STAREG,	TANY,
		OPANY,	SCON,	TANY,

DEFINCDEC,	ASG MINUS,	0,
	ASG MINUS,	SANY,	TANY,
		REG,	SANY,	TANY,
		ICON,	SANY,	TANY,

TSOREG,	1,	0,
	UNARY MUL,	SANY,	TANY,
		REG,	SANY,	TANY,

TSOREG,	2,	0,
	UNARY MUL,	SANY,	TANY,
		PLUS,	SANY,	TANY,
			REG,	SANY,	TANY,
			ICON,	SANY,	TCHAR|TUCHAR|TSHORT|TUSHORT|TINT|TUNSIGNED|TPOINT,

TSOREG,	2,	0,
	UNARY MUL,	SANY,	TANY,
		MINUS,	SANY,	TANY,
			REG,	SANY,	TANY,
			ICON,	SANY,	TCHAR|TUCHAR|TSHORT|TUSHORT|TINT|TUNSIGNED|TPOINT,
0,0,0};
# endif
