/*
 * @(#)vfork.s	4.1 (Berkeley) 12/21/80
 * C library -- vfork
 */

/*
 * pid = vfork();
 *
 * d1 == 0 in parent process, d1 == 1 in child process.
 * d0 == pid of child in parent, d0 == pid of parent in child.
 */

#include "SYS.h"
	.set	vfork,66

ENTRY(vfork)
	movl	sp@+,a1		/* a1 must be preserved across sys call */
	movl	#vfork,d0
	trap	#1
	jcs	2f
	tstl	d1		/* parent process */
	jeq	1f		/* yes */
	movq	#0,d0
1:
	jmp	a1@

2:
	.globl	_errno
	movl	d0,_errno
	movq	#-1,d0
	jmp	a1@
