#include <ctype.h>
#include <stdio.h>
#include "o68.h"

static char rcsid[] = "$Header: o2.c,v 1.3 85/06/07 13:52:57 wendyt Exp $";

int	maskno;
int	maskvalue;

char	*copy();
long	astoi();

int	wval;

# ifdef CHKCMPOK
chkcmp(p)
struct node	*p;
{
    next:
#ifdef DEBUG
 	if (debug) {
 		printf("chkcmp processing p:\n");
 		trace(p);
 	}
#endif
 	if (!p)
 		return 1;
 	if (p->op == LABEL)
 		p = p->forw;
 	if (p->op == CBR || p->op == DBR || p->op == JBR || p->op == JMP) {
 		if ( chkcmp(p->ref)) {
 			p = p->forw;
 			goto next;
 		}
 		return 0;
 	}
 	else if (p->op == CMP && p->subop == LONG) {
 		dualop(p);
 		if (regs[RT1][0] == '#' && islt32k(wval=astoi(&regs[RT1][1]))) {
#ifdef DEBUG
 			if (debug) {
 				printf("chkcmp found, p:, p->forw:\n");
 				trace(p); trace(p->forw);
 			}
#endif
 			p = p->forw;
 			goto next;
 	    	}	
 		return 0;
 	}
 	return 1;
}
# else CHKCMPOK
chkcmp(p)
struct node	*p;
{
	return 0;
}
# endif CHKCMPOK
 
replcmp(p)
struct node	*p;
{
next:
 	if (!p)
 		return 1;
#ifdef DEBUG
	if (debug) {
		printf("replcmp, next,  p:\n");
		trace(p);
	}
#endif
 	if (p->op == LABEL)
 		p = p->forw;
 	if (p->op == CBR || p->op == DBR || p->op == JBR || p->op == JMP) {
#ifdef DEBUG
		if (debug)					/* WAT */
			printf("replcmp: calling replcmp\n");	/* WAT */
#endif
 		if ( replcmp(p->ref)) {
 			p = p->forw;
 			goto next;
 		}
 		return 0;
 	}
 	else if (p->op == CMP && p->subop == LONG) {
 		dualop(p);
 		if (regs[RT1][0] == '#' && islt32k(wval=astoi(&regs[RT1][1]))) {
 			p->subop = WORD;
#ifdef DEBUG
 			if (debug) {
 				printf("replcmp, after changing subop, p:, p->forw:\n");
 				trace(p); trace(p->forw);
 			}
#endif
 			p = p->forw;
 			goto next;
 	    	    }	
 		    return 0;
 	}
 	return 1;
}

inclabref(p)
struct node 	*p;
{
	struct node	*q;
	char		*r;
	int		labno;

	dualop(p);
	r = &(regs[RT1][0]);
	if ( *r++ != '#' || *r++ != 'L')
		return;
	labno = atoi(r);
#ifdef DEBUG
	if ( debug ) {
		printf("inclabref, found label no=%d, statement:\n",labno);
		trace(p);
	}
#endif
	for ( q = first.forw; q != 0; q = q->forw )
		if ( q->op == LABEL && q->labno == labno ) {
			q->refc++;
#ifdef DEBUG
			if ( debug ) {
				printf("inclabref, label referenced at:\n");
				trace(p); trace(q);
			}
#endif
			break;
		}
}

struct node *
delnode(p)
struct node	*p;
{
#ifdef DEBUG
	if ( debug ) {
		printf("delnode, deleting:\n");
		trace(p);
	}
#endif
	p->forw->back = p->back;
	p->back->forw = p->forw;
	p->ref = freenodes;
	freenodes = p;
	return p->forw;
}

rmdecr(p)
struct node	*p;
{
	char	*q;

	for ( q = &(p->code[0]); *q ; q++ )
		;

	*(--q) = 0;
}

chknestcall(p)
struct node	*p;
{
	struct node	*q, *r;

	if (((q = p->forw)->op == ADDQ) && ( q->subop == LONG) &&
		((r = q->forw)->op == MOV) && (r->subop == LONG )) {
			dualop(q);
			if (strcmp(regs[RT1],"#4") == 0 &&
			  strcmp(regs[RT2],"sp") == 0) {
			     dualop(r);
			     if (strcmp(regs[RT2],"sp@-") == 0) {
#ifdef DEBUG
			        if ( debug )
				     printf("found nested call sequence\n");
#endif
				q = delnode(q);		/* addq */
				rmdecr(q);
			     }
			}
		}
}

savemask(p)
struct node	*p;
{
	if ( !masksaved ) {
		masksaved = 1;
		dualop(p);
		if ( (regs[RT1][0] == '#') && (regs[RT1][1] == '_')
				&& (regs[RT1][2] == 'S'))
			maskno = atoi( &regs[RT1][3] );
#ifdef DEBUG
		if ( debug )
			printf("saving mask, maskno=%d\n",maskno);
#endif
	}
}

checkmask(p)
struct node	*p;
{
	char		*cp;
	struct node	*q;

	if ( !maskchecked ) {
		maskchecked = 1;
		maskvalue = 0;
		if ( maskno == atoi(&(p->code[2]) ) ) {
			maskchecked = masksaved = 0;
			cp = &(p->code[2]) ;
/* --LOOK-- */
			while ( *cp != '=' && *cp++ != '\n')
				;
			while ( *cp++ == ' ')
				;
			maskvalue = astoi(cp);
			if ( maskvalue == 0 )
			    for ( q = first.forw; q != 0; q = q->forw )
				if ( q->op == MOVEM ) {
				    dualop(q);
				    if ( maskno == astoi( &regs[RT1][3] )) {
					delnode(q);
					return;
				    }
				}

		}
#ifdef DEBUG
	    if ( debug )
		printf("checking mask, maskvalue=%d\n",maskvalue);
#endif
	}

}

trace(t)
register struct node *t;
{
	register struct optab *op;
	register int byte;


	switch (t->op) {

	    case END:
		return;

	    case LABEL:
		printf("L%d:\n", t->labno);
		break;

	    case DLABEL:
		printf("%s:\n", t->code);
		break;

	    default:
		byte = t->subop;
		if (byte==BYTE || byte==WORD || byte==LONG) 
			t->subop = 0;
		for (op = optab; op->opstring!=0; op++) 
			if (op->opcode == (t->op | (t->subop<<8))) {
				if (t->op==CBR || t->op==JBR)
				  	printf("\tj%s", op->opstring+1);
				else if (t->op==FCBR)
				  	printf("\tfj%s", op->opstring+2);
				else 
					printf("\t%s", op->opstring);
				if (byte==BYTE) 
					printf("b");
				if (byte==WORD) 
					printf("w");
				if (byte==LONG) 
					printf("l");
				if (byte==BYTE || byte==WORD || byte==LONG) 
					t->subop = byte;
				break;
			}
		if (t->op==JSW || t->op==JSL)
			printf("\tL%d%s\n", t->labno, t->code);
		else if (t->op==DBR || t->op==FDBR)
			printf("\t%sL%d\n", t->code, t->labno);
		else if (t->code)
			printf("\t%s\n", t->code);
		else if (t->op==JBR || t->op==CBR || t->op==FCBR)
			printf("\tL%d\n", t->labno);
		else
			printf("\n");
		break;

	    case 0:
		if (t->code)
			printf("%s", t->code);
		printf("\n");
		break;
	}
}

/*
** 	Routine to check if the constant argument fits within a byte
**	i.e. it is less than 256.
*/
int
islt256(l)
long l;
{
	if ( (l <= 127) && (l >= -127) )
		return 1;
	else
		return 0;
}

/*
** 	Routine to check if the constant argument fits within a word
**	i.e. it is less than 32k.
*/
int
islt32k(l)
long l;
{
	if ( (l <= 32766) && (l >= -32767) )
		return 1;
	else
		return 0;
}

/*
** 	Routine to check if the argument is a power of 2.
*/
int
ispow2(l)
unsigned long l;
{
	int	pow;

	pow = 0;
	while ( (l > 1) && ((l & 01) == 0 )) {
		l = l/2;
		pow = pow + 1;
	}
	if ( l != 1)
		return -1;
	else
		return pow;
}

# define	STATE0		0
# define	STATE1		1
# define	STATE2		2	
# define	STATE3		3		
# define	STATE4		4
# define	STATE5		5
# define	STATE6		6
# define	STATE7		7
# define	STATE8		8
# define	STATE9		9
# define	STATE10		10
# define	STATE11		11
# define	STATE12		12
# define	STATE13		13
# define	STATE14		14
# define	STATE16		16
# define	STATE17		17

int		state, startstate;
struct node	*startp;
int		r1, r2;
int		bitno;
int		di, ai, aj;
char		stopchar;
char		*pnchar;

repldreg()
{
	int	dj;

	if ( startstate != STATE2)
		return;
	dualop(startp);
	if ( (dj = isreg( regs[RT2] )) == di)
		if ( (dj = isreg( regs[RT1])) != -1) {
#ifdef DEBUG
			if (debug)
				printf("replacing d%d by d%d\n",di,dj);
#endif
			di = dj;
			delnode(startp);
		}
}

isaindir(i)
int	i;
{

	int	r;
	char	*p, *q;
	
	q = p = &regs[RT1][0];
	if ( *p++ == 'a' && i == atoi(p)) {
		r = 0;	/* source == ai */
		goto found;
	}
	p = &regs[RT2][0];
	if ( *p++ == 'a' && i == atoi(p))
		r = 1;  /* dest == ai */
	else
		return -1;
   found:
	if ( *(++p) == '@') {
		if ( !(*(++p)))
			return r;
		else
			return -1;
	}
	else
		return -1;
}

/*
**	Routine to check if an array indexing sequence starts
**	at p.
*/
arryindx(p)
struct node 	*p;
{
	struct node 	*q, *r;
	int		dk;
	int		opnd;

	dualop(p);
	if ( di == isreg( regs[RT2]))
	    if ( (r = p->forw)->op == MOV) {
#ifdef DEBUG
		    if (debug)
			printf("arryindx(state=%d), move after add found\n",
				state);
#endif
		    dualop(r);
		    if ( ( di == isreg(regs[RT1])) &&
			   ( (ai = isreg(regs[RT2])) != -1)) {
#ifdef DEBUG
	    		if (debug)
	    			printf("arryindx, di, ai found on move\n");
#endif
			if ( (r = r->forw)->op == MOV) {
			    dualop(r);
			    if ( (opnd = isaindir(ai-8)) >= 0 )
					goto found;
			}
			else if ( r->op == CLR) {
#ifdef DEBUG
			    if (debug)
				printf("array indexing CLR found\n");
#endif
			    dualop(r);
			    if ( (opnd = isaindir(ai-8)) >= 0 ) {
					if ( state == STATE9) 
						state = STATE17;
					else
						state = STATE16;
#ifdef DEBUG
				if (debug)
					printf("array indexing seq found, state=%d\n",state);
#endif
					goto found;
			    }
			}
		    }
	    }
	return 0;
  found:
	if ( state == STATE9) {
		if ( opnd == 0 )
			state = STATE10;
		else
			state = STATE11;
	}
	else if ( state == STATE3) {
		if ( opnd == 0 )
			state = STATE7;
		else
			state = STATE8;
	}
	return 1;
}

replaceop2(p)
struct node	*p;
{
	char	*q1, *q2, *qt;
	char    qq[128];

	qt = &qq[0];
	
	q2 = &(regs[RT1][0]);
	for (q1 = &(p->code[0]) ; *q1 && *q1 != ',' ; )
		*qt++ = *q1++;
	*qt++ = *q1++;
	while ( *qt++ = *q2++ )
		;
	*qt = 0;
	p->code = copy(&qq[0]);
}

opnds(p)
struct node	*p;
{
	char	*q1, *q2;

	q1 = &(regs[RT1][0]);
	q2 = &(p->code[0]);
	stopchar = ',';
	while ( *q1++ = *q2++) {
		if ( *q2 == '(') {
			stopchar = ')';
			pnchar = q1;
		}
		else if ( *q2 == stopchar)
			break;
	}
	if ( stopchar == ')' ) {
		*q1++ = stopchar;
		q2++;
	}
	*q1 = 0;
	q1 = &(regs[RT2][0]);
	q2++;
	while ( *q1++ = *q2++) 
		;
#ifdef DEBUG
	if (debug )
		printf("opnds, regs[RT1]=%s, regs[RT2]=%s\n",
			regs[RT1],regs[RT2]);
#endif
}

btstop(p, i)
struct node	*p;
{

	char	*qt;
	char    qq[128];

	qt = &qq[0];
	p->op = BTST;
	p->subop = 0;
	sprintf(qt,"#%02d,%s",bitno,&(regs[i][0]));
	p->code = copy(&qq[0]);
}
struct node	*
mbtstop(p, i)
struct node	*p;
{
	char	*qt;
	char    qq[128];

	if ( stopchar == ')')
	{
		qt = pnchar;
		if ( *(++qt) == '+' || *qt == '-')
				qt++;
		while ( *qt && *qt != ')' )
			if ( isdigit( *qt++ ) )
				continue;
			else
			{
				nchange--;
				return p;
			}

		p = delnode(p);		/* movw */
		p = delnode(p);		/* extl */
		p->op = BTST;
		p->subop = 0;

		qt = pnchar;
		sprintf(qt,"(%d)",(atoi(++pnchar)+1));
#ifdef DEBUG
		if ( debug )
			printf("mbtstop, regs after mod, regs[i]=%s\n", i,
					&(regs[i][0]));
#endif
		qt = &qq[0];
		sprintf(qt,"#%02d,%s",bitno,&(regs[i][0]));
		p->code = copy(&qq[0]);
	}
	else
	{
		qt = &regs[i][0];
		if ( *qt++ == 'a' && isdigit(*qt++) && *qt == '@') {
			p = delnode(p);		/* movw */
			p = delnode(p);		/* extl */
			qt = &qq[0];
			p->op = BTST;
			p->subop = 0;
			sprintf(qt,"#%02d,%s(1)",bitno,&(regs[i][0]));
			p->code = copy(&qq[0]);
		}
		else
			nchange--;
	}
	return p;
}

struct node	*
repl1byteindx(r)
struct node	*r;
{
	char	*qt;
	char    qq[128];

	r = delnode(r->forw->forw);	/* extl, past movb and extw */
	opnds(r);
	if ( (aj = isreg(regs[RT1])) && (aj > 7)) {
		r = delnode(r);		/* delete ai to aj move */
#ifdef DEBUG
		if ( debug )
			printf("replacing a%d by a%d\n",ai,aj);
#endif
		ai = aj;
	} else {
		qt = &qq[0];
		r->op = MOV;
		sprintf(qt,"%s,a%d",regs[RT1],ai-8);
		r->code = copy(&qq[0]);
		r = r->forw;
	}
	r = delnode(r);		/* movl */
	dualop(r);
	return r;
}

struct node	*
repl2byteindx(r)
struct node	*r;
{
	char	*qt;
	char    qq[128];


	repldreg();
	r = delnode(r->forw);	/* extl, past extw */
	opnds(r);
	if ( (aj = isreg(regs[RT1])) && (aj > 7)) {
		r = delnode(r);		/* delete ai to aj move */
#ifdef DEBUG
		if ( debug )
			printf("replacing a%d by a%d\n",ai,aj);
#endif
		ai = aj;
	} else {
		qt = &qq[0];
		r->op = MOV;
		sprintf(qt,"%s,a%d",regs[RT1],ai-8);
		r->code = copy(&qq[0]);
		r = r->forw;
	}
	r = delnode(r);		/* movl */
	dualop(r);
	return r;
}

struct node	*
replwordindx(r)
struct node	*r;
{
	char	*qt;
	char    qq[128];


	r = delnode(r->forw);   /* extl */
	r->subop = WORD;	/* asll */
	r = r->forw;
	opnds(r);		/* addl */
	if ( (aj = isreg(regs[RT1])) && (aj > 7)) {
		r = delnode(r);		/* delete ai to aj move */
#ifdef DEBUG
		if ( debug )
			printf("replacing a%d by a%d\n",ai,aj);
#endif
		ai = aj;
	} else {
		qt = &qq[0];
		r->op = MOV;
		sprintf(qt,"%s,a%d",regs[RT1],ai-8);
		r->code = copy(&qq[0]);
		r->subop = LONG;
		r = r->forw;
	}
	r = delnode(r);		/* movl */
	dualop(r);
	return r;
}

struct node *
rewrite(p,seqno)
struct node	*p;
int		seqno;
{
	struct node	*q, *r;
	char		qq[128];
	char		*qt;
	int		rn;

#ifdef DEBUG
	if (debug )
		printf("rewrite(seqno=%d)\n",seqno);
#endif
	switch ( seqno )
	{
	  case 1:
		nchange++;
		r = p->forw->forw;		/* extl */	
		r = delnode(r);
#ifdef DEBUG
		if (debug) {
			printf("after deleting, r:, r->forw:\n");
			trace(r); trace(r->forw);
			printf("rewrite(1) calling replcmp\n");	/* WAT */
		}
#endif
 		replcmp(r);
		return r;
	  case 2:
		nchange++;
		r = delnode(p->forw);    /* extl */
#ifdef DEBUG
		if (debug) {
			printf("after deleting, r:, r->forw:\n");
			trace(r); trace(r->forw);
			printf("rewrite(2) calling replcmp\n");	/* WAT */
		}
#endif
		replcmp(r);
		return r;
	  case 3:
		nchange++;
		opnds(p); 
		r = delnode(p);		/* movb */
		r = delnode(r);		/* extw */
		r = delnode(r);		/* extl */
		btstop(r, RT1);
		return r;
	  case 4:
		opnds(p);
		if ( ((rn = isreg(regs[RT1])) >= 0 ) && rn < 8 && (bitno <= 15)) {
			nchange++;
			r = delnode(p);		/* movw */
			r = delnode(r);		/* extl */
			btstop(r, RT1);
			return r;
		} else if ( bitno > 7 && bitno <= 15) {
			nchange++;
			r = delnode(p);		/* movw */
			r = delnode(r);		/* extl */
			bitno -= 8;
			btstop(r, RT1);
			return r;
		} else if ( bitno <= 7 ) {
			nchange++;
			r = mbtstop(p, RT1);
			return r;
		}
		break;
	  case 5:
		opnds(p);
		if ( ((rn = isreg(regs[RT1])) >= 0 ) ) {
			nchange++;
			if (rn < 8) {
				r = delnode(p);		/* movl */
				btstop(r, RT1);
			} else {
				r = p->forw;
				btstop(r, RT2);
			}
			return r;
		} else if ( bitno > 23 && bitno <= 31 ) {
			nchange++;
			bitno -= 24;
			r = delnode(p);		/* extl */
			btstop(r, RT1);
			return r;
		}
		break;
	  case 6:			/* byte, source */
		nchange++;
		r = repl1byteindx(p);
		qt = &qq[0];
		sprintf(qt,"a%d@(0,d%d:w),%s",ai-8,di,regs[RT2]);
		r->code = copy(&qq[0]);
		return r;
	  case 7:			/* byte, source */
		nchange++;
		r = repl2byteindx(p);
		qt = &qq[0];
		sprintf(qt,"a%d@(0,d%d:w),%s",ai-8,di,regs[RT2]);
		r->code = copy(&qq[0]);
		return r;
	  case 8:			/* byte, destination */
		nchange++;
		r = repl1byteindx(p);
		qt = &qq[0];
		sprintf(qt,"%s,a%d@(0,d%d:w)",regs[RT1],ai-8,di);
		r->code = copy(&qq[0]);
		return r;
	  case 9:			/* byte, destination */
		nchange++;
		r = repl2byteindx(p);
		qt = &qq[0];
		sprintf(qt,"%s,a%d@(0,d%d:w)",regs[RT1],ai-8,di);
		r->code = copy(&qq[0]);
		return r;
	  case 10:			/* word, source */
		nchange++;
		r = replwordindx(p);
		qt = &qq[0];
		sprintf(qt,"a%d@(0,d%d:w),%s",ai-8,di,regs[RT2]);
		r->code = copy(&qq[0]);
		return r;
	  case 11:			/* word, destination */
		nchange++;
		r = replwordindx(p);
		qt = &qq[0];
		sprintf(qt,"%s,a%d@(0,d%d:w)",regs[RT1],ai-8,di);
		r->code = copy(&qq[0]);
		return r;
	  case 12:
		nchange++;
		r = delnode(p->forw);	/* extl */
		r->subop = WORD;
		return r;
	  case 13:
		nchange++;
		r = p->forw;
		r->subop = WORD;
		return r;
	  case 14:
		nchange++;
		r = delnode(p->forw);    /* extl */
		r->subop = WORD;	 /* andl */
#ifdef DEBUG
		if (debug) {
			printf("after deleting, r:, r->forw:\n");
			trace(r); trace(r->forw);
			printf("rewrite(14) calling replcmp\n"); /* WAT */
		}
#endif
		r = r->forw;
		replcmp(r);
		return r;
	  case 16:
		nchange++;
		r = delnode(p->forw);	/* extw */
		r = delnode(r);		/* extl */
		r->subop = BYTE;
		return r;
	  case 18:
		nchange++;
		r = repl1byteindx(p);
		qt = &qq[0];
		sprintf(qt,"a%d@(0,d%d:w)",ai-8,di);
		r->code = copy(&qq[0]);
		return r;
	  case 19:
		nchange++;
		r = repl2byteindx(p);
		qt = &qq[0];
		sprintf(qt,"a%d@(0,d%d:w)",ai-8,di);
		r->code = copy(&qq[0]);
		return r;
	  case 20:
		nchange++;
		r = replwordindx(p);
		qt = &qq[0];
		sprintf(qt,"a%d@(0,d%d:w)",ai-8,di);
		r->code = copy(&qq[0]);
		return r;
	  default:
		printf("illegal optimizer sequence\n");
		break;
	}
	return p;
}

/*
**	Routine to look for the new instruction sequences.
*/
struct node *
newsqn(p,q)
struct node	*p,*q;
{
	int		seqno;
	struct node	*fp;
	char		byte,op;

#ifdef DEBUG
	if ( debug )
		printf("newsqn()\n");
#endif

	state = STATE0;
	fp = p;

   nextstate:
	if ( state != STATE0 )
		p = p->forw;
	if ( p == NULL)
		return fp;
#ifdef DEBUG
	if ( debug )
		printf(" state=%d\n",state);
#endif
	switch (p->op) 
	{

	    case MOV:
#ifdef DEBUG
		if (debug)
			printf("newsqn: case MOV\n");
#endif
		opnds(p);
		
		if ( (r1 = isreg(regs[RT2]))  != -1) {
			if ( state == STATE0 ) {
				if (p->subop==BYTE ) {
					singop(p=p->forw);
					if (p->op != EXT ||  p->subop != WORD)
						break;
					if ( ( (r2 = isreg(regs[RT1]) ) == -1)
				     	      || ( r2 != r1 ))
						break;
					di = r1;
					startstate = state = STATE1;
					startp = p;
					goto nextstate;
				} else if (p->subop==WORD) {
					di = r1;
					startstate = state = STATE2;
					startp = p;
					goto nextstate;
				} else if (p->subop==LONG) {
					di = r1;
					startstate = state = STATE5;
					startp = p;
					goto nextstate;
				}
			}

			break;
		}
		break;

	   case ADD:
#ifdef DEBUG
		if (debug)
			printf("newsqn: case ADD\n");
#endif
		if ( state == STATE3) {
			if (p->subop == LONG) {
#ifdef DEBUG
				if ( debug )
					printf("calling arryindx\n");
#endif
				if ( arryindx(p)) {
#ifdef DEBUG
					if (debug)
						printf("array indexing sequence found\n");
#endif
				}
			}
		}
		break;

	   case EXT:    
#ifdef DEBUG
		if (debug)
			printf("newsqn: case EXT\n");
#endif
	        if ( state == STATE1 || state == STATE2) {
			if (p->subop != LONG)
				break;
			singop(p);
			if ( ( (r1 = isreg(regs[RT1]) ) == -1)
				     	      || ( r1 != di ))
				break;
			state = STATE3;
			goto nextstate;
		}	
		break;

	   case CMP:  
#ifdef DEBUG
		if (debug)
			printf("newsqn: case CMP\n");
#endif
		if ( state == STATE3 || state == STATE4) {
			if (p->subop != LONG)
				break;
			if ( chkcmp(p) ) {
#ifdef DEBUG
				if (debug)
					printf("compare sequence found\n");
#endif
				if (state == STATE3)
					state = STATE4;
			}
		}
		break;

 	   case CBR:  
#ifdef DEBUG
		if (debug)
			printf("newsqn: case CBR\n");
#endif
		if ( state == STATE4) {
			/* check condition code */
			goto nextstate;
		}
		break;

	   case AND:
#ifdef DEBUG
		if (debug)
			printf("newsqn: case AND\n");
#endif
		if (state == STATE3 || state == STATE5) {
			if (p->subop != LONG)
				break;
			dualop(p);
			if (regs[RT1][0] == '#') {
			    if ( (bitno=ispow2((unsigned long)astoi(&regs[RT1][1]))) >= 0  ) {
				if (p->forw->op != CMP) {
					if (p->forw->op == CBR && (p->forw->subop == JEQ || p->forw->subop == JNE)) {
						state = STATE6;
#ifdef DEBUG
						if (debug)
							printf("found bit test sequence, bit=%d\n",bitno);
#endif
						break;
					}
				}
			    }
			    if ( (startstate==STATE2 || startstate==STATE5 ) &&
			    	islt32k(astoi(&regs[RT1][1]))) {
				if (p->forw->op != CMP) {
					if (p->forw->op == CBR) {
						state = STATE12;
#ifdef DEBUG
						if (debug)
						    printf("found andw seq\n");
#endif
						break;
					}
				} else if (p->forw->subop == LONG) {
					if (chkcmp(p->forw)) {
						state = STATE13;
						p = p->forw;
						break;
					}
				}
			    }
			    if ( startstate == STATE1 && 
			    	islt256(astoi(&regs[RT1][1]))) {
				if (p->forw->op != CMP) {
					if (p->forw->op == CBR) {
						state = STATE14;
#ifdef DEBUG
						if (debug)
							printf("found andw sequence\n");
#endif
						break;
					}
				}
			    }
			}
		}
		break;
	  case ASL:
#ifdef DEBUG
		if (debug)
			printf("newsqn: case ASL\n");
#endif
		if ( state == STATE3)
			if (p->subop  == LONG) {
#ifdef DEBUG
				if ( debug )
					printf("calling arryindx\n");
#endif
				state = STATE9;
				if ( arryindx(p->forw)) {
#ifdef DEBUG
					if (debug)
						printf("array indexing sequence found\n");
#endif
				}
			}
		break;
	  default:
#ifdef DEBUG
		if ( debug)
			printf("newsqn, default case\n");
#endif
		break;
	}
#ifdef DEBUG
	if (debug)
		printf("newsqn: before state switch, state=%d, startstate=%d\n",
			state, startstate);
#endif
	switch ( state )
	{
	  case STATE4:
		if (startstate == STATE1)
			fp = rewrite(fp,1);
		else
			fp = rewrite(fp,2);
		break;
	  case STATE6:
		if (startstate == STATE1)
			fp = rewrite(fp,3);
		else if (startstate == STATE2)
			fp = rewrite(fp,4);
		else
			fp = rewrite(fp,5);
		break;
	  case STATE7:
		if (startstate == STATE1)
			fp = rewrite(fp,6);
		else if (startstate == STATE2)
			fp = rewrite(fp,7);
		break;
	  case STATE8:
		if (startstate == STATE1)
			fp = rewrite(fp,8);
		else if (startstate == STATE2)
			fp = rewrite(fp,9);
		break;
	  case STATE10:
		if (startstate == STATE2)
			fp = rewrite(fp,10);
		break;
	  case STATE11:
		if (startstate == STATE2)
			fp = rewrite(fp,11);
		break;
	  case STATE12:
		if (startstate == STATE2)
			fp = rewrite(fp,12);
		else if (startstate == STATE5)
			fp = rewrite(fp,13);
		break;
	  case STATE13:
		if (startstate == STATE2)
			fp = rewrite(fp,14);
		break;
	  case STATE14:
		if (startstate == STATE1)
			fp = rewrite(fp,16);
		break;
	  case STATE16:
		if (startstate == STATE1)
			fp = rewrite(fp,18);
		else if (startstate == STATE2)
			fp = rewrite(fp,19);
		break;
	  case STATE17:
		if (startstate == STATE2)
			fp = rewrite(fp,20);
		break;
	}
	return fp;
}

equivpattern(p,q,no)
struct node	*p,*q;
{
#ifdef DEBUG
	if ( debug )
		printf("equivpattern\n");
#endif
}
