# include "DEFS.h"

/************************************************************************/
/*									*/
/*  Original version COPYRIGHT 1983  by					*/
/*									*/
/*  U  S   S o f t w a r e    C o r p o r a t i o n			*/
/*									*/
/************************************************************************/
/*									*/
/*  Last revision:  30 Dec 1983						*/
/*  Extensive revisions by Wendy Thrash:  25 Mar 1985			*/
/*									*/
/*  There were some real problems with this software because it did not	*/
/*  save and restore registers.  Also, its call interface was screwy.	*/
/*  It would have been possible to get around this with wrappers, but	*/
/*  I did not wish to sacrifice performance.  Changes:			*/
/*	1) Assembler format changed from Motorola to whatever ours is	*/
/*	2) Call and return are now bsr, rts				*/
/*	3) Arguments come in on stack, results go out in d0/d1		*/
/*	4) An internal call interface still passes a return address	*/
/*		in a0; [FD]OPRSL returns through a0 if it is non-zero	*/
/*	5) New entry point names added					*/
/*									*/
/************************************************************************/

.data
.globl FPERR
.globl NANFLG
.globl INFFLG
.globl UNFFLG

FPERR:	.space	1
NANFLG:	.space	1
INFFLG:	.space	1
UNFFLG:	.space	1

.text


FBIAS = 127		/* Single precision format exponent bias */
DBIAS = 1023		/* Double precision format exponent bias */


CCRC = 0x1		/* Carry bit in CCR */
CCRV = 0x2		/* Overflow bit in CCR */
CCRZ = 0x4		/* Zero bit in CCR */
CCRN = 0x8		/* Negative bit in CCR */
CCRX = 0x10		/* Extend bit in CCR */


ERNAN = 3
EROVF = 2
ERUNF = 1

.globl	FNANRS		/* For use by library routines */
.globl	FINFRS		/* For use by library routines */
.globl	FUNFRS		/* For use by library routines */
.globl	FZERRS		/* For use by library routines */

.globl	DNANRS		/* For use by library routines */
.globl	DINFRS		/* For use by library routines */
.globl	DUNFRS		/* For use by library routines */
.globl	DZERRS		/* For use by library routines */

.globl	GETFP1		/* For use by library routines */
.globl	GETDP1		/* For use by library routines */

/*  dpufloat */
/*  ======= */
/*  Float the unsigned integer value on the stack into a double precision */
/*  floating point value in D0:D1. */

ASENTRY(dpufloat)
	link	fp,#-40
	moveml	#0x3cfc,sp@	/* Save registers */
	subl	a0,a0		/* Return flag for DOPRSL */
	subl	a2,a2		/* Set A2 = 0 */
	clrl	d0		/* Set high word of argument */
	movl	fp@(8),d1	/* Get argument */
	bne	dpf02		/* Jump if value != 0 */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts

/*  dpfloat */
/*  ====== */
/*  Float the integer value on the stack into a double precision floating */
/*  point value in D0:D1. */

ASENTRY(dpfloat)
	link	fp,#-40
	moveml	#0x3cfc,sp@	/* Save registers */
	subl	a0,a0		/* Return flag for DOPRSL */
	subl	a2,a2		/* Set A2 = 0 */
	clrl	d0		/* Set high word of argument */
	movl	fp@(8),d1	/* Get argument */
	bne	dpf01		/* Jump if value != 0 */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts

dpf01:	bge	dpf02		/* Jump if value > 0 */
	subql	#1,a2		/* Set A2 = -1 */
	moveq	#-1,d0		/* Worry about 0x80000000 case */
	negl	d1
	negxl	d0

dpf02:	movl	#DBIAS+63,d2	/* Default bias value */
	andl	d0,d0
	bne	dpf03		/* Jump if 32 bit shift not required */

	subw	#32,d2		/* Reduce exponent */
	exg	d0,d1		/* Do shift (since D0 is zero) */

dpf03:	cmpl	#0x0000FFFF,d0
	bhi	dpf04		/* Jump if 16 bit shift not required */

	swap	d0		/* Do the shift */
	swap	d1
	movw	d1,d0
	clrw	d1
	subw	#16,d2

dpf04:	andl	d0,d0
	bmi	dpf07		/* Jump if value normalized */

dpf05:	subql	#1,d2		/* Dec exponent, shift mantissa */
	asll	#1,d1
	roxll	#1,d0
	bpl	dpf05		/* Jump if more shifts to do */

dpf07:	exg	d0,d2		/* Position to standard D0/D2:D3/A2 form */
	movl	d1,d3
	jra	DOPRSL		/* Jump if double precision result (w/ round) */


/*  dpufix */
/*  ====== */
/*  Convert the double precision argument on the stack to an unsigned */
/*  integer value */

ASENTRY(dpufix)
	link	fp,#-40
	moveml	#0x3cfc,sp@
	jbsr	GETDP1		/* Get argument */
	andw	d0,d0
	bne	dufix05		/* Jump if argument not zero */
	clrl	d0		/* Return integer zero */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts			/* Return */
dufix05:
	cmpw	#DBIAS,d0
	bcc	dufix10		/* Jump if abs() >= 1.0  [BCC == BHS] */

	clrl	d0		/* Return a zero value */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	orb	#CCRC+CCRX,cc	/* Set carry/extend bits */
	rts

dufix10: subw	#DBIAS+32,d0
	blt	dufix20		/* Jump if abs() < 2^31 */

	movl	a2,d2
	bne	dufix15
	movl	#0xffffffff,d0
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts
dufix15:
	movl	#0x80000000,d0
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts

dufix20: clrl	d1		/* Clear bit drop off accum */
	addql	#1,d0		/* Correct shift count */
	negw	d0		/* Positive shift count */
	cmpw	#16,d0
	blt	dufix25		/* J/ less than a swap left */

	orw	d3,d1		/* Accum any bits dropped off */

	movw	d2,d3		/* Do a swap shift (16 bits) */
	swap	d3
	clrw	d2
	swap	d2

	subw	#16,d0

dufix25: subqw	#1,d0
	blt	dufix35		/* Jump if shifting complete */

dufix30: lsrl	#1,d2
	roxrl	#1,d3

	roxll	#1,d1

	dbra	d0,dufix30

dufix35: cmpw	#0,a2		/* Check for negative value */
	beq	dufix40		/* Jump if positive */

	negl	d2

dufix40: moveq	#-1,d0
	addl	d1,d0		/* Set carry if bits lost */

	exg	d2,d0		/* Move integer result to D0:D1 */
				/* Use exg to avoid killing carry flag */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts


/*  dpfix */
/*  ===== */
/*  Convert the double precision argument on the stack to an integer value */

ASENTRY(dpfix)
	link	fp,#-40
	moveml	#0x3cfc,sp@
	jbsr	GETDP1		/* Get argument */
	andw	d0,d0
	bne	dfix05		/* Jump if argument not zero */
	clrl	d0		/* Return integer zero */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts			/* Return */
dfix05:
	cmpw	#DBIAS,d0
	bcc	dfix10		/* Jump if abs() >= 1.0  [BCC == BHS] */

	clrl	d0		/* Return a zero value */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	orb	#CCRC+CCRX,cc	/* Set carry/extend bits */
	rts

dfix10:	subw	#DBIAS+31,d0
	blt	dfix20		/* Jump if abs() < 2^31 */

	movl	a2,d2
	bne	dfix15
	movl	#0x7fffffff,d0
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts
dfix15:
	movl	#0x80000000,d0
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts

dfix20:	clrl	d1		/* Clear bit drop off accum */
	negw	d0		/* Positive shift count */
	cmpw	#16,d0
	blt	dfix25		/* J/ less than a swap left */

	orw	d3,d1		/* Accum any bits dropped off */

	movw	d2,d3		/* Do a swap shift (16 bits) */
	swap	d3
	clrw	d2
	swap	d2

	subw	#16,d0

dfix25:	subqw	#1,d0
	blt	dfix35		/* Jump if shifting complete */

dfix30:	lsrl	#1,d2
	roxrl	#1,d3

	roxll	#1,d1

	dbra	d0,dfix30

dfix35:	cmpw	#0,a2		/* Check for negative value */
	beq	dfix40		/* Jump if positive */

	negl	d2

dfix40:	moveq	#-1,d0
	addl	d1,d0		/* Set carry if bits lost */

	exg	d2,d0		/* Move integer result to D0:D1 */
				/* Use exg to avoid killing carry flag */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts


/*  adsub */
/*  ===== */
/*  Double precision assign plus routine */
ASENTRY(adsub)
	link	fp,#-40
	moveml	#0x3cfc,sp@
	jbsr	GETADP		/* Fetch operands, set assign flag */
	bra	DPS005

/*  adadd */
/*  ===== */
/*  Double precision assign plus routine */
ASENTRY(adadd)
	link	fp,#-40
	moveml	#0x3cfc,sp@
	jbsr	GETADP		/* Fetch operands, set assign flag */
	bra	DPA005

/*  dpsub */
/*  ===== */
/*  Double precision subtract routine */
ASENTRY(dpsub)
	link	fp,#-40
	moveml	#0x3cfc,sp@
	subl	a0,a0		/* Clear DOPRSL return flag */
	jbsr	GETDP2		/* Fetch both operands */
DPS005:	exg	d2,a2		/* Flip sign information */
	notl	d2
	exg	d2,a2
	bra	DPA005		/* Now do add */

/*  Double precision add routine */
ASENTRY(dpadd)
	subl	a0,a0		/* Clear DOPRSL return flag */
	link	fp,#-40
	moveml	#0x3cfc,sp@
	jbsr	GETDP2		/* Fetch both operands */
DPA005:	cmpw	#0x7FF,d0

	bne	DPA010		/* J/ operand not NaN/INF */

	lsll	#1,d2		/* Remove implicit bit */
	jne	DNANRS		/* J/  ?  + NaN -> NaN */

	cmpw	#0x7FF,d1
	jne	DINFRS		/* J/  0,num + INF -> INF */

	lsll	#1,d4		/* Remove implicit bit */
	jne	DNANRS		/* J/ INF + NaN -> NaN */

	cmpl	a2,a3
	jne	DNANRS		/* J/ INF - INF -> NaN */
	jra	DINFRS		/*    INF + INF -> INF */


DPA010:	cmpw	#0x7FF,d1
	bne	DPA040		/* J/ not NaN or INF */

	lsll	#1,d4		/* Remove implicit bit */
	jne	DNANRS		/* J/ NaN + 0,num -> NaN */

	movl	a3,a2		/* Move sign over */
	jra	DINFRS		/* INF result */


DPXSUB:				/* Entry for dpcmp */
DPA040:	andw	d1,d1
	jeq	DOPRSL		/* J/ 0,num + 0 -> 0,num */

	andw	d0,d0
	bne	DPA045		/* J/ no zeroes involved */

	movw	d1,d0		/* Copy over data */
	movl	d4,d2
	movl	d5,d3
	movl	a3,a2
	jra	DOPRSL


DPA045:
	cmpw	d1,d0
	bcc	DPA060		/* J/ op1.exp >= op2.exp */

	exg	d2,d4		/* Flip mantissas */
	exg	d3,d5
	exg	d0,d1
	exg	a2,a3

DPA060:	subw	d0,d1
	negw	d1
	cmpw	#53,d1
	jhi	DOPRSL		/* J/ op2 too small to matter */

	cmpw	#32,d1
	blt	DPA061		/* J/ less than a word shift */

	movl	d4,d5
	clrl	d4

	subw	#32,d1

DPA061:	cmpw	#16,d1
	blt	DPA062		/* J/ less than a swap shift left */

	movw	d4,d5		/* Do a swap shift (16 bits) */
	clrw	d4
	swap	d5
	swap	d4

	subw	#16,d1

DPA062:	moveq	#-1,d7		/* Mask in D7 */
	lsrl	d1,d7
	rorl	d1,d4
	rorl	d1,d5
	andl	d7,d5		/* Trim bits */
	eorl	d4,d5		/* Mix in D4 -> D5 bits */
	andl	d7,d4		/* Strip D4 -> D5 bits */
	eorl	d4,d5		/* Finish   LSL  D0,D4:D5 */

	cmpl	a2,a3
	bne	DPS100		/* J/ subtract operation */

	addl	d5,d3
	addxl	d4,d2
	bcc	DOPRSL		/* J/ no carry out */

	roxrl	#1,d2		/* Handle carry out */
	roxrl	#1,d3
	addqw	#1,d0		/* Bump the exponent */
	jra	DOPRSL


DPS100:	subl	d5,d3		/* Do the subtract */
	subxl	d4,d2
	bcc	DPS110

	negl	d3
	negxl	d2

	movl	a3,a2		/* Flip sign */

DPS110:	andl	d2,d2		/* Normalization section */
	bne	DPS115		/* J/ top word is not zero */

	exg	d2,d3
	subw	#32,d0		/* Reduce exponent appropriately */

	andl	d2,d2
	jeq	DZERRS		/* J/ zero result */

DPS115:	cmpl	#0x0000FFFF,d2
	bhi	DPS118		/* J/ less than a swap shift left */

	swap	d2		/* Do a swap shift (16 bits) */
	swap	d3
	movw	d3,d2
	clrw	d3

	subw	#16,d0

DPS118:	tstl	d2
	jmi	DOPRSL		/* J/ normalized */

	subqw	#1,d0		/* Decrease exponent value */
DPS120:	lsll	#1,d3
	roxll	#1,d2
	dbmi	d0,DPS120	/* J/ not normalized */

	jra	DOPRSL

	

/*  admul */
/*  ===== */
/*  Double precision assign multiply routine */
ASENTRY(admul)
	link	fp,#-40
	moveml	#0x3cfc,sp@
	jbsr	GETADP		/* Fetch operands, set assign flag */
	bra	DPM005


/*  Double precision multiply routine. */

ASENTRY(dpmul)
	subl	a0,a0		/* Clear DOPRSL return flag */
	link	fp,#-40
	moveml	#0x3cfc,sp@
	jbsr	GETDP2		/* Fetch both operands */
DPM005:	movw	a2,d6
	movw	a3,d7
	eorw	d6,d7
	movw	d7,a2		/* Result's sign */

	andw	d0,d0
	bne	DPM010		/* J/ operand <> 0.0 */

	cmpw	#0x7FF,d1
	jeq	DNANRS		/* J/ 0.0 * NaN,INF -> NaN */
	jra	DZERRS		/* J/ 0.0 * 0.0,num -> 0.0 */

DPM010:	cmpw	#0x7FF,d0
	bne	DPM020		/* J/ operand is a number */

	lsll	#1,d2
	jne	DNANRS		/* J/ NaN *  ?  -> NaN */

	andw	d1,d1
	jeq	DNANRS		/* J/ INF * 0.0 -> NaN */

	cmpw	#0x7FF,d1
	jne	DINFRS		/* J/ INF * num -> INF */
	lsll	#1,d4
	jeq	DINFRS		/* J/ INF * INF -> INF */
	jra	DNANRS		/* J/ INF * NaN -> NaN */

DPM020:	andw	d1,d1
	jeq	DZERRS		/* J/ num * 0.0 -> 0.0 */

	cmpw	#0x7FF,d1
	bne	DPM040		/* J/ num * num */

	lsll	#1,d4
	jeq	DINFRS		/* J/ num * INF -> INF */
	jra	DNANRS		/* J/ num * NaN -> NaN */


DPM040:	addw	d1,d0		/* Calculate result`s exponent */
	subw	#DBIAS-1,d0	/* Remove double bias, assume shift */
	movw	d0,a3		/* Save exponent in A3, free up D0 */

DPM050:				/* Entry for dpdiv...... */
	movl	d2,d0		/* A * D */
	movl	d5,d1
	bsrs	DPM500		/* 32 x 32 partial multiply */
	movl	d0,d5		/* Save word */

	movl	d3,d0		/* B * C */
	movl	d4,d1
	bsrs	DPM500		/* 32 x 32 partial multiply */
	movl	d0,d3

	movl	d2,d0		/* A * C */
	movl	d4,d1
	bsrs	DPM500		/* 32 x 32 partial multiply */

	clrl	d2		/* Sum partial multiply results */
	addl	d5,d3
	addxl	d2,d2		/* Preserve possible carry out */
	addl	d1,d3
	addxl	d0,d2
	movw	a3,d0		/* Restore exponent */

	tstl	d2		/* Check for normalized result */
	jmi	DOPRSL		/* J/ result normalized */

	asll	#1,d3		/* One left shift to normalize */
	roxll	#1,d2
	subqw	#1,d0
	jra	DOPRSL

/*  DPM500: 32 x 32 partial multiply routine */

/*  Multiply D0 by D1 (long words) yielding a 64 bit result. */

DPM500:	movw	d0,d6		/* Copy over B */
	swap	d1
	mulu	d1,d6		/* Produce BC */
	swap	d0
	swap	d1
	movw	d1,d7
	mulu	d0,d7		/* Produce AD */
	addl	d6,d7		/* Produce BC+AD in D6:D7 */
	subxl	d6,d6
	negl	d6
	swap	d6		/* Properly position BC+AD */
	swap	d7
	movw	d7,d6

	movw	d1,d7		/* Save D (slide in under BC+AD) */
	swap	d1
	mulu	d0,d1		/* Produce AC */
	swap	d0
	mulu	d7,d0
	clrw	d7		/* Restore D6:D7 */
	exg	d0,d1		/* AC:BD, then result, in D0:D1 */
	addl	d7,d1
	addxl	d6,d0
	rts


/*  addiv */
/*  ===== */
/*  Double precision assign divide routine */
ASENTRY(addiv)
	link	fp,#-40
	moveml	#0x3cfc,sp@
	jbsr	GETADP		/* Fetch operands, set assign flag */
	bra	DPD005


/*  Double precision division operation. */

ASENTRY(dpdiv)
	subl	a0,a0		/* Clear DOPRSL return flag */
	link	fp,#-40
	moveml	#0x3cfc,sp@
	jbsr	GETDP2

DPD005:	movw	a2,d6		/* Compute result's sign */
	movw	a3,d7
	eorw	d6,d7
	movw	d7,a2

	andw	d0,d0
	bne	DPD010		/* J/ divisor is not zero */

	andw	d1,d1
	jeq	DNANRS		/* J/ 0.0 / 0.0 -> NaN */
	cmpw	#0x7FF,d1
	jne	DINFRS		/* J/ num / 0.0 -> INF */
	lsll	#1,d4
	jeq	DINFRS		/* J/ INF / 0.0 -> INF */
	jra	DNANRS		/* J/ NaN / 0.0 -> NaN */

DPD010:	cmpw	#0x7FF,d0
	bne	DPD020		/* J/ divisor is a normal number */

	lsll	#1,d2
	jne	DNANRS		/* J/  ?  / NaN -> NaN */
	andw	d1,d1
	jeq	DZERRS		/* J/ 0.0 / INF -> 0.0 */
	cmpw	#0x7FF,d1
	jne	DUNFRS		/* J/ num / INF -> 0.0 (w/ underflow) */
	jra	DNANRS		/* J/ NaN,INF / INF -> NaN */

DPD020:	andw	d1,d1
	jeq	DZERRS		/* J/ 0.0 / num -> 0.0 */
	cmpw	#0x7FF,d1
	bne	DPD040		/* J/ num / num */

	lsll	#1,d4
	jeq	DINFRS		/* J/ INF / num -> INF */
	jra	DNANRS		/* J/ NaN / num -> NaN */

/*  Division Algorithm: */

/*  (1)  Use a two stage recipication approximation to obtain 1/B */
/*       (a)  X0 = 1 / (B0 + B1)    (B0 is ms 16 bits of B, B1 = B - B0) */
/*               = 1/B0 * (1 - B1/B0)  { accurate to 28+ bits) */
/*       (b)  X1 = X0 * (2 - B*X0)  (N-R iteration, 55+ bits accuracy) */
/*  (2)  Use dpmul entry to produce A * X1 (64 bit computation) */


DPD040:	subw	d0,d1
	addw	#DBIAS,d1	/* Restore bias */
	movw	d1,a3		/* Save exponent in A3 */

	movl	d5,sp@-		/* Save dividend mantissa on stack */
	movl	d4,sp@-

	moveq	#1,d6		/* Create a 1.0 entry */
	rorl	#2,d6		/* Set D4 = 4000 0000H */
	swap	d2
	divu	d2,d6		/* Top fifteen bits of 1/B */
	movw	d6,d4		/* 1/B ultimately into D4:D5 */
	movw	d6,d7		/* Save for correction term */
	swap	d4		/* Position MS word */
	clrw	d6		/* Zero low order bits in D6 */
	divu	d2,d6		/* Division of shifted remainder */
	movw	d6,d4		/* Complete 1/B approximation */

	movl	d2,d6
	clrw	d6		/* Create a shifted C in D6 (16 bits) */
	lsrl	#1,d6		/* Insure no division overflow */
	divu	d2,d6		/* C/B approximation */
	mulu	d7,d6
	lsrl	#8,d6		/* Position correction term */
	lsrl	#7,d6
	subl	d6,d4
	lsll	#1,d4		/* Left shift approximation */
	subxl	d6,d6		/* Do not overflow */
	orl	d6,d4		/* 28+ bit 1/B approx in D4, B in D2:D3 */
	swap	d2

	movl	d4,d0		/* Save X0 in D0 */
	bsr	DPD500		/* D4 * D2:D3 -> D2:D3 (in place) */
	negl	d3
	negxl	d2
	movl	d0,d4
	bsr	DPD500

	asll	#1,d3
	roxll	#1,d2
	bcc	DPD080		/* J/ no shift out */
	moveq	#-1,d2		/* Set D2:D3 to FFFFFFFF:FFFFFFFF */
	moveq	#-1,d3
DPD080:
	movl	sp@+,d4	/* Fetch dividend */
	movl	sp@+,d5
	bra	DPM050

/*  DPD500:  Multiply D2:D3 by D4, top 64 bits of result in D2:D3 */

DPD500:	movw	d2,d1
	mulu	d4,d1		/* BY partial product */
	swap	d2
	swap	d3
	movw	d3,d7
	movw	d2,d6
	mulu	d4,d7
	mulu	d4,d6		/* AY:CY in D6:D7 */
	movw	d6,d7
	clrw	d6
	swap	d6
	swap	d7		/* LSR #16,D6:D7 */
	addl	d1,d7
	clrl	d1
	addxl	d1,d6		/* 00:BY + 0A:YC */

	swap	d4
	movw	d3,d5
	movw	d2,d1
	mulu	d4,d5
	mulu	d4,d1		/* AX:CX in D1:D5 */
	addl	d5,d7
	addxl	d1,d6		/* AX:CX + 00:BY + 0A:CY */

	swap	d2
	swap	d3
	mulu	d4,d3
	mulu	d4,d2		/* BX:DX in D2:D3 */
	movw	d2,d3
	clrw	d2
	swap	d2
	swap	d3		/* LSR #16,D2:D3 */
	addl	d7,d3
	addxl	d6,d2		/* Result in D2:D3 */

	swap	d4		/* Restore D4 */
	rts

	

/*  Double Precision comparison routine. */

/*  Compare the two arguments provided and set the condition code */
/*  register bits N, Z, and V as follows: */

/*      N  Z  V   Relation */
/*      =  =  =   ==================================== */
/*      1  0  0   X > Y   (X is top argument on stack) */
/*      0  1  0   X = Y   (within FFUZZ specification) */
/*      0  0  0   X < Y */
/*      0  0  1   X does not compare to Y */


DFUZZ = 53		/* Fifty-one bits of fuzz */


ASENTRY(dpcmp)
	link	fp,#-40
	moveml	#0x3cfc,sp@
	jbsr	GETDP2
	cmpw	#0x7FF,d0
	bne	DPC020		/* J/ X is not INF or NaN */

	lsll	#1,d2		/* Remove implicit bit */
	beq	DPC005		/* J/ X is INF */

DPC001:				/* **  X does not compare to Y  ** */
	moveq	#CCRV,d0	/* CCR V bit */
	movw	d0,cc
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts			/* Return */

DPC005:	cmpw	#0x7FF,d1
	bne	DPC009		/* J/ Y is not INF or NaN */

	lsll	#1,d4
	bne	DPC001		/* J/ Y is NaN (does not compare) */

	cmpw	a2,a3
	beq	DPC001		/* J/ INF's with same sign - no compare */

DPC009:	movw	a2,d0		/* Result based on compl. of X's sign */
	eorw	#CCRN,d0
	bra	DPC011

DPC010:	movw	a3,d0		/* Set result based on Y's sign */
DPC011:	andw	#CCRN,d0
	movw	d0,cc
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts


DPC020:	cmpw	#0x7FF,d1
	bne	DPC030		/* J/ Y is not NaN or INF */

	lsll	#1,d4
	bne	DPC001		/* J/ Y is NaN - no comparison */
	bra	DPC010		/* Result is based on Y's sign */

DPC030:	cmpw	a2,a3
	beq	DPC035		/* Let's make 0 = -0 (WT) */
	movl	d1,d1		/* For following branch */
	bne	DPC010		/* Really differ; use Y's sign */
	movl	d2,d2		/* For following branch */
	bne	DPC010		/* Really differ; use Y's sign */
	movl	d4,d4		/* For following branch */
	bne	DPC010		/* Really differ; use Y's sign */
	movl	d5,d5		/* For following branch */
	bne	DPC010		/* Really differ; use Y's sign */
	bra	DPC050		/* Really 0 = -0 */

DPC035:	movw	d0,d6
	movw	d0,d7		/* Assume X's exp is larger */
	subw	d1,d6		/* Calc difference in exponents */
	bpl	DPC031		/* J/ positive */
	movw	d1,d7		/* Y's exp is larger */
	negw	d6
DPC031:
	lsrw	#1,d6
	beq	DPC040		/* Must subtract to obtain result */

	subw	d0,d1
	subxw	d0,d0		/* Set D0 to sign of Y[exp]-X[exp] */
	movw	a2,d1
	eorw	d1,d0		/* Flip if negative values */
	bra	DPC011		/* Result based on value in D0 */

DPC040:	movw	d7,sp@-		/* Save max exp value */

/*	In the following 3 lines, d7 used to be d0. Changed per memo 103 */
/*	(actually, memo 103 said d5, but that caused problems for me) */
	movw	a2,d7
	notw	d7		/* Flip sign of opnd (force subtract) */
	movw	d7,a2

	movl	#DPC041,a0	/* Return address in A0 */

	jra	DPXSUB

DPC041:	movl	d1,d3		/* for CMPGET */
	jbsr	DCMPGET		/* Fetch and unpack result */

	movw	sp@+,d7		/* Recall max exp value */

	andw	d0,d0
	beq	DPC050		/* J/ zero result */

	subw	d0,d7
	cmpw	#DFUZZ,d7
	bge	DPC050		/* J/ within FFUZZ specification - zero */

	movw	a2,d0		/* Sign of result into D0 */
	bra	DPC011		/* Comparison result from sign of sub */

DPC050:	subw	d0,d0		/* Force CCR to say "Z" */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts			/* Return */

	
/*  GETADP */
/*  ====== */
/*  Get double precision arguments for assign op routines. */
/*  The address of one argument and the value of the other are on the stack. */

GETADP:
	movl	fp@(12),d0	/* Get argument */
	movl	fp@(16),d3	/* Get argument (low part) */
	subw	d2,d2		/* Clear carry */
	roxll	#1,d0		/* Sign bit to bit 0 */
	subxw	d2,d2		/* Fill D2 with sign bit */
	movw	d2,a2		/* Sign bit info to A2 */
	roll	#8,d0		/* Left justify mantissa, position exp */
	roll	#3,d0
	movl	d0,d2		/* Copy into mantissa register */
	andw	#0x7FF,d0	/* Mask to exponent field */
	beq	GETA10		/* J/ zero value */

	eorw	d0,d2		/* Zero exponent bits in D2 */
	lsrl	#1,d2		/* Position mantissa */
	bset	#31,d2		/* Set implicit bit in D2 */
	roll	#8,d3		/* Position lo long word of mantissa */
	roll	#3,d3
	eorw	d3,d2		/* Clever use of EOR to move bits */
	andw	#0xF800,d3	/* Trim off bits moved into D2 */
	eorw	d3,d2		/* Remove noise in D2 */

GETA10:

	movl	fp@(8),a0	/* Get argument address */
	movl	a0@,d1		/* Get argument */
	movl	a0@(4),d5	/* Get argument (low part) */
	subw	d4,d4		/* Clear carry */
	roxll	#1,d1		/* Sign bit carry */
	subxw	d4,d4		/* Replicate sign bit throughout D4 */
	movw	d4,a3		/* Sign bit info into A3 */
	roll	#8,d1		/* Left justify mantissa, position exp */
	roll	#3,d1
	movl	d1,d4		/* Copy into mantissa register */
	andw	#0x7FF,d1	/* Mask to exponent field */
	beq	GETA20		/* J/ zero value */

	eorw	d1,d4		/* Zero exponent bits in D4 */
	lsrl	#1,d4		/* Position mantissa */
	bset	#31,d4		/* Set implicit bit in D4 */
	roll	#8,d5		/* Position low long word of mantissa */
	roll	#3,d5
	eorw	d5,d4		/* Clever use of EOR to move bits */
	andw	#0xF800,d5	/* Trim off bits moved into D4 */
	eorw	d5,d4		/* Remove noise in D4 */

GETA20:	movl	a0,d6
	negl	d6
	movl	d6,a0		/* Flag for DOPRSL */
	rts			/* Return to caller, its ret addr in A0 */

/*  GETDP2 */
/*  ====== */
/*  Routine called to extract two double precision arguments from */
/*  the system stack and place them in the 68000`s registers. */

GETDP2:
	movl	fp@(16),d0	/* Get argument */
	movl	fp@(20),d3	/* Get argument (low part) */
	subw	d2,d2		/* Clear carry */
	roxll	#1,d0		/* Sign bit to bit 0 */
	subxw	d2,d2		/* Fill D2 with sign bit */
	movw	d2,a2		/* Sign bit info to A2 */
	roll	#8,d0		/* Left justify mantissa, position exp */
	roll	#3,d0
	movl	d0,d2		/* Copy into mantissa register */
	andw	#0x7FF,d0	/* Mask to exponent field */
	beq	GETD21		/* J/ zero value */

	eorw	d0,d2		/* Zero exponent bits in D2 */
	lsrl	#1,d2		/* Position mantissa */
	bset	#31,d2		/* Set implicit bit in D2 */
	roll	#8,d3		/* Position lo long word of mantissa */
	roll	#3,d3
	eorw	d3,d2		/* Clever use of EOR to move bits */
	andw	#0xF800,d3	/* Trim off bits moved into D2 */
	eorw	d3,d2		/* Remove noise in D2 */

GETD21:

	movl	fp@(8),d1	/* Get argument */
	movl	fp@(12),d5	/* Get argument (low part) */
	subw	d4,d4		/* Clear carry */
	roxll	#1,d1		/* Sign bit carry */
	subxw	d4,d4		/* Replicate sign bit throughout D4 */
	movw	d4,a3		/* Sign bit info into A3 */
	roll	#8,d1		/* Left justify mantissa, position exp */
	roll	#3,d1
	movl	d1,d4		/* Copy into mantissa register */
	andw	#0x7FF,d1	/* Mask to exponent field */
	beq	GETD22		/* J/ zero value */

	eorw	d1,d4		/* Zero exponent bits in D4 */
	lsrl	#1,d4		/* Position mantissa */
	bset	#31,d4		/* Set implicit bit in D4 */
	roll	#8,d5		/* Position low long word of mantissa */
	roll	#3,d5
	eorw	d5,d4		/* Clever use of EOR to move bits */
	andw	#0xF800,d5	/* Trim off bits moved into D4 */
	eorw	d5,d4		/* Remove noise in D4 */

GETD22:	rts			/* Return to caller, its ret addr in A0 */


	

/*  GETDP1 */
/*  ====== */
/*  Routine called to extract a double precision argument from the */
/*  system stack and place it (unpacked) into the 68000's registers. */

GETDP1:
	movl	fp@(8),d0	/* Get argument */
	movl	fp@(12),d3	/* Get argument (low part) */
DCMPGET:			/* Local entry for dpcmp */
	subw	d2,d2		/* Clear carry */
	roxll	#1,d0		/* Sign bit into carry */
	subxw	d2,d2		/* Replicate sign bit throughout D2 */
	movw	d2,a2		/* Sign bit info into A2 */
	roll	#8,d0		/* Left justify mantissa, position exp */
	roll	#3,d0
	movl	d0,d2
	andw	#0x7FF,d0	/* Mask to exponent field */
	beq	GETD11		/* J/ zero value */

	eorw	d0,d2		/* Zero exponent bits in D2 */
	lsrl	#1,d2		/* Position mantissa */
	bset	#31,d2		/* Set implicit bit */
	roll	#8,d3		/* Position lo long word of mantissa */
	roll	#3,d3
	eorw	d3,d2		/* Clever use of EOR to move bits */
	andw	#0xF800,d3	/* Trim off bits moved to D3 */
	eorw	d3,d2		/* Remove noise in D2 */

GETD11:	rts			/* Return to caller, its ret addr in A0 */


	

/*  DOPRSL */
/*  ====== */
/*  Double precision floating point result (main entry w/ round). */
/*  Mantissa in D2:D3, exponent in D0, sign in A2, and return address */
/*  in A0.  Place a formatted value in D0:D1 */

DOPRSL:	addl	#0x400,d3	/* Round the value */
	bcc	DOPR01		/* J/ no carry out */
	addql	#1,d2
	bcc	DOPR01		/* J/ no carry out */

	roxrl	#1,d2		/* Adjust mantissa and exponent */
	roxrl	#1,d3
	addqw	#1,d0

DOPR01:	andw	d0,d0
	jle	DUNFRS		/* J/ underflow */

	cmpw	#0x7FF,d0	/* Check for overflow */
	jge	DINFRS		/* J/ overflow */

	andw	#0xF800,d3	/* Trim mantissa */
	eorw	d2,d3		/* EOR to move over 11 bits */
	andw	#0xF800,d2	/* Remove bits moved */
	eorw	d2,d3		/* Remove noise in D3 */
	subw	d1,d1		/* Clear carry */
	roxll	#1,d2		/* Implicit bit into carry */
	addw	d0,d2		/* Exponent into D2 */
	rorl	#8,d2		/* Reposition high word */
	rorl	#3,d2
	movw	a2,d0		/* Sign bit into carry */
	aslw	#1,d0
	roxrl	#1,d2
	rorl	#8,d3
	rorl	#3,d3
	movl	d2,d0
	movl	d3,d1

	movb	#0,FPERR	/* No floating point error */
	movl	a0,d6		/* For following branch */
	ble	DOPR05	
	jmp	a0@		/* Local return */
DOPR05:	beq	DOPR10
	negl	d6		/* Doing assign op */
	movl	d6,a0		/* Recover result address */
	movl	d0,a0@		/* Store high word of result */
	movl	d1,a0@(4)	/* Store low word of result */
DOPR10:	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts			/* Return */



DNANRS:	moveq	#-1,d0		/* Set D0 to $FFFFFFFF */
	moveq	#-1,d1

	movb	#ERNAN,FPERR
	movb	#-1,NANFLG
	movl	a0,d6		/* For following branch */
	ble	DNAN05	
	jmp	a0@		/* Local return */
DNAN05:	beq	DNAN10
	negl	d6		/* Doing assign op */
	movl	d6,a0		/* Recover result address */
	movl	d0,a0@		/* Store high word of result */
	movl	d1,a0@(4)	/* Store low word of result */
DNAN10:	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts			/* Return */


DINFRS:	movl	#0x7ff00000,d0
	movl	a2,d1		/* Get sign information */
	bge	DINF03
	movl	#0xfff00000,d0
DINF03:	clrl	d1
	movb	#EROVF,FPERR
	movb	#-1,INFFLG
	movl	a0,d6		/* For following branch */
	ble	DINF05	
	jmp	a0@		/* Local return */
DINF05:	beq	DINF10
	negl	d6		/* Doing assign op */
	movl	d6,a0		/* Recover result address */
	movl	d0,a0@		/* Store high word of result */
	movl	d1,a0@(4)	/* Store low word of result */
DINF10:	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts			/* Return */


DUNFRS:	movb	#ERUNF,FPERR
	movb	#-1,UNFFLG
	bra	DZER01


DZERRS:	movb	#0,FPERR


DZER01:	clrl	d0
	clrl	d1
	movl	a0,d6		/* For following branch */
	ble	DZER05	
	jmp	a0@		/* Local return */
DZER05:	beq	DZER10
	negl	d6		/* Doing assign op */
	movl	d6,a0		/* Recover result address */
	movl	d0,a0@		/* Store high word of result */
	movl	d1,a0@(4)	/* Store low word of result */
DZER10:	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts			/* Return */


/*  asadd */
/*  ===== */
/*  Slow version of assign add routine.  There are problems */
/*  because of single/double/single conversions. */
ASENTRY(asadd)
	movl	sp@(4),a0
	movl	a0@,sp@-
	jbsr	sptodp
	movl	sp@(16),sp@
	movl	sp@(12),sp@-
	movl	d1,sp@-
	movl	d0,sp@-
	jbsr	dpadd
	movl	d1,sp@(4)
	movl	d0,sp@
	jbsr	dptosp
	lea	sp@(16),sp
	movl	sp@(4),a0
	movl	d0,a0@
	rts
	

/*  asaddf */
/*  ===== */
/*  Single-precision version of asadd, used by f77 when loop control */
/*  is single-precision floating-point. */

ASENTRY(asaddf)
	movl	sp@(4),a0
	movl	a0@,sp@-
	movl	sp@(12),sp@-
	jbsr	spadd
	addql	#8,sp
	movl	sp@(4),a0
	movl	d0,a0@
	rts


/*  assub */
/*  ===== */
/*  Slow version of assign sub routine.  There are problems */
/*  because of single/double/single conversions. */
ASENTRY(assub)
	movl	sp@(4),a0
	movl	a0@,sp@-
	jbsr	sptodp
	movl	sp@(16),sp@
	movl	sp@(12),sp@-
	movl	d1,sp@-
	movl	d0,sp@-
	jbsr	dpsub
	movl	d1,sp@(4)
	movl	d0,sp@
	jbsr	dptosp
	lea	sp@(16),sp
	movl	sp@(4),a0
	movl	d0,a0@
	rts
	


/*  asmul */
/*  ===== */
/*  Slow version of assign mul routine.  There are problems */
/*  because of single/double/single conversions. */
ASENTRY(asmul)
	movl	sp@(4),a0
	movl	a0@,sp@-
	jbsr	sptodp
	movl	sp@(16),sp@
	movl	sp@(12),sp@-
	movl	d1,sp@-
	movl	d0,sp@-
	jbsr	dpmul
	movl	d1,sp@(4)
	movl	d0,sp@
	jbsr	dptosp
	lea	sp@(16),sp
	movl	sp@(4),a0
	movl	d0,a0@
	rts


/*  asdiv */
/*  ===== */
/*  Slow version of assign div routine.  There are problems */
/*  because of single/double/single conversions. */
ASENTRY(asdiv)
	movl	sp@(4),a0
	movl	a0@,sp@-
	jbsr	sptodp
	movl	sp@(16),sp@
	movl	sp@(12),sp@-
	movl	d1,sp@-
	movl	d0,sp@-
	jbsr	dpdiv
	movl	d1,sp@(4)
	movl	d0,sp@
	jbsr	dptosp
	lea	sp@(16),sp
	movl	sp@(4),a0
	movl	d0,a0@
	rts


/*  spufloat */
/*  ======== */
/*  Float the unsigned integer value on the stack into a single precision */
/*  floating point number in D0 */

ASENTRY(spufloat)
	link	fp,#-40
	moveml	#0x3cfc,sp@
	subl	a0,a0		/* Return flag for DOPRSL */
	subl	a2,a2		/* Set A2 = 0 */
	movl	fp@(8),d0	/* Get argument */
	bne	FLT02		/* Jump if value != 0 */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts			/* Return 0. */

/*  spfloat */
/*  ======= */
/*  Float the integer value on the stack into a single precision floating */
/*  point number in D0 */

ASENTRY(spfloat)
	link	fp,#-40
	moveml	#0x3cfc,sp@
	subl	a0,a0		/* Return flag for DOPRSL */
	subl	a2,a2		/* Set A2 = 0 */
	movl	fp@(8),d0	/* Get argument */
	bne	FLT01		/* Jump if value != 0 */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts			/* Return 0. */

FLT01:	bge	FLT02		/* Jump if value > 0 */
	subql	#1,a2		/* Set A2 = -1 */
	negl	d0

FLT02:	movl	#FBIAS+15,d2	/* Default bias value */
	swap	d0
	andw	d0,d0
	beq	FLT03		/* Jump if 16 bit shift required */

	swap	d0		/* Undo the shift */
	addw	#16,d2		/* Reflect the larger number */

FLT03:	andl	d0,d0
	bmi	FLT06		/* Jump if value normalized */

FLT04:	subqw	#1,d2		/* Decrement exponent */
	asll	#1,d0		/* Shift mantissa */
	bpl	FLT04		/* Jump if more shifts to do */

FLT06:	exg	d0,d2		/* Position to standard D0/D2/A2 form */
	jra	FOPRSL		/* Single precision result (w/ round) */
	


/*  spufix */
/*  ====== */
/*  Convert the single precision argument on the stack to an unsigned */
/*  integer value */

ASENTRY(spufix)
	link	fp,#-40
	moveml	#0x3cfc,sp@
	jbsr	GETFP1		/* Get argument */
	andw	d0,d0
	bne	sufix05		/* Jump if argument not zero */
	clrl	d0		/* Return integer zero */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts			/* Return */
sufix05:
	cmpw	#FBIAS,d0
	bcc	sufix10		/* Jump if abs() >= 1.0  [BCC == BHS] */

	clrl	d0		/* Return a zero value */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	orb	#CCRC+CCRX,cc	/* Set carry/extend bits */
	rts

sufix10:
	subw	#FBIAS+32,d0
	blt	sufix20		/* Jump if abs() < 2^32 */

	movl	a2,d2
	bne	sufix15
	movl	#0xffffffff,d0
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts
sufix15:
	movl	#0x80000000,d0
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts

sufix20:
	addql	#1,d0		/* Correct shift count */
	negw	d0		/* Positive shift count */
	rorl	d0,d2		/* Multibit shift */
	moveq	#-1,d1		/* Mask for bit dropout check */
	lsrl	d0,d1
	notl	d1
	andl	d2,d1		/* Bit(s) dropped left in D1 */
	eorl	d1,d2		/* Integer value in D2 */
	movl	a2,d0
	eorl	d2,d0		/* Negate as required, move to D0 */
	subl	a2,d0
	moveq	#-1,d2
	addl	d2,d1		/* Set carry/extend if bits lost */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts


	
/*  spfix */
/*  ===== */
/*  Convert the single precision argument on the stack to an integer value */

ASENTRY(spfix)
	link	fp,#-40
	moveml	#0x3cfc,sp@
	jbsr	GETFP1		/* Get argument */
	andw	d0,d0
	bne	sfix05		/* Jump if argument not zero */
	clrl	d0		/* Return integer zero */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts			/* Return */
sfix05:
	cmpw	#FBIAS,d0
	bcc	sfix10		/* Jump if abs() >= 1.0  [BCC == BHS] */

	clrl	d0		/* Return a zero value */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	orb	#CCRC+CCRX,cc	/* Set carry/extend bits */
	rts

sfix10:	subw	#FBIAS+31,d0
	blt	sfix20		/* Jump if abs() < 2^31 */

	movl	a2,d2
	bne	sfix15
	movl	#0x7fffffff,d0
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts
sfix15:
	movl	#0x80000000,d0
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts

sfix20: negw	d0		/* Positive shift count */
	rorl	d0,d2		/* Multibit shift */
	moveq	#-1,d1		/* Mask for bit dropout check */
	lsrl	d0,d1
	notl	d1
	andl	d2,d1		/* Bit(s) dropped left in D1 */
	eorl	d1,d2		/* Integer value in D2 */
	movl	a2,d0
	eorl	d2,d0		/* Negate as required, move to D0 */
	subl	a2,d0
	moveq	#-1,d2
	addl	d2,d1		/* Set carry/extend if bits lost */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts


	
/*  spsub */
/*  ===== */
/*  Single precision subtract routine */

ASENTRY(spsub)
	subl	a0,a0		/* Clear FOPRSL return flag */
	link	fp,#-40
	moveml	#0x3cfc,sp@
	jbsr	GETFP2		/* Fetch both operands */
	exg	d2,a2		/* Flip sign information */
	notl	d2
	exg	d2,a2
	bra	FPA005		/* Now do add */


/*  Single precision add routine */

ASENTRY(spadd)
	link	fp,#-40
	subl	a0,a0		/* Return flag for DOPRSL */
	moveml	#0x3cfc,sp@
	jbsr	GETFP2		/* Fetch both operands */
FPA005:	cmpw	#0xFF,d0

	bne	FPA010		/* J/ operand not NaN/INF */

	lsll	#1,d2		/* Remove implicit bit */
	jne	FNANRS		/* J/  ?  + NaN -> NaN */

	cmpw	#0xFF,d1
	jne	FINFRS		/* J/  0,num + INF -> INF */

	lsll	#1,d3		/* Remove implicit bit */
	jne	FNANRS		/* J/ INF + NaN -> NaN */

	cmpl	a2,a3
	jne	FNANRS		/* J/ INF - INF -> NaN */
	jra	FINFRS		/*    INF + INF -> INF */


FPA010:	cmpw	#0xFF,d1
	bne	FPA040		/* J/ not NaN or INF */

	lsll	#1,d3		/* Remove implicit bit */
	jne	FNANRS		/* J/ NaN + 0,num -> NaN */

	movl	a3,a2		/* Move sign over */
	jra	FINFRS		/* INF result */


FPXSUB:				/* Entry for spcmp */

FPA040:	andw	d1,d1
	jeq	FOPRSL		/* J/ 0,num + 0 -> 0,num */

	andw	d0,d0
	bne	FPA045		/* J/ no zeroes involved */

	movw	d1,d0		/* Copy over data */
	movl	d3,d2
	movl	a3,a2
	jra	FOPRSL


FPA045:

	cmpw	d1,d0
	bcc	FPA060		/* J/ op1.exp >= op2.exp */

	exg	d2,d3		/* Flip mantissas */
	exg	d0,d1
	exg	a2,a3

FPA060:	subw	d0,d1
	negw	d1
	cmpw	#24,d1
	jhi	FOPRSL		/* J/ op2 too small to matter */

	lsrl	d1,d3
	cmpl	a2,a3
	bne	FPS100		/* J/ subtract operation */

	addl	d3,d2
	jcc	FOPRSL		/* J/ no carry out */

	roxrl	#1,d2		/* Handle carry out */
	addqw	#1,d0		/* Bump the exponent */
	jra	FOPRSL


FPS100:	subl	d3,d2		/* Do the subtract */
	jeq	FZERRS		/* J/ zero result */
	bcc	FPS110

	negl	d2

	movl	a3,a2		/* Flip sign */

FPS110:	andl	d2,d2		/* Normalization section */
	jmi	FOPRSL		/* J/ normalized */

	subqw	#1,d0		/* Decrease exponent value */
FPS120:	addl	d2,d2		/* Left shift D2 */
	dbmi	d0,FPS120	/* J/ not normalized */

	jra	FOPRSL

	

/*  Single precision multiply routine. */

ASENTRY(spmul)
	subl	a0,a0		/* Return flag for DOPRSL */
	link	fp,#-40
	moveml	#0x3cfc,sp@
	jbsr	GETFP2		/* Fetch both operands */
	movw	a2,d4
	movw	a3,d5
	eorw	d4,d5
	movw	d5,a2		/* Result's sign */

	andw	d0,d0
	bne	FPM010		/* J/ operand <> 0.0 */

	cmpw	#0xFF,d1
	jeq	FNANRS		/* J/ 0.0 * NaN,INF -> NaN */
	jra	FZERRS		/* J/ 0.0 * 0.0,num -> 0.0 */

FPM010:	cmpw	#0xFF,d0
	bne	FPM020		/* J/ operand is a number */

	lsll	#1,d2
	jne	FNANRS		/* J/ NaN *  ?  -> NaN */

	andw	d1,d1
	jeq	FNANRS		/* J/ INF * 0.0 -> NaN */

	cmpw	#0xFF,d1
	jne	FINFRS		/* J/ INF * num -> INF */
	lsll	#1,d3
	jeq	FINFRS		/* J/ INF * INF -> INF */
	jra	FNANRS		/* J/ INF * NaN -> NaN */

FPM020:	andw	d1,d1
	jeq	FZERRS		/* J/ num * 0.0 -> 0.0 */

	cmpw	#0xFF,d1
	bne	FPM040		/* J/ num * num */

	lsll	#1,d1
	jeq	FINFRS		/* J/ num * INF -> INF */
	jra	FNANRS		/* J/ num * NaN -> NaN */


FPM040:	addw	d1,d0		/* Calculate result`s exponent */
	subw	#FBIAS-1,d0	/* Remove double bias, assume shift */

	movw	d2,d4		/* Copy Lo byte to D4 (B) */
	movw	d3,d5		/* Copy Lo byte to D5 (D) */
	swap	d2		/* Position for high byte multiply (A) */
	mulu	d2,d5		/* A mid multiplication result (AD) */
	swap	d3		/* Position for high byte multiply (C) */
	mulu	d3,d4		/* A mid multiplication result (CB) */
	mulu	d3,d2		/* High order words multiplied (CA) */
	addl	d4,d5		/* Combine mid multiply results (CB + AD) */
	subxw	d5,d5		/* Preserve carry while... */
	negw	d5		/* ...positioning the... */
	swap	d5		/* ...result before... */
	addl	d5,d2		/* ...combining partial products */
	jmi	FOPRSL		/* Result normalized w/o shift */

	subqw	#1,d0
	addl	d2,d2		/* Do a left shift */
	jra	FOPRSL

	

/*  Single precision division operation. */

ASENTRY(spdiv)
	subl	a0,a0		/* Return flag for DOPRSL */
	link	fp,#-40
	moveml	#0x3cfc,sp@
	jbsr	GETFP2		/* Fetch both operands */

FPD001:	movw	a2,d4		/* Compute result's sign */
	movw	a3,d5
	eorw	d4,d5
	movw	d5,a2

	andw	d0,d0
	bne	FPD010		/* J/ divisor is not zero */

	andw	d1,d1
	jeq	FNANRS		/* J/ 0.0 / 0.0 -> NaN */
	cmpw	#0xFF,d1
	jne	FINFRS		/* J/ num / 0.0 -> INF */
	lsll	#1,d3
	jeq	FINFRS		/* J/ INF / 0.0 -> INF */
	jra	FNANRS		/* J/ NaN / 0.0 -> NaN */

FPD010:	cmpw	#0xFF,d0
	bne	FPD020		/* J/ divisor is a normal number */

	lsll	#1,d2
	jne	FNANRS		/* J/  ?  / NaN -> NaN */
	andw	d1,d1
	jeq	FZERRS		/* J/ 0.0 / INF -> 0.0 */
	cmpw	#0xFF,d1
	jne	FUNFRS		/* J/ num / INF -> 0.0 (w/ underflow) */
	jra	FNANRS		/* J/ NaN,INF / INF -> NaN */

FPD020:	andw	d1,d1
	jeq	FZERRS		/* J/ 0.0 / num -> 0.0 */
	cmpw	#0xFF,d1
	bne	FPD040		/* J/ num / num */

	lsll	#1,d3
	jeq	FINFRS		/* J/ INF / num -> INF */
	jra	FNANRS		/* J/ NaN / num -> NaN */


/*  Division Algorithm:   A/(B+C) = A/B - A/B*C/B + A/B*(C/B)^2 - ... */
/*                                = A/B * (1 - C/B + (C/B)^2) */

/*  Choose C to be the low order byte of the 24 bit mantissa.  The */
/*  third and succeeding corrections terms (C squared and above) */
/*  can be neglected because they are at least thirty bits down. */

FPD040:	subw	d1,d0
	negw	d0
	addw	#FBIAS,d0	/* Restore bias */
	exg	d2,d3

	movl	d2,d4		/* Copy A */
	lsrl	#1,d4		/* Insure no overflow during divide */
	swap	d3
	divu	d3,d4		/* Top fifteen bits of A/B */
	movw	d4,d2		/* A/B ultimately into D2 */
	movw	d4,d5		/* Copy for later opn (A/B * C) */
	swap	d2		/* Position MS word */
	clrw	d4		/* Zero low order bits in D4 */
	divu	d3,d4		/* Division of shifted remainder */
	movw	d4,d2		/* Complete A/B operation */

	movl	d3,d4
	clrw	d4		/* Create a shifted C in D4 */
	lsrl	#1,d4		/* Insure no division overflow */
	divu	d3,d4		/* Division (complete since C is 8 bits) */

	mulu	d5,d4		/* A/B * C */
	lsrl	#8,d4		/* Position A/B * C */
	lsrl	#7,d4
	subl	d4,d2
	jmi	FOPRSL		/* J/ result normalized */

	subqw	#1,d0
	addl	d2,d2		/* Normalize it */
	jra	FOPRSL

	

/*  The following spcmp routine is a fast version that assumes FUZZ=24 */
/*  That is, x == y iff x and y are exactly the same (except that 0 == -0) */
/*  Note that the main path of this routine works for X or Y = +- Inf */

/*  Compare the two arguments provided and set the condition code */
/*  register bits N, Z, and V as follows: */

/*      N  Z  V   Relation */
/*      =  =  =   ==================================== */
/*      1  0  0   X > Y   (X is top argument on stack) */
/*      0  1  0   X == Y   (as described above) */
/*      0  0  0   X < Y */
/*      0  0  1   X does not compare to Y */

ASENTRY(spcmp)
	link	fp,#-8
	moveml	#0x000c,sp@	/* NOTE: save only d2 and d3! */
	movl	fp@(12),d0	/* Get X */
	movl	fp@(8),d1	/* Get Y */
	movl	d0,d2
	swap	d2

/*	Note: If we support denormalized numbers, need a better test for -0. */
	cmpw	#0x8000,d2	/* Check for -0. */
	bne	6f
	clrl	d0
	bra	1f
6:
	andw	#0x7f80,d2
	cmpw	#0x7f80,d2
	bne	1f		/* Branch if X not Inf or NaN */
	movl	d0,d2

	andl	#0x7fffff,d2
	beq	1f		/* Branch is X is +-Inf (regular stuff OK) */
				/* X is NaN, does not compare to Y */
	moveq	#CCRV,d0	/* CCR V bit */
	movw	d0,cc
	moveml	sp@,#0x000c	/* Restore registers */
	unlk	fp
	rts			/* Return */

1:	movl	d1,d3
	swap	d3

/*	Note: If we support denormalized numbers, need a better test for -0. */
	cmpw	#0x8000,d3	/* Check for -0. */
	bne	7f
	clrl	d1
	bra	2f
7:
	andl	#0x7f80,d3
	cmpl	#0x7f80,d3
	bne	2f		/* Branch if Y not Inf or NaN */
	movl	d1,d3

	andl	#0x7fffff,d3
	beq	2f		/* Branch is Y is +-Inf (regular stuff OK) */
				/* Y is NaN, does not compare to X */
	moveq	#CCRV,d0	/* CCR V bit */
	movw	d0,cc
	moveml	sp@,#0x000c	/* Restore registers */
	unlk	fp
	rts			/* Return */

2:
	movl	d0,d2
	andl	d1,d2
	bge	5f
	exg	d0,d1		/* If X and Y have different signs, exchange */
5:
	cmpl	d0,d1
	moveml	sp@,#0x000c	/* Restore registers */
	unlk	fp
	rts			/* Return */
	




/*  The following version deals with FUZZ correctly: */
/*  Single Precision comparison routine. */

/*  Compare the two arguments provided and set the condition code */
/*  register bits N, Z, and V as follows: */

/*      N  Z  V   Relation */
/*      =  =  =   ==================================== */
/*      1  0  0   X > Y   (X is top argument on stack) */
/*      0  1  0   X = Y   (within FFUZZ specification) */
/*      0  0  0   X < Y */
/*      0  0  1   X does not compare to Y */


FFUZZ = 24		/* Twenty-four bits of fuzz (exact compares only) */


/*spcmp:	link	fp,#-40 */
	moveml	#0x3cfc,sp@
	jbsr	GETFP2
	cmpw	#0xFF,d0
	bne	FPC020		/* J/ X is not INF or NaN */

	lsll	#1,d2		/* Remove implicit bit */
	jeq	FPC005		/* J/ X is INF */

FPC001:				/* **  X does not compare to Y  ** */
	moveq	#CCRV,d0	/* CCR V bit */
	movw	d0,cc
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts			/* Return */

FPC005:	cmpw	#0xFF,d1
	bne	FPC009		/* J/ Y is not INF or NaN */

	lsll	#1,d3
	bne	FPC001		/* J/ Y is NaN (does not compare) */

	cmpw	a2,a3
	beq	FPC001		/* J/ INF's with same sign - no compare */

FPC009:	movw	a2,d0		/* Result based on compl. of X's sign */
	eorw	#CCRN,d0
	bra	FPC011

FPC010:	movw	a3,d0		/* Set result based on Y's sign */
FPC011:	andw	#CCRN,d0
	movw	d0,cc
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts			/* Return */


FPC020:	cmpw	#0xFF,d1
	bne	FPC030		/* J/ Y is not NaN or INF */

	lsll	#1,d3
	bne	FPC001		/* J/ Y is NaN - no comparison */
	bra	FPC010		/* Result is based on Y's sign */

FPC030:	cmpw	a2,a3
	beq	FPC035		/* Jump if signs same */
	movl	d2,d2		/* Are we comparing +-0? */
	bne	FPC010		/* If not 0, use Y's sign */
	movl	d3,d3		/* Is other arg 0? */
	bne	FPC010		/* If not 0, use Y's sign */
	bra	FPC050		/* Really 0 = -0 */

FPC035:
	movw	d0,d4
	movw	d0,d5		/* Assume X's exp is larger */
	subw	d1,d4		/* Calc difference in exponents */
	bpl	FPC031		/* J/ positive */
	movw	d1,d5		/* Y's exp is larger */
	negw	d4
FPC031:
	lsrw	#1,d4
	beq	FPC040		/* Must subtract to obtain result */

	subw	d0,d1
	subxw	d0,d0		/* Set D0 to sign of Y[exp]-X[exp] */
	movw	a2,d1
	eorw	d1,d0		/* Flip if negative values */
	bra	FPC011		/* Result based on value in D0 */

FPC040:	movw	d5,sp@-		/* Save max exp value, return address */

	movw	a2,d5
	notw	d5		/* Flip sign of opnd (force subtract) */
	movw	d5,a2

	movl	#FPC041,a0	/* Return address in A0 */

	jra	FPXSUB

FPC041:	jbsr	CMPGET		/* Fetch and unpack result */

	movw	sp@+,d5		/* Recall max exp value */

	andw	d0,d0
	beq	FPC050		/* J/ zero result */

	subw	d0,d5
	cmpw	#FFUZZ,d5
	bge	FPC050		/* J/ within FFUZZ specification - zero */

	movw	a2,d0		/* Sign of result into D0 */
	bra	FPC011		/* Comparison result from sign of sub */

FPC050:	subw	d0,d0		/* Force CCR to say "Z" */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts			/* Return */

	

/*  GETFP2 */
/*  ====== */
/*  Routine called to extract two single precision arguments from */
/*  the system stack and place them in the 68000`s registers. */

GETFP2:
	movl	fp@(12),d0	/* Get TOS (source) operand */
	asll	#1,d0		/* Sign bit to carry */
	subxw	d2,d2		/* Fill D2 with sign bit */
	movw	d2,a2		/* Sign bit info to A2 */
	roll	#8,d0		/* Left justify mantissa, position exp */
	movl	d0,d2		/* Copy into mantissa register */
	andw	#0xFF,d0	/* Mask to exponent field */
	beq	GETF21		/* J/ zero value */

	andw	#0xFE00,d2	/* Zero sign bit and exponent bits in D2 */
	lsrl	#1,d2		/* Position mantissa */
	bset	#31,d2		/* Set implicit bit in D2 */

GETF21:
	movl	fp@(8),d1	/* Get NOS (source) operand */
	asll	#1,d1		/* Sign bit to carry */
	subxw	d3,d3		/* Replicate sign bit throughout D3 */
	movw	d3,a3		/* Sign bit info into A3 */
	roll	#8,d1		/* Left justify mantissa, position exp */
	movl	d1,d3		/* Copy into mantissa register */
	andw	#0xFF,d1	/* Mask to exponent field */
	beq	GETF22		/* J/ zero value */

	andw	#0xFE00,d3	/* Zero sign bit and exponent bits in D3 */
	lsrl	#1,d3		/* Position mantissa */
	bset	#31,d3		/* Set implicit bit in D3 */

GETF22:	rts			/* Return to caller */


	

/*  GETFP1 */
/*  ====== */
/*  Routine called to extract a single precision argument from the */
/*  system stack and place it (unpacked) into the 68000's registers. */

GETFP1:
	movl	fp@(8),d0	/* Get argument */
CMPGET:
	asll	#1,d0		/* Sign bit into carry */
	subxw	d2,d2		/* Replicate sign bit throughout D2 */
	movw	d2,a2		/* Sign bit info into A2 */
	roll	#8,d0		/* Left justify mantissa, position exp */
	movl	d0,d2
	andw	#0xFF,d0	/* Mask to exponent field */
	beq	GETF11		/* J/ zero value */

	andw	#0xFE00,d2	/* Zero sign bit and exponent bits in D2 */
	lsrl	#1,d2		/* Position mantissa */
	bset	#31,d2		/* Set implicit bit */

GETF11:	rts			/* Return to caller */


	

/*  FOPRSL */
/*  ====== */
/*  Single precision floating point result (main entry w/ round). */
/*  Mantissa in D2, exponent in D0, sign in A2, and return address */
/*  in A0.  Place a formatted value in d0. */

FOPRSL:	addl	#0x80,d2	/* Round the value */
	bcc	FOPR01		/* J/ no carry out */

	roxrl	#1,d2		/* Adjust mantissa and exponent */
	addqw	#1,d0

FOPR01:	andw	d0,d0
	jle	FUNFRS		/* J/ underflow */

	cmpw	#0xFF,d0	/* Check for overflow */
	jge	FINFRS		/* J/ overflow */

	andw	#0xFF00,d2	/* Trim mantissa */
	asll	#1,d2		/* Drop implicit bit */
	addw	d0,d2		/* Blend in the exponent */
	rorl	#8,d2		/* Reposition value */
	movw	a2,d0
	aslw	#1,d0		/* Sign bit into carry/extend */
	roxrl	#1,d2		/* Finish construction of value */
	movl	d2,d0

	movb	#0,FPERR	/* No floating point error */
	movl	a0,d6		/* For following branch */
	beq	FOPR05
	jmp	a0@		/* Local return */
FOPR05:	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts			/* Return */



FNANRS:	moveq	#-1,d0		/* Set D0 to $FFFFFFFF */

	movb	#ERNAN,FPERR
	movb	#-1,NANFLG
	movl	a0,d6		/* For following branch */
	beq	FNAN05
	jmp	a0@		/* Local return */
FNAN05:	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts			/* Return */


FINFRS:	movl	a2,d0		/* Get sign information */
	movl	#0xFF000000,d1
	rorb	#1,d0
	rorl	#1,d1
	movl	d1,d0

	movb	#EROVF,FPERR
	movb	#-1,INFFLG
	movl	a0,d6		/* For following branch */
	beq	FINF05
	jmp	a0@		/* Local return */
FINF05:	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts			/* Return */


FUNFRS:	movb	#ERUNF,FPERR
	movb	#-1,UNFFLG
	bra	FZER01


FZERRS:	movb	#0,FPERR


FZER01:	subl	d0,d0
	movl	a0,d6		/* For following branch */
	beq	FZER05
	jmp	a0@		/* Local return */
FZER05:	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts			/* Return */


/*  Convert the double precision value on the stack to single precision */

ASENTRY(dptosp)
	link	fp,#-40
	moveml	#0x3cfc,sp@
	subl	a0,a0		/* Clear flag for DPORSL */
	jbsr	GETDP1		/* Fetch the operand */

	andw	d0,d0
	jeq	FZERRS		/* 0.0 parameter/result */

	cmpw	#0x7FF,d0
	jeq	SNG010		/* operand is NaN/INF */

	addw	#FBIAS-DBIAS,d0	/* Change exponent bias */
	jra	FOPRSL		/* Standard single prec. result routine */

SNG010:	lsll	#1,d2		/* Remove implicit bit */
	jne	FNANRS		/* NaN converts to NaN */
	jra	FINFRS		/* INF converts to INF */



/*  Extend the single precision argument to double precision */

ASENTRY(sptodp)
	link	fp,#-40
	moveml	#0x3cfc,sp@
	subl	a0,a0		/* Clear flag for DPORSL */
	jbsr	GETFP1		/* Get argument */

	andw	d0,d0
	jeq	DZERRS		/* 0.0 converts to 0.0 */

	cmpw	#0xFF,d0
	jeq	DBL010		/* operand is NaN/INF */

	addw	#DBIAS-FBIAS,d0	/* Change exponent bias */
	clrl	d3		/* Extend precision of mantissa */
	jra	DOPRSL		/* Standard double prec. result routine */

DBL010:	lsll	#1,d2
	jne	DNANRS		/* NaN converts to NaN */
	jra	DINFRS		/* INF converts to INF */


	.data
