/*
 *	C library - ascii to floating
 */

#include <ctype.h>

double
atof (p)
  register char *p;
  {
	register char c;
	double fl, flexp, exp5;
	double big = 72057594037927936.;  /*2^56*/
	double ldexp();
	register short eexp, exp, neg, negexp, bexp;

	neg = 1;
	while (isspace (*p++))
		;
	if (*--p == '-') {
		p += 1;
		neg = -1;
	}
	else if (*p == '+')
		p += 1;

	exp = 0;
	fl = 0;
	while (isdigit (c = *p++))
		if (fl < big)
			fl = 10 * fl + (c - '0');
		else
			exp += 1;

	if (c == '.') while (isdigit (c = *p++))
		if (fl < big) {
			fl = 10 * fl + (c - '0');
			exp -= 1;
		}

	negexp = 1;
	eexp = 0;
	if ((c == 'E')  ||  (c == 'e')) {
		if ((c = *p++) == '+')
			;
		else if (c == '-')
			negexp = -1;
		else
			p -= 1;

		while (isdigit (c = *p++))
			eexp = 10 * eexp + (c - '0');

		if (negexp < 0)
			eexp = -eexp;
		exp = exp + eexp;
	}

	negexp = 1;
	if (exp < 0) {
		negexp = -1;
		exp = -exp;
	}

	flexp = 1;
	exp5 = 5;
	bexp = exp;
	while (1) {
		if (exp & 1)
			flexp *= exp5;
		exp >>= 1;
		if (exp == 0)
			break;
		exp5 *= exp5;
	}
	if (negexp < 0)
		fl /= flexp;
	else
		fl *= flexp;
	fl = ldexp (fl, negexp * bexp);
	if (neg < 0)
		fl = -fl;
	return fl;
}
