/*	strncpy.s	4.2	83/11/22	*/

/* strncpy(s0, s1, n)
 * Copy s1 to s0, truncating or null-padding to always copy n bytes.
 * Returns s0.
 */

/*
 * char *
 * strncpy(s0, s1, n)
 * register char *s0, *s1;
 * {
 *         register i;
 *         register char *os0;
 * 
 *         os0 = s0;
 *         for (i = 0; i < n; i++)
 *                 if ((*s0++ = *s1++) == '\0') {
 *                         while (++i < n)
 *                                 *s0++ = '\0';
 *                         return(os0);
 *                 }
 *         return(os0);
 * }
 */

#include "DEFS.h"

ENTRY(strncpy)
	movl	sp@(4),a0	/* s0: dest */
	movl	a0,d0		/* return value */
	movl	sp@(8),a1	/* s1: source */
	movl	sp@(12),d1	/* n */
	jgt	2f
	rts			/* nonpositive count -- all done */

1:	movb	a1@+,a0@+	/* COPY LOOP */
2:	dbeq	d1,1b		/* entry point of copy loop */
	jeq	3f
	addqw	#1,d1		/* propogate borrow thru all 32 bits */
	subql	#1,d1
	jge	1b
	rts			/* count exhausted -- return */
3:
	movl	d0,a1		/* save return value */
	movq	#0,d0		/* fill value: zero */
	jbr	5f

4:	movb	d0,a0@+		/* CLEAR LOOP */
5:	dbf	d1,4b		/* entry point of clear loop */
	addqw	#1,d1		/* propogate borrow thru all 32 bits */
	subql	#1,d1
	jge	4b

	movl	a1,d0		/* restore return value */
	rts
