/* signed long division: quotient = dividend / divisor */
/* Code marked (WT) is speedup for many common cases -  Wendy Thrash */

#include "DEFS.h"

RENTRY(rldiv)
	moveml	#0x3C00,sp@-	/* need d2,d3,d4,d5 registers */
	movl	d0,d5		/* save sign of dividend */
	jge	1f
	negl	d0
1:
	movl	d0,d3		/* save positive dividend */
	movl	d1,d4
	jge	2f
	negl	d1
	negl	d4
	negl	d5
2:
/*	Positive dividend in d3, positive divisor in d1, d4 */

	cmpl	#0x10000,d1	/* divisor >= 2 ** 16? */
	jcc	3f		/* yes, divisor must be < 2 ** 16 */

	movl	d1,d2		/* Top bits of divisor are zero, so... (WT) */
	swap	d2		/* d2 = divisor * 2**16 (WT) */
	cmpl	d2,d0		/* Will quotient fit in 16 bits? (WT) */
	bcc	7f		/* No.  Go do it the hard way (WT) */
	divu	d1,d0		/* Yes. An easy divide (WT) */
	andl	#0xffff,d0	/* Throw away remainder (WT) */
	tstl	d5		/* sign of result */
	jge	9f
	negl	d0
9:
	moveml	sp@+,#0x003C	/* restore registers */
	rts

7:	clrw	d0		/* divide dividend */
	swap	d0		/*   by 2 ** 16 */
	divu	d1,d0		/* get the high order bits of quotient */
	movw	d0,d2		/* save quotient high */
	movw	d3,d0		/* dividend low + remainder * (2**16) */
	divu	d1,d0		/* get quotient low */
	swap	d0		/* temporarily save quotient low in high */
	movw	d2,d0		/* restore quotient high to low part of reg */
	swap	d0		/* put things right */
	jra	5f		/* return */
3:
	lsrl	#0x1,d0		/* shift dividend */
	lsrl	#0x1,d1		/* shift divisor */
	cmpl	#0x10000,d1	/* divisor < 2 ** 16? */
	jcc	3b		/* no, continue shift */
	divu	d1,d0		/* yes, divide, remainder is garbage */
	andl	#0xFFFF,d0	/* get rid of remainder */
	movl	d0,d2		/* save quotient */
	movl	d0,sp@-		/* call ulmul with quotient */
	movl	d4,sp@-		/*   and saved divisor on stack */
	jsr	ulmul		/*   as arguments */
	addql	#0x8,sp		/* restore sp */
	cmpl	d0,d3		/* original dividend >= ulmul result? */
	jcc	4f		/* yes, quotient should be correct */
	subql	#1,d2		/* no, fix up quotient */
4:
	movl	d2,d0		/* move quotient to d0 */
5:
	tstl	d5		/* sign of result */
	jge	6f
	negl	d0
6:
	moveml	sp@+,#0x003C	/* restore registers */
	rts
