/* @(#)bzero.s	4.2 11/22/83 */
/* bzero(base, length) */

#include "DEFS.h"

ENTRY(bzero)
	movl	sp@(4),a0	/* base */
	movl	sp@(8),d1	/* length */
	jle	7f		/* ought to be positive */

	movw	a0,d0		/* check for odd address */
	lsrw	#1,d0
	jcc	1f
	clrb	a0@+
	subql	#1,d1
	jle	7f
1:				/* we now have even address, positive count */
	movq	#0,d0
	movl	d1,a1		/* save byte count */
	lsrl	#2,d1		/* convert to long count (truncated) */
	jra	3f

2:	movl	d0,a0@+		/* long copy loop */
3:	dbf	d1,2b		/* entry point of long copy loop */
	addqw	#1,d1		/* propogate borrow thru all 32 bits */
	subql	#1,d1
	jge	2b
4:
	movw	a1,d1		/* restore byte count */
	andw	#3,d1		/* only interested in bottom 3 bits */
	jra	6f

5:	movb	d0,a0@+		/* copy last 0-3 bytes */
6:	dbf	d1,5b
7:
	rts
