/* addressed unsigned long division: *dividend = *dividend / divisor */

#include "DEFS.h"

ASENTRY(auldiv)
	link	a6,#0
	moveml	#0x3800,sp@-	/* need d2,d3,d4 registers */
	movl	a6@(8),a0	/* a0 = dividend pointer */
	movl	a0@,d0		/* d0 = dividend */
	movl	d0,d3		/* save dividend */
	movl	a6@(12),d1	/* divisor */
	movl	d1,d4		/* save divisor */

	cmpl	#0x10000,d1	/* divisor >= 2 ** 16? */
	jcc	1f		/* yes, divisor must be < 2 ** 16 */
	clrw	d0		/* divide dividend */
	swap	d0		/*   by 2 ** 16 */
	divu	d1,d0		/* get the high order bits of quotient */
	movw	d0,d2		/* save quotient high */
	movw	d3,d0		/* dividend low + remainder * (2**16) */
	divu	d1,d0		/* get quotient low */
	swap	d0		/* temporarily save quotient low in high */
	movw	d2,d0		/* restore quotient high to low part of reg */
	swap	d0		/* put things right */
	jra	3f		/* return */
1:
	lsrl	#0x1,d0		/* shift dividend */
	lsrl	#0x1,d1		/* shift divisor */
	cmpl	#0x10000,d1	/* divisor < 2 ** 16? */
	jcc	1b		/* no, continue shift */
	divu	d1,d0		/* yes, divide, remainder is garbage */
	moveq	#0,d2		/* get rid of remainder */
	movw	d0,d2		/* save quotient */
	movl	d2,sp@-		/* call ulmul with quotient */
	movl	d4,sp@-		/*   and saved divisor on stack */
	jsr	ulmul		/*   as arguments */
	addql	#0x8,sp		/* restore sp */
	cmpl	d0,d3		/* original dividend >= lmul result? */
	jcc	2f		/* yes, quotient should be correct */
	subql	#1,d2		/* no, fix up quotient */
2:
	movl	d2,d0		/* move quotient to d0 */
3:
	movl	d0,a0@		/* store result via pointer */
	moveml	sp@+,#0x001C	/* restore registers */
	unlk	a6
	rts
