/*
 * @(#)reset.s	4.2 (Berkeley) 7/5/83
 * C library -- reset, setexit
 *
 *	reset(x)
 * will generate a "return" from
 * the last call to
 *	setexit()
 * by restoring d2-d7 & a2-a7 & ret addr
 * and doing a return.
 * The returned value is x; on the original
 * call the returned value is 0.
 *
 * useful for going back to the main loop
 * after a horrible error in a lowlevel
 * routine.
 */
#include "DEFS.h"

ENTRY(setexit)
	movl	sp@+,a1
	lea	setsav,a0
	movml	#0xFEFC,a0@
	movq	#0,d0
	jmp 	a1@

ENTRY(reset)
	movl	sp@(4),d0
	lea	setsav,a0
	movml	a0@,#0xFEFC
	jmp 	a1@

	.data
setsav:	.space	13*4
