
/*
	signal -- old system call emulation for 4.2BSD (VAX version)
		(adapted from BRL UNIX System V emulation for 4.2BSD)

	From: Doug Gwyn (VLD/VMB) <Brl-Vld.ARPA!gwyn>

	last edit:	25-Aug-1984	D A Gwyn

	NOTE:  Although this module is VAX-specific, it should be
	possible to adapt it to other fairly clean implementations of
	4.2BSD.  The difficulty lies in avoiding the automatic restart
	of certain system calls when the signal handler returns.  I use
	here a trick first described by Donn Seeley of UCSD Chem. Dept.

	Comment from unidentified Sun person: "This is really sicko, but I've
						seen worse."
*/

#include	<errno.h>
#include	<signal.h>
#include	<syscall.h>

typedef int (*funcp)(); 			/* for the sun C compiler */

extern int	sigvec();
extern int	sigsetmask();

extern		etext;
extern int	errno;

static funcp handler[NSIG] = {			/* "current handler" memory */
	BADSIG					/* initially, unknown state */
	};
static int	inited = 0;			/* for initializing above */

static int	_catchsig();
extern int	interrupt_sys();

funcp
signal4_1( sig, func )				/* returns previous handler */
	register int	sig;			/* signal affected */
	register int	(*func)();		/* new handler */
{
	register int	(*retval)();		/* previous handler value */
	struct sigvec	oldsv;			/* previous state */
	struct sigvec	newsv;			/* state being set */

	if ( func >= (funcp)&etext ) {		/* "lint" hates this */
		errno = EFAULT;
		return(BADSIG);			/* error */
	}

	/* cancel pending signals */
	newsv.sv_handler = SIG_IGN;
	newsv.sv_mask = newsv.sv_onstack = 0;
	if ( sigvec( sig, &newsv, &oldsv ) != 0 )
		return BADSIG;		/* error */

	/* C language provides no good way to initialize handler[] */
	if ( inited == 0 ) {			/* once only */
		register int	i;
		for ( i = 1; i < NSIG; ++i ) {
			handler[i] = BADSIG;
		}
		++inited;
	}

	/* the first time for this sig, get state from the system */
	if ( (retval = handler[sig-1]) == BADSIG )
		retval = oldsv.sv_handler;

	handler[sig-1] = func;			/* keep track of state */

	if ( func == SIG_DFL )
		newsv.sv_handler = SIG_DFL;
	else if ( func == SIG_IGN )
		return(retval);			/* exit */
	else 
		newsv.sv_handler = _catchsig;	/* actual sig catcher */

	if ( sigvec( sig, &newsv, (struct sigvec *)0 ) != 0 )
		return(BADSIG);			/* error */

	return(retval);				/* exit */
}


/* PC will be pointing at a syscall if it is to be restarted: */
typedef unsigned short  instruction;
#define SYSCALL ((instruction)0x4E40)   /* 68010/20 "trap 0" instruction */
#define	PEAIMM	((instruction)0x4878)	/* 68010/20 "pea immediate" instr */

/*ARGSUSED*/
static int
_catchsig( sig, code, scp )		/* signal interceptor */
	register int		sig;	/* signal number */
	int			code;	/* code for SIGILL, SIGFPE */
	register struct sigcontext	*scp;	/* -> interrupted context */
{
	register int		(*uhandler)();	/* user handler */
	register instruction		*pc;	/* for snooping instructions */
	struct sigvec		newsv;		/* state being set */

	/* at this point, sig is blocked */

	uhandler = handler[sig - 1];

	/* 
	 * most UNIXes usually want the state reset to SIG_DFL 
	 * comment these lines out if you want to have the 4.2 action of leaving
	 * the signal handler in place after making a call.
	 */
	if ( sig != SIGILL && sig != SIGTRAP ) {
		handler[sig-1] = newsv.sv_handler = SIG_DFL;
		newsv.sv_mask = newsv.sv_onstack = 0;
		(void)sigvec( sig, &newsv, (struct sigvec *)0 );
	}

	(void)sigsetmask( scp->sc_mask );	/* restore old mask */

	/* 
	 * at this point, sig is not blocked, usually have SIG_DFL;
	 * a longjmp may safely be taken by the user signal handler 
	 */

	(void)(*uhandler)( sig );		/* user signal handler */

	/* 
	 * must now avoid restarting certain system calls
	 * Here is what is going to happen.  We check the PC that is to be 
	 * restored after all the signal jazz has run its course.  If the 
	 * PC is pointing to a "trap 0x0" instruction, we know that we are 
	 * going to trap back to the kernel for a system call of one sort or
	 * another.  The convention is to push a value onto the stack via
	 * "pea   XX" where XX is some value from <syscall.h>, and then do
	 * the "trap 0x0".  So, if we find that the value pushed onto the 
	 * stack before the trap is one of the ones we want to interrupt, we
	 * now have to diddle the PC to jump to my "system call return"
	 * 
	 *
	 */
	pc = (instruction *)scp->sc_pc;
	if ( *pc == SYSCALL) {
		pc--;
		if ((*pc == SYS_read || *pc == SYS_write || *pc == SYS_ioctl ||
		    *pc == SYS_readv || *pc == SYS_writev ||*pc == SYS_wait) &&
		    (*(--pc) == PEAIMM))
				scp->sc_pc = (int)interrupt_sys;
	}

	/* return here restores interrupted context */
}
