#undef NOTDEF
/*
 * C object code improver-- second part
 * Removed bug in equop (it thought two .TEXT's coulde be replaced by one),
 *	and added some comments. 1982/Jan Per Bothner
 * Changed so MOVEQ, ADDQ, SUBQ never try loading from reg. 82/Jan PB
 * Fixed findcon to test for null locations. 82/Jan/21 PB
 */
#include <stdio.h>
#include "o68.h"

static char rcsid[] = "$Header: o1.c,v 1.3 86/03/11 07:32:00 root Exp $";

struct node *newsqn();
char *findcon();

/* 
 * Improve register usage by using any operands which are already in registers 
 */
rmove()
{
	register struct node *p, *q, *t;
	register char *cp;
	register int r;
	int r1, tr;
	int wr1, wr2;
	struct node *ptemp;
	int	seqno;


#ifdef NOTDEF
	if (debug)
		printf("Entering rmove\n");	/* DEBUG */
#endif

	for (q=p=first.forw; p!=0; q=p, p = p->forw) {

#ifdef NOTDEF
	if (debug) {
		for (tr=0; tr<NREG; tr++)
			if (regs[tr][0])
				printf("%d: %s ", tr, regs[tr]);
		trace(p);
	}
#endif

	switch (p->op) {

	case MOVEQ:
	case MOV:
#ifdef NOTDEF
		if (debug) {
			printf("rmove: case MOV/MOVEQ\n");
			for (tr=0; tr<NREG; tr++)
				if (regs[tr][0])
					printf("%d: %s ", tr, regs[tr]);
			printf("\nMOV: entering: %d %d %d %d %d %d %d %d\n\n",
			  cregs[0], cregs[1], cregs[2], cregs[3], cregs[4],
			  cregs[5], cregs[6], cregs[7]);
			trace(p);
		}
#endif
		if ( (t = newsqn(p,q)) != p) {
			p = t;
			continue;
		}
		dualop(p);
		if (equstr(regs[RT1],regs[RT2])) {
#ifdef NOTDEF
			if (debug)
				printf("source == dest");
#endif
			goto deli;
		}
		if (p->subop==BYTE || p->subop==WORD)
			goto badmov;
		r = findrand(regs[RT1]);
		wr2 = isreg(regs[RT2]);
		wr1 = isreg(regs[RT1]);
		if (debug)
			printf("wr1 = %d, wr2 = %d\n", wr1, wr2);
# ifdef OLD
		if ((((r >= 0) && (r < 8) && (r == wr2))
		  || ((wr1 >= 0) && (wr1 < 8) && (wr2 >= 0) && (wr2 < 8)
		  && (cregs[wr2] == cregs[wr1]))) && p->forw->op != CBR) {
# else OLD
		if ((r >= 0) && (r < 8) && ((r == wr2)
		  || ((wr1 >= 0) && (wr1 < 8) && (wr2 >= 0) && (wr2 < 8)
		  && (cregs[wr2] == cregs[wr1]))) && p->forw->op != CBR) {
# endif OLD

deli:
			if (debug) {
				printf("DELI ");
#ifdef NOTDEF
				if (wr1 >= 0 && wr1 <= 7)
					printf("cregs[%d]=%d ",wr1,cregs[wr1]);
				if (wr2 >= 0 && wr2 <= 7)
					printf("cregs[%d]=%d ",wr2,cregs[wr2]);
				printf("\n");
#endif
			}
			p->forw->back = p->back;
			p->back->forw = p->forw;
			p->ref = freenodes;
			freenodes = p;
			redunm++;
			nchange++;
			continue;
		}
#ifdef NOTDEF
		if (debug) {
			printf("NO DELI ");
			if (wr1 >= 0 && wr1 <= 7)
				printf(" cregs[%d]=%d", wr1, cregs[wr1]);
			if (wr2 >= 0 && wr2 <= 7)
				printf(" cregs[%d]=%d", wr2, cregs[wr2]);
			printf("\n");
		}
#endif
		if (p->op != MOVEQ)
		    repladdr(p, 0, 1);
		r = isreg(regs[RT1]);
		r1 = isreg(regs[RT2]);
#ifdef NOTDEF
		if (debug)
			printf("AFTER REPLADDR, r = %d, r1 = %d code is %s\n",
				r, r1, p->code);
#endif
		dest(regs[RT2]);
		if (r >= 0 && r < 8)
			if (r1 >= 0) {
				cregs[r1] = cregs[r];
				savereg(r1, regs[r]);
			}
			else
				savereg(r, regs[RT2]);
		else
			if (r1 >= 0 && r1 < 8) {
				cregs[r1] = r1;
				savereg(r1, regs[RT1]);
			}
			else
				setcon(regs[RT1], regs[RT2]);
		source(regs[RT1]);
#ifdef NOTDEF
		if (debug)
			printf("\nMOV: exiting: %d %d %d %d %d %d %d %d\n\n",
		  	cregs[0], cregs[1], cregs[2], cregs[3], cregs[4],
		  	cregs[5], cregs[6], cregs[7]);
#endif
/*		setcc(regs[RT2]);
*/		continue;

	case ADDQ:
	case SUBQ:
#ifdef NOTDEF
		if (debug)
			printf("rmove: case ADDQ/SUBQ\n");
#endif
		dualop(p);
		dest(regs[RT2]);
		ccloc[0] = 0;
		fixcregs();
		continue;

	case MULS:
	case MULU:
	case DIVS:
	case DIVU:
	case ADD:
	case SUB:
	case AND:
	case OR:
	case EOR:
	badmov:
#ifdef NOTDEF
		if (debug)
			printf("rmove: case MUL/DIV/ADD/SUB/AND/OR/badmov\n");
#endif
/*  CTH  5/17/84
 * there was a bug where the optimizer did not realize that the length of
 * what was being referenced affected wether its value was properly aligned in
 * a register. If the same location was referenced (via cast) as a long and 
 * then a char, it would replace the char with the register the long was in; 
 * the alignment being incorect. The solution is to not attempt to replace 
 * addresses on char and word instructions.
 * the code if(p->subop==LONG) before all calls to repladdr is intended to fix
 * this problem.
 */
		dualop(p);
		if (p->subop==LONG)
			repladdr(p, 0, 1);
		source(regs[RT1]);
		dest(regs[RT2]);
		ccloc[0] = 0;
		fixcregs();
		continue;

	case CLR:
	case NOT:
	case NEG:
	case EXT:
#ifdef NOTDEF
		if (debug)
			printf("rmove: case CLR/NOT/NEG/EXT\n");
#endif
		singop(p);
		dest(regs[RT1]);
		if (p->op==CLR)
			if ((r = isreg(regs[RT1])) >= 0)
				savereg(r, "#0");
			else
				setcon("#0", regs[RT1]);
		ccloc[0] = 0;
		fixcregs();
		continue;

	case TST:
#ifdef NOTDEF
		if (debug)
			printf("rmove: case TST\n");
#endif
		singop(p);
		if (p->subop==LONG)
			repladdr(p, 0, 0);
		source(regs[RT1]);
		if (regs[RT1][0] && equstr(regs[RT1], ccloc)) {
			p->back->forw = p->forw;
			p->forw->back = p->back;
			ptemp = p;
			p = p->back;
			ptemp->ref = freenodes;
			freenodes = ptemp;
			nrtst++;
			nchange++;
		}
		fixcregs();
		continue;

	case CMP:
#ifdef NOTDEF
		if (debug)
			printf("rmove: case CMP\n");
#endif
		dualop(p);
		source(regs[RT1]);
		source(regs[RT2]);
		if (p->subop==LONG)
			repladdr(p, 1, 1);
		ccloc[0] = 0;
		fixcregs();
		continue;

	case CBR:
#ifdef NOTDEF
		if (debug)
			printf("rmove: case CBR\n");
#endif
		ccloc[0] = 0;
		clearcregs();
		continue;

	case MOVEM:
#ifdef NOTDEF
		if (debug)
			printf("rmove: case MOVEM\n");
#endif
		savemask(p);
		clearcregs();
		continue;

	case JBSR:
#ifdef NOTDEF
		if (debug)
			printf("rmove: case JBSR\n");
#endif
		chknestcall(p);
		clearreg();
		clearcregs();
		continue;

	case JBR:
#ifdef NOTDEF
		if (debug)
			printf("rmove: case JBR\n");
#endif
		redunbr(p);
		clearreg();
		clearcregs();
		continue;

	case EROU:
#ifdef NOTDEF
		if (debug)
			printf("rmove: case EROU\n");
#endif
		checkmask(p);
		clearreg();
		clearcregs();
		continue;

	default:
#ifdef NOTDEF
		if (debug)
			printf("rmove: case default\n");
#endif
		clearreg();
		clearcregs();
	}
	}
}

jumpsw()
{
	register struct node *p, *p1, *tp;
	register t;
	int nj;

	t = 0;
	nj = 0;
	for (p=first.forw; p!=0; p = p->forw)
		p->refc = ++t;
	for (p=first.forw; p!=0; p = p1) {
		p1 = p->forw;
		if (p->op == CBR && p1->op==JBR && p->ref && p1->ref && 
		   abs(p->refc - p->ref->refc)>abs(p1->refc - p1->ref->refc)) {
			if (p->ref==p1->ref)
				continue;
			p->subop = revbr[p->subop];
			tp = p1->ref;
			p1->ref = p->ref;
			p->ref = tp;
			t = p1->labno;
			p1->labno = p->labno;
			p->labno = t;
#ifdef COPYCODE
			if (p->labno == 0) {
				t = p1->code;
				p1->code = p->code;
				p->code = t;
			}
#endif COPYCODE
			nrevbr++;
			nj++;
		}
	}
	return(nj);
}

abs(x)
{
	return(x<0? -x: x);
}

/* Test if p1 and p2 are "equal". */
equop(p1, p2)
register struct node *p1, *p2;
{
	register char *cp1, *cp2;

	if (p1->op!=p2->op || p1->subop!=p2->subop)
		return(0);
	if (p1->op>0 && p1->op<MOV)
	    return(0);
	/* Added 1982/Jan -Per Bothner */
	if (p1->op>=TEXT)
	    return(0);
	cp1 = p1->code;
	cp2 = p2->code;
	if (cp1==0 && cp2==0)
		return(1);
	if (cp1==0 || cp2==0)
		return(0);
	while (*cp1 == *cp2++)
		if (*cp1++ == 0)
			return(1);
	return(0);
}

decref(p)
register struct node *p;
{
	if (p->op != LABEL) 
		return;
	if ( keeplab)  
		return;
	if (--p->refc <= 0 ) {
		nrlab++;
		p->back->forw = p->forw;
		p->forw->back = p->back;
		p->ref = freenodes;
		freenodes = p;
	}
}

/* Return first node after ap (inclusive) which is not a label */
struct node *nonlab(ap)
struct node *ap;
{
	register struct node *p;

	p = ap;
	while (p && p->op==LABEL)
		p = p->forw;
	return(p);
}

/* Return a new node */
struct node *
getnode()
{
	register struct node *p;
	char *calloc();

	if (p = freenodes) { 
		freenodes = p->ref; 
		p->subop = 0; 
		return(p); 
	}
	return ((struct node *)calloc(1,sizeof first));
}

clearreg()
{
	register int i;

	for (i=0; i<NREG; i++)
		regs[i][0] = '\0';
	regs[0][0] = 'd';	/* EXPERIMENTAL */
	regs[0][1] = '0';	/* EXPERIMENTAL */
	regs[0][0] = '\0';	/* EXPERIMENTAL */
	regs[1][0] = 'd';	/* EXPERIMENTAL */
	regs[1][1] = '1';	/* EXPERIMENTAL */
	regs[1][0] = '\0';	/* EXPERIMENTAL */
	regs[2][0] = 'd';	/* EXPERIMENTAL */
	regs[2][1] = '2';	/* EXPERIMENTAL */
	regs[2][0] = '\0';	/* EXPERIMENTAL */
	conloc[0] = 0;
	ccloc[0] = 0;
}

savereg(ai, as)
char *as;
{
	register char *p, *s, *sp;

	sp = p = regs[ai];
	s = as;
	if (source(s))
		return;
/*	if (s[0]=='a' && s[1]<'6' && s[2]=='@') {
 *		*sp = 0;
 *		return;
 *	}
 */	while (*p++ = *s)
		if (*s++ == ',')
			break;
	*--p = '\0';
}

/* look through register contents table, clearing entries
 * based on value of address register 'reg'.
 */
areg(reg)
  {	register int i;
	register char *p;

	for (i = 0; i < RT2; i++) {
		p = regs[i];
		if (*p++ == 'a' && *p == (reg - 8 + '0')) 
			regs[i][0] = 0;
	}
}

/* update register contents table assuming operand passed as argument
 * was affected by instruction
 */
dest(as)
char *as;
{
	register char *s;
	register int i;

	s = as;
	source(s);

	/* if dest was a register, update registers table entry */
	if ((i = isreg(s)) >= 0) 
		regs[i][0] = 0;

	/* if dest was an address reg, clear table entries for regs that
	 * were loaded using that address reg.
	 */
	if (i >= 8) 
		areg(i);

	/* clear any regs that claim to have copy of dest's value */
	while ((i = findrand(s)) >= 0) 
		regs[i][0] = 0;

	/* if there is any indirection, we don't know anything afterward */
	if (*s++=='a' && *s>='0' && *s++<='5' && *s=='@')
		for (i=0; i<NREG; i++) {
			if (regs[i][0] != '#') 
				regs[i][0] = 0;
			conloc[0] = 0;
		}
}

/* set RT1 (source) "register" from assy. language code */
singop(ap)
struct node *ap;
{
	register char *p1, *p2;

	p1 = ap->code;
	p2 = regs[RT1];
	while (*p2++ = *p1++);
	regs[RT2][0] = 0;
}


/* set RT1 (source) and RT2 (dest) "registers" from assy. language code */
dualop(ap)
struct node *ap;
{
	register char *p1, *p2;
	register struct node *p;

	p = ap;
	p1 = p->code;
	p2 = regs[RT1];
	while (*p1 && *p1!=',')
		*p2++ = *p1++;
	*p2++ = 0;
	p2 = regs[RT2];
	*p2 = 0;
	if (*p1++ !=',')
		return;
	while (*p1==' ' || *p1=='\t')
		p1++;
	while (*p2++ = *p1++);
}

/* return register number of reg that already contains operand passed as
 * arg, -1 otherwise.
 */
findrand(as)
char *as;
{	register int i;

#ifdef NOTDEF
	if (debug) /* DEBUG */
		printf("findrand(%s)\n", as);
#endif
	if (*as) 
	    for (i = 0; i<NREG; i++)
		if (equstr(regs[i], as)) {
#ifdef NOTDEF
			if (debug)
				printf("findrand: %s %s\n",as,regs[i]);
#endif
			return(i);
		}

	return(-1);
}

/* return register number if operand corresponds to register, else -1 */
isreg(as)
char *as;
{
	register char *s;

	s = as;
	if (s[0]=='d' && s[1]>='0' && s[1]<='7' && s[2]==0)
		return(s[1]-'0');
	if (s[0]=='a' && s[1]>='0' && s[1]<='5' && s[2]==0)
		return(s[1]-'0'+8);
	return(-1);
}

check()
{
	register struct node *p, *lp;

	lp = &first;
	for (p=first.forw; p!=0; p = p->forw) {
		if (p->back != lp)
			abort();
		lp = p;
	}
}

/* look for operands of the form an@+ or an@-; if found, reset register contents
 * table for register n and for any regs based on address register n.
 */
source(ap)
char *ap;
{
	register char *p1, *p2;
	register int i;

	p1 = ap;
	p2 = p1;
	if (*p1==0)
		return(0);
	while (*p2++);
	if (*(p2-2)=='+' || *(p2-2)=='-') {
		if (*p1++=='a' && *p1>='0' && *p1<='5') {
		  regs[(i = *p1 - '0' + 8)][0] = 0;
		  areg(i);
		}
		return(1);
	}
	return(0);
}

/* Replace address fields of instruction 'p' of args already in regs.
 * If 'f', arg2 is second source instead of destination.
 * If 'g', address register may be used as replacement, else only data.
 */
repladdr(p, f, g)
struct node *p;
{
	register r;
	int r1;
	register char *p1, *p2;
	static char rt1[50], rt2[50];

	if (f)
		r1 = findrand(regs[RT2]);
	else
		r1 = -1;
	r = findrand(regs[RT1]);
	if (r>=0 || r1>=0) {
		p2 = regs[RT1];
		for (p1 = rt1; *p1++ = *p2++;);
		if (regs[RT2][0]) {
			p1 = rt2;
			*p1++ = ',';
			for (p2 = regs[RT2]; *p1++ = *p2++;);
		} else
			rt2[0] = 0;
		if (r>=0) {
			if (r>7) {
			  if (!g) return;
			  rt1[0] = 'a';
			  rt1[1] = r - 8 + '0';
			} else { 
			  rt1[0] = 'd'; 
			  rt1[1] = r + '0'; 
			}
			rt1[2] = 0;
			nsaddr++;
		}
		if (r1>=0) {
			if (r1>7) {
			  if (!g) 
				return;
			  rt2[1] = 'a';
			  rt2[2] = r1 - 8 + '0';
			} else { 
			  rt2[1] = 'd'; 
			  rt2[2] = r1 + '0'; 
			}
			rt2[3] = 0;
			nsaddr++;
		}
		strcat(rt1,rt2);
		p->code = copy(rt1);
	}
}

movedat()
{
	register struct node *p1, *p2;
	struct node *p3;
	register seg;
	struct node data;
	struct node *datp;

	if (first.forw == 0)
		return;
	data.forw = 0;
	datp = &data;
	for (p1 = first.forw; p1!=0; p1 = p1->forw) {
		if (p1->op == DATA) {
			p2 = p1->forw;
			while (p2 && p2->op!=TEXT)
				p2 = p2->forw;
			if (p2==0)
				break;
			p3 = p1->back;
			p1->back->forw = p2->forw;
			p2->forw->back = p3;
			p2->forw = 0;
			datp->forw = p1;
			p1->back = datp;
			p1 = p3;
			datp = p2;
		}
	}
	if (data.forw) {
		datp->forw = first.forw;
		first.forw->back = datp;
		data.forw->back = &first;
		first.forw = data.forw;
	}
/**/
	/* Remove redundant TEXT, DATA, and BSS nodes. */
/*	seg = -1;
	for (p1 = first.forw; p1!=0; p1 = p1->forw)
		if (p1->op==TEXT||p1->op==DATA||p1->op==BSS) {
			if (p1->op == seg || (p1->forw && 
			    (p1->forw->op==TEXT||p1->forw->op==DATA||
			    p1->forw->op==BSS))) {
				p1->back->forw = p1->forw;
				p1->forw->back = p1->back;
				p1->ref = freenodes;
				freenodes = p1;
				p1 = p1->back;
				continue;
			}
			else 
				seg = p1->op;
		}
/**/
}

redunbr(p)
register struct node *p;
{
	register struct node *p1;
	register char *ap1, *ap2;

	if ((p1 = p->ref) == 0)
		return;
	p1 = nonlab(p1);
	if (p1->op==TST) {
		singop(p1);
		savereg(RT2, "#0");
	} else if (p1->op==CMP)
		dualop(p1);
	else
		return;
	if (p1->forw->op!=CBR)
		return;
	ap1 = findcon(RT1);
	ap2 = findcon(RT2);
	p1 = p1->forw;
	if (compare(p1->subop, ap1, ap2)) {
		nredunj++;
		nchange++;
		decref(p->ref);
		p->ref = p1->ref;
		p->labno = p1->labno;
#ifdef COPYCODE
		if (p->labno == 0)
			p->code = p1->code;
		if (p->ref)
#endif COPYCODE
			p->ref->refc++;
	}
}

/* Return code which is equal to contents of reg. i, preferably a constant */
char *
findcon(i)
{
	register char *p; register maxiter = 14;
	do  {
	    p = regs[i];
	    if (*p=='#')
		return(p);
	} while ((i = isreg(p)) >= 0 && --maxiter);
	if (*p && equstr(p, conloc))
		return(conval);
	return(p);
}

/* Test: acp1 op acp2.
 * Return 1 if test succeeds; 0 if not or can't tell. */
compare(op, acp1, acp2)
char *acp1, *acp2;
{
	register char *cp1, *cp2;
	register n1, n2;
	struct { int i;};

	cp1 = acp1;
	cp2 = acp2;

	if (*cp1++ != '#' || *cp2++ != '#')
		return(0);
	n1 = 0;
	while (*cp2 >= '0' && *cp2 <= '9') {
		n1 *= 10;
		n1 += *cp2++ - '0';
	}
	n2 = n1;
	n1 = 0;
	while (*cp1 >= '0' && *cp1 <= '9') {
		n1 *= 10;
		n1 += *cp1++ - '0';
	}
	if (*cp1=='+')
		cp1++;
	if (*cp2=='+')
		cp2++;
	do {
		if (*cp1++ != *cp2)
			return(0);
	} while (*cp2++);

	switch(op) {

	case JEQ:
		return(n1 == n2);
	case JNE:
		return(n1 != n2);
	case JLE:
		return(n1 <= n2);
	case JGE:
		return(n1 >= n2);
	case JLT:
		return(n1 < n2);
	case JGT:
		return(n1 > n2);
	case JLO:
		return(n1 < n2);
	case JHI:
		return(n1 > n2);
	case JLOS:
		return(n1 <= n2);
	case JHIS:
		return(n1 >= n2);
	}
	return(0);
}

setcon(ar1, ar2)
char *ar1, *ar2;
{
	register char *cl, *cv, *p;

	cl = ar2;
	cv = ar1;
	if (*cv != '#')
		return;
	if (!natural(cl))
		return;
	p = conloc;
	while (*p++ = *cl++);
	p = conval;
	while (*p++ = *cv++);
}

equstr(ap1, ap2)
char *ap1, *ap2;
{
	char *p1, *p2;

	p1 = ap1;
	p2 = ap2;
	do {
		if (*p1++ != *p2)
			return(0);
	} while (*p2++);
	return(1);
}

setcc(ap)
char *ap;
{
	register char *p, *p1;

	p = ap;
	if (!natural(p)) {
		ccloc[0] = 0;
		return;
	}
	p1 = ccloc;
	while (*p1++ = *p++);
}

natural(ap)
char *ap;
{
	register char *p;

	p = ap;
	if (*p=='*' || *p=='(' || *p=='-'&&*(p+1)=='(')
		return(0);
	while (*p++);
	p--;
	if (*--p == '+' || *p ==')' && *--p != '5')
		return(0);
	return(1);
}

astoi(p)
register char *p;
{
/*	register char c; */
	char c;
	register int n = 0;
	int negflg = 1;
	
	if (p == NULL)
		return (0);
	while ((c = *p++) == ' ' || c == '\t'); 
	if (c == 0)
		return (0);
	if (c == '-') {
		negflg = -1;
		c = *p++;
	}
	if ( (c == '0') && ( ((c = *p++) == 'x') ||  (c == 'X') ) )
		while (c = *p++) {
			if (c >= '0' && c <= '9')
				n = (n << 4) + (c - '0');
			else if (c >= 'a' && c <= 'f')
				n = (n << 4) + (c - 'a');
			else if (c >= 'A' && c <= 'F')
				n = (n << 4) + (c - 'A');
			else 
				return (negflg*n);
		}
	while ( c >= '0' && c <= '9') {
		n = 10*n + (c-'0');
		c = *p++;
	}
	return (negflg*n);
}

fixcregs()
{
	int r, minequiv, i;

#ifdef NOTDEF
	if (debug) {
		printf("\nfixcregs: entering: %d %d %d %d %d %d %d %d\n\n",
			cregs[0], cregs[1], cregs[2], cregs[3], cregs[4],
			cregs[5], cregs[6], cregs[7]);
	}
#endif
	if (regs[RT2][0]==0) {
		if ((r = isreg(regs[RT1])) >= 0 && r < 8) {
			cregs[r] = r;
		}
	}
	else if ((r = isreg(regs[RT2])) >= 0 && r < 8) {
		cregs[r] = r;
	}
	minequiv = -1;
	for (i=0; i<8; i++) {
		if (i != r && cregs[i] == r)
			if (minequiv >= 0)
				cregs[i] = minequiv;
			else {
				cregs[i] = i;
				minequiv = i;
			}
	}
#ifdef NOTDEF
	if (debug)
		printf("\nfixcregs: exiting: %d %d %d %d %d %d %d %d\n\n",
			cregs[0], cregs[1], cregs[2], cregs[3], cregs[4],
			cregs[5], cregs[6], cregs[7]);
#endif
}

clearcregs()
{
	int i;

	for (i=0; i<8; i++)
		cregs[i] = i;
}
