/*
        Of filter for HP laser printer for Berkeley 4.2 line printer
        system.  No use is made of width parameter passed by
        lpd.

        Original by Steve Misek, ISI

        Argument processing added and errors fixed by Wally Wedel
        6-26-85.  Following printcap entry works with this
        filter.

	#
	# HP laserJet entry 
	#
	ht|HP LaserJet text filter:\
	 :lp=/dev/ttyh4:\
	 :br#9600:\
	 :rw:\
	 :fc#0000374:\
	 :fs#0000003:\
	 :xc#0037737:\
	 :xs#0040040:\
	 :of=/usr/lib/lpfilters/hpdrf:\
	 :sd=/usr/spool/lht:\
	 :lf=/usr/adm/lw-log:\
	 :af=/usr/adm/lw.acct:

 */
#include <stdio.h>

#define BUFSIZE 1024
#define MAXROWS   66
char    ibuf[BUFSIZE],obuf[3*BUFSIZE];
char    init1[]={'\033','E'};                   /* master reset   */
# ifdef NOTDEF
char    init2[]={'\033','&','k','3','G'};       /* cr -> cr+lf    */
# else NOTDEF
char    init2[]={'\033','&','k','2','G'};       /* cr -> cr+lf    */
# endif NOTDEF
char    init3[]={'\033','&','a','2','L'};       /* left marg  */
char    init4[]={'\033','&','l','6','6','F'};   /* text length 66 */
char    init5[]={'\033','&','l','2','E'};       /* top margin to 2 */
char    init6[]={'\033','&','l','7','.','6','C'};/* v-spc 7.6*1/48 in*/
char    portrait[]={'\033','&','l','0','O'};    /* portrait mode  */
char    landscape[]={'\033','&','l','1','O'};   /* landscape mode */
char    crff[]={'\015','\014'};                 /* CR + form feed */

int pwidth = 85;
int plength = MAXROWS;
int dplength = 66;
int errflg = 0;

main(argc,argv)
int     argc;
char    **argv;
{
        short  row,column,n,p,i;
        int c;
        extern char *optarg;
        extern int optind;

	fprintf(stderr, "HP LJ started\n");
        while ((c = getopt(argc, argv, "w:l:")) != EOF)
                switch (c) {
                case 'w':
                        pwidth = atoi(optarg);
                        break;
                case 'l':
                        plength = atoi(optarg);
                        break;
                default:
                        errflg++;
                        break;
                }

        if (write(1,init1,sizeof(init1)) != sizeof(init1))
           leave(1,sizeof(init1));

        if (plength > dplength)
                plength = dplength;

        if (write(1,init6,sizeof(init6)) != sizeof(init6))
           leave(6,sizeof(init6));

        if (write(1,init2,sizeof(init2)) != sizeof(init2))
           leave(2,sizeof(init2));

        if (write(1,init3,sizeof(init3)) != sizeof(init3))
           leave(3,sizeof(init3));

        if (write(1,init5,sizeof(init5)) != sizeof(init5))
           leave(5, sizeof(init5));

        if (write(1,init4,sizeof(init4)) != sizeof(init4))
           leave(4, sizeof(init4));
 
        column = 0;
        row = 0;
        while((n=read(0,ibuf,BUFSIZE)) > 0){
                for (p=0,i=0;i<n;i++) {
                        if (ibuf[i] == '\t') {
                                do {
                                        obuf[p] = ' ';
                                        p++;
                                        column++;
                                } while (column & 07);
                        }
                        else if (ibuf[i] == '\f') {
                                obuf[p++] = ibuf[i];
                                release_obuf(p);
                                p=row=0;
                        }
                        else {
                                obuf[p] = ibuf[i];
                                p++;
                                column++;
                                if (ibuf[i] == '\n')  {
                                   column=0;
                                   row++;
                                   if (row >= plength) {
                                      if (row != dplength)
                                         obuf[p++] = '\f';
                                      release_obuf(p);
                                      p = 0;
                                      row = 0;
                                   }
                                }
                        }
                }
                if (p > 0) if (write(1,obuf,p) != p) leave(6,p);
        }
}

release_obuf(p)
short p;
{
   if (write(1,obuf,(p)) != (p)) leave(6,(p));
}

leave(o,b)
short o,b;
{
   printf(" HP_TEXT FILTER: write error(%d)  should be %d\n",o,b);
   exit(1);
}


/*
 * getopt - get option letter from argv
 */

#include <stdio.h>

char    *optarg;        /* Global argument pointer. */
int     optind = 0;     /* Global argv index. */

static char     *scan = NULL;   /* Private scan pointer. */

extern char     *index();

int
getopt(argc, argv, optstring)
int argc;
char *argv[];
char *optstring;
{
        register char c;
        register char *place;

        optarg = NULL;

        if (scan == NULL || *scan == '\0') {
                if (optind == 0)
                        optind++;
        
                if (optind >= argc || argv[optind][0] != '-' || argv[optind][1] == '\0')
                        return(EOF);
                if (strcmp(argv[optind], "--")==0) {
                        optind++;
                        return(EOF);
                }
        
                scan = argv[optind]+1;
                optind++;
        }

        c = *scan++;
        place = index(optstring, c);

        if (place == NULL || c == ':') {
                fprintf(stderr, "%s: unknown option -%c\n", argv[0], c);
                return('?');
        }

        place++;
        if (*place == ':') {
                if (*scan != '\0') {
                        optarg = scan;
                        scan = NULL;
                } else {
                        optarg = argv[optind];
                        optind++;
                }
        }

        return(c);
}

