/*
    FUNCTION:

        Of filter for APPLE Laser printer under Berkeley 4.2 line
	printer system.  No use is made of width parameter passed
	by lpd.

    HISTORY:
        	030185   Steve Misek, original implementation for hp.
		062685   Wally Wedel  Argument processing added and 
				      errors fixed.  Corrected the
				      printcap entry. (see below)
        	070185   Steve Misek, extended basic filter to work
				      with the Apple laser writer.

    PRINTCAP ENTRY: (VME/510/1410)
	at|Apple Draft Text Filter:\
		:lp=/dev/ttyhe:\
		:br#9600:\
		:fc#0000374\
		:fs#0000003\
		:xc#0\
		:xs#0040040\
		:rw:sh:\
		:of=/usr/lib/lpfilters/drfat:\
		:sd=/usr/spool/lat:\
		:lf=/usr/adm/lw-log:\
		:af=/usr/adm/lw.acct:\
		:mx#0:\
		:sf:\
		:sb:
    PRINTCAP ENTRY: (U!)
	at|Apple text filter:\
		:lp=/dev/ttyc0:\
		:br#9600:\
		:of=/usr/lib/lpfilters/drfap:\
		:sd=/usr/spool/lat:\
		:lf=/usr/adm/lpd-errs:


 */
#include <stdio.h>

#define BUFSIZE 1024
#define MAXROWS   66

char	startpage[] = {'S','t','a','r','t','P','a','g','e','\n'};
char	endpage[]   = {'E','n','d','P','a','g','e','\n'};
char	controld[]   = {'\004'};

char    ibuf[BUFSIZE],obuf[3*BUFSIZE];
int	pwidth = 85;
int	plength = MAXROWS;
int	dplength = 66;
int	errflg = 0;
int	pagenum = 1;

main(argc,argv)
int     argc;
char    **argv;
{
        short  row,column,n,p,i;
        int c;
        extern char *optarg;
        extern int optind;

	/***********************************/
        /* get options off of command line */
	/***********************************/
        while ((c = getopt(argc, argv, "w:l:")) != EOF)
                switch (c) {
                case 'w':
                        pwidth = atoi(optarg);
                        break;
                case 'l':
                        plength = atoi(optarg);
                        break;
                default:
                        errflg++;
                        break;
                }
	/*************************/
        /* initialize, and begin */
	/*************************/
	initialize();
        write(1,startpage,sizeof(startpage));
        if (plength > dplength) plength = dplength;
        column = 0;
        row = 0;
	p = 0;
        while((n=read(0,ibuf,BUFSIZE)) > 0){
                for (i=0;i<n;i++) {
                        if (ibuf[i] == '\t') {
                                do {
                                        obuf[p] = ' ';
                                        p++;
                                        column++;
                                } while (column & 07);
                        }
                        else if (ibuf[i] == '\f') {
				release_page(p);
                                p=row=0;
                        }
                        else {
				if ((ibuf[i] == '\\') ||
				    (ibuf[i] == '(' ) ||
				    (ibuf[i] == ')' ))
				{
				   obuf[p] = '\\';
				   p++;
				}
                                obuf[p] = ibuf[i];
                                p++;
                                column++;
                                if (ibuf[i] == '\n')  {
				   release_line(p);
                                   p=column=0;
                                   row++;
                                   if (row >= plength) {
                                      /* if (row != dplength) */ 
					 release_page(0);
                                      row = 0;
                                   }
                                }
                        }
                }
        }
        if (p > 0) release_page(p);
	write(1,endpage,sizeof(endpage));
	/****************************/
	/* write out end characters */
	/****************************/
	write(1,controld,sizeof(controld));
	sprintf(obuf,"(%%%%[ pagecount: )print statusdict /pagecount");
	   write(1,obuf,strlen(obuf));
	sprintf(obuf," get exec(                )cvs print( ]%%%%)= flush\n");
	   write(1,obuf,strlen(obuf));
	write(1,controld,sizeof(controld));
   sleep(15);
}
 
release_page(p)
short p;
{
   pagenum++;
   if (p > 0) write(1,obuf,p);
   write(1,endpage,sizeof(endpage));
   sprintf(obuf,"%%%%Page %d %d\n",pagenum,pagenum);
      write(1,obuf,strlen(obuf));
   write(1,startpage,sizeof(startpage));
   sleep(15);
}
 
release_line(p)
short p;
{
   if (p > 1) {
      obuf[p-1] = ')';
      obuf[p]   = 'S';
      obuf[p+1] = '\n';
      write(1,"(",sizeof("("));
      write(1,obuf,(p+2));
   }
   else {
      obuf[0] = '1';
      obuf[1] = ' ';
      obuf[2] = 'L';
      obuf[3] = '\n';
      write(1,obuf,4);
   }
}

initialize()
{
   /**********/
   /* line 1 */
   /**********/
	sprintf(obuf,"(%%%%[ pagecount: )print statusdict /pagecount");
	   write(1,obuf,strlen(obuf));
	sprintf(obuf," get exec(                )cvs print( ]%%%%)= flush\n");
	   write(1,obuf,strlen(obuf));
   /**********/
   /* line 2 */
   /**********/
        sprintf(obuf,"%%%%PS-Adobe-1.0\n");
	   write(1,obuf,strlen(obuf));
   /**********/
   /* line 3 */
   /**********/
        sprintf(obuf,"%%%%Creator: barney:misek\n");
	   write(1,obuf,strlen(obuf));
   /**********/
   /* line 4 */
   /**********/
        sprintf(obuf,"%%%%CreationDate: Sun Jun 30 18:13:53 1985\n");
	   write(1,obuf,strlen(obuf));
   /**********/
   /* line 5 */
   /**********/
        sprintf(obuf,"%%%%DocumentFonts: Courier\n");
	   write(1,obuf,strlen(obuf));
   /**********/
   /* line 6 */
   /**********/
        sprintf(obuf,"/StartPage {/sv save def 48 756 moveto} def\n");
	   write(1,obuf,strlen(obuf));
   /**********/
   /* line 7 */
   /**********/
        sprintf(obuf,"/S {count{gsave show grestore}");
	   write(1,obuf,strlen(obuf));
	sprintf(obuf,"repeat 0 -10 rmoveto}def\n");
	   write(1,obuf,strlen(obuf));
   /**********/
   /* line 8 */
   /**********/
        sprintf(obuf,"/L {-10 mul 0 exch rmoveto}def\n");
	   write(1,obuf,strlen(obuf));
   /**********/
   /* line 9 */
   /**********/
        sprintf(obuf,"/EndPage {showpage sv restore}def\n");
	   write(1,obuf,strlen(obuf));
   /***********/
   /* line 10 */
   /***********/
        sprintf(obuf,"/Courier findfont 10 scalefont setfont\n");
	   write(1,obuf,strlen(obuf));
   /***********/
   /* line 11 */
   /***********/
        sprintf(obuf,"%%%%EndProlog\n");
	   write(1,obuf,strlen(obuf));
}


/*
 *
 * getopt - get option letter from argv
 * author: Wally Wedel
 *
 */

#include <stdio.h>

char    *optarg;        /* Global argument pointer. */
int     optind = 0;     /* Global argv index. */

static char     *scan = NULL;   /* Private scan pointer. */

extern char     *index();

int
getopt(argc, argv, optstring)
int argc;
char *argv[];
char *optstring;
{
        register char c;
        register char *place;

        optarg = NULL;

        if (scan == NULL || *scan == '\0') {
                if (optind == 0)
                        optind++;
        
                if (optind >= argc || argv[optind][0] != '-' || argv[optind][1] == '\0')
                        return(EOF);
                if (strcmp(argv[optind], "--")==0) {
                        optind++;
                        return(EOF);
                }
        
                scan = argv[optind]+1;
                optind++;
        }

        c = *scan++;
        place = index(optstring, c);

        if (place == NULL || c == ':') {
                fprintf(stderr, "%s: unknown option -%c\n", argv[0], c);
                return('?');
        }

        place++;
        if (*place == ':') {
                if (*scan != '\0') {
                        optarg = scan;
                        scan = NULL;
                } else {
                        optarg = argv[optind];
                        optind++;
                }
        }

        return(c);
}

