/*
 * purpose:	Apple LaserWriter Bitmap Filter
 * author:	Steve Misek (ISI)
 * written:	4-5-85
 * updates:	12-28-85 (to correct large bitmap print problem)
 *		03-12-86 (to correct odd height problem)
 */
#define PPI 150
struct jbit {
	long b_magic;
	int  b_width;
	int  b_height;
	int  b_hres;
	int  b_vres;
	char unused[20];
} headinfo;
short	pad_height;

main()
{
	short w,h;

	while (read(0,&headinfo,sizeof(struct jbit)) == sizeof(struct jbit)) {
		if (pad_height = (headinfo.b_height%2)) headinfo.b_height++;
		h = headinfo.b_height;
		w = (((headinfo.b_width+15)>>4)<<2);
		printf("%%!\n/showpick {{currentfile %d string",w);
		printf(" readhexstring pop} image} def\n");
		w = (w<<2);
		printf("gsave\n100 100 translate\n");
		printf("%d %d scale\n",((w*72)/PPI),((h*72)/PPI));
		printf(" %d %d 1 [ %d 0 0 -%d 0 %d ] showpick\n",w,h,w,h,h);
		PutData();
   		printf("showpage\ngrestore\n");
		sleep(30);
	}
}

int PutData()
{
	register short j, *cp, f, n, w, i, mask;
	char *ibuf, *malloc();
	static char	hex[] = "0123456789abcdef";
	static short hmask[] = {
		0x0000, 0x0001, 0x0003, 0x0007,
		0x000f, 0x001f, 0x003f, 0x007f,
		0x00ff, 0x01ff, 0x03ff, 0x07ff,
		0x0fff, 0x1fff, 0x3fff, 0x7fff };

	w = (((headinfo.b_width+15)>>4)<<1);
        if (!(ibuf = malloc(w)))	return(1);
	mask = hmask[(w<<3) - headinfo.b_width];

	for (i=0; i<headinfo.b_height; i++){
		if ((n = read(0, ibuf, w)/2) > 0) {
			for (f=0,cp=(short *)ibuf,j=0; j<n-1; j++,cp++,f++) {
				if (f >= 20) {
					putchar('\n');
					f = 0;
				}
				putchar(hex[(*cp>>12) & 0x000f]);
				putchar(hex[(*cp>>8) & 0x000f]);
				putchar(hex[(*cp>>4) & 0x000f]);
				putchar(hex[(*cp) & 0x000f]);
			}
			*cp |= mask;
			putchar(hex[(*cp>>12) & 0x000f]);
			putchar(hex[(*cp>>8) & 0x000f]);
			putchar(hex[(*cp>>4) & 0x000f]);
			putchar(hex[(*cp) & 0x000f]);
			putchar('\n');
		}
	}
	if (pad_height) {
		for (i=1;i<=(w*2);i++) {
			putchar('f');
			if (!(i%80)) putchar('\n');
		}
	}
	putchar('\n');
	free(ibuf);
	return(0);
}
