#include	<signal.h>
#include	<sys/param.h>
#include	<vt.h>
#define	NULLFUN	((int (*)())0)		/* null function pointer */


struct RAD {				/* refresh and adjust descriptor */
	int	(*app_refresh)();	/* refresh routine */
	int	refresh_parameter;	/* refresh parameter (id) */
	int	(*app_adjust)();	/* adjust routine */
	int	adjust_parameter;	/* adjust parameter (id) */
	short	w, h;			/* current window size */
};

static struct RAD	rad[NOFILE];	/* one for each file descriptor */

static
catch_adjust_signal()
{
    /* catches the SIGADJ and calls the handlers for each file descriptor */

    int			signalmask;
    register int	fd;

    /* disable SIGADJ and SIGREF while we are handling the current one */
    signalmask = sigblock((0x01 << (SIGADJ-1)) | (0x01 << (SIGREF-1)));

    for (fd=0; fd<NOFILE; fd++) {
	register struct RAD	*prad;
	prad = &rad[fd];
	if (prad->app_adjust != NULLFUN ||
	    prad->app_refresh != NULLFUN) {
	    /* fd has an adjust or a refresh routine */
	    struct wstate	ws;

	    Flush(fd);
	    GetWindowState(fd, &ws);
	    /* do something if this window changed size */
	    if (prad->w < ws.width || prad->h < ws.height){
		    /* window was made larger */
		    if (prad->app_refresh == NULLFUN) {
		        (*(prad->app_adjust))(prad->adjust_parameter, 
				    ws.width, ws.height);
			prad->w = ws.width; prad->h = ws.height;
		    }
	    } else if (prad->w > ws.width || prad->h > ws.height){
		/* window was made smaller */
		if (prad->app_adjust != NULLFUN ) {
		    (*(prad->app_adjust))(prad->adjust_parameter, 
				    ws.width, ws.height);
		    if (prad->app_refresh != NULLFUN) {
		        (*(prad->app_refresh))(prad->refresh_parameter, 
				    0, 0, ws.width, ws.height);
		    }
		}
	        prad->w = ws.width; prad->h = ws.height;
	    }
	    Flush(fd);
	}
    }

    /* set the mask back to its previous state */
    sigsetmask(signalmask);
}


int (* SetAdjust(fd, id, routine))()
register
int	fd;
int	id;
int	(*routine)();
{
    struct wstate	ws;
    int			signalmask;
    int			(*oroutine)();
    register struct RAD	*prad;

    /* make sure the fd is valid */
    if ((fd < 0) || (fd >= NOFILE)) return(BADSIG);
    prad = &rad[fd];

    /* disable SIGADJ and SIGREF while we modify the data structures */
    signalmask = sigblock((0x01 << (SIGADJ-1)) | (0x01 << (SIGREF-1)));

    /* set up the adjust descriptor for this fd */
    oroutine = prad->app_adjust;
    prad->app_adjust = routine;
    prad->adjust_parameter = id;

    GetWindowState(fd, &ws);
    prad->w = ws.width; prad->h = ws.height;

    signal(SIGADJ, catch_adjust_signal);

    /* set the mask back to its previous state */
    sigsetmask(signalmask);
    return(oroutine);
}

static
catch_refresh_signal()
{
    /* catch SIGREF and call the handler for each file descriptor */

    int		signalmask;
    register
    int		fd;
    short	x, y, w, h;

    /* disable SIGREF and SIGADJ while we process this one */
    signalmask = sigblock((0x01 << (SIGREF-1)) | (0x01 << (SIGADJ-1)));

    for (fd=0; fd<NOFILE; fd++) {
	register struct RAD	*prad;
	prad = &rad[fd];
	if (prad->app_refresh != NULLFUN){
	    /* fd has a refresh routine */
	    struct wstate	ws;
	
	    Flush(fd);
	    GetWindowState(fd, &ws);
	    GetRefreshClipping(fd, &x, &y, &w, &h);
	    if( ws.width > prad->w || ws.height > prad->h){
		/* window got larger */
		if (prad->app_adjust != NULLFUN){ /* smart program */
		    (*(prad->app_adjust))(prad->adjust_parameter, 
					ws.width, ws.height);
		    (*(prad->app_refresh))(prad->refresh_parameter, 
					0, 0, ws.width, ws.height);
		}else{	/* simple program */
		    (*(prad->app_refresh))(prad->refresh_parameter, 
			    prad->w, 0, ws.width-prad->w, prad->h);
		    (*(prad->app_refresh))(prad->refresh_parameter, 
			    0, prad->h, ws.width, ws.height-prad->h);
		}
		prad->w = ws.width; prad->h = ws.height;
	    }else{
		/* if there is something to refresh, call it */
		if ((w != 0) || (h != 0)) {
		    (*(prad->app_refresh))(prad->refresh_parameter, x, y, w, h);
		}
	    }
	    Flush(fd);
	}
    }

    /* set signal mask back to its previous state */
    sigsetmask(signalmask);
}


int (* SetRefresh(fd, id, routine))()
register
int	fd;
int	id;
int	(*routine)();
{
    struct wstate	ws;
    short		nul;
    int			signalmask;
    int			(*oroutine)();
    register struct RAD	*prad;

    /* make sure fd is valid */
    if ((fd <0) || (fd >=NOFILE)) return(BADSIG);
    prad = &rad[fd];

    /* disable SIGADJ and SIGREF while we modify the data structures */
    signalmask = sigblock((0x01 << (SIGADJ-1)) | (0x01 << (SIGREF-1)));

    /* set the refresh descriptor for the given fd */
    oroutine = prad->app_refresh;
    prad->app_refresh = routine;
    prad->refresh_parameter = id;

    GetWindowState( fd, &ws);
    prad->w = ws.width; prad->h = ws.height;

    signal(SIGREF, catch_refresh_signal);
    signal(SIGADJ, catch_adjust_signal);
    GetRefreshClipping( fd, &nul, &nul, &nul, &nul);

    /* set the mask back to its previous state */
    sigsetmask(signalmask);
    return(oroutine);
}


int
BlockRefreshAdjust(flag)
int	flag;
{
    int		signalmask;	/* current signal mask */

    if (flag == 0) {
	/* unblock refresh and adjust */
	signalmask =
	    sigsetmask(sigblock(0) &
		    ~((0x01 << (SIGADJ-1)) | (0x01 << (SIGREF-1))));
    } else {
	/* block refresh and adjust */
	signalmask = sigblock((0x01 << (SIGADJ-1)) | (0x01 << (SIGREF-1)));
    }

    /* return non-zero if refresh or adjust was previously enabled */
    return(signalmask & ((0x01 << (SIGADJ-1)) | (0x01 << (SIGREF-1))));
}
