#include	<signal.h>
#include	<sys/param.h>
#include	"vt.h"

#define	IBUFSIZE	256	/* 256 matches well with kernel buffer */
static struct IBUF {
	unsigned char	buf[IBUFSIZE+1];/* input buffer */
	unsigned char	*p;		/* current position in buffer */
	unsigned char	*eob;		/* first byte not in buffer */
} *ibuf[NOFILE];
#define	NULLIBUF	((struct IBUF *)0)

static int fillvtbuf(fd)
int	fd;
{
    register struct IBUF	*ib = ibuf[fd];
    int				nread, curmask;

    /* flush all buffered output for all windows */
    libvt_flushall();

    /* unblock refresh and adjust, saving current mask */
    curmask = sigsetmask(sigblock(0) &
        ~((0x01 << (SIGREF-1)) | (0x01 << (SIGADJ-1))));

    nread = read(fd, ib->buf, IBUFSIZE);

    /* set block mask back to original state */
    sigsetmask(curmask);

    if (nread <= 0) {
	/* read failed */
	return(-1);
    }
    /* set end of buffer and current position */
    ib->eob = ib->buf + nread;
    ib->p = ib->buf;

    /* buffer filled */
    return(0);
}

static struct IBUF *getvtbuf()
{
    register struct IBUF	*ib;
    char	*malloc();
    /* no input buffer yet */
    if ((ib = (struct IBUF *)malloc(sizeof(struct IBUF))) == NULLIBUF) {
	/* cannot get a buffer */
	return(NULLIBUF);
    }
    /* buffer is initially empty */
    ib->p = ib->eob = ib->buf;
    return(ib);
}

int getvtchar(fd)
register int	fd;
{
    /* get a single byte of vt input */
    register struct IBUF	*ib;

    /* make sure there is an input buffer */
    if (fd<0 || fd>=NOFILE) {
	/* bad file descriptor */
	return(VT_EOF);
    }
    if ((ibuf[fd] == NULLIBUF) && (ibuf[fd]=getvtbuf()) == NULLIBUF) {
	/* no input buffer */
	return(VT_EOF);
    }
    ib = ibuf[fd];

    /* make sure buffer has a character */
    if ((ib->p == ib->eob) && (fillvtbuf(fd) == -1)) {
	/* empty buffer cannot be filled */
	return(VT_EOF);
    }

    return(*(ib->p++));
}


int getvtseq(fd, seq)
register int		fd;
register struct vtseq	*seq;
{
    register struct IBUF	*ib;

    /* make sure there is an input buffer */
    if (fd<0 || fd>=NOFILE) {
	/* bad file descriptor */
	return(VT_EOF);
    }
    if ((ibuf[fd] == NULLIBUF) && (ibuf[fd]=getvtbuf()) == NULLIBUF) {
	/* no input buffer */
	return(VT_EOF);
    }
    ib = ibuf[fd];

    /* make sure buffer has a character */
    if ((ib->p == ib->eob) && (fillvtbuf(fd) == -1)) {
	/* empty buffer cannot be filled */
		return(VT_EOF);
    }

    /* read the sequence */
    switch (*(ib->p)) {
    case VT_HARDKEY:
	if (ib->eob - ib->p >= 3) {
		/* assume a keyboard escape sequence, since enough chars */
		seq->type = VT_HARDKEY;
		ib->p++;
		seq->u.hardkey.mode    = *(ib->p++);
		seq->u.hardkey.keycode = *(ib->p++);
	} else {
		/* assume an escape key */
		seq->type    = VT_ASCII;
		seq->u.ascii = *(ib->p++);
	}
	break;
    case VT_MOUSE:
	seq->type = VT_MOUSE;
	if (ib->eob - ib->p++ < 8) {
		/* not enought chars; something wrong */
		return(VT_EOF);
	}
	seq->u.mouse.buttons = *(ib->p++);
	seq->u.mouse.window  = *(ib->p++);
	seq->u.mouse.pane    = *(ib->p++);
	seq->u.mouse.x       = *(ib->p++) << 8;
	seq->u.mouse.x      |= *(ib->p++);
	seq->u.mouse.y       = *(ib->p++) << 8;
	seq->u.mouse.y      |= *(ib->p++);
	break;
    default:
	seq->type    = VT_ASCII;
	seq->u.ascii = *(ib->p++);
    }

    return (seq->type);
}
