#include	<sys/param.h>

struct BD {				/* buffer descriptor */
	unsigned char	*buffer;	/* pointer to buffer area */
	unsigned char	*pbuf;		/* current position in buffer */
	int		bufsize;	/* buffer size */
};

static struct BD	bd[NOFILE];	/* one for each file descriptor */

libvt_write(fd, wbuf, nbytes)		/* buffered write */
register
int		fd;
register
unsigned char	*wbuf;
register
int		nbytes;
{
    register struct BD	*pbd;

    /* nbytes less than or equal to zero or null buffers are not very useful */
    if ((nbytes <= 0) || (wbuf == 0)) return;

    /* make sure the fd is valid */
    if ((fd < 0) || (fd >= NOFILE)) return;

    /* get a pointer to the buffer descriptor to make things easier */
    pbd = &bd[fd];

    /* if buffer is not big enough for the request, just flush it and write */
    if (nbytes > pbd->bufsize) {
	Flush(fd);
	write(fd, wbuf, nbytes);
	return;
    }

    /* buffer is big enough; if not enough room left, flush it */
    if ((pbd->pbuf + nbytes) > (pbd->buffer + pbd->bufsize)) {
	Flush(fd);
    }

    /* there is now enough room in the buffer; put the bytes in it */
    while (nbytes-- > 0) {
	*(pbd->pbuf)++ = *wbuf++;
    }
}


Flush(fd)
register int	fd;
{
    register struct BD	*pbd;

    /* make sure the fd is valid */
    if ((fd < 0) || (fd >= NOFILE)) return;

    /* get a pointer to the buffer descriptor to make things easier */
    pbd = &bd[fd];

    /* if anything is in the buffer, write it out and clear the buffer */
    if (pbd->pbuf != pbd->buffer) {
	write(fd, pbd->buffer, pbd->pbuf - pbd->buffer);
	pbd->pbuf = pbd->buffer;
    }
}


SetBuf(fd, size)
register
int	fd;
int	size;
{
    register struct BD	*pbd;

    /* make sure the fd is valid */
    if ((fd < 0) || (fd >= NOFILE)) return;

    /* get a pointer to the buffer descriptor to make things easier */
    pbd = &bd[fd];

    /* flush the buffer and free any space allocated to this file descriptor */
    if (pbd->buffer != (unsigned char *) 0) {
	Flush(fd);
	free(pbd->buffer);
    }

    /* give it a new size */
    if (size <= 0) {
	pbd->pbuf = pbd->buffer = (unsigned char *) 0;
	pbd->bufsize = 0;
    } else {
	char	*malloc();
	pbd->pbuf = pbd->buffer = (unsigned char *) malloc(size);
	pbd->bufsize = (pbd->buffer == 0 ? 0 : size);
    }
}

libvt_flushall()
{
    register struct BD	*pbd;

    /* fast flush of all buffers */
    for (pbd = &bd[NOFILE-1]; pbd>=bd; --pbd) {
	if (pbd->bufsize != 0)
		Flush(pbd - bd);
    }
}
