#include	<vt.h>


SetWindowState(fd, state)
register int		fd;
register struct wstate	*state;
{
    struct wstate	current;

    GetWindowState(fd, &current);
    /* changing between two non-graphics disciplines; just set discipline */
    if ((state->ldisc != TWSDISC) && (current.ldisc != TWSDISC)) {
	SetLineDisc(fd, state->ldisc);
	return;
    }
    /* need to be in TWSDISC to do these operations */
    SetLineDisc(fd, TWSDISC);
    SetColor(fd, state->fcolor);
    SetBColor(fd, state->bcolor);
    SetFont(fd, state->font);
    SetPosition(fd, state->xpos, state->ypos);
    SetAddressing(fd, state->addressing);
    SetJustification(fd, state->justification);
    SetOrientation(fd, state->orientation);
    SetDirection(fd, state->direction);
    SetCharAttributes(fd, state->ctype);
    SetPhase(fd, state->xphase, state->yphase);
    SetThickness(fd, state->thickness);
    SetStyle(fd, state->mask, state->count);
    /* width, height */
    if (state->ldisc != TWSDISC) {
	/* going non-graphics; make clipping entire window */
	SetPermanentClipping(fd, 0, 0, current.width, current.height);
	SetTemporaryClipping(fd, 0, 0, current.width, current.height);
    } else {
	/* going graphics; restore previous clipping */
	SetPermanentClipping(fd, state->px, state->py, state->pw, state->ph);
	SetTemporaryClipping(fd, state->tx, state->ty, state->tw, state->th);
    }
    SetMouseMode(fd, state->mmode);
    if (state->cvisible)
	    ShowLocalCursor(fd);
    else
	    HideLocalCursor(fd);
    /* LEDs */
    SetLineDisc(fd, state->ldisc);
}
