#ifndef	_TOOLS
#define	_TOOLS

/*
 * menu
 */

typedef	short	    qtype;

#define	SELECT	    1
#define	TOGGLE	    2
#define	STRING	    3
#define NUMBER	    4


typedef	short	    ctype;

#define	LABEL	    1
#define	GLYPH	    2
#define	SHADE	    3

#define	SHADEWIDTH	    32
#define	SHADEHEIGHT	    32


struct menu
{
    char	    *label;
    short	    size;
    struct question *questions;
};
    

struct question
{
    qtype	    type;
    char	    *label;
    short	    size;
    struct choice   *choices;
};


struct choice
{
    ctype	type;
    char	*label;
    VT_COLOR	shade;
};

extern int PresentMenu();

/*
 * elevator
 */

#define	EB_VERTICAL	0	/* vertical elevator bar */
#define	EB_HORIZONTAL	1	/* horizontal elevator bar */

#define	EB_NOARROWS	0	/* no arrows on elevator bar */
#define	EB_ARROWS	1	/* arrows on elevator bar */
#define	EB_MAX		10000	/* maximum elevator bar value */

char	*CreateElevatorBar();
short	DoElevatorBar();
char	*CreateElevatorBar2D();
short	DoElevatorBar2D();

/*
 *	buttons
 */

#define BF_SHADOW	(0x01)
#define BF_SAMESIZE 	(0x02)
#define BF_RECT	 	(0x04)
#define BF_OVAL	 	(0x08)
#define BF_RIGHTJ	(0x10)
#define BF_LEFTJ	(0x20)

#define BF_VERTICAL	0
#define BF_HORIZONTAL	1

struct button	{
	char	*label;
	short	fcolor, bcolor;
	char	highlighted;
};

char	*CreateButtonField();
short	ButtonInput();

/*
 * cursors
 */

struct cursor {
    unsigned long	face[32];
    unsigned long	mask[32];
    short		x;
    short		y;
    short		blink;
};

extern struct cursor	cur_blank;
extern struct cursor	cur_bucket;
extern struct cursor	cur_camera;
extern struct cursor	cur_crosshair;
extern struct cursor	cur_eraser;
extern struct cursor	cur_finger;
extern struct cursor	cur_pencil;
extern struct cursor	cur_triangle;
extern struct cursor	cur_ularrow;

#define	cur_default	cur_ularrow

/*
 * gauges
 */

struct tick {
	char	*label;
	int	size;
};

extern char *CreateGauge();

#endif
