#include <vt.h>
#include "tools.h"

#define	GFONT		"menu"

struct gauge {
    int		fd;
    short	x;
    short	y;
    short	w;
    short	h;
    short	bcolor;
    short	tcolor;
    short	lcolor;
    short	ncolor;
    short	font;
    short	pos;
    struct tick	*ticks;
    unsigned	nticks;
    short	tspace;
    short	txoffset;
    short	tyoffset;
    short	maxtsize;
    short	thickness;
    short	nx;
    short	ny;
};

static short StringWidth(font, s)
register short	font;
register char	*s;
{
    register int	l=0;
    while (*s != '\0')
	l += CharacterWidth(font, *s++);
    return(l);
}

char * CreateGauge(fd, x, y, w, h, bcolor, tcolor, lcolor, ncolor, font, pos, ticks, nticks)
int		fd;
short		x, y, w, h;
short		bcolor, tcolor, lcolor, ncolor;
short		font;
short		pos;
struct tick	ticks[];
unsigned	nticks;
{
    register struct gauge	*g;
    register int		i;
    char			*malloc();
    short			l, r;

    if ((g = (struct gauge *) malloc(sizeof(struct gauge))) ==
		(struct gauge *) 0) {
	return((char *) 0);
    }
    g->fd = fd;
    g->x = x;
    g->y = y;
    g->w = w;
    g->h = h;
    g->bcolor = bcolor;
    g->tcolor = tcolor;
    g->lcolor = lcolor;
    g->ncolor = ncolor;
    if (font == -1)
	g->font = GetFontId(GFONT);
    else
	g->font = font;
    if (pos < 0)
	pos = 0;
    else if (pos > w)
	pos = w;
    g->pos = pos;
    g->ticks = ticks;
    g->nticks = nticks;
    
    for (i=0,g->maxtsize=0; i<nticks; i++) {
	if (g->ticks[i].size > g->maxtsize)
	    g->maxtsize = g->ticks[i].size;
    }
    if ((g->thickness = (w<h?w:h)/50) < 2)
	g->thickness = 2;
    l = StringWidth(g->font, ticks[0].label);
    r = StringWidth(g->font, ticks[nticks-1].label);
    g->tspace = (g->w - g->thickness*2 - (r>l?r:l))/(g->nticks-1);
    g->txoffset = (g->w - g->thickness - (g->tspace * (g->nticks-1)))/2;
    g->tyoffset = CharacterHeight(g->font);
    g->nx = g->x + w/2;
    g->ny = g->y + g->h - 2*g->thickness;
    return((char *) g);
}

RefreshGauge(gd)
char	*gd;
{
    register struct gauge	*g = (struct gauge *)gd;
    struct wstate		ws;
    short			x, y, w, h;

    GetWindowState(g->fd, &ws);
    GetTemporaryClipping(g->fd, &x, &y, &w, &h);
    SetPermanentClipping(g->fd, x, y, w, h);
    RestrictPermanentClipping(g->fd, g->x, g->y, g->w, g->h);
    SetAddressing(g->fd, VT_RELATIVE);
    SetPosition(g->fd, g->x, g->y);
    SetColor(g->fd, g->bcolor);
    PaintRectangleInterior(g->fd, g->w, g->h);
    DrawLabels(g);
    DrawTicks(g);
    DrawPost(g);
    DrawNeedle(g, g->pos, g->ncolor);
    SetWindowState(g->fd, &ws);
}

MoveGauge(gd, pos)
char		*gd;
register short	pos;
{
    register struct gauge	*g = (struct gauge *)gd;

    if (pos < 0)
	pos = 0;
    else if (pos > g->w)
	pos = g->w;
    if (pos != g->pos) {
	DrawNeedle(g, g->pos, g->bcolor);
	DrawNeedle(g, pos, g->ncolor);
	DrawPost(g);
	g->pos = pos;
    }
}

DeleteGauge(gd)
char	*gd;
{
    free(gd);
}

static DrawLabels(g)
register struct gauge	*g;
{
    register int	i;

    SetFont(g->fd, g->font);
    SetJustification(g->fd, VT_CENTER);
    SetCharAttributes(g->fd, 0);
    SetColor(g->fd, g->lcolor);
    SetYPosition(g->fd, g->y + CharacterBaseline(g->font));
    for (i=0; i<g->nticks; i++) {
	SetXPosition(g->fd, g->x+g->txoffset+i*g->tspace+g->thickness/2);
	PaintString(g->fd, VT_STREND, (unsigned char *)(g->ticks[i].label));
    }
}

static DrawTicks(g)
register struct gauge	*g;
{
    register int	i;

    SetPosition(g->fd, g->x+g->txoffset, g->y+g->tyoffset);
    SetColor(g->fd, g->tcolor);
    for (i=0; i<g->nticks; i++) {
	PaintRectangleInterior(g->fd,
				g->thickness, g->ticks[i].size*g->thickness);
	BumpXPosition(g->fd, g->tspace);
    }
}

static DrawPost(g)
register struct gauge	*g;
{
    SetPosition(g->fd, g->nx, g->ny);
    SetColor(g->fd, g->ncolor);
    PaintCircleInterior(g->fd, (3*g->thickness)/2);
}

static DrawNeedle(g, pos, color)
register struct gauge	*g;
short			pos;
short			color;
{
    /* adjust position to lie between "empty" and "full" */
    pos = (pos * (g->w - 2*g->txoffset) / g->w) + g->txoffset;
    SetPosition(g->fd, g->nx, g->ny);
    SetColor(g->fd, color);
    SetThickness(g->fd, g->thickness);
    SetAddressing(g->fd, VT_ABSOLUTE);
    PaintLine(g->fd, g->x+pos, g->y+g->tyoffset+(g->maxtsize+1)*g->thickness);
    SetAddressing(g->fd, VT_RELATIVE);
}
