#include <vt.h>
#include <tools.h>

/*
 * arrow glyphs
 */

static short darrow[] = {
	0x07e0,
	0x07e0,
	0x0660,
	0x0660,
	0x0660,
	0x0660,
	0x0660,
	0x0660,
	0x7e7e,
	0x7e7e,
	0x381c,
	0x1c38,
	0x0e70,
	0x07e0,
	0x03c0,
	0x0180
};

static short larrow[] = {
	0x0000,
	0x0300,
	0x0700,
	0x0f00,
	0x1f00,
	0x3bff,
	0x73ff,
	0xe003,
	0xe003,
	0x73ff,
	0x3bff,
	0x1f00,
	0x0f00,
	0x0700,
	0x0300,
	0x0000
};

static short rarrow[] = {
	0x0000,
	0x00c0,
	0x00e0,
	0x00f0,
	0x00f8,
	0xffdc,
	0xffce,
	0xc007,
	0xc007,
	0xffce,
	0xffdc,
	0x00f8,
	0x00f0,
	0x00e0,
	0x00c0,
	0x0000
};

static short uarrow[] = {
	0x0180,
	0x03c0,
	0x07e0,
	0x0e70,
	0x1c38,
	0x381c,
	0x7e7e,
	0x7e7e,
	0x0660,
	0x0660,
	0x0660,
	0x0660,
	0x0660,
	0x0660,
	0x07e0,
	0x07e0
};


#define bound(l, u, v) ((v) < (l) ? (l) : ((v) > (u)) ? (u) : (v))
#define max(u, v) ((u) > (v) ? (u) : (v))
#define min(u, v) ((u) < (v) ? (u) : (v))

#define	GWID		16
#define	GHIG		16
#define EL_MIN		8

static RASTER arrows[4] = { {2, uarrow}, {2, darrow}, {2, larrow}, {2, rarrow}};

struct eb2d {
    long	magic;
    int		window;
    short	x, y, w, h, bcolor, brdrsiz;
    short	bx, by, bw, bh;
    bool	arrows;
    short	ex, ey, ew, eh, ecolor;
};

char *
CreateElevatorBar2D(window, x, y, w, h, bcolor, brdrsiz, arrows,
		    ex, ey, ew, eh, ecolor)
int	window;
short	x, y, w, h, bcolor, brdrsiz;
bool	arrows;
short	ex, ey, ew, eh, ecolor;
{
    register struct eb2d	*ebp;
    short			T;
    char			*malloc();
    if ((ebp = (struct eb2d *)malloc(sizeof(struct eb2d)))!=(struct eb2d *)0){
	    ebp->window = window;
	    ebp->x = x;
	    ebp->y = y;
	    ebp->w = w;
	    ebp->h = h;
	    ebp->bcolor = bcolor;
	    ebp->brdrsiz = bound(0, min(w, h)/2, brdrsiz);
	    T = ebp->brdrsiz;
	    ebp->arrows = arrows;
	    ebp->ew = bound(0, EB_MAX, ew);
	    ebp->eh = bound(0, EB_MAX, eh);
	    ebp->ex = bound(0, EB_MAX-ebp->ew, ex);
	    ebp->ey = bound(0, EB_MAX-ebp->eh, ey);
	    ebp->ecolor = ecolor;
	    ebp->bx = x+T;
	    ebp->by = y+T;
	    ebp->bw = w-T-T;
	    ebp->bh = h-T-T;
	    if (arrows) {
		ebp->by += GHIG+T+2;
		ebp->bh -= GHIG+GHIG+T+T+4;
		ebp->bx += GWID+T+2;
		ebp->bw -= GWID+GWID+T+T+4;
	    }
	    ebp->magic = 2001;
    }
    return((char *) ebp);
}

static refreshbar2d(eba)
char *eba;
{
    struct wstate ws;
    register struct eb2d *ebp = (struct eb2d *) eba;
    int ew, eh;
    short T = ebp->brdrsiz;
    GetWindowState(ebp->window, &ws); 
    SetThickness(ebp->window, T);
    HideLocalCursor(ebp->window);
    SetAddressing(ebp->window, VT_RELATIVE);
    /*  draw borders  */
    SetColor(ebp->window, VT_Black);
    SetPosition(ebp->window, ebp->x+T, ebp->y+T);
    PaintRectangleBorder(ebp->window, ebp->w-T-T, ebp->h-T-T);
    /*  draw interior */
    SetColor(ebp->window, ebp->bcolor);
    SetPosition(ebp->window, ebp->bx, ebp->by);
    PaintRectangleInterior(ebp->window, ebp->bw, ebp->bh);
    SetThickness(ebp->window, 2);
    SetColor(ebp->window, ebp->ecolor);
    ew = max(ebp->ew*ebp->bw/EB_MAX, EL_MIN)-4;
    eh = max(ebp->eh*ebp->bh/EB_MAX, EL_MIN)-4;
    BumpPosition(ebp->window,
		 min(ebp->bw-ew, (ebp->ex*ebp->bw+EB_MAX/2)/EB_MAX+2),
		 min(ebp->bh-eh, (ebp->ey*ebp->bh+EB_MAX/2)/EB_MAX+2));
    PaintRectangleInterior(ebp->window, ew, eh);
    SetColor(ebp->window, VT_Black);
    PaintRectangleBorder(ebp->window, ew, eh);
    SetWindowState(ebp->window, &ws); 
}

static refresharrows2d(eba)
char *eba;
{
    struct wstate ws;
    register struct eb2d *ebp = (struct eb2d *) eba;
    short T = ebp->brdrsiz;
    GetWindowState(ebp->window, &ws); 
    SetThickness(ebp->window, T);
    HideLocalCursor(ebp->window);
    SetAddressing(ebp->window, VT_RELATIVE);
    /*  draw arrows  */
    if (ebp->arrows) {
	/*  upper half  */
	SetPosition(ebp->window, ebp->bx, ebp->y+T);
	SetColor(ebp->window, VT_White);
	PaintRectangleInterior(ebp->window, ebp->bw, GHIG+2);
	SetColor(ebp->window, VT_Black);
	PaintRectangleBorder(ebp->window, ebp->bw, GHIG+2);
	DisplayBitmap(ebp->window, PAINTRASTER, &arrows[0], 0, 0, 
		      ebp->x+(ebp->w-GWID)/2, ebp->y+T+1, GWID, GHIG, 0);
	/*  lower half  */
	SetPosition(ebp->window, ebp->bx, ebp->by+ebp->bh+T);
	SetColor(ebp->window, VT_White);
	PaintRectangleInterior(ebp->window, ebp->bw, GHIG+2);
	SetColor(ebp->window, VT_Black);
	PaintRectangleBorder(ebp->window, ebp->bw, GHIG+2);
	DisplayBitmap(ebp->window, PAINTRASTER, &arrows[1], 0, 0,
		      ebp->x+(ebp->w-GWID)/2, ebp->by+ebp->bh+T+1, 
		      GWID, GHIG, 0);
	/*  left half  */
	SetPosition(ebp->window, ebp->x+T, ebp->by);
	SetColor(ebp->window, VT_White);
	PaintRectangleInterior(ebp->window, GHIG+2, ebp->bh);
	SetColor(ebp->window, VT_Black);
	PaintRectangleBorder(ebp->window, GHIG+2, ebp->bh);
	DisplayBitmap(ebp->window, PAINTRASTER, &arrows[2], 0, 0, 
		      ebp->x+T+1, ebp->y+(ebp->h-GWID)/2, GHIG, GWID, 0);
	/*  right half  */
	SetPosition(ebp->window,  ebp->bx+ebp->bw+T, ebp->by);
	SetColor(ebp->window, VT_White);
	PaintRectangleInterior(ebp->window, GHIG+2, ebp->bh);
	SetColor(ebp->window, VT_Black);
	PaintRectangleBorder(ebp->window, GHIG+2, ebp->bh);
	DisplayBitmap(ebp->window, PAINTRASTER, &arrows[3], 0, 0,
		      ebp->bx+ebp->bw+T+1, ebp->y+(ebp->h-GWID)/2, 
		      GHIG, GWID, 0);
    }
    SetWindowState(ebp->window, &ws); 
}

RefreshElevatorBar2D(eba)
char *eba;
{
    refreshbar2d(eba);
    refresharrows2d(eba);
}

MoveElevator2D(eba, ex, ey)
char *eba;
short ex, ey;
{
    short tx, ty;
    struct eb2d *ebp = (struct eb2d *) eba;
    tx = bound(0, EB_MAX-ebp->ew, ex);
    ty = bound(0, EB_MAX-ebp->eh, ey);
    if ((tx == ebp->ex) && (ty == ebp->ey)) return;
    ebp->ex = tx;
    ebp->ey = ty;
    refreshbar2d(eba);
}

SizeElevator2D(eba, ew, eh)
char *eba;
short ew, eh;
{
    register struct eb2d *ebp = (struct eb2d *) eba;
    ebp->ew = bound(0, EB_MAX, ew);
    ebp->eh = bound(0, EB_MAX, eh);
    ebp->ex = bound(0, EB_MAX-ebp->ew, ebp->ex);
    ebp->ey = bound(0, EB_MAX-ebp->eh, ebp->ey);
    refreshbar2d(eba);
}

static bool
withinrec(x, y, w, h, x1, y1)
short	x, y, w, h, x1, y1;
{
    return(!((x > x1) || (x+w < x1) || (y > y1) || (y+h < y1)));
}

short
DoElevatorBar2D(eba, x, y)
char *eba;
short *x, *y;
{
    int	block;
    short ox, oy;
    struct wstate ws;
    register struct eb2d *ebp = (struct eb2d *) eba;
    block = BlockRefreshAdjust(1);
    GetWindowState(ebp->window, &ws);
    ox = ebp->ex;
    oy = ebp->ey;
    if (withinrec(ebp->x, ebp->y, ebp->w, ebp->h, *x, *y)) {
	if (withinrec(ebp->bx, ebp->by, ebp->bw, ebp->bh, *x, *y)) {
	    doleft2d(eba, *x, *y);
	} else {
	    doarrow2d(eba, *x, *y);
	}
	refreshbar2d(eba);
    }
    BlockRefreshAdjust(block);
    SetWindowState(ebp->window, &ws);
    *x = ebp->ex;
    *y = ebp->ey;
    if (ox != *x || oy != *y) return(1);
    return(0);
}

static
doarrow2d(eba, x, y)
char *eba;
short x, y;
{
    register struct eb2d *ebp = (struct eb2d *) eba;
    if (withinrec(ebp->x, ebp->y, ebp->w, GHIG+ebp->brdrsiz*2, x, y))
	ebp->ey = bound(0, EB_MAX-ebp->eh, ebp->ey-ebp->eh);
    if (withinrec(ebp->x, ebp->y+ebp->h-GHIG-ebp->brdrsiz*2,
		  ebp->w, GHIG+ebp->brdrsiz*2, x, y))
	ebp->ey = bound(0, EB_MAX-ebp->eh, ebp->ey+ebp->eh);
    if (withinrec(ebp->x, ebp->y, GHIG+ebp->brdrsiz*2, ebp->h, x, y))
	ebp->ex = bound(0, EB_MAX-ebp->ew, ebp->ex-ebp->ew);
    if (withinrec(ebp->x+ebp->w-GWID-ebp->brdrsiz*2, ebp->y,
		  GHIG+ebp->brdrsiz*2, ebp->h, x, y))
	ebp->ex = bound(0, EB_MAX-ebp->ew, ebp->ex+ebp->ew);
}

static
doleft2d(eba, x, y)
char *eba;
short x, y;
{
    register struct eb2d *ebp = (struct eb2d *) eba;
    int ew, eh, ex, ey;
    ew = max(ebp->ew*ebp->bw/EB_MAX, EL_MIN);
    eh = max(ebp->eh*ebp->bh/EB_MAX, EL_MIN);
    ex = ebp->ex*ebp->bw/EB_MAX;
    ey = ebp->ey*ebp->bh/EB_MAX;
    if (withinrec(ebp->bx+ex, ebp->by+ey, ew, eh, x, y)) {
	/* in elevator */
	x = ebp->bx+ex;
	y = ebp->by+ey;
	TrackFixedBox(ebp->window, &x, &y, ew, eh, ebp->bx, 
		      ebp->by, ebp->bw, ebp->bh, 2);
	ebp->ex = (x-ebp->bx)*EB_MAX/ebp->bw;
	ebp->ey = (y-ebp->by)*EB_MAX/ebp->bh;
    } else {
	ebp->ex = bound(0, EB_MAX-ebp->ew,
		       (x-ebp->bx-ew/2)*EB_MAX/ebp->bw);
	ebp->ey = bound(0, EB_MAX-ebp->eh, 
		       (y-ebp->by-eh/2)*EB_MAX/ebp->bh);
    }
}

DeleteElevatorBar2D(eba)
char *eba;
{
    struct eb2d *ebp = (struct eb2d *) eba;
    ebp->magic = 0;
    free((struct eb2d *) ebp);
}
