#include <vt.h>
#include <tools.h>

/*
 * arrow glyphs
 */

static short darrow[] = {
	0x07e0,
	0x07e0,
	0x0660,
	0x0660,
	0x0660,
	0x0660,
	0x0660,
	0x0660,
	0x7e7e,
	0x7e7e,
	0x381c,
	0x1c38,
	0x0e70,
	0x07e0,
	0x03c0,
	0x0180
};

static short larrow[] = {
	0x0000,
	0x0300,
	0x0700,
	0x0f00,
	0x1f00,
	0x3bff,
	0x73ff,
	0xe003,
	0xe003,
	0x73ff,
	0x3bff,
	0x1f00,
	0x0f00,
	0x0700,
	0x0300,
	0x0000
};

static short rarrow[] = {
	0x0000,
	0x00c0,
	0x00e0,
	0x00f0,
	0x00f8,
	0xffdc,
	0xffce,
	0xc007,
	0xc007,
	0xffce,
	0xffdc,
	0x00f8,
	0x00f0,
	0x00e0,
	0x00c0,
	0x0000
};

static short uarrow[] = {
	0x0180,
	0x03c0,
	0x07e0,
	0x0e70,
	0x1c38,
	0x381c,
	0x7e7e,
	0x7e7e,
	0x0660,
	0x0660,
	0x0660,
	0x0660,
	0x0660,
	0x0660,
	0x07e0,
	0x07e0
};


#define bound(l, u, v) ((v) < (l) ? (l) : ((v) > (u)) ? (u) : (v))
#define max(u, v) ((u) > (v) ? (u) : (v))

#define	GWID		16
#define	GHIG		16
#define EL_MIN		6

static RASTER arrows[4] = { {2, uarrow}, {2, darrow}, {2, larrow}, {2, rarrow}};

struct eb {
    long	magic;
    int		window;
    short	x, y, w, h, bcolor, brdrsiz;
    short	bx, by, bw, bh;
    bool	dir, arrows;
    short	loc, siz, ecolor;
};

char *
CreateElevatorBar(window, x, y, w, h, bcolor, brdrsiz,
			dir, arrows, loc, siz, ecolor)
int	window;
short	x, y, w, h, bcolor, brdrsiz;
bool	dir, arrows;
short	loc, siz, ecolor;
{
    register struct eb	*ebp;
    short		T;
    char		*malloc();
    if ((ebp = (struct eb *) malloc(sizeof(struct eb))) != (struct eb *) 0) {
	    ebp->window = window;
	    ebp->x = x;
	    ebp->y = y;
	    ebp->w = w;
	    ebp->h = h;
	    ebp->bcolor = bcolor;
	    ebp->brdrsiz = bound(0, dir == 1 ? w/2 : h/2, brdrsiz);
	    T = ebp->brdrsiz;
	    ebp->dir = dir;
	    ebp->arrows = arrows;
	    ebp->siz = bound(0, EB_MAX, siz);
	    ebp->loc = bound(0, EB_MAX-ebp->siz, loc);
	    ebp->ecolor = ecolor;
	    ebp->bx = x+T;
	    ebp->by = y+T;
	    ebp->bw = w-T-T;
	    ebp->bh = h-T-T;
	    if (dir == EB_VERTICAL) {
		if (arrows) {
		    ebp->by += GHIG+T+2;
		    ebp->bh -= GHIG+GHIG+T+T+4;
		}
	    } else {
		if (arrows) {
		    ebp->bx += GWID+T+2;
		    ebp->bw -= GWID+GWID+T+T+4;
		}
	    }
	    ebp->magic = 2001;
    }
    return((char *) ebp);
}

static refreshbar(eba)
char *eba;
{
    struct wstate ws;
    register struct eb *ebp = (struct eb *) eba;
    int size;
    short T = ebp->brdrsiz;
    GetWindowState(ebp->window, &ws); 
    SetThickness(ebp->window, T);
    HideLocalCursor(ebp->window);
    SetAddressing(ebp->window, VT_RELATIVE);
    /*  draw borders  */
    SetColor(ebp->window, VT_Black);
    SetPosition(ebp->window, ebp->x+T, ebp->y+T);
    PaintRectangleBorder(ebp->window, ebp->w-T-T, ebp->h-T-T);
    /*  draw interior */
    SetColor(ebp->window, ebp->bcolor);
    SetPosition(ebp->window, ebp->bx, ebp->by);
    PaintRectangleInterior(ebp->window, ebp->bw, ebp->bh);
    SetThickness(ebp->window, 2);
    SetColor(ebp->window, ebp->ecolor);
    if (ebp->dir == EB_VERTICAL) {
	size = max(ebp->siz*ebp->bh/EB_MAX, EL_MIN)-4;
        BumpPosition(ebp->window, 2, 2+(ebp->loc*ebp->bh+EB_MAX/2)/EB_MAX);
        PaintRectangleInterior(ebp->window, ebp->bw-4, size);
        SetColor(ebp->window, VT_Black);
        PaintRectangleBorder(ebp->window, ebp->bw-4, size);
    } else {
	size = max(ebp->siz*ebp->bw/EB_MAX, EL_MIN)-4;
        BumpPosition(ebp->window, 2+(ebp->loc*ebp->bw+EB_MAX/2)/EB_MAX, 2);
        PaintRectangleInterior(ebp->window, size, ebp->bh-4);
        SetColor(ebp->window, VT_Black);
        PaintRectangleBorder(ebp->window, size, ebp->bh-4);
    }
    SetWindowState(ebp->window, &ws); 
}

static refresharrows(eba)
char *eba;
{
    struct wstate ws;
    register struct eb *ebp = (struct eb *) eba;
    short T = ebp->brdrsiz;
    GetWindowState(ebp->window, &ws); 
    SetThickness(ebp->window, T);
    HideLocalCursor(ebp->window);
    SetAddressing(ebp->window, VT_RELATIVE);
    /*  draw arrows  */
    if (ebp->arrows) {
	if (ebp->dir == EB_VERTICAL) {
	    /*  upper half  */
	    SetPosition(ebp->window, ebp->bx, ebp->y+T);
	    SetColor(ebp->window, VT_White);
	    PaintRectangleInterior(ebp->window, ebp->bw, GHIG+2);
	    SetColor(ebp->window, VT_Black);
	    PaintRectangleBorder(ebp->window, ebp->bw, GHIG+2);
	    DisplayBitmap(ebp->window, PAINTRASTER, &arrows[0], 0, 0, 
			  ebp->x+(ebp->w-GWID)/2, ebp->y+T+1, GWID, GHIG, 0);
	    /*  lower half  */
	    SetPosition(ebp->window, ebp->bx, ebp->by+ebp->bh+T);
	    SetColor(ebp->window, VT_White);
	    PaintRectangleInterior(ebp->window, ebp->bw, GHIG+2);
	    SetColor(ebp->window, VT_Black);
	    PaintRectangleBorder(ebp->window, ebp->bw, GHIG+2);
	    DisplayBitmap(ebp->window, PAINTRASTER, &arrows[1], 0, 0,
			  ebp->x+(ebp->w-GWID)/2, ebp->by+ebp->bh+T+1, 
			  GWID, GHIG, 0);
	} else {
	    /*  left half  */
	    SetPosition(ebp->window, ebp->x+T, ebp->by);
	    SetColor(ebp->window, VT_White);
	    PaintRectangleInterior(ebp->window, GHIG+2, ebp->bh);
	    SetColor(ebp->window, VT_Black);
	    PaintRectangleBorder(ebp->window, GHIG+2, ebp->bh);
	    DisplayBitmap(ebp->window, PAINTRASTER, &arrows[2], 0, 0, 
			  ebp->x+T+1, ebp->y+(ebp->h-GWID)/2, GHIG, GWID, 0);
	    /*  right half  */
	    SetPosition(ebp->window,  ebp->bx+ebp->bw+T, ebp->by);
	    SetColor(ebp->window, VT_White);
	    PaintRectangleInterior(ebp->window, GHIG+2, ebp->bh);
	    SetColor(ebp->window, VT_Black);
	    PaintRectangleBorder(ebp->window, GHIG+2, ebp->bh);
	    DisplayBitmap(ebp->window, PAINTRASTER, &arrows[3], 0, 0,
			  ebp->bx+ebp->bw+T+1, ebp->y+(ebp->h-GWID)/2, 
			  GHIG, GWID, 0);
	}
    }
    SetWindowState(ebp->window, &ws); 
}

RefreshElevatorBar(eba)
char *eba;
{
    refreshbar(eba);
    refresharrows(eba);
}

MoveElevator(eba, loc)
char *eba;
short loc;
{
    short tloc;
    struct eb *ebp = (struct eb *) eba;
    if ((tloc = bound(0, EB_MAX-ebp->siz, loc)) == ebp->loc) return;
    ebp->loc = tloc;
    refreshbar(eba);
}

SizeElevator(eba, siz)
char *eba;
short siz;
{
    struct eb *ebp = (struct eb *) eba;
    ebp->siz = bound(0, EB_MAX, siz);
    ebp->loc = bound(0, EB_MAX-ebp->siz, ebp->loc);
    refreshbar(eba);
}

static bool
withinrec(x, y, w, h, x1, y1)
short	x, y, w, h, x1, y1;
{
    return(!((x > x1) || (x+w < x1) || (y > y1) || (y+h < y1)));
}

short
DoElevatorBar(eba, x, y)
char *eba;
short x, y;
{
    int	block;
    struct wstate ws;
    register struct eb  *ebp = (struct eb  *) eba;
    block = BlockRefreshAdjust(1);
    GetWindowState(ebp->window, &ws);
    if (withinrec(ebp->x, ebp->y, ebp->w, ebp->h, x, y)) {
	if (withinrec(ebp->bx, ebp->by, ebp->bw, ebp->bh, x, y)) {
	    doleft(eba, x, y);
	} else {
	    doarrow(eba, x, y);
	}
    }
    BlockRefreshAdjust(block);
    SetWindowState(ebp->window, &ws);
    return(ebp->loc);
}

static
doarrow(eba, x, y)
char *eba;
short x, y;
{
    register struct eb  *ebp = (struct eb  *) eba;
    if (ebp->dir == EB_VERTICAL) {
	if (withinrec(ebp->x, ebp->y, ebp->w, GHIG+ebp->brdrsiz+2, x, y)) {
	    ebp->loc = bound(0, EB_MAX-ebp->siz, ebp->loc-ebp->siz);
	} else {
	    ebp->loc = bound(0, EB_MAX-ebp->siz, ebp->loc+ebp->siz);
	}
    } else {
	if (withinrec(ebp->x, ebp->y, GHIG+ebp->brdrsiz+2, ebp->h, x, y)) {
	    ebp->loc = bound(0, EB_MAX-ebp->siz, ebp->loc-ebp->siz);
	} else {
	    ebp->loc = bound(0, EB_MAX-ebp->siz, ebp->loc+ebp->siz);
	}
    }
    refreshbar(eba);
}

static
doleft(eba, x, y)
char *eba;
short x, y;
{
    register struct eb  *ebp = (struct eb  *) eba;
    int size;
    int locat;
    if (ebp->dir == EB_VERTICAL) {
	size = max(ebp->siz*ebp->bh/EB_MAX, EL_MIN);
	locat = ebp->loc*ebp->bh/EB_MAX;
	if (withinrec(ebp->bx, ebp->by+locat, ebp->bw, size, x, y)) {
	    /* in elevator */
	    x = ebp->bx;
	    y = ebp->by+locat;
	    TrackFixedBox(ebp->window, &x, &y, ebp->bw, size, ebp->bx, 
			  ebp->by, ebp->bw, ebp->bh, 2);
	    ebp->loc = (y-ebp->by)*EB_MAX/ebp->bh;
	} else {
	    ebp->loc = bound(0, EB_MAX-ebp->siz,
			    (y-ebp->by-size/2)*EB_MAX/ebp->bh);
	}
    } else {
	size = max(ebp->siz*ebp->bw/EB_MAX, EL_MIN);
	locat = ebp->loc*ebp->bw/EB_MAX;
	if (withinrec(ebp->bx+locat, ebp->by, size, ebp->bh, x, y)) {
	    /* in elevator */
	    y = ebp->by;
	    x = ebp->bx+locat;
	    TrackFixedBox(ebp->window, &x, &y, size, ebp->bh, ebp->bx, 
			  ebp->by, ebp->bw, ebp->bh, 2);
	    ebp->loc = (x-ebp->bx)*EB_MAX/ebp->bw;
	} else {
	    ebp->loc = bound(0, EB_MAX-ebp->siz,
			    (x-ebp->bx-size/2)*EB_MAX/ebp->bw);
	}
    }
    refreshbar(ebp);
}

DeleteElevatorBar(eba)
char *eba;
{
    struct eb  *ebp = (struct eb  *) eba;
    ebp->magic = 0;
    free((struct eb *) ebp);
}
