#include <vt.h>
#include "tools.h"

#define ENTIREBUTTON	0	/* used by DisplayButton() */
#define INSIDEONLY	1

struct rect	{
	short	x, y;
	short	w, h;
};

struct buttondesc	{
	int	fd;
	short	n;
	short	fcolor;
	struct  button	*bs;
	int	dir, spacing;
	short	style, thickness, font;
	struct rect	field;
	struct rect	*pos;
};

char *
CreateButtonField(fd, n, bs, dir, spacing, style, thickness, font, fc, x, y, w, h)
int	fd;
int	n;
struct  button	*bs;
int	dir, spacing;
short	style, thickness, font;
short	fc;
short	x, y, w, h;
{
	register struct buttondesc *bfd;
	char	*malloc(), *calloc();
	if( bfd = (struct buttondesc *)malloc(sizeof(struct buttondesc))){
		bfd->fd = fd;
		bfd->n = n;
		bfd->fcolor = fc;
		bfd->bs = bs;
		bfd->dir = dir;
		bfd->spacing = spacing;
		bfd->style = style;
		bfd->thickness = thickness;
		bfd->font = font;
		bfd->field.x = x;
		bfd->field.y = y;
		bfd->field.w = w;
		bfd->field.h = h;
		if(!(bfd->pos = (struct rect *)calloc(n, sizeof(struct rect)))){
			free(bfd);
			bfd = 0;
		}
		initializepos(bfd);
		
	}
	return((char *)bfd);
}

DeleteButtonField(bfd)
register struct buttondesc *bfd;
{
	if(bfd){
	    free(bfd->pos);
	    free(bfd);
	}
}

RefreshButtonField(bfd)
register struct buttondesc *bfd;
{
	register short	i;
	short	ox, oy, ow, oh;
	
	if(bfd){
		GetPermanentClipping(bfd->fd, &ox, &oy, &ow, &oh);
		RestrictPermanentClipping(bfd->fd, bfd->field.x, bfd->field.y, 
						   bfd->field.w, bfd->field.h);
		SetPosition(bfd->fd, bfd->field.x, bfd->field.y);
		SetColor(bfd->fd, bfd->fcolor);
		PaintRectangleInterior(bfd->fd, bfd->field.w, bfd->field.h);
		if(bfd->font >= 0)
		    SetFont(bfd->fd, bfd->font);
		if(bfd->thickness >= 0)
		    SetThickness(bfd->fd, bfd->thickness);
		for(i=0; i<bfd->n; i++){
			DisplayButton(bfd->fd, &bfd->bs[i], bfd->pos[i].x,
				    bfd->pos[i].y, bfd->pos[i].w, bfd->pos[i].h,
				    bfd->style, bfd->font, bfd->thickness, 
				    ENTIREBUTTON);
		}
		SetPermanentClipping(bfd->fd, ox, oy, ow, oh);
	}
}

static DisplayButton(fd, button, x, y, w, h, style, font, t, insideonly)
register int	fd;
register struct	button	*button;
short	x, y;
register short	 w, h;
unsigned char	style;
short	font;
register short	t;
char	insideonly;
{
    short r;
    if(button){
	if(style&BF_SHADOW && (style & (BF_OVAL|BF_RECT))){
		w -= t; h -= t;
	}
	SetColor(fd, button->fcolor);
	
	if((style&(BF_RECT|BF_OVAL)) == BF_RECT){
		/* draw a rectangle */
		SetPosition(fd, x+t, y+t);
		w -= 2*t; h -= 2*t;
		if(!insideonly){
		    if(style&BF_SHADOW){
			    /* draw the shadow */
			    BumpPosition(fd, t, t);
			    PaintRectangleBorder(fd, w, h);
			    BumpPosition(fd, -t, -t);
		    }
		    PaintRectangleBorder(fd, w, h);
		}
		SetColor(fd, button->highlighted ? button->fcolor:button->bcolor);
		PaintRectangleInterior(fd, w, h);

	}else if((style&(BF_RECT|BF_OVAL)) == BF_OVAL){
		/* draw an oval */
		h -= t<<1; w -= (h+t+t);
		SetPosition(fd, x+(h>>1), y+t);
		if(!insideonly){
		    if(style&BF_SHADOW){
			    /* draw the shadow */
			    BumpPosition(fd, t, t);
				BumpYPosition(fd, h);
				    PaintRectangleInterior(fd, w, t);
				BumpYPosition(fd, -h);
				BumpPosition(fd, w, h>>1);
				    PaintArcInterior(fd, 
						(h>>1)+t, 0, -h, -1, h>>1);
				BumpPosition(fd, -w, -(h>>1));
			    BumpPosition(fd, -t, -t);
		    }
		    BumpYPosition(fd, -t);
			PaintRectangleInterior(fd, w, t);
		    BumpYPosition(fd, t+h);
			PaintRectangleInterior(fd, w, t);
		    BumpYPosition(fd, -h + (h>>1));
			PaintArcBorder(fd, (h>>1), 0, h, 0, -h);
			BumpXPosition(fd, w);
			    PaintArcBorder(fd, (h>>1), -1, -(h>>1), -1, h>>1);
			BumpXPosition(fd, -w);
		    BumpYPosition(fd, -(h>>1));
		}
		SetColor(fd, button->highlighted ? button->fcolor:button->bcolor);
		BumpYPosition(fd, h>>1);
		    PaintArcInterior(fd, (h>>1), 0, h, 0, -h);
		BumpYPosition(fd, -(h>>1));
		PaintRectangleInterior(fd, w, h);
		BumpPosition(fd, w, h>>1);
		    PaintArcInterior(fd, (h>>1), 0, -h, 0, h);
		BumpPosition(fd, -w, -(h>>1));
	}else if ((style & (BF_RECT|BF_OVAL)) == (BF_RECT|BF_OVAL)){
		/* rectangular oval */
		h -= (t<<1); r = h>>2; w -= ((r<<1) + (t<<1));
		SetPosition(fd, x+r+t, y+t);
		if(!insideonly){
		    if(style&BF_SHADOW){
			    /* draw the shadow */
			    BumpPosition(fd, t, t);
				BumpYPosition(fd, h);
				    PaintRectangleInterior(fd, w, t);
				BumpYPosition(fd, -h);
				BumpPosition(fd, w, r);	/* upper-right shadow */
				    PaintArcInterior(fd, r+t, -1, -r, r, 1);
				    BumpXPosition(fd, r);
					PaintRectangleInterior(fd, t, h-(r<<1));
				    BumpXPosition(fd, -r);
				    BumpYPosition(fd, h-(r<<1));
					PaintArcInterior(fd, r+t, r, -1, -1, r);
				    BumpYPosition(fd, -(h-(r<<1)));
				BumpPosition(fd, -w, -r);
			    BumpPosition(fd, -t, -t);
		    }
		    BumpYPosition(fd, -t);	/* top edge */
			PaintRectangleInterior(fd, w, t);
		    BumpYPosition(fd, t+h);	/* bottom edge */
			PaintRectangleInterior(fd, w, t);
		    BumpPosition(fd, -r+(-t), (-h) + r);
			PaintRectangleInterior(fd, t, h-(r<<1));
		    BumpXPosition(fd, w+r+r+t);
			PaintRectangleInterior(fd, t, h-(r<<1));
		    BumpXPosition(fd, -r+(-w));	/* upper left arc border */
			PaintArcBorder(fd, r, -r, 1, 1, -r);
		    BumpXPosition(fd, w);	/* upper right */
			PaintArcBorder(fd, r, -1, -r, r, 1);
		    BumpYPosition(fd, h-(r<<1));/* lower right */
			PaintArcBorder(fd, r, r, -1, -1, r);
		    BumpXPosition(fd, -w);	/* lower left */
			PaintArcBorder(fd, r, 1, r, -r, -1);
		    BumpYPosition(fd, -(h-r));
		}
		SetColor(fd, button->highlighted ? 
			     button->fcolor : button->bcolor);

		BumpYPosition(fd, r);	/* upper left inside */
		    PaintArcInterior(fd, r, -r, 1, 1, -r);
		    PaintRectangleInterior(fd, -r, h-(r<<1));
		BumpXPosition(fd, w);	/* upper right */
		    PaintArcInterior(fd, r, -1, -r, r, 1);
		    PaintRectangleInterior(fd, r, h-(r<<1));
		BumpYPosition(fd, h-(r<<1));/* lower right */
		    PaintArcInterior(fd, r, r, -1, -1, r);
		BumpXPosition(fd, -w);	/* lower left */
		    PaintArcInterior(fd, r, 1, r, -r, -1);
		BumpYPosition(fd, -(h-r));
		    PaintRectangleInterior(fd, w, h);
	}else{	/* no border type */
		SetPosition(fd, x, y);
		SetColor(fd, button->highlighted ? 
				button->fcolor : button->bcolor);
		PaintRectangleInterior(fd, w, h);
	}
	/* now draw the text */
	if (style&BF_RIGHTJ && !(style&BF_LEFTJ)){
		SetJustification(fd, VT_FLUSHRIGHT);
		BumpXPosition(fd, w);
	}else if (style&BF_LEFTJ && !(style&BF_RIGHTJ)){
		SetJustification(fd, VT_FLUSHLEFT);
	}else{ /* center */
		SetJustification(fd, VT_CENTER);
		BumpXPosition(fd, w>>1);
	}
	SetColor(fd, button->highlighted ? button->bcolor : button->fcolor);
	SetBColor(fd, button->highlighted ? button->fcolor : button->bcolor);
	BumpYPosition(fd, CharacterBaseline(font));
	PaintString(fd, VT_STRBEG, button->label);
    }
}

short
ButtonInput(bfd, x, y)
register struct buttondesc *bfd;
{
    register short	i;
    if(bfd){
	if(within( x, y, &bfd->field)){
	    for(i=0; i<bfd->n; i++){
		if(within( x, y, &bfd->pos[i])){
		    return(i);
		}
	    }
	}
    }
    return(-1);
}

HighlightButton(bfd, b)
register struct buttondesc *bfd;
{
    if(bfd){
	if(!bfd->bs[b].highlighted){
	    bfd->bs[b].highlighted = 1;
	    DisplayButton(bfd->fd, &bfd->bs[b], bfd->pos[b].x,
			bfd->pos[b].y, bfd->pos[b].w, bfd->pos[b].h,
			bfd->style, bfd->font, bfd->thickness, INSIDEONLY);
	return(0);
	}
    }
    return(-1);
}

UnHighlightButton(bfd, b)
register struct buttondesc *bfd;
{
    if(bfd){
	if(bfd->bs[b].highlighted){
	    bfd->bs[b].highlighted = 0;
	    DisplayButton(bfd->fd, &bfd->bs[b], bfd->pos[b].x,
			bfd->pos[b].y, bfd->pos[b].w, bfd->pos[b].h,
			bfd->style, bfd->font, bfd->thickness, INSIDEONLY);
	return(0);
	}
    }
    return(-1);
}

GetButtonFieldWidth(n, bs, dir, spacing, style, t, font)
int	n;
struct  button	*bs;
register int	dir; 
int	spacing;
register short	style;
short	t, font;
{
    register short	i;
    short	max, w, h;
    register short	totalw;

    max = totalw = 0;
    /* find the size of each button, noting the largest */
    for(i=0; i<n; i++){
	ButtonSize(style, t, font, &w, &h, &bs[i]);
	if(w > max){
	    max = w;
	}
	if(!(style & BF_SAMESIZE) && (dir != BF_VERTICAL)){
	    totalw += w;
	}
    }
    if(style & BF_SAMESIZE){
	if(dir==BF_VERTICAL){
	    totalw = max;
	}else{
	    totalw = n*max;
	}
    }
    if(spacing >= 0){
	if(dir != BF_VERTICAL){
	    totalw += (n*spacing);
	}
    }
    return( totalw);
}

GetButtonFieldHeight(n, bs, dir, spacing, style, t, font)
int	n;
struct  button	*bs;
register int	dir; 
int	spacing;
register short	style;
short	t, font;
{
    register short	i;
    short		w, h;
    register short	totalh;

    totalh = 0;
    /* find the size of each button, noting the largest */
    for(i=0; i<n; i++){
	ButtonSize(style, t, font, &w, &h, &bs[i]);
	if(dir == BF_VERTICAL){
	    totalh += h;
	}else{
	    totalh = h;
	}
    }
    if(spacing >= 0){
	if(dir == BF_VERTICAL){
	    totalh += (n*spacing);
	}
    }
    return( totalh);
}

static initializepos(bfd)
register struct buttondesc *bfd;
{
    register short	i;
    short	max, p;
    register short	totalw, totalh;

    max = 0;
    /* find the size of each button, noting the largest */
    for(i=0; i<bfd->n; i++){
	ButtonSize(bfd->style, bfd->thickness, bfd->font, 
			&bfd->pos[i].w, &bfd->pos[i].h, &bfd->bs[i]);
	if(bfd->pos[i].w > max){
		max = bfd->pos[i].w;
	}
    }
    if( bfd->style & BF_SAMESIZE){
	/* make all the buttons the same size */
	for(i=0; i<bfd->n; i++){
		bfd->pos[i].w = max;
	}
    }
    totalw = totalh = 0;
    for(i=0; i<bfd->n; i++){
	if(bfd->dir==BF_VERTICAL){
	    totalh += bfd->pos[i].h;
	    totalw = max;
	}else{
	    totalw += bfd->pos[i].w;
	    totalh = bfd->pos[i].h;
	}
    }
    if( totalh > bfd->field.h)
	totalh = bfd->field.h;
    if( totalw > bfd->field.w)
	totalw = bfd->field.w;
    if (bfd->spacing < 0){
	if(bfd->dir==BF_VERTICAL){
	    bfd->spacing = (bfd->field.h - totalh)/bfd->n;
	}else{
	    bfd->spacing = (bfd->field.w - totalw)/bfd->n;
	}
    }
    /* calculate the (x,y) positions for each button */
    if(bfd->dir==BF_VERTICAL){
	p = bfd->field.y;
    }else{
	p = bfd->field.x;
    }
    p += (bfd->spacing>>1);
    for(i=0; i<bfd->n; i++){
	    if(bfd->dir==BF_VERTICAL){
		bfd->pos[i].x = bfd->field.x+((bfd->field.w-bfd->pos[i].w)>>1);
		bfd->pos[i].y = p;
		p += (bfd->pos[i].h+bfd->spacing);
	    }else{
		bfd->pos[i].x = p;
		bfd->pos[i].y = bfd->field.y + ((bfd->field.h - totalh)>>1);
		p += (bfd->pos[i].w+bfd->spacing);
	    }
    }
}

static ButtonSize( style, t, font, w, h, button)
short	style, t, font;
register short	*w, *h;
struct button	*button;
{
	*w = StringWidth(font, button->label);
	*h = CharacterHeight(font);

	if( (style & (BF_OVAL|BF_RECT)) == BF_RECT){
		*w += (t<<1);
		*h += (t<<1);
	}else if( (style & (BF_OVAL|BF_RECT)) == BF_OVAL){
		*h += (t<<1);
		*w += *h;
	}else if( (style & (BF_OVAL|BF_RECT)) == (BF_OVAL|BF_RECT)){
		*w += ((*h>>2)<<1) + (t<<1);
		*h += (t<<1);
	}
	
	if(style & BF_SHADOW && (style & (BF_OVAL|BF_RECT))){
		*w += t;
		*h += t;
	}
}

static StringWidth( f, s)
short	f;
register char	*s;
{
	register short w;
	w = 0;
	while( *s)
		w += CharacterWidth(f, *s++);
	return(w);
}

static within( x, y, r)
register short	x, y;
register struct rect *r;
{
	if(x > r->x && y > r->y && x < (r->x + r->w) && y < (r->y + r->h)){
		return(1);
	}else{
		return(0);
	}
}
