/*
    Pascal Runtime library - Copyright 1983,1984,1985,1986,1987
			     by Green Hills Software Inc.
    This program is the property of Green Hills Software, Inc,
    its contents are proprietary information and no part of it
    is to be disclosed to anyone except employees of Green Hills
    Software, Inc., or as agreed in writing signed by the President
    of Green Hills Software, Inc.
*/

void _gh_SET(s,low,high) unsigned long *s; unsigned low,high;
{
    char *cp;
    int i;

    if (high < low) { return; }
    if (((unsigned)s & 3) != 0) {
	cp = (char *)s + (low-- >> 3);
	while (++low <= high) { *cp++ |= (1 << (low & 7)); }
    } else if (low == high) {
	s[low >> 5] |= (1 << (low & 31));
    } else if ((low >> 5) == (high >> 5)) {
	s[low >> 5] |= ((((unsigned)0xffffffff) >> (32-(high+1-low))) << low);
    } else {
	_gh_SET(s, low, low | 31);
	_gh_SET(s, high & ~31, high);
	high >>= 5;
	low >>= 5;
	if ((i = high - ++low) > 0) {
	    s += low;
	    do { *s++ = -1; } while (--i != 0);
	}
    }
}

void SETPAIR(s,low,high) unsigned long *s; unsigned low,high;
{
    _gh_SET(s, low, high);
}
