/*
    Pascal Runtime library - Copyright 1983,1984,1985,1986,1987
			     by Green Hills Software Inc.
    This program is the property of Green Hills Software, Inc,
    its contents are proprietary information and no part of it
    is to be disclosed to anyone except employees of Green Hills
    Software, Inc., or as agreed in writing signed by the President
    of Green Hills Software, Inc.
*/

/* Implements the Pascal mod operation */
/* The compiler may generate a call to this routine */

_gh_PMD(x, y)
register x,y;
{
    x = x % y;
    if (x != 0)
	if (x < 0 && y > 0 || x > 0 && y < 0)
	    x += y;
    return(x);
}

PMOD(x,y)
{
    return(_gh_PMD(x,y));
}

/* Implements the division complement to the Pascal mod operation */
/* The compiler may generate a call to this routine */

_gh_PDV(x, y)
register x,y;
{
    return((x - PMOD(x, y)) / y);
}

PDIV(x,y)
{
    return(_gh_PDV(x,y));
}
