/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)dolio.c	5.2	7/30/85
 */

/*
 * list directed and namelist i/o common routines
 */

#include "fio.h"
#include "lio.h"


c_le(a,flag) cilist *a;
{	int n;
	lfname = NULL;
	elist = NO;
	sequential=external=YES;
	errflag = a->cierr;
	endflag = a->ciend;
#ifdef	SILICON_SOLUTIONS
	lunit = tr_unit(a->ciunit,fmtbuf);
#else
	lunit = a->ciunit;
	if(not_legal(lunit)) err(errflag,F_ERUNIT,fmtbuf)
#endif	SILICON_SOLUTIONS
	curunit = &units[lunit];
#ifdef	SILICON_SOLUTIONS
	if(!curunit->ufd && (n=fk_open(flag,SEQ,FMT,(ftnint)a->ciunit)))
#else
	if(!curunit->ufd && (n=fk_open(flag,SEQ,FMT,(ftnint)lunit)))
#endif	SILICON_SOLUTIONS
		err(errflag,n,fmtbuf)
	cf = curunit->ufd;
	elist = YES;
	lfname = curunit->ufnm;
	scale=recpos=cursor=0;
	cplus=cblank=NO;
	if(!curunit->ufmt) err(errflag,F_ERNOFIO,fmtbuf)
	if(curunit->url) err(errflag,F_ERNOSIO,fmtbuf)
	return(OK);
}

do_lio(type,number,ptr,len) ftnint *number,*type; flex *ptr; ftnlen len;
{
	return((*lioproc)(number,ptr,len,*type));
}
